' This cog handles the status line.
' Also keeps the real-time counter

con

  STATUS_NONE, STATUS_PRE, STATUS_GAME, STATUS_PAUSE, STATUS_OUT_OF_TIME, STATUS_GAME_OVER

var
  long status_addr
  long stack[20]
  long vsync_addr
  long score
  byte ticks_per_sec
  byte tick_count
  byte time
  byte diamond_count
  byte diamond_value
  byte diamonds_needed
  byte player
  byte men
  byte cave
  byte level
  byte status_mode
  byte update
  byte status_temp[20*2]
  byte toggle
  byte decbuf[6]

pub start(video_params)

  vsync_addr := long[video_params + constant(6 * 4)]
  status_addr := long[video_params + constant(5 * 4)] + constant(40 * 28 + 4 + 4)

  time := 0
  status_mode := STATUS_NONE
  update := true
  toggle := 0

  if long[video_params + constant(4 * 4)] == 0
    ticks_per_sec := 60  'NTSC
  else
    ticks_per_sec := 50  'PAL

  cognew(process, @stack)

pub player_params(p, m, c, l, s)

  player := p
  men := m
  cave := c
  level := l
  score := s
  
pub cave_params(dn, dv, t)

  diamonds_needed := dn
  diamond_value := dv
  diamond_count := 0
  time := t
  tick_count := ticks_per_sec

pub set_time(t)

  tick_count := ticks_per_sec
  time := t
  update := true

pub get_time

  return time

pub set_mode(m)

  status_mode := m
  update := true

pub set_score(s)

  score := s
  update := true

pub set_diamond_value(dv)

  diamond_value := dv
  update := true

pub set_diamond_count(n)

  diamond_count := n
  update := true

pub process
                  
  repeat

    'wait for vsync
    repeat while byte[vsync_addr] == 0
    repeat while byte[vsync_addr] <> 0

    if update
      update := false

      if status_mode == STATUS_NONE
        long[status_addr] &= !1
      else
        long[status_addr] |= 1

      if toggle
        longmove(status_addr, @status_temp, 10)
        toggle := 0

      if status_mode == STATUS_PRE
        bytefill(status_addr + constant(4 + 20), $06, 20)
        if cave > 16
          text_out(status_addr + 4, @bonus_life, 20)
        else
          text_out(status_addr + 4, @pre, 20)
          byte[status_addr + constant(4 + 8)] := player + $80
          byte[status_addr + constant(4 + 11)] := men + $80
          byte[status_addr + constant(4 + 17)] := cave + $90
          byte[status_addr + constant(4 + 19)] := level + $81
         
      elseif status_mode == STATUS_GAME
        byte[status_addr + constant(4 + 0)] := $90
        if diamond_count => diamonds_needed
          byte[status_addr + constant(4 + 1)] := $AC
          byte[status_addr + constant(4 + 2)] := $AC
          byte[status_addr + constant(4 + 21)] := $06
          byte[status_addr + constant(4 + 22)] := $06
        else
          convert_to_dec(diamonds_needed, 2)         
          byte[status_addr + constant(4 + 1)] := decbuf[1]
          byte[status_addr + constant(4 + 2)] := decbuf[0]
          byte[status_addr + constant(4 + 21)] := $9D
          byte[status_addr + constant(4 + 22)] := $9D

        byte[status_addr + constant(4 + 3)] := $AC
        convert_to_dec(diamond_value, 2)         
        byte[status_addr + constant(4 + 4)] := decbuf[1]
        byte[status_addr + constant(4 + 5)] := decbuf[0]
        byte[status_addr + constant(4 + 6)] := $90         
        convert_to_dec(diamond_count, 2)         
        byte[status_addr + constant(4 + 7)] := decbuf[1]
        byte[status_addr + constant(4 + 8)] := decbuf[0]
        byte[status_addr + constant(4 + 9)] := $90         
        convert_to_dec(time, 3)         
        byte[status_addr + constant(4 + 10)] := decbuf[2]
        byte[status_addr + constant(4 + 11)] := decbuf[1]
        byte[status_addr + constant(4 + 12)] := decbuf[0]
        byte[status_addr + constant(4 + 13)] := $90
        convert_to_dec(score, 6)         
        byte[status_addr + constant(4 + 14)] := decbuf[5]
        byte[status_addr + constant(4 + 15)] := decbuf[4]
        byte[status_addr + constant(4 + 16)] := decbuf[3]
        byte[status_addr + constant(4 + 17)] := decbuf[2]
        byte[status_addr + constant(4 + 18)] := decbuf[1]
        byte[status_addr + constant(4 + 19)] := decbuf[0]
        
        byte[status_addr + constant(4 + 27)] := $9D
        byte[status_addr + constant(4 + 28)] := $9D

      elseif status_mode == STATUS_GAME_OVER
        bytefill(status_addr + constant(4 + 20), $06, 20)
        text_out(status_addr + 4, @game_over, 20)

    if --tick_count == 0
      tick_count := ticks_per_sec

      if status_mode == STATUS_GAME
        if time > 0
          convert_to_dec(--time, 3)         
          byte[status_addr + constant(4 + 10)] := decbuf[2]
          byte[status_addr + constant(4 + 11)] := decbuf[1]
          byte[status_addr + constant(4 + 12)] := decbuf[0]

      elseif status_mode == STATUS_PAUSE
        if toggle
          longmove(status_addr, @status_temp, 10)
          toggle := 0
        else
          longmove(@status_temp, status_addr, 10)
          bytefill(status_addr + constant(4 + 20), $06, 20)
          text_out(status_addr + 4, @pause, 20)
          toggle := 1      

      elseif status_mode == STATUS_OUT_OF_TIME
        'out of time
        if toggle
          longmove(status_addr, @status_temp, 10)
          toggle := 0
        else
          longmove(@status_temp, status_addr, 10)
          bytefill(status_addr + constant(4 + 20), $06, 20)
          text_out(status_addr + 4, @out_of_time, 20)
          toggle := 1

pub convert_to_dec(val, len) | i
  repeat i from 0 to len-1
    decbuf[i] := val // 10 + $80
    val /= 10  

pub text_out(addr, str, len) | i, c
  repeat i from 0 to len-1
    c := byte[str + i]
    if c == $20 
      byte[addr + i] := $90
    elseif c == $2C
      byte[addr + i] := $AF
    elseif c == $2F
      byte[addr + i] := $8C
    else
      byte[addr + i] := c + $50
 
dat

pre           byte      " PLAYER  ,   MEN  / "
out_of_time   byte      "     OUT OF TIME    "
pause         byte      " SPACEBAR TO RESUME "
bonus_life    byte      " B O N U S  L I F E "
game_over     byte      "  G A M E  O V E R  "