{
    Multi core transform sample

    derived from "3D Graphics DEMO" by Beau Schwabe (Parallax)
}

CON
  ' enable multi core transform calculation
  MultiCoreTranform = true

  ZX            = 180
  ZY            = 240

  MaxPoints     = 50

  _CLKMODE      = XTAL1 + PLL16X
  _XINFREQ      = 5_000_000
  _stack        = ($3000 + $3000 + 100) >> 2

  x_tiles       = 16
  y_tiles       = 12

  paramcount    = 14
  bitmap_base   = $2000
  display_base  = $5000


VAR
    long              tv_status                         '0/1/2 = off/visible/invisible                  read-only
    long              tv_enable                         '0/? = off/on                                   write-only
    long              tv_pins                           '%ppmmm = pins                                  write-only
    long              tv_mode                           '%ccinp = chroma,interlace,ntsc/pal,swap        write-only
    long              tv_screen                         'pointer to screen (words)                      write-only
    long              tv_colors                         'pointer to colors (longs)                      write-only
    long              tv_hc                             'horizontal cells                               write-only
    long              tv_vc                             'vertical cells                                 write-only
    long              tv_hx                             'horizontal cell expansion                      write-only
    long              tv_vx                             'vertical cell expansion                        write-only
    long              tv_ho                             'horizontal offset                              write-only
    long              tv_vo                             'vertical offset                                write-only
    long              tv_broadcast                      'broadcast frequency (Hz)                       write-only
    long              tv_auralcog                       'aural fm cog                                   write-only

    word              screen[x_tiles * y_tiles]
    long              colors[64]

    long              cogStack[40 * 5]
    long              pointData[MaxPoints * 5]
    byte              frame


OBJ
    tv    :       "bel-tv"
    gr    :       "pf_graphics"

PUB start | i,dx,dy

  'start tv
  longmove(@tv_status, @tvparams, paramcount)
  tv_screen := @screen
  tv_colors := @colors
  tv.start(@tv_status)

  'init colors
  repeat i from 0 to 63
    colors[i] := $ad02ad06

  'init tile screen
  i := 0
  repeat dy from 0 to tv_vc - 1
    repeat dx from 0 to tv_hc - 1
      screen[i++] := display_base >> 6 + dy + dx * tv_vc + (dy << 10)

  'start and setup graphics
  gr.start
  gr.setup(tv_hc, tv_vc, tv_hc<<3, tv_vc<<3, bitmap_base)

  'Start transform routines (per object)
  if MultiCoreTranform
    repeat i from 0 to 4
      cognew( Polyobj(@pointData[ MaxPoints * i ], @PostureData + i * 20), @cogStack[i * 40] )

  MainLoop


PRI MainLoop | i, n, t
  n := 0
  t := cnt & |<27
  repeat
    gr.clear
    gr.width(0)

    repeat i from 0 to n
      if !MultiCoreTranform
        TranslatePoints( @pointData[ MaxPoints * i ], @PostureData + i * 20, @PointSrc, constant((@PointSrc_End - @PointSrc)/3) )
      repeat until ( word[ @PostureData + i * 20 + 18] == frame )
      gr.lineseq( @pointData[MaxPoints * i], @SeqData)

    gr.copy(display_base)
    frame++

    if ( t <> cnt & |<27 )
      t := cnt & |<27
      n := (n + 1) <# 4

    'wait Vsync
    repeat until ( tv_status == 1 )


PRI PolyObj(destAddr, postureAddr)
  repeat
    repeat while word[ postureAddr + 18 ] == frame
    TranslatePoints( destAddr, postureAddr, @PointSrc, constant((@PointSrc_End - @PointSrc)/3) )


PRI TranslatePoints( destAddr, postureAddr, pointAddr, numPoints ) | i,dst,px,py,pz,tx,ty,tz,dx,dy,dz,S1,S2,S3,C1,C2,C3,x,y,z
    tx := ( word[ postureAddr + 6  ] += word[ postureAddr + 12 ] )
    ty := ( word[ postureAddr + 8  ] += word[ postureAddr + 14 ] )
    tz := ( word[ postureAddr + 10 ] += word[ postureAddr + 16 ] )

    S1 := Sin(tx)
    S2 := Sin(ty)
    S3 := Sin(tz)

    C1 := Cos(tx)
    C2 := Cos(ty)
    C3 := Cos(tz)

    x := ~word[ postureAddr + 0 ]
    y := ~word[ postureAddr + 2 ]
    z := word[ postureAddr + 4 ] + (C1 ~> 9) ' add C1~>9 for test

    repeat i from 0 to numPoints
      px := ~byte[pointAddr++]
      py := ~byte[pointAddr++]
      pz := ~byte[pointAddr++]

      tx := ( px * C2 - pz * S2 ) ~> 16
      tz := ( px * S2 + pz * C2 ) ~> 16
      ty := ( tz * S1 + py * C1 ) ~> 16

      dx := ( tx * C3 + ty * S3 ) ~> 16 + x
      dy := ( ty * C3 - tx * S3 ) ~> 16 + y
      dz := ( tz * C1 - py * S1 ) ~> 16 + z

      word[destAddr  ] := dx * ZX / dz
      word[destAddr+2] := dy * ZY / dz
      destAddr += 4

    word[ postureAddr + 18 ] := frame


pri cos(angle) : x
  x := sin(angle + $800)


pri sin(angle) : y
  '' Get sine of angle (0-8191)
  y := angle << 1 & $FFE ' address
  if angle & $800
    y := word[$F000 - y]
  else
    y := word[$E000 + y]
  if angle & $1000
    -y


DAT
PostureData
                        '    trans           rot      rotspeed    sync
                        word    0,   0, 400, 0, 0, 0, 0,  0, 200, 0
                        word -120, -80, 400, 0, 0, 0, 50, 30, 40, 0
                        word -120,  80, 400, 0, 0, 0, 40, 50, 30, 0
                        word  120, -80, 400, 0, 0, 0, 30, 50, 40, 0
                        word  120,  80, 400, 0, 0, 0, 50, 40, 30, 0

PointSrc
                        byte -20,-20,-20
                        byte -20,-20, 20
                        byte -20, 20, 20
                        byte -20, 20,-20
                        byte  20,-20,-20
                        byte  20,-20, 20
                        byte  20, 20, 20
                        byte  20, 20,-20

                        byte -40,-40,-40
                        byte -40,-40, 40
                        byte -40, 40, 40
                        byte -40, 40,-40
                        byte  40,-40,-40
                        byte  40,-40, 40
                        byte  40, 40, 40
                        byte  40, 40,-40

                        byte -70, 0, 0
                        byte  70, 0, 0
PointSrc_End

SeqData
                        ' orange thing
                        byte   13, 1, 16, 0, 4, 17, 5, 1, 16, 2, 6, 17, 7, 3, 16
                        byte   5, 1, 0, 1, 2, 3, 0
                        byte   5, 1, 4, 5, 6, 7, 4
                        ' black cube
                        byte   10, 2, 8, 9,10,11, 8,12,13,14,15,12
                        byte   2, 2, 9,13
                        byte   2, 2,10,14
                        byte   2, 2,11,15
                        byte   0


tvparams                long    0               'status
                        long    1               'enable
                        'long    %011_0000       'pins Old Board
                        long    %010_0101       'pins New Board
                        long    %0000           'mode
                        long    0               'screen
                        long    0               'colors
                        long    x_tiles         'hc
                        long    y_tiles         'vc
                        long    10              'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    60_000_000      '_xinfreq<<4 'broadcast
                        long    0               'auralcog

