{       Hive-Soundobjekt fr Boulderdash

}

'signaldefinitionen bellatrix

#0,     D0,D1,D2,D3,D4,D5,D6,D7                         'datenbus
#8,     BEL_VGABASE                                     'vga-signale (8pin)
#16,    BEL_KEYBC,BEL_KEYBD                             'keyboard-signale
#18,    BEL_MOUSEC,BEL_MOUSED                           'maus-signale
#20,    BEL_VIDBASE                                     'video-signale(3pin)
#23,    BEL_SELECT                                      'belatrix-auswahlsignal
#24,    HBEAT                                           'front-led
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal

var

byte          sndfx             ' Kommando fr Administra
byte          fcCog             ' Flag ob cCog gestartet
long          cStack[32]        ' Stack fr cCog


pub Start: Pass

  Pass := (fcCog := cognew(cCog, @cStack)+1) > 0
  
pub cCog | cmd

  bus_init
  repeat
    repeat until sndfx > 0                              'warte bis fx gesendet werden soll
    bus_putchar(sndfx~)                                 'sndfx-Kommando senden


CON
'                                                       
'          hbeat   --------+                            
'          clk     -------+|                            
'          /wr     ------+||                            
'          /hs     -----+||| +------------------------- /cs
'                       |||| |                 -------- d0..d7
DB_IN            = %00001001_00000000_00000000_00000000 'maske: dbus-eingabe
DB_OUT           = %00001001_00000000_00000000_11111111 'maske: dbus-ausgabe

M1               = %00000010_00000000_00000000_00000000
M2               = %00000010_10000000_00000000_00000000 'busclk=1? & /cs=0?

M3               = %00000000_00000000_00000000_00000000
M4               = %00000010_00000000_00000000_00000000 'busclk=0?


PUB bus_putchar(zeichen)                                                        'BUS: Ein Byte ber BUS ausgeben
{{ein byte ber bus ausgeben Belltrix --> Regnatix}}
  waitpeq(M1,M2,0)                                      'busclk=1? & prop2=0?
  dira := db_out                                        'datenbus auf ausgabe stellen
  outa[7..0] := zeichen                                 'daten ausgeben
  outa[bus_hs] := 0                                     'daten gltig
  waitpeq(M3,M4,0)                                      'busclk=0?
  dira := db_in                                         'bus freigeben
  outa[bus_hs] := 1                                     'daten ungltig

PUB bus_getchar : zeichen                                                       'BUS: Ein Byte ber BUS empfangen
{{ein byte ber bus empfangen Regnatix --> Bellatrix}}
   waitpeq(M1,M2,0)                                     'busclk=1? & prop2=0?
   zeichen := ina[7..0]                                 'daten einlesen
   outa[bus_hs] := 0                                    'daten quittieren
   outa[bus_hs] := 1
   waitpeq(M3,M4,0)                                     'busclk=0?

PUB bus_init
{{initialisierung des bussystems}}
  dira := db_in                                                   'datenbus auf eingabe schalten
  outa[bus_hs] := 1                                               'handshake inaktiv


dat 'soundadapter

con

_music_on                       = 1
_music_off                      = 2
_moving_sound1                  = 3
_moving_sound2                  = 4
_boulder_sound                  = 5
_diamond_sound                  = 6
_pick_sound                     = 7
_explosion_sound                = 8
_crack_sound                    = 9
_magic_wall_sound_on            = 10
_magic_wall_sound_off           = 11
_amoeba_sound_on                = 12
_amoeba_sound_off               = 13
_time_ending_sound              = 14
_bonus_point_sound              = 15
_cover_sound                    = 16
        
pub music_on
  sndfx := _music_on

pub music_off
  sndfx := _music_off

pub moving_sound(surface)
  repeat until sndfx == 0
  if surface == $00
    sndfx := _moving_sound1
  else ' $01
    sndfx := _moving_sound2
  repeat until sndfx == 0
    
pub boulder_sound
  sndfx := _boulder_sound

pub diamond_sound
  repeat until sndfx == 0
  sndfx := _diamond_sound
  repeat until sndfx == 0

pub pick_sound
  repeat until sndfx == 0
  sndfx := _pick_sound
  repeat until sndfx == 0

pub explosion_sound
  repeat until sndfx == 0
  sndfx := _explosion_sound
  repeat until sndfx == 0

pub crack_sound
  repeat until sndfx == 0
  sndfx := _crack_sound
  repeat until sndfx == 0

pub magic_wall_sound_on
  repeat until sndfx == 0
  sndfx := _magic_wall_sound_on
  repeat until sndfx == 0

pub magic_wall_sound_off
  repeat until sndfx == 0
  sndfx := _magic_wall_sound_off
  repeat until sndfx == 0

pub amoeba_sound_on
  repeat until sndfx == 0
  sndfx := _amoeba_sound_on
  repeat until sndfx == 0

pub amoeba_sound_off
  'sndfx := _amoeba_sound_off

pub time_ending_sound(sec_left)
  repeat until sndfx == 0
  sndfx := _time_ending_sound
  repeat until sndfx == 0

pub bonus_point_sound(pts)
  repeat until sndfx == 0
  sndfx := _bonus_point_sound
  repeat until sndfx == 0

pub cover_sound
  sndfx := _cover_sound


  