' This cog takes care of the smooth scrolling and animates animated objects.
' Also:
' - flashes the screen when the game target is reached
' - signals about new life with random background pattern

var
  long x, y, nx, ny
  long scroll_addr
  long tile_addr
  long palette_addr
  long stack[12]
  long rockford_dir
  long random_addr
  long vsync_addr
  byte flash_cnt
  byte new_life_cnt
  byte tapping
  byte blinking
  byte wall_milling

pub start(video_params, rnd_addr)

  x := 0
  y := 0
  
  vsync_addr := long[video_params + constant(6 * 4)]
  random_addr := rnd_addr
  palette_addr := long[video_params + constant(5 * 4)] + constant(40 * 28)
  scroll_addr := palette_addr + 4
  tile_addr := scroll_addr + constant(4 + 4 + 20 * 2)

  rockford_dir := 0
  flash_cnt := 0
  new_life_cnt := 0
  blinking := 0
  tapping := 0
  wall_milling := 0
  cognew(process, @stack)

pub scroll_to(sx, sy)

  nx := sx
  ny := sy

pub rockford_reset

  blinking := 0
  tapping := 0

pub rockford_go(dir)

  rockford_dir := dir
  if rockford_dir <> 0
    blinking := 0
    tapping := 0

pub flash

  flash_cnt := 6

pub new_life

  new_life_cnt := 400

pub milling_on

  wall_milling := 1

pub milling_off

  wall_milling := 0

pub process | i, n, cp, temp
                  
  n := 0
  i := 0

  repeat

    'wait for vsync    
    repeat while byte[vsync_addr] == 0
    repeat while byte[vsync_addr] <> 0

    if x <> nx or y <> ny
      if x > nx
        x := x - 1
      elseif x < nx
        x := x + 1
      if y > ny
        y := y - 2
      elseif y < ny
        y := y + 2
      long[scroll_addr] := (x << 16) + y

    if i == 0
      'rockford
      if rockford_dir > 0
        cp := @rockford_right + n
      elseif rockford_dir < 0
        cp := @rockford_left + n
      else
        cp := @rockford
        if n == 0
          if (byte[random_addr] & $03) == 0
            blinking := 1
          else
            blinking := 0
          if (byte[random_addr] & $0F) == 0
            tapping ^= 1  
      ifnot blinking or tapping
        wordmove(tile_addr + constant(32 * $38), cp, 16)
        wordmove(tile_addr + constant(32 * $39), cp, 16)
      else
        if blinking
          cp := @rockford_bored + n
          wordmove(tile_addr + constant(32 * $38), cp, 8)             ' top part only
          wordmove(tile_addr + constant(32 * $39), cp, 8)
        if tapping
          cp := @rockford_bored + 16 + n
          wordmove(tile_addr + constant(32 * $38 + 16), cp, 8)        ' bottom part only
          wordmove(tile_addr + constant(32 * $39 + 16), cp, 8)
      
      ' diamonds
      cp := @diamonds + n
      wordmove(tile_addr + constant(32 * $14), cp, 16)                ' update all 4 variants
      wordmove(tile_addr + constant(32 * $15), cp, 16)
      wordmove(tile_addr + constant(32 * $16), cp, 16)
      wordmove(tile_addr + constant(32 * $17), cp, 16)
      ' fireflies
      cp := @firefly + n
      wordmove(tile_addr + constant(32 * $08), cp, 16)                ' update all 8 variants
      wordmove(tile_addr + constant(32 * $09), cp, 16)
      wordmove(tile_addr + constant(32 * $0A), cp, 16)
      wordmove(tile_addr + constant(32 * $0B), cp, 16)
      wordmove(tile_addr + constant(32 * $0C), cp, 16)
      wordmove(tile_addr + constant(32 * $0D), cp, 16)
      wordmove(tile_addr + constant(32 * $0E), cp, 16)
      wordmove(tile_addr + constant(32 * $0F), cp, 16)
      ' butterflies
      cp := @butterfly + n
      wordmove(tile_addr + constant(32 * $30), cp, 16)                ' update all 8 variants
      wordmove(tile_addr + constant(32 * $31), cp, 16)
      wordmove(tile_addr + constant(32 * $32), cp, 16)
      wordmove(tile_addr + constant(32 * $33), cp, 16)
      wordmove(tile_addr + constant(32 * $34), cp, 16)
      wordmove(tile_addr + constant(32 * $35), cp, 16)
      wordmove(tile_addr + constant(32 * $36), cp, 16)
      wordmove(tile_addr + constant(32 * $37), cp, 16)
      ' amoeba
      cp := @amoeba + n
      wordmove(tile_addr + constant(32 * $3A), cp, 16)
      wordmove(tile_addr + constant(32 * $3B), cp, 16)
      ' magic wall
      if wall_milling
        wordmove(tile_addr + constant(32 * $03), @magic_wall + (n & $60), 16)
      else
        wordmove(tile_addr + constant(32 * $03), @wall, 16)
      ' flashing door
      if n & 128
        wordmove(tile_addr + constant(32 * $05), @door_frame, 16)
        wordmove(tile_addr + constant(32 * $25), @door_frame, 16)
      else
        wordmove(tile_addr + constant(32 * $05), tile_addr + constant(32 * $07), 16)
        wordmove(tile_addr + constant(32 * $25), tile_addr + constant(32 * $07), 16)

      n += 32
      if n => constant(32 * 8)
        n := 0
    i ^= 1

    ' scrolling steel wall
    cp := tile_addr + constant(32 * $3C)
    temp := word[cp]
    wordmove(cp, cp + 2, 15)
    word[cp + 31] := temp

    if flash_cnt > 0
      if --flash_cnt > 0
        byte[palette_addr + 0] := $07
      else
        byte[palette_addr + 0] := $02

    if i == 0 and new_life_cnt > 0
      if new_life_cnt-- == 1
        wordfill(tile_addr, $00, 16)
      else
        cp := byte[random_addr]
        byte[tile_addr] := cp
        byte[tile_addr + 9] := cp
        cp := byte[random_addr]
        byte[tile_addr + 8] := cp
        byte[tile_addr + 1] := cp
        cp := byte[random_addr]
        byte[tile_addr + 16] := cp
        byte[tile_addr + 25] := cp
        cp := byte[random_addr]
        byte[tile_addr + 24] := cp
        byte[tile_addr + 17] := cp

dat

' animated creatures, 8 frames per each
' -- amoeba
amoeba
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_3
      word  %%0_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%2_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3

      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_3
      word  %%0_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%2_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3

      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_2_0
      word  %%0_2_3_3_3_2_2_0
      word  %%2_3_3_3_3_3_2_0
      word  %%3_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%2_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3

      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_2_0
      word  %%0_2_3_3_3_2_2_0
      word  %%2_3_3_3_3_3_2_0
      word  %%3_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%2_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3

      word  %%3_3_2_0_0_0_2_3
      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_2_0
      word  %%3_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_2_0_0_0_2_3

      word  %%3_3_2_0_0_0_2_3
      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_2_0
      word  %%3_3_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_2_0_0_0_2_3

      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_3
      word  %%0_2_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%2_2_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3

      word  %%3_3_3_2_0_2_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_3_3_3_3_3_3_3
      word  %%0_2_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%2_2_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_2_0
      word  %%2_2_3_3_3_3_3_2
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_2_3_3_3
      word  %%3_3_3_2_0_2_3_3

' -- fireflies
firefly
      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2

      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_3_3_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_2_2_2_2_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_2_2_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_3_3_3_3_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0

      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2

      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_0_0_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_2_2_2_2_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_2
      word  %%2_2_2_2_2_2_2_2
      word  %%2_2_2_2_2_2_2_2

      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3

      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_2_2_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_2_2_2_2_2_2_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_3_3_3_3_3

' -- diamonds
diamonds
      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_3_3_3_0_0
      word  %%0_0_1_3_3_2_0_0
      word  %%0_2_2_2_2_2_3_0
      word  %%0_1_1_1_1_1_2_0
      word  %%2_0_0_0_0_0_0_3
      word  %%1_0_0_0_0_0_0_2
      word  %%2_1_1_1_1_1_1_3
      word  %%1_2_2_2_2_2_2_2
      word  %%0_2_3_3_3_3_3_0
      word  %%0_1_3_3_3_3_2_0
      word  %%0_0_2_2_2_3_0_0
      word  %%0_0_1_1_1_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_3_3_3_0_0
      word  %%0_0_1_2_2_2_0_0
      word  %%0_2_1_1_1_1_3_0
      word  %%0_1_0_0_0_0_2_0
      word  %%2_0_0_0_0_0_0_3
      word  %%1_1_1_1_1_1_1_2
      word  %%2_2_2_2_2_2_2_3
      word  %%1_3_3_3_3_3_3_2
      word  %%0_2_3_3_3_3_3_0
      word  %%0_1_2_2_2_2_2_0
      word  %%0_0_2_1_1_3_0_0
      word  %%0_0_1_0_0_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_2_2_3_0_0
      word  %%0_0_1_1_1_2_0_0
      word  %%0_2_0_0_0_0_3_0
      word  %%0_1_0_0_0_0_2_0
      word  %%2_1_1_1_1_1_1_3
      word  %%1_2_2_2_2_2_2_2
      word  %%2_3_3_3_3_3_3_3
      word  %%1_3_3_3_3_3_3_2
      word  %%0_2_2_2_2_2_3_0
      word  %%0_1_1_1_1_1_2_0
      word  %%0_0_2_0_0_3_0_0
      word  %%0_0_1_0_0_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_1_1_3_0_0
      word  %%0_0_1_0_0_2_0_0
      word  %%0_2_0_0_0_0_3_0
      word  %%0_1_1_1_1_1_2_0
      word  %%2_2_2_2_2_2_2_3
      word  %%1_3_3_3_3_3_3_2
      word  %%2_3_3_3_3_3_3_3
      word  %%1_2_2_2_2_2_2_2
      word  %%0_2_1_1_1_1_3_0
      word  %%0_1_0_0_0_0_2_0
      word  %%0_0_2_0_0_3_0_0
      word  %%0_0_1_1_1_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_0_0_3_0_0
      word  %%0_0_1_0_0_2_0_0
      word  %%0_2_1_1_1_1_3_0
      word  %%0_1_2_2_2_2_2_0
      word  %%2_3_3_3_3_3_3_3
      word  %%1_3_3_3_3_3_3_2
      word  %%2_2_2_2_2_2_2_3
      word  %%1_1_1_1_1_1_1_2
      word  %%0_2_0_0_0_0_3_0
      word  %%0_1_0_0_0_0_2_0
      word  %%0_0_2_1_1_3_0_0
      word  %%0_0_1_2_2_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_0_0_3_0_0
      word  %%0_0_1_1_1_2_0_0
      word  %%0_2_2_2_2_2_3_0
      word  %%0_1_3_3_3_3_2_0
      word  %%2_3_3_3_3_3_3_3
      word  %%1_2_2_2_2_2_2_2
      word  %%2_1_1_1_1_1_1_3
      word  %%1_0_0_0_0_0_0_2
      word  %%0_2_0_0_0_0_3_0
      word  %%0_1_1_1_1_1_2_0
      word  %%0_0_2_2_2_3_0_0
      word  %%0_0_1_3_3_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_1_1_3_0_0
      word  %%0_0_1_2_2_2_0_0
      word  %%0_2_3_3_3_3_3_0
      word  %%0_1_3_3_3_3_2_0
      word  %%2_2_2_2_2_2_2_3
      word  %%1_1_1_1_1_1_1_2
      word  %%2_0_0_0_0_0_0_3
      word  %%1_0_0_0_0_0_0_2
      word  %%0_2_1_1_1_1_3_0
      word  %%0_1_2_2_2_2_2_0
      word  %%0_0_2_3_3_3_0_0
      word  %%0_0_1_3_3_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

      word  %%0_0_0_2_3_0_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_2_2_2_3_0_0
      word  %%0_0_1_3_3_2_0_0
      word  %%0_2_3_3_3_3_3_0
      word  %%0_1_2_2_2_2_2_0
      word  %%2_1_1_1_1_1_1_3
      word  %%1_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_3
      word  %%1_1_1_1_1_1_1_2
      word  %%0_2_2_2_2_2_3_0
      word  %%0_1_3_3_3_3_2_0
      word  %%0_0_2_3_3_3_0_0
      word  %%0_0_1_2_2_2_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_1_1_0_0_0

' -- butterflies
butterfly
      word  %%3_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_1
      word  %%3_3_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_1_3
      word  %%2_2_3_0_0_2_2_2
      word  %%1_1_2_0_0_1_1_1
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%1_1_1_3_2_1_1_1
      word  %%2_2_2_2_1_2_2_2
      word  %%3_3_3_0_0_2_3_3
      word  %%3_3_2_0_0_1_3_3
      word  %%2_3_0_0_0_0_2_2
      word  %%1_2_0_0_0_0_1_1
      word  %%2_0_0_0_0_0_0_1
      word  %%1_0_0_0_0_0_0_1

      word  %%3_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_1
      word  %%3_3_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_1_3
      word  %%2_2_3_0_0_2_2_2
      word  %%1_1_2_0_0_1_1_1
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%1_1_1_3_2_1_1_1
      word  %%2_2_2_2_1_2_2_2
      word  %%3_3_3_0_0_2_3_3
      word  %%3_3_2_0_0_1_3_3
      word  %%2_3_0_0_0_0_2_2
      word  %%1_2_0_0_0_0_1_1
      word  %%2_0_0_0_0_0_0_1
      word  %%1_0_0_0_0_0_0_1

      word  %%0_3_0_0_0_0_2_0
      word  %%0_3_0_0_0_0_2_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_3_0_0_2_2_0
      word  %%0_1_2_0_0_1_1_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_1_1_3_2_1_1_0
      word  %%0_2_2_2_1_2_2_0
      word  %%0_3_3_0_0_2_3_0
      word  %%0_3_2_0_0_1_3_0
      word  %%0_3_0_0_0_0_2_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_0_0_0_0_2_0
      word  %%0_1_0_0_0_0_1_0

      word  %%0_0_3_0_0_2_0_0
      word  %%0_0_2_0_0_1_0_0
      word  %%0_0_3_0_0_2_0_0
      word  %%0_0_2_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0

      word  %%0_0_3_0_0_2_0_0
      word  %%0_0_2_0_0_1_0_0
      word  %%0_0_3_0_0_2_0_0
      word  %%0_0_2_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_1_0_0_1_0_0

      word  %%0_3_0_0_0_0_2_0
      word  %%0_3_0_0_0_0_2_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_3_0_0_2_2_0
      word  %%0_1_2_0_0_1_1_0
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%0_1_1_3_2_1_1_0
      word  %%0_2_2_2_1_2_2_0
      word  %%0_3_3_0_0_2_3_0
      word  %%0_3_2_0_0_1_3_0
      word  %%0_3_0_0_0_0_2_0
      word  %%0_2_0_0_0_0_1_0
      word  %%0_2_0_0_0_0_2_0
      word  %%0_1_0_0_0_0_1_0

      word  %%3_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_1
      word  %%3_3_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_1_3
      word  %%2_2_3_0_0_2_2_2
      word  %%1_1_2_0_0_1_1_1
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%1_1_1_3_2_1_1_1
      word  %%2_2_2_2_1_2_2_2
      word  %%3_3_3_0_0_2_3_3
      word  %%3_3_2_0_0_1_3_3
      word  %%2_3_0_0_0_0_2_2
      word  %%1_2_0_0_0_0_1_1
      word  %%2_0_0_0_0_0_0_1
      word  %%1_0_0_0_0_0_0_1

      word  %%3_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_1
      word  %%3_3_0_0_0_0_2_3
      word  %%3_2_0_0_0_0_1_3
      word  %%2_2_3_0_0_2_2_2
      word  %%1_1_2_0_0_1_1_1
      word  %%0_0_0_3_2_0_0_0
      word  %%0_0_0_2_1_0_0_0
      word  %%1_1_1_3_2_1_1_1
      word  %%2_2_2_2_1_2_2_2
      word  %%3_3_3_0_0_2_3_3
      word  %%3_3_2_0_0_1_3_3
      word  %%2_3_0_0_0_0_2_2
      word  %%1_2_0_0_0_0_1_1
      word  %%2_0_0_0_0_0_0_1
      word  %%1_0_0_0_0_0_0_1

' rockford
'   walking left
rockford_left
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_1_0
      word  %%0_1_0_0_0_0_0_3
      word  %%0_1_0_0_0_0_0_3
      word  %%3_3_0_0_0_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_1_0
      word  %%0_1_0_0_0_0_0_3
      word  %%0_1_0_0_0_0_0_3
      word  %%3_3_0_0_0_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_1_3
      word  %%0_0_1_0_0_0_0_3
      word  %%0_3_3_0_0_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_0_0_0
      word  %%0_0_1_0_1_1_1_0
      word  %%0_0_1_0_0_1_3_0
      word  %%0_3_3_0_0_0_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_1_1_0_0_0
      word  %%0_0_0_1_1_3_0_0
      word  %%0_0_3_3_0_3_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_1_1_1_0_0_0
      word  %%0_0_1_1_1_0_0_0
      word  %%0_0_0_3_3_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_1_1_1_0_0_0
      word  %%0_0_1_1_1_0_0_0
      word  %%0_0_3_3_3_3_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_2_0_2_2_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_3_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_0_0_0
      word  %%0_0_1_0_1_1_1_0
      word  %%0_0_1_0_0_1_3_0
      word  %%0_3_3_0_0_0_3_0

'   walking right
rockford_right
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_1_1_3_3_1_0_0
      word  %%3_0_0_0_0_0_1_0
      word  %%3_0_0_0_0_0_1_0
      word  %%0_0_0_0_0_0_3_3

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_1_1_3_3_1_0_0
      word  %%3_0_0_0_0_0_1_0
      word  %%3_0_0_0_0_0_1_0
      word  %%0_0_0_0_0_0_3_3

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%3_1_1_1_0_1_0_0
      word  %%3_0_0_0_0_1_0_0
      word  %%0_0_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_1_0_0
      word  %%0_1_1_1_0_1_0_0
      word  %%0_3_1_0_0_1_0_0
      word  %%0_3_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_1_1_0_0_0
      word  %%0_0_3_1_1_0_0_0
      word  %%0_0_3_0_3_3_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_1_1_1_0_0
      word  %%0_0_0_1_1_1_0_0
      word  %%0_0_0_3_3_0_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_1_1_1_0_0
      word  %%0_0_0_1_1_1_0_0
      word  %%0_0_3_3_3_3_0_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_0_3_3_1_0_0
      word  %%0_1_1_1_0_1_0_0
      word  %%0_3_1_0_0_1_0_0
      word  %%0_3_0_0_0_3_3_0

'   blinking eyes / tapping foot
rockford_bored
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_1_0_0
      word  %%0_0_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_1_0_0
      word  %%0_0_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_1_0_0
      word  %%0_0_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_2_2_2_2_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_1_0_0
      word  %%0_0_0_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_3_3_0

      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_0_3_2_2_3_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_3_3_0

'   rockford, standing
rockford
      word  %%0_0_0_0_0_0_0_0
      word  %%0_0_2_0_0_2_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_2_0_2_2_0_2_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%0_2_0_3_3_0_2_0
      word  %%0_3_0_2_2_0_3_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_0_2_2_0_0_0
      word  %%0_0_1_3_3_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_3_3_0_0_3_3_0

'   diamond frame
      word  %%0_0_0_1_1_0_0_0
      word  %%0_0_0_3_3_0_0_0
      word  %%0_0_1_0_0_1_0_0
      word  %%0_0_3_0_0_3_0_0
      word  %%0_1_0_0_0_0_1_0
      word  %%0_3_0_0_0_0_3_0
      word  %%1_0_0_0_0_0_0_1
      word  %%3_0_0_0_0_0_0_3
      word  %%1_0_0_0_0_0_0_2
      word  %%3_0_0_0_0_0_0_3
      word  %%0_1_0_0_0_0_2_0
      word  %%0_3_0_0_0_0_3_0
      word  %%0_0_1_0_0_2_0_0
      word  %%0_0_3_0_0_3_0_0
      word  %%0_0_0_1_2_0_0_0
      word  %%0_0_0_3_3_0_0_0

'   dummy
      word  %%3_3_0_0_0_0_3_3
      word  %%0_3_3_3_3_3_3_0
      word  %%3_3_2_3_3_2_3_3
      word  %%3_3_2_3_3_2_3_3
      word  %%3_3_3_3_3_3_3_3
      word  %%0_3_3_0_0_3_3_0
      word  %%0_0_3_3_0_3_0_0
      word  %%0_0_2_2_2_2_0_0
      word  %%1_1_2_2_2_2_1_0
      word  %%1_0_2_2_2_2_0_1
      word  %%0_0_2_2_2_2_1_0
      word  %%0_3_3_3_3_3_3_0
      word  %%0_3_3_0_0_3_3_0
      word  %%0_3_0_0_0_0_3_0
      word  %%3_3_0_0_0_0_3_0
      word  %%0_0_0_0_0_0_3_3

'   wall
wall
      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_2_2_0_2_2_2
      word  %%0_0_0_0_0_0_0_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%2_2_0_2_2_2_0_2
      word  %%0_0_0_0_0_0_0_0
      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_2_2_0_2_2_2
      word  %%0_0_0_0_0_0_0_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%2_2_0_2_2_2_0_2
      word  %%0_0_0_0_0_0_0_0

'   door frame
door_frame
      word  %%2_2_2_2_2_2_2_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_0_0_0_0_0_0_2
      word  %%2_2_2_2_2_2_2_2

'   magic wall
magic_wall
      word  %%3_3_3_3_3_3_3_3
      word  %%3_2_3_3_3_2_3_3
      word  %%3_2_2_2_3_2_2_2
      word  %%3_0_0_0_3_0_0_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_3_3_3_0_3
      word  %%2_2_0_3_2_2_0_3
      word  %%0_0_0_3_0_0_0_3
      word  %%3_3_3_3_3_3_3_3
      word  %%3_2_3_3_3_2_3_3
      word  %%3_2_2_2_3_2_2_2
      word  %%3_0_0_0_3_0_0_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_3_3_3_0_3
      word  %%2_2_0_3_2_2_0_3
      word  %%0_0_0_3_0_0_0_3

      word  %%0_3_3_3_0_3_3_3
      word  %%0_3_3_3_0_3_3_3
      word  %%0_3_2_2_0_3_2_2
      word  %%0_3_0_0_0_3_0_0
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_2_3_3_3_2
      word  %%2_2_3_2_2_2_3_2
      word  %%0_0_3_0_0_0_3_0
      word  %%0_3_3_3_0_3_3_3
      word  %%0_3_3_3_0_3_3_3
      word  %%0_3_2_2_0_3_2_2
      word  %%0_3_0_0_0_3_0_0
      word  %%3_3_3_3_3_3_3_3
      word  %%3_3_3_2_3_3_3_2
      word  %%2_2_3_2_2_2_3_2
      word  %%0_0_3_0_0_0_3_0

      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_3_2_0_2_3_2
      word  %%0_0_3_0_0_0_3_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%2_3_0_2_2_3_0_2
      word  %%0_3_0_0_0_3_0_0
      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_3_2_0_2_3_2
      word  %%0_0_3_0_0_0_3_0
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%2_3_0_2_2_3_0_2
      word  %%0_3_0_0_0_3_0_0

      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_2_3_0_2_2_3
      word  %%0_0_0_3_0_0_0_3
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%3_2_0_2_3_2_0_2
      word  %%3_0_0_0_3_0_0_0
      word  %%0_3_3_3_0_3_3_3
      word  %%0_2_3_3_0_2_3_3
      word  %%0_2_2_3_0_2_2_3
      word  %%0_0_0_3_0_0_0_3
      word  %%3_3_0_3_3_3_0_3
      word  %%3_3_0_2_3_3_0_2
      word  %%3_2_0_2_3_2_0_2
      word  %%3_0_0_0_3_0_0_0
      