CON ''------------------------------------------------- ADMINISTRA
_CLKMODE     = XTAL1 + PLL16X
_XINFREQ     = 5_000_000


'
'          hbeat   --------+
'          clk     -------+|
'          /wr     ------+||
'          /hs     -----+||| +------------------------- /cs
'                       |||| |                 +------+ d0..d7
'                       |||| |                 |      |
DB_IN            = %00001001_00000000_00000000_00000000 'dira-wert für datenbuseingabe
DB_OUT           = %00001001_00000000_00000000_11111111 'dira-wert für datenbusausgabe

M1               = %00000010_00000000_00000000_00000000 'busclk=1? & /prop1=0?
M2               = %00000010_10000000_00000000_00000000 'maske: busclk & /cs (/prop1)

M3               = %00000000_00000000_00000000_00000000 'busclk=0?
M4               = %00000010_00000000_00000000_00000000 'maske: busclk
'


#0,     D0,D1,D2,D3,D4,D5,D6,D7                         'datenbus
'#8,     ADM_SOUNDL,ADM_SOUNDR                           'sound (stereo 2 pin)
'#10,    ADM_SDD0,ADM_SDCLK,ADM_SDCMD,ADM_SDD3           'sd-cardreader (4 pin)
#23,    ADM_SELECT                                      'administra-auswahlsignal
#24,    HBEAT                                           'front-led
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal


'index für dmarker
#0,     RMARKER                 'root
        SMARKER                 'system
        UMARKER                 'programmverzeichnis
        AMARKER
        BMARKER
        CMARKER
LED_OPEN     = HBEAT                                    'led-pin für anzeige "dateioperation"

var
  long  dmarker[6]                                      'speicher für dir-marker
  byte  tbuf[20]                                        'stringpuffer
  byte  tbuf2[20]
  byte copy_buffer[4002]                                'Kopier-Puffer

OBJ
                snd             : "NS_sound_drv_030.spin"           ' Sound driver
                snd2             : "NS_sound_drv_030.spin"           ' Sound driver
                sdfat           : "adm-fat"        'fatengine

PUB main | cmd,err,i                                      'chip: kommandointerpreter
''funktionsgruppe               : chip
''funktion                      : kommandointerpreter
''eingabe                       : -
''ausgabe                       : -

  init_chip                                             'bus/vga/keyboard/maus initialisieren
  repeat

    cmd := bus_getchar                                  'kommandocode empfangen
    !outa[hbeat]
'    debug.dec(cmd)
'    debug.tx(44)
'    i++
'    if i==30
'       i:=0
'       debug.tx(13)

    case cmd
'       ------------ Sound-Engine-Commands -------------------------
        1: snd.playsound(1,snd#SHAPE_SQUARE,500,1000)
           snd2.playsound(1,snd#SHAPE_SQUARE,500,1000)
        2: snd.playsound(1,snd#SHAPE_SQUARE,1500,1000)
           snd2.playsound(1,snd#SHAPE_SQUARE,1500,1000)
        3: i:=sub_getlong
           snd.playsound(1,snd#SHAPE_TRIANGLE,i,3000)
           snd2.playsound(1,snd#SHAPE_TRIANGLE,i,3000)
        4: snd.playsound(1,snd#SHAPE_SINE,3000,2000)
           snd2.playsound(1,snd#SHAPE_SINE,3000,2000)
        5: i:=sub_getlong
           snd.playsound(1,snd#SHAPE_TRIANGLE,i,2000)                                           '
           snd2.playsound(1,snd#SHAPE_TRIANGLE,i,2000)
PUB init_chip|i                                         'chip: initialisierung des administra-chips
''funktionsgruppe               : chip
''funktion                      : - initialisierung des businterface
''                                - grundzustand definieren (hss aktiv, systemklänge an)
''eingabe                       : -
''ausgabe                       : -


    repeat i from 0 to 7                                'evtl. noch laufende cogs stoppen
      ifnot i == cogid
        cogstop(i)

  'businterface initialisieren
  outa[bus_hs] := 1                                     'handshake inaktiv             ,frida
  dira := db_in                                         'datenbus auf eingabe schalten ,frida

'  debug.start(31,30,0,19200)
  'start sound driver
'#####################
  snd.start(8)
  snd2.start(9)
  'snd.playsound(1,snd#SHAPE_SINE,3000,2000)
  'New_Game_Music_Reset
CON ''------------------------------------------------- SUBPROTOKOLL-FUNKTIONEN

PRI sub_getlong:wert                                    'sub: long empfangen
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen long-wert von regnatix zu empfangen
''eingabe                       : -
''ausgabe                       : 32bit-wert der empfangen wurde
''busprotokoll                  : [get.byte1][get.byte2][get.byte3][get.byte4]
''                              : [  hsb    ][         ][         ][   lsb   ]

  wert :=        bus_getchar << 24                      '32 bit empfangen hsb/lsb
  wert := wert + bus_getchar << 16
  wert := wert + bus_getchar << 8
  wert := wert + bus_getchar



PRI bus_getchar : zeichen                               'chip: ein byte über bus empfangen
''funktionsgruppe               : chip
''funktion                      : emfangsroutine für ein byte von regnatix über den systembus
''eingabe                       : -
''ausgabe                       : byte zeichen

  waitpeq(M1,M2,0)                                      'busclk=1? & /prop1=0?
  zeichen := ina[7..0]                                  'daten einlesen
  outa[bus_hs] := 0                                     'daten quittieren
  outa[bus_hs] := 1
  waitpeq(M3,M4,0)                                      'busclk=0?


