' REM Asset data file
' spin function to get the address of the tilemap.
PUB tilemap
RETURN @_tilemap

' spin function to get the address of the tiles data.
PUB tiles
RETURN @_tiles

dat
' Start tilemap definition here
_tilemap
' First 32 tile row is called the 'toptilemap' portion of the screen, which is non-scrolling.
' It can used to display score or life status. Please compile and see 'Rem_alien_invader' for
' a working example.
toptilemap    byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
' Same goes for 'bottomtilemap'.
bottomtilemap byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32

' The real game tilemap starts here:
' The tilemap is created in Mappy (free Windows map utility), and then translated using 'xgs_convert_mappy.pl'
' Please read readme.txt if you need additional information.
tilemap000   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap001   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap002   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 202, 203, 203, 203, 203, 204
tilemap003   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap004   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 218, 219, 219, 219, 219, 220
tilemap005   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 202, 203, 204, 16, 16, 16
tilemap006   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap007   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 218, 219, 220, 16, 16, 16
tilemap008   byte 16, 16, 202, 203, 204, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap009   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap010   byte 16, 16, 218, 219, 220, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap011   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16
tilemap012   byte 16, 16, 16, 16, 16, 16, 16, 132, 195, 195, 195, 195, 195, 195, 195, 195
tilemap013   byte 195, 195, 195, 195, 195, 195, 195, 133, 16, 16, 16, 16, 16, 16, 16, 16
tilemap014   byte 16, 16, 16, 16, 16, 16, 16, 106, 107, 107, 107, 107, 107, 107, 107, 107
tilemap015   byte 107, 107, 107, 107, 107, 107, 107, 108, 16, 16, 16, 16, 16, 16, 16, 16
tilemap016   byte 16, 16, 16, 16, 16, 16, 16, 106, 107, 1, 2, 3, 4, 5, 6, 7
tilemap017   byte 8, 9, 10, 11, 12, 13, 107, 108, 16, 16, 16, 16, 16, 16, 16, 16
tilemap018   byte 16, 16, 16, 16, 16, 16, 16, 106, 107, 17, 18, 19, 20, 21, 22, 23
tilemap019   byte 24, 25, 26, 27, 28, 29, 107, 108, 16, 16, 16, 16, 16, 16, 202, 203
tilemap020   byte 16, 16, 16, 16, 16, 16, 16, 106, 107, 107, 107, 107, 107, 107, 107, 107
tilemap021   byte 107, 107, 107, 107, 107, 107, 107, 108, 16, 16, 16, 16, 16, 16, 218, 219
tilemap022   byte 16, 16, 16, 16, 16, 16, 16, 148, 211, 211, 211, 211, 211, 211, 211, 211
tilemap023   byte 211, 211, 211, 211, 211, 211, 211, 149, 16, 16, 16, 16, 16, 16, 16, 16
tilemap024   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 106, 108, 16, 16, 16, 16, 16
tilemap025   byte 16, 16, 16, 16, 200, 106, 108, 201, 16, 16, 16, 16, 16, 16, 16, 16
tilemap026   byte 16, 16, 16, 16, 16, 16, 16, 16, 16, 106, 108, 200, 201, 16, 16, 16
tilemap027   byte 16, 16, 16, 16, 216, 106, 108, 217, 16, 16, 16, 16, 16, 16, 16, 16
tilemap028   byte 16, 16, 16, 16, 132, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195
tilemap029   byte 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 133, 16, 16, 16, 16, 16
tilemap030   byte 16, 16, 200, 201, 106, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap031   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 108, 16, 16, 16, 200, 201
tilemap032   byte 16, 16, 216, 217, 106, 107, 107, 107, 107, 62, 52, 57, 50, 55, 48, 107
tilemap033   byte 59, 55, 44, 68, 48, 61, 107, 107, 107, 107, 108, 16, 16, 16, 216, 217
tilemap034   byte 201, 196, 213, 198, 106, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap035   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 108, 200, 201, 196, 213, 198
tilemap036   byte 217, 212, 213, 214, 106, 107, 107, 107, 107, 107, 63, 66, 58, 107, 59, 55
tilemap037   byte 44, 68, 48, 61, 107, 107, 107, 107, 107, 107, 108, 216, 217, 212, 213, 214
tilemap038   byte 14, 14, 14, 14, 106, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap039   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 108, 14, 14, 14, 14, 14
tilemap040   byte 15, 15, 15, 15, 106, 107, 107, 107, 107, 107, 65, 62, 107, 46, 58, 56
tilemap041   byte 59, 64, 63, 48, 61, 107, 107, 107, 107, 107, 108, 15, 15, 15, 15, 15
tilemap042   byte 30, 30, 30, 30, 106, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap043   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 108, 30, 30, 30, 30, 30
tilemap044   byte 31, 31, 31, 31, 148, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211
tilemap045   byte 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 149, 31, 31, 31, 31, 31
tilemap046   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 106, 108, 42, 42, 42, 42, 42
tilemap047   byte 42, 42, 42, 42, 42, 106, 108, 42, 42, 42, 42, 42, 42, 42, 42, 42
tilemap048   byte 16, 16, 216, 213, 217, 16, 218, 220, 218, 219, 219, 220, 16, 16, 16, 16
tilemap049   byte 16, 16, 16, 16, 16, 16, 218, 219, 219, 219, 220, 16, 84, 85, 16, 87
tilemap050   byte 201, 196, 213, 213, 198, 199, 200, 201, 16, 16, 16, 16, 34, 35, 36, 37
tilemap051   byte 38, 39, 40, 41, 16, 16, 80, 81, 16, 16, 16, 99, 100, 101, 102, 103
tilemap052   byte 217, 212, 213, 213, 214, 215, 216, 217, 16, 16, 16, 83, 14, 121, 33, 33
tilemap053   byte 33, 33, 121, 14, 86, 16, 96, 97, 16, 16, 114, 115, 116, 117, 118, 119
tilemap054   byte 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 124, 125, 221
tilemap055   byte 32, 126, 127, 14, 14, 14, 14, 14, 33, 33, 82, 14, 14, 14, 14, 14
tilemap056   byte 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 122, 32
tilemap057   byte 32, 123, 14, 14, 14, 14, 89, 32, 221, 32, 82, 159, 88, 89, 14, 14
tilemap058   byte 15, 132, 195, 195, 195, 195, 195, 195, 195, 133, 15, 138, 137, 137, 139, 136
tilemap059   byte 136, 142, 137, 137, 141, 88, 105, 32, 32, 221, 82, 221, 104, 105, 15, 15
tilemap060   byte 15, 106, 107, 107, 107, 107, 107, 107, 107, 108, 15, 122, 32, 32, 32, 32
tilemap061   byte 32, 32, 32, 32, 123, 104, 105, 221, 32, 32, 98, 32, 104, 105, 15, 15
tilemap062   byte 15, 106, 63, 58, 59, 107, 107, 107, 107, 108, 15, 122, 32, 32, 32, 32
tilemap063   byte 32, 32, 32, 32, 123, 104, 105, 32, 32, 32, 112, 113, 104, 105, 15, 15
tilemap064   byte 30, 106, 70, 70, 70, 70, 70, 70, 70, 108, 30, 122, 32, 32, 32, 32
tilemap065   byte 32, 32, 32, 32, 123, 104, 105, 32, 32, 221, 128, 129, 104, 105, 30, 30
tilemap066   byte 30, 106, 107, 107, 107, 107, 107, 107, 107, 108, 30, 122, 32, 32, 32, 32
tilemap067   byte 32, 32, 32, 32, 123, 104, 105, 32, 32, 32, 144, 145, 104, 105, 30, 30
tilemap068   byte 30, 106, 62, 46, 58, 61, 48, 107, 107, 108, 30, 122, 32, 32, 32, 32
tilemap069   byte 32, 32, 32, 32, 123, 104, 105, 32, 221, 32, 160, 161, 104, 105, 30, 30
tilemap070   byte 30, 106, 70, 70, 70, 70, 70, 70, 70, 108, 30, 122, 32, 32, 32, 32
tilemap071   byte 32, 32, 32, 32, 123, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30
tilemap072   byte 30, 148, 211, 211, 211, 211, 211, 211, 211, 149, 30, 122, 32, 32, 32, 32
tilemap073   byte 32, 32, 32, 32, 123, 30, 132, 195, 195, 195, 195, 195, 195, 133, 30, 30
tilemap074   byte 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 122, 32, 32, 32, 32
tilemap075   byte 32, 32, 32, 32, 123, 31, 106, 107, 107, 107, 107, 107, 107, 108, 31, 31
tilemap076   byte 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 122, 32, 32, 32, 32
tilemap077   byte 32, 32, 32, 32, 123, 31, 106, 55, 48, 65, 48, 55, 107, 108, 31, 31
tilemap078   byte 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 122, 32, 32, 32, 32
tilemap079   byte 32, 32, 32, 32, 123, 31, 106, 107, 107, 107, 107, 70, 70, 108, 31, 31
tilemap080   byte 31, 31, 31, 175, 32, 32, 159, 32, 143, 31, 31, 122, 32, 32, 32, 32
tilemap081   byte 32, 32, 32, 32, 123, 31, 106, 107, 107, 107, 107, 107, 107, 108, 31, 31
tilemap082   byte 31, 31, 31, 32, 32, 166, 167, 32, 221, 88, 89, 122, 32, 32, 32, 32
tilemap083   byte 32, 32, 32, 32, 123, 31, 106, 62, 59, 48, 48, 47, 107, 108, 31, 31
tilemap084   byte 42, 42, 42, 221, 32, 182, 183, 32, 32, 104, 105, 122, 32, 32, 32, 32
tilemap085   byte 32, 32, 32, 32, 123, 42, 106, 107, 107, 107, 107, 107, 107, 108, 42, 42
tilemap086   byte 42, 42, 42, 32, 164, 165, 134, 135, 32, 104, 105, 122, 32, 32, 32, 32
tilemap087   byte 32, 32, 32, 32, 123, 42, 106, 107, 107, 107, 107, 107, 107, 108, 42, 42
tilemap088   byte 42, 42, 42, 32, 180, 181, 150, 151, 221, 104, 105, 122, 32, 32, 32, 32
tilemap089   byte 32, 32, 32, 32, 123, 42, 106, 49, 58, 62, 62, 52, 55, 108, 42, 42
tilemap090   byte 42, 42, 42, 190, 191, 32, 191, 32, 205, 42, 42, 122, 32, 32, 32, 32
tilemap091   byte 32, 32, 32, 32, 123, 42, 106, 107, 107, 107, 107, 70, 70, 108, 42, 42
tilemap092   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 124, 140, 140, 140, 140
tilemap093   byte 140, 140, 140, 140, 127, 42, 148, 211, 211, 211, 211, 211, 211, 149, 42, 42
tilemap094   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42
tilemap095   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42
tilemap096   byte 84, 85, 16, 87, 218, 219, 219, 220, 16, 16, 218, 132, 195, 195, 195, 195
tilemap097   byte 195, 195, 195, 195, 133, 219, 219, 220, 16, 218, 220, 218, 219, 219, 220, 16
tilemap098   byte 100, 101, 102, 103, 34, 35, 36, 37, 38, 36, 37, 106, 107, 55, 48, 65
tilemap099   byte 48, 55, 43, 107, 108, 39, 40, 38, 39, 40, 41, 16, 16, 80, 81, 16
tilemap100   byte 116, 117, 118, 119, 83, 120, 33, 33, 33, 33, 121, 106, 70, 70, 107, 107
tilemap101   byte 107, 107, 70, 70, 108, 120, 33, 33, 33, 33, 121, 86, 16, 96, 97, 16
tilemap102   byte 14, 14, 14, 14, 14, 124, 125, 32, 32, 126, 127, 148, 211, 211, 211, 211
tilemap103   byte 211, 211, 211, 211, 149, 124, 125, 32, 32, 126, 127, 14, 14, 14, 14, 14
tilemap104   byte 14, 14, 14, 14, 14, 14, 122, 32, 32, 123, 14, 14, 14, 14, 14, 33
tilemap105   byte 33, 14, 14, 14, 14, 14, 122, 32, 32, 123, 14, 14, 14, 14, 14, 14
tilemap106   byte 15, 15, 15, 138, 137, 137, 139, 136, 136, 142, 137, 137, 141, 15, 15, 82
tilemap107   byte 32, 15, 15, 138, 137, 137, 139, 136, 136, 142, 137, 137, 141, 15, 15, 15
tilemap108   byte 15, 15, 15, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 89, 159, 82
tilemap109   byte 221, 159, 88, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 15, 15, 15
tilemap110   byte 15, 15, 15, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 105, 32, 82
tilemap111   byte 32, 221, 104, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 15, 15, 15
tilemap112   byte 30, 30, 30, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 105, 32, 98
tilemap113   byte 32, 32, 104, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 30, 30, 30
tilemap114   byte 30, 30, 30, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 105, 32, 130
tilemap115   byte 131, 32, 104, 122, 32, 32, 156, 157, 158, 32, 32, 32, 123, 30, 30, 30
tilemap116   byte 30, 30, 30, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 105, 32, 146
tilemap117   byte 147, 32, 104, 122, 32, 32, 172, 173, 174, 32, 32, 32, 123, 30, 30, 30
tilemap118   byte 30, 30, 30, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 105, 221, 162
tilemap119   byte 145, 32, 104, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 30, 30, 30
tilemap120   byte 30, 30, 30, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 190, 32, 160
tilemap121   byte 161, 32, 205, 122, 32, 32, 184, 185, 186, 32, 32, 32, 123, 30, 30, 30
tilemap122   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap123   byte 31, 31, 31, 122, 32, 32, 187, 188, 189, 32, 32, 32, 123, 31, 31, 31
tilemap124   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap125   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap126   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap127   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap128   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 132, 195, 195
tilemap129   byte 195, 195, 133, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap130   byte 31, 31, 31, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 90, 91, 92
tilemap131   byte 93, 94, 95, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 31, 31, 31
tilemap132   byte 42, 42, 42, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 106, 107, 107
tilemap133   byte 70, 70, 108, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 42, 42, 42
tilemap134   byte 42, 42, 42, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 106, 70, 70
tilemap135   byte 107, 107, 108, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 42, 42, 42
tilemap136   byte 42, 42, 42, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 148, 211, 211
tilemap137   byte 211, 211, 149, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 42, 42, 42
tilemap138   byte 42, 42, 42, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 42, 42, 42
tilemap139   byte 42, 42, 42, 122, 32, 32, 32, 32, 32, 32, 32, 32, 123, 42, 42, 42
tilemap140   byte 42, 42, 42, 124, 140, 140, 140, 140, 140, 140, 140, 140, 127, 42, 42, 42
tilemap141   byte 42, 42, 42, 124, 140, 140, 140, 140, 140, 140, 140, 140, 127, 42, 42, 42
tilemap142   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42
tilemap143   byte 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42
tilemap144   byte 16, 16, 218, 219, 219, 219, 219, 138, 137, 137, 137, 137, 137, 137, 137, 137
tilemap145   byte 137, 137, 137, 137, 137, 137, 137, 137, 141, 219, 219, 219, 219, 220, 16, 16
tilemap146   byte 16, 16, 16, 16, 16, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107
tilemap147   byte 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16, 16, 16, 16, 16
tilemap148   byte 16, 16, 16, 138, 137, 137, 137, 139, 107, 107, 72, 107, 59, 55, 44, 68
tilemap149   byte 48, 61, 107, 50, 44, 56, 48, 107, 142, 137, 137, 137, 141, 16, 16, 16
tilemap150   byte 16, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap151   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap152   byte 16, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap153   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap154   byte 16, 16, 16, 122, 107, 107, 49, 58, 62, 62, 52, 55, 107, 55, 48, 65
tilemap155   byte 48, 55, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap156   byte 204, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap157   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap158   byte 220, 16, 16, 122, 107, 107, 107, 107, 71, 59, 107, 186, 206, 206, 206, 206
tilemap159   byte 206, 206, 206, 206, 206, 189, 107, 70, 70, 107, 107, 107, 123, 16, 16, 16
tilemap160   byte 16, 16, 16, 122, 107, 107, 107, 107, 72, 59, 107, 188, 223, 189, 222, 222
tilemap161   byte 222, 222, 222, 222, 222, 189, 107, 70, 70, 107, 107, 107, 123, 16, 202, 203
tilemap162   byte 16, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap163   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 218, 219
tilemap164   byte 16, 16, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap165   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap166   byte 16, 16, 16, 122, 107, 107, 62, 59, 48, 48, 47, 107, 107, 107, 107, 107
tilemap167   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap168   byte 203, 204, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap169   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap170   byte 219, 220, 16, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap171   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap172   byte 16, 16, 16, 122, 107, 107, 107, 107, 71, 59, 107, 107, 107, 107, 107, 107
tilemap173   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 16, 16, 16
tilemap174   byte 16, 200, 201, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap175   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 200, 201, 16
tilemap176   byte 16, 216, 217, 122, 107, 107, 107, 107, 107, 107, 107, 55, 58, 66, 107, 107
tilemap177   byte 56, 48, 47, 107, 107, 51, 52, 50, 51, 107, 107, 107, 123, 216, 217, 16
tilemap178   byte 196, 213, 198, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap179   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 213, 198, 199
tilemap180   byte 212, 213, 214, 122, 107, 107, 107, 107, 72, 59, 107, 107, 107, 107, 107, 107
tilemap181   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 213, 214, 215
tilemap182   byte 14, 14, 14, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap183   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 14, 14, 14
tilemap184   byte 15, 15, 15, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap185   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 15, 15, 15
tilemap186   byte 30, 30, 30, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap187   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 30, 30, 30
tilemap188   byte 31, 31, 31, 122, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107
tilemap189   byte 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 123, 31, 31, 31
tilemap190   byte 42, 42, 42, 124, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137
tilemap191   byte 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 127, 42, 42, 42




_tiles
' Tiles data goes here. Each tile is 8x8.
' You can put as many as you want. The only restriction being memory limit.
' Default number of tiles is ??. You can change that by modifying 'xgs_tiles_export.pl'
tile000 long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
tile001 long $ACACACAC,$ACACACAC,$ACACACAC,$000000AC
        long $00ACACAC,$9C9C0000,$00ACACAC,$9C9C9C00
        long $0000ACAC,$0000009C,$9C00ACAC,$00050000
        long $9C9C00AC,$05050500,$9C9C00AC,$00050500
tile002 long $AC000000,$ACACACAC,$00009C9C,$AC000000
        long $9C9C9C9C,$009C9C9C,$009C9C9C,$9C000000
        long $009C9C9C,$00000505,$009C9C00,$00050005
        long $009C0000,$00050505,$009C0005,$00000500
tile003 long $ACACACAC,$ACACACAC,$ACACACAC,$0000ACAC
        long $ACACAC00,$000000AC,$ACACAC00,$000000AC
        long $ACAC009C,$0000ACAC,$ACAC009C,$0000ACAC
        long $ACAC009C,$00ACACAC,$ACAC009C,$00ACACAC
tile004 long $00000000,$ACACAC00,$FBFBFBFB,$ACAC0000
        long $FBFBFBFB,$AC0000FB,$FBFBFBFB,$0000FBFB
        long $0000FB00,$FBFB0000,$0000FB00,$FB0000AC
        long $00FBFB00,$FB00ACAC,$00FBFB00,$FB000000
tile005 long $00000000,$00000000,$1C1C1C00,$001C1C1C
        long $001C1C00,$1C1C1C00,$001C1C00,$1C1C0000
        long $001C1C00,$1C1C0000,$1C1C1C00,$001C1C1C
        long $1C1C1C00,$0000001C,$1C1C0000,$00001C1C
tile006 long $ACACACAC,$00ACACAC,$ACACAC00,$0000ACAC
        long $ACACAC00,$0000ACAC,$ACACAC00,$B90000AC
        long $ACACAC00,$B90000AC,$ACACAC00,$B90000AC
        long $ACACACAC,$B90000AC,$ACACACAC,$B90000AC
tile007 long $ACAC0000,$ACACACAC,$AC0000B9,$00ACACAC
        long $0000B9B9,$0000ACAC,$0000B9B9,$B900ACAC
        long $AC00B9B9,$B90000AC,$0000B9B9,$B9000000
        long $B9B9B9B9,$B9B9B9B9,$B9B9B9B9,$B9B9B9B9
tile008 long $ACAC0000,$ACACACAC,$00000000,$ACACACAC
        long $BA0000B9,$ACACAC00,$BA00B9B9,$00AC0000
        long $BA00B9B9,$000000BA,$BA00B9B9,$0000BABA
        long $BA0000B9,$BABABABA,$BA0000B9,$BABABABA
tile009 long $000000AC,$00000000,$00000000,$3A3A3A3A
        long $00BA0000,$3A3A3A3A,$00BABA00,$003A3A3A
        long $00BABA00,$AC003A3A,$00BABABA,$00003A3A
        long $00BABABA,$003A3A3A,$0000BABA,$003A3A00
tile010 long $00000000,$ACACAC00,$3A3A3A3A,$00AC0000
        long $3A3A3A3A,$0000003A,$3A3A0000,$0000003A
        long $3A3A00AC,$8C00003A,$3A0000AC,$8C00003A
        long $3A3A00AC,$8C000000,$3A3A0000,$8C000000
tile011 long $00000000,$AC000000,$8C8C8C00,$AC008C8C
        long $8C8C8C8C,$00008C8C,$8C008C8C,$008C8C8C
        long $00AC008C,$008C8C8C,$0000008C,$00008C8C
        long $8C8C8C8C,$AC008C8C,$8C8C8C8C,$AC000000
tile012 long $ACACACAC,$00000000,$00ACACAC,$006A6A00
        long $0000ACAC,$6A6A6A6A,$0000ACAC,$6A6A6A6A
        long $0000ACAC,$6A6A6A6A,$0000ACAC,$6A006A6A
        long $0000ACAC,$00006A6A,$0000ACAC,$AC006A6A
tile013 long $ACACACAC,$ACACACAC,$ACAC0000,$ACACACAC
        long $ACAC006A,$ACACACAC,$AC00006A,$ACACACAC
        long $AC006A6A,$ACACACAC,$00006A6A,$ACACACAC
        long $006A6A6A,$ACACACAC,$006A6A00,$ACACACAC
tile014 long $9C9CABAB,$9C9C9C9C,$AB9C9C9C,$9CAB9CAB
        long $9C9CAB9C,$AB9C9C9C,$9C9C9C9C,$9C9C9C9C
        long $9C9C9CAB,$9CABAB9C,$9CABAB9C,$9C9C9C9C
        long $9C9C9C9C,$9C9CABAB,$9C9CAB9C,$AB9C9C9C
tile015 long $ABABABAB,$AAABABAB,$AAABABAB,$ABABABAA
        long $ABABAAAA,$ABABABAB,$ABABABAB,$ABABABAB
        long $ABABABAB,$ABABAAAA,$ABABABAA,$AAAAABAB
        long $AAAAABAB,$ABABABAB,$ABABABAB,$ABABABAB
tile016 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile017 long $9C9C0000,$05050000,$9C9C9C00,$0000009C
        long $9C9C0000,$9C9C9C9C,$9C9C00AC,$9C00009C
        long $9C0000AC,$00009C9C,$0000ACAC,$9C9C9C9C
        long $00ACACAC,$9C9C0000,$ACACACAC,$000000AC
tile018 long $9C9C0005,$9C000000,$9C9C9C00,$9C9C9C9C
        long $9C9C9C9C,$9C9C9C9C,$9C9C9C9C,$9C9C009C
        long $009C9C00,$009C0000,$9C00009C,$00009C9C
        long $9C9C9C9C,$AC000000,$00000000,$ACACAC00
tile019 long $ACAC009C,$00ACACAC,$ACAC009C,$00ACACAC
        long $ACAC0000,$ACACACAC,$ACACAC00,$ACACACAC
        long $ACACAC00,$00ACACAC,$ACACACAC,$00ACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile020 long $FBFB0000,$FBFB0000,$FBFB0000,$FBFBFBFB
        long $FBFB0000,$00FBFBFB,$FBFB0000,$00000000
        long $00000000,$00000000,$00000000,$00ACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile021 long $001C00FB,$001C1C00,$001C0000,$1C000000
        long $001C1C00,$00000000,$001C1C00,$000000AC
        long $00000000,$0000ACAC,$AC000000,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile022 long $ACACAC00,$B90000AC,$ACAC0000,$B90000AC
        long $ACAC001C,$B90000AC,$ACAC0000,$B90000AC
        long $ACAC0000,$B90000AC,$ACACACAC,$000000AC
        long $ACACACAC,$000000AC,$ACACACAC,$ACACACAC
tile023 long $B9B9B9B9,$B9B9B9B9,$000000B9,$B9B90000
        long $000000B9,$00B90000,$ACAC00B9,$00B90000
        long $ACAC00B9,$00000000,$ACAC0000,$00000000
        long $ACACAC00,$AC0000AC,$ACACACAC,$ACACACAC
tile024 long $00000000,$BABABA00,$0000AC00,$BABA0000
        long $ACACAC00,$BA000000,$ACACACAC,$BA000000
        long $ACACACAC,$BABA0000,$ACACACAC,$00BA0000
        long $ACACACAC,$00000000,$ACACACAC,$AC0000AC
tile025 long $00000000,$3A3A3A00,$00AC0000,$3A3A3A00
        long $00ACAC00,$3A3A3A00,$00ACAC00,$3A3A3A00
        long $00ACAC00,$00000000,$00ACAC00,$00000000
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile026 long $3A3A3A3A,$8C000000,$003A3A3A,$8C000000
        long $00003A3A,$8C0000AC,$AC000000,$8C0000AC
        long $ACAC0000,$8C0000AC,$ACACACAC,$000000AC
        long $ACACACAC,$000000AC,$ACACACAC,$ACACACAC
tile027 long $8C8C8C8C,$ACAC0000,$8C8C8C8C,$ACACAC00
        long $8C000000,$ACAC0000,$8C000000,$AC00008C
        long $00000000,$00008C8C,$00000000,$0000008C
        long $0000ACAC,$AC000000,$0000ACAC,$ACACAC00
tile028 long $0000ACAC,$00006A6A,$0000ACAC,$6A6A6A6A
        long $0000ACAC,$6A6A6A6A,$0000ACAC,$006A6A6A
        long $0000ACAC,$00006A6A,$000000AC,$00000000
        long $000000AC,$ACAC0000,$ACACACAC,$ACACACAC
tile029 long $006A6A00,$ACACAC00,$6A6A6A6A,$ACACAC00
        long $6A6A6A6A,$ACAC0000,$6A6A6A00,$ACAC006A
        long $6A6A0000,$ACAC006A,$00000000,$ACAC0000
        long $000000AC,$ACACAC00,$0000ACAC,$ACACACAC
tile030 long $AAAA9999,$AAAAAAAA,$99AAAAAA,$AA99AA99
        long $AAAA99AA,$99AAAAAA,$AAAAAAAA,$AAAAAAAA
        long $AAAAAA99,$AA9999AA,$AA9999AA,$AAAAAAAA
        long $AAAAAAAA,$AAAA9999,$AAAA99AA,$99AAAAAA
tile031 long $99999999,$A8999999,$A8999999,$999999A8
        long $9999A8A8,$99999999,$99999999,$99999999
        long $99999999,$9999A8A8,$999999A8,$A8A89999
        long $A8A89999,$99999999,$99999999,$99999999
tile032 long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile033 long $ABAB9CAB,$9CABAB9C,$00AAABAA,$00AA00AA
        long $AA0000AA,$AA000000,$0000AA00,$00AA0099
        long $00000000,$00000000,$00000099,$00990000
        long $00990000,$00000000,$00000000,$00000000
tile034 long $00002C2C,$2C2C2C00,$99002C2C,$000000AA
        long $002C2C2C,$2C00AA99,$002C2C2C,$2C00AA99
        long $002C2C2C,$2C00AA99,$2C2C2C2C,$00AA9900
        long $2C2C2C2C,$00AA9900,$2C2C2C2C,$00AA9900
tile035 long $2C2C2C2C,$2C2C2C2C,$2C2C2C00,$2C2C2C2C
        long $0000002C,$2C2C0000,$2C2C2C2C,$00002C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile036 long $00002C2C,$2C2C2C00,$99002C2C,$2C2C00AA
        long $99002C2C,$2C2C00AA,$00000000,$0000AA99
        long $002C2C2C,$2C00AA99,$002C2C2C,$2C00AA99
        long $002C2C2C,$2C00AA99,$002C2C2C,$2C00AA99
tile037 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$00002C2C
        long $002C2C2C,$2C2C0000,$2C000000,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile038 long $002C2C2C,$2C2C0000,$99000000,$2C2C00AA
        long $99002C2C,$000000AA,$99002C2C,$2C2C00AA
        long $AA99002C,$2C2C2C00,$AA99002C,$2C2C2C00
        long $AA99002C,$2C2C2C00,$AA99002C,$2C2C2C00
tile039 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C00,$0000002C,$0000002C,$002C2C00
        long $2C2C2C2C,$002C2C2C,$2C2C2C2C,$002C2C2C
        long $2C2C2C2C,$99002C2C,$2C2C2C2C,$99002C2C
tile040 long $00000000,$2C2C2C2C,$00AA9900,$2C2C2C2C
        long $00AA9900,$00002C2C,$2C00AA99,$2C2C0000
        long $2C00AA99,$2C2C2C2C,$2C00AA99,$2C2C2C2C
        long $2C2C00AA,$2C2C2C2C,$2C2C00AA,$2C2C2C2C
tile041 long $002C2C2C,$2C2C0000,$99002C2C,$2C2C00AA
        long $99000000,$2C2C00AA,$AA99002C,$2C2C2C00
        long $AA99002C,$2C2C2C00,$AA99002C,$2C2C2C00
        long $00AA9900,$2C2C2C2C,$00AA9900,$2C2C2C2C
tile042 long $A8A88888,$A8A8A8A8,$88A8A8A8,$A888A888
        long $A8A888A8,$88A8A8A8,$A8A8A8A8,$A8A8A8A8
        long $A8A8A888,$A88888A8,$A88888A8,$A8A8A8A8
        long $A8A8A8A8,$A8A88888,$A8A888A8,$88A8A8A8
tile043 long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$00ACACAC,$ACAC0000
        long $0000ACAC,$ACACAC00,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile044 long $00ACACAC,$ACACAC00,$0000ACAC,$ACAC0000
        long $AC0000AC,$AC0000AC,$000000AC,$AC000000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile045 long $000000AC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$000000AC,$ACAC0000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $000000AC,$ACAC0000,$ACACACAC,$ACACACAC
tile046 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile047 long $000000AC,$ACACAC00,$AC0000AC,$ACAC0000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$ACAC0000
        long $000000AC,$ACACAC00,$ACACACAC,$ACACACAC
tile048 long $000000AC,$AC000000,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$000000AC,$ACACAC00
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $000000AC,$AC000000,$ACACACAC,$ACACACAC
tile049 long $000000AC,$AC000000,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$000000AC,$ACACAC00
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$ACACACAC,$ACACACAC
tile050 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$ACACACAC,$AC0000AC,$AC000000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile051 long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$000000AC,$AC000000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile052 long $0000ACAC,$ACAC0000,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile053 long $00ACACAC,$AC000000,$ACACACAC,$ACAC0000
        long $ACACACAC,$ACAC0000,$ACACACAC,$ACAC0000
        long $ACACACAC,$ACAC0000,$AC0000AC,$ACAC0000
        long $0000ACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile054 long $AC0000AC,$AC0000AC,$AC0000AC,$ACAC0000
        long $000000AC,$ACACAC00,$000000AC,$ACACACAC
        long $000000AC,$ACACAC00,$AC0000AC,$ACAC0000
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile055 long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $000000AC,$AC000000,$ACACACAC,$ACACACAC
tile056 long $AC0000AC,$0000ACAC,$000000AC,$000000AC
        long $000000AC,$00000000,$000000AC,$00000000
        long $AC0000AC,$0000ACAC,$AC0000AC,$0000ACAC
        long $AC0000AC,$0000ACAC,$ACACACAC,$ACACACAC
tile057 long $AC0000AC,$AC0000AC,$000000AC,$AC0000AC
        long $000000AC,$AC000000,$000000AC,$AC000000
        long $AC0000AC,$AC000000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile058 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile059 long $000000AC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$000000AC,$ACAC0000
        long $AC0000AC,$ACACACAC,$AC0000AC,$ACACACAC
        long $AC0000AC,$ACACACAC,$ACACACAC,$ACACACAC
tile060 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$0000ACAC,$ACAC0000
        long $ACACACAC,$AC000000,$ACACACAC,$ACACACAC
tile061 long $000000AC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$000000AC,$ACAC0000
        long $000000AC,$ACACAC00,$AC0000AC,$ACAC0000
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile062 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$ACACACAC,$0000ACAC,$ACAC0000
        long $ACACACAC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile063 long $000000AC,$AC000000,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile064 long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile065 long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$0000ACAC,$ACAC0000
        long $00ACACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile066 long $AC0000AC,$0000ACAC,$AC0000AC,$0000ACAC
        long $AC0000AC,$0000ACAC,$AC0000AC,$0000AC00
        long $000000AC,$00000000,$000000AC,$000000AC
        long $AC0000AC,$0000ACAC,$ACACACAC,$ACACACAC
tile067 long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$00ACACAC,$ACACAC00
        long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$ACACACAC,$ACACACAC
tile068 long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$0000ACAC,$ACAC0000
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile069 long $000000AC,$AC000000,$ACACACAC,$AC0000AC
        long $ACACACAC,$ACAC0000,$00ACACAC,$ACACAC00
        long $0000ACAC,$ACACACAC,$AC0000AC,$ACACACAC
        long $000000AC,$AC000000,$ACACACAC,$ACACACAC
tile070 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC000000,$000000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile071 long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $0000ACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $000000AC,$AC000000,$ACACACAC,$ACACACAC
tile072 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $ACACACAC,$AC0000AC,$ACACACAC,$ACAC0000
        long $0000ACAC,$ACACACAC,$AC0000AC,$ACACACAC
        long $000000AC,$AC000000,$ACACACAC,$ACACACAC
tile073 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $ACACACAC,$AC0000AC,$00ACACAC,$ACAC0000
        long $ACACACAC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile074 long $ACACACAC,$AC0000AC,$ACACACAC,$AC000000
        long $00ACACAC,$AC000000,$AC0000AC,$AC0000AC
        long $000000AC,$00000000,$ACACACAC,$AC0000AC
        long $ACACACAC,$AC0000AC,$ACACACAC,$ACACACAC
tile075 long $000000AC,$AC000000,$AC0000AC,$ACACACAC
        long $000000AC,$ACAC0000,$ACACACAC,$AC0000AC
        long $ACACACAC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile076 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$ACACACAC,$000000AC,$ACAC0000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile077 long $000000AC,$AC000000,$AC0000AC,$AC0000AC
        long $ACACACAC,$ACAC0000,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$00ACACAC,$ACACAC00
        long $00ACACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile078 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$0000ACAC,$ACAC0000
        long $AC0000AC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile079 long $0000ACAC,$ACAC0000,$AC0000AC,$AC0000AC
        long $AC0000AC,$AC0000AC,$0000ACAC,$AC000000
        long $ACACACAC,$AC0000AC,$AC0000AC,$AC0000AC
        long $0000ACAC,$ACAC0000,$ACACACAC,$ACACACAC
tile080 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$042C2C2C,$042C2C2C,$04020402
        long $044C2C2C,$04040402,$044C2C2C,$02040204
tile081 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $04040404,$2C2C2C2C,$04040404,$2C2C2C2C
        long $04020204,$2C2C2C04,$02040004,$2C2C2C04
tile082 long $00000000,$AB000000,$00000000,$AB000000
        long $00000000,$AB000000,$00000000,$AB000000
        long $00000000,$AB000000,$00000000,$AB000000
        long $00000000,$AB000000,$00000000,$AB000000
tile083 long $2C2C2C2C,$AB2B2C2C,$2C2C2C2C,$9C9C2B2C
        long $2C2C2C2C,$9CABAB2B,$2B2C2C2C,$AB9C9CAB
        long $AB2B2C2C,$9C9C9C9C,$ABAB2B2C,$9C9C9C9C
        long $9C9C9C2B,$9C9CABAB,$9C9CAB9C,$AB9C9C9C
tile084 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$6A6A692C,$2C2C2C2C,$2C2C692C
tile085 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C6A6A,$2C2C2C2C,$2C2C6A2C,$2C2C2C2C
tile086 long $2C2C2BAB,$2C2C2C2C,$2C2B9C9C,$2C2C2C2C
        long $2B9C9CAB,$2C2C2C2C,$9C9C9CAB,$2C2C2C2B
        long $9C9CAB9C,$2C2C2B9C,$AB9C9C9C,$2C2B9C9C
        long $AB9C9C9C,$2B9C9C9C,$9C9C9CAB,$9CABABAB
tile087 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C002C,$2C2C2C2C,$2C2C2C02,$2C2C2C2C
tile088 long $00A9AAA9,$AAA90000,$00A9AAA9,$AAA90000
        long $00A9AAA9,$AAA90000,$A9AAA900,$AAA90000
        long $AAA90000,$AAA900A9,$A9000000,$AAA9A9AA
        long $00000000,$AAAAAAA9,$00000000,$AAAAA900
tile089 long $0000A9AA,$A9AAA900,$0000A9AA,$A9AAA900
        long $0000A9AA,$A9AAA900,$0000A9AA,$00A9AAA9
        long $A900A9AA,$0000A9AA,$AAA9A9AA,$000000A9
        long $A9AAAAAA,$00000000,$00A9AAAA,$00000000
tile090 long $ACACACA8,$ACACACAC,$ACACACA8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACACA8,$00ACACAC
        long $ACACA8A8,$00ACACAC,$ACACA8A8,$0000ACAC
        long $ACACA8A8,$0000ACAC,$ACACACA8,$ACACACAC
tile091 long $ACACACAC,$ACACACAC,$000000AC,$0000ACAC
        long $00000000,$AC0000AC,$ACACAC00,$AC0000AC
        long $ACAC0000,$AC000000,$ACAC0000,$AC000000
        long $ACACACAC,$000000AC,$ACACACAC,$ACACACAC
tile092 long $ACACACAC,$ACACACAC,$ACACAC00,$AC000000
        long $00ACAC00,$AC000000,$0000AC00,$00ACACAC
        long $0000AC00,$00AC0000,$ACACAC00,$ACAC0000
        long $00ACACAC,$ACACAC00,$ACACACAC,$ACACACAC
tile093 long $ACACACAC,$ACACACAC,$000000AC,$0000ACAC
        long $00000000,$AC0000AC,$ACACAC00,$AC0000AC
        long $AC000000,$AC0000AC,$AC0000AC,$AC0000AC
        long $ACAC0000,$ACAC0000,$ACACACAC,$ACACACAC
tile094 long $ACACACAC,$ACACACAC,$0000ACAC,$00ACACAC
        long $AC0000AC,$0000ACAC,$AC0000AC,$AC0000AC
        long $AC0000AC,$000000AC,$AC0000AC,$00ACACAC
        long $00000000,$0000AC00,$ACACACAC,$ACACACAC
tile095 long $ACACACAC,$A8ACACAC,$ACAC0000,$A8ACACAC
        long $ACAC0000,$A8A8ACAC,$ACACACAC,$A8ACACAC
        long $ACACAC00,$A8A8ACAC,$ACACAC00,$A8A8ACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8ACACAC
tile096 long $044C2C2C,$00040002,$044C2C2C,$04000400
        long $4C2C2C2C,$04020004,$4C2C2C2C,$04040404
        long $4C2C2C2C,$4C4C4C4C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$9C2C2C2C,$ABAB2C2C,$AB9CAB9C
tile097 long $02000404,$2C2C2C04,$00040402,$2C2C2C04
        long $04020404,$2C2C2C04,$4C4C4C04,$2C2C2C2C
        long $2C2CAAA9,$2C2C2C2C,$2C2CAAA9,$2C2C2C2C
        long $9CABA9AB,$2C2C2C2C,$AB9CABAB,$2CAB9C9C
tile098 long $00000000,$AB000000,$00000000,$AB000000
        long $0000AB00,$00AB0000,$0000AB00,$00AB0000
        long $00AB009C,$0000AB00,$AB009C00,$000000AB
        long $009C009C,$00000000,$00009C9B,$00000000
tile099 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C69692C,$2C69692C
        long $69040469,$69040469,$69040469,$69040469
        long $69696969,$69696969,$00020069,$69020002
tile100 long $2C2C2C2C,$2C2C2C69,$2C2C2C2C,$2C2C2C69
        long $692C2C2C,$6A2C2C2C,$692C2C2C,$6A2C2C2C
        long $69696969,$69696969,$6A6A6A69,$696A6A6A
        long $6A6A6A6A,$6A6A6A6A,$0000006A,$6A6A0000
tile101 long $2C2C2C6A,$2C2C2C2C,$2C2C2C6A,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$AA2C2C2C,$ABAB2CAA
        long $AAAA2C2C,$ABABAAAA,$AAAA2C2C,$ABABABAA
        long $AAAAAA2C,$ABABABAA,$AAAAAA69,$69ABABAB
tile102 long $2C2C2C2C,$022C2C2C,$2C2C2C2C,$2C022C2C
        long $2C2C2C2C,$2C022C2C,$2C2C2CAB,$2C2C022C
        long $2C2C2CAB,$2C2C022C,$6A6A6A69,$6A6A6A6A
        long $6A6A6A69,$6A6A6A6A,$00006A6A,$6A6A0000
tile103 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C6A,$2C2C2C2C
tile104 long $00000000,$AAA90000,$00000000,$AAA90000
        long $00000000,$AAA90000,$00000000,$AAA90000
        long $00000000,$AAA90000,$00000000,$AAA90000
        long $00000000,$AAA90000,$00000000,$AAA90000
tile105 long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
tile106 long $ACACACA8,$ACACACAC,$ACACACA8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACACA8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACA8A8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACACA8,$ACACACAC
tile107 long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile108 long $ACACACAC,$A8ACACAC,$ACACACAC,$A8ACACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8ACACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8A8ACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8ACACAC
tile109 long $C8C8D900,$0000D9D9,$C8CACAC8,$00CACAC8
        long $D9CAC8C8,$00CAD9C8,$D9C8C8C8,$00D9C8D9
        long $C8C8C8C8,$00CAD9C8,$C8D9C8C8,$00D9C8C8
        long $D9C8C800,$0000C8C8,$00000000,$00000000
tile110 long $29293B00,$00003B3B,$294C4C29,$004C4C29
        long $3B4C2929,$004C3B29,$3B292929,$003B293B
        long $29292929,$004C3B29,$293B2929,$003B2929
        long $3B292900,$00002929,$00000000,$00000000
tile111 long $A9A99B00,$00009B9B,$A99C9CA9,$009C9CA9
        long $9B9CA9A9,$009C9BA9,$9BA9A9A9,$009BA99B
        long $A9A9A9A9,$009C9BA9,$A99BA9A9,$009BA9A9
        long $9BA9A900,$0000A9A9,$00000000,$00000000
tile112 long $009C9B9B,$C8C89B00,$009C9B9C,$C8C89B00
        long $00009C9B,$C8C8C8C8,$009C009C,$052A0000
        long $00009C00,$9B9B0000,$0000009C,$9C9C9C00
        long $00000000,$9C9C0000,$00000000,$9C9B0000
tile113 long $000000C8,$00000000,$0000C8C8,$00000000
        long $00C8C8C8,$00000000,$00C8C89B,$00000000
        long $00C89B9C,$00000000,$00009B9C,$00000000
        long $03030302,$00000002,$02009B9C,$00000303
tile114 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$002C2C2C,$2C2C2C2C,$002C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$AB2C2C2C,$2C2C2C2C,$AB2C2C2C
tile115 long $00020069,$69020002,$0002002C,$69020002
        long $AAABAA00,$690000AB,$ABAAAB00,$690000AA
        long $00002CAB,$00000000,$2C2C2CAB,$02020202
        long $2C2C2C2C,$02020202,$2C2C2C2C,$0202022C
tile116 long $0303006A,$6A000303,$03030300,$00030303
        long $03030300,$00030302,$02030300,$00030303
        long $02030303,$03030302,$03030303,$03030303
        long $03030302,$2C030303,$03032C2C,$2C2C0303
tile117 long $AAAA6A6A,$69ABABAB,$696A6A6A,$69696969
        long $6A6A6A6A,$6A6A6A6A,$69696969,$69696969
        long $00000000,$00000000,$2C2C2C2C,$02020202
        long $2C2C2C2C,$02020202,$2C2C2C2C,$0202022C
tile118 long $0303006A,$6A000303,$03030300,$00030303
        long $03030300,$00030302,$02030300,$00030303
        long $02030303,$03030302,$03030303,$03030303
        long $03030302,$2C030303,$03032C2C,$2C2C0303
tile119 long $2C2C2C6A,$2C2C2C2C,$2C2C0000,$2C2C2C2C
        long $2C2C0000,$2C2C2C2C,$2C2C2C00,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile120 long $00090909,$09090000,$AA000909,$0900AAAA
        long $00AA0009,$00AA0000,$0000AA00,$AA009C9C
        long $9C00AA00,$AA009999,$9C00AA00,$AA009999
        long $9C00AA00,$AA009999,$9C00AA00,$AA009999
tile121 long $00000000,$00000000,$AAAA0000,$000000AA
        long $0000AA00,$0000AA00,$9C9C00AA,$00AA0000
        long $999900AA,$00AA009C,$999900AA,$00AA009C
        long $999900AA,$00AA009C,$999900AA,$00AA009C
tile122 long $9C00AA00,$AA009999,$9C00AA00,$AA009999
        long $9C00AA00,$AA009999,$9C00AA00,$AA009999
        long $9C00AA00,$AA009999,$9C00AA00,$AA009999
        long $9C00AA00,$AA009999,$9C00AA00,$AA009999
tile123 long $999900AA,$00AA009C,$999900AA,$00AA009C
        long $999900AA,$00AA009C,$999900AA,$00AA009C
        long $999900AA,$00AA009C,$999900AA,$00AA009C
        long $999900AA,$00AA009C,$999900AA,$00AA009C
tile124 long $9900AA00,$00009999,$0000AA00,$00999999
        long $00AA009C,$9999999C,$00AA009C,$999C9C00
        long $AA009CAB,$9C000000,$00ABAB9C,$0000AAAA
        long $9C9C9C9C,$AAAA0000,$9C9CAB9C,$00009C9C
tile125 long $000000AA,$00000000,$00AAAA00,$00000000
        long $AA000099,$000000AA,$00009999,$0000AA00
        long $9999999C,$00AA0000,$99999900,$00AA0099
        long $999C0000,$AA009999,$9C0000AA,$AA009999
tile126 long $00000000,$AA000000,$00000000,$00AAAA00
        long $AA000000,$990000AA,$00AA0000,$99990000
        long $0000AA00,$9C999999,$9900AA00,$00999999
        long $999900AA,$00009C99,$999900AA,$AA00009C
tile127 long $99990000,$00AA0099,$99999900,$00AA0000
        long $9C999999,$9C00AA00,$009C9C99,$9C00AA00
        long $0000009C,$AB9C00AA,$AAAA0000,$9CABAB00
        long $0000AAAA,$9C9C9C9C,$9C9C0000,$9CAB9C9C
tile128 long $00000000,$9B000000,$00000000,$D9D9D9CA
        long $CA000000,$D9D9D9CA,$CA000000,$D9D9D9CA
        long $CACA0000,$D9D9D9CA,$CACA0000,$D9D9D900
        long $CACA0000,$9C9B9BCA,$CA000000,$D99B9BCA
tile129 long $00009B9B,$00030302,$CAD9D9D9,$0003029C
        long $9CD9D9D9,$000302CA,$CA9CD9D9,$000300CA
        long $CAD99B9B,$0002CACA,$00D99B9B,$0000CACA
        long $CACACAD9,$0000CACA,$CACAD9D9,$000000CA
tile130 long $9B000000,$00C8C8C8,$9B000000,$C8C8C8C8
        long $C8C80000,$C8C8C8C8,$00000000,$C89B052A
        long $00000000,$9B9C9B9B,$9C000000,$9B9C9C9C
        long $00000000,$9B9C9C9C,$00000000,$9B9C9C9B
tile131 long $00000000,$00000000,$00000000,$00000000
        long $000000C8,$00000000,$000000C8,$00000000
        long $000000C8,$00000000,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile132 long $A8A8A8A8,$A8A8A8A8,$A8A8A8A8,$A8ACACA8
        long $A8A8A8A8,$ACACACAC,$ACACA8A8,$ACACACAC
        long $ACA8A8A8,$ACACACAC,$ACACA8A8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACACA8,$ACACACAC
tile133 long $A8A8A8A8,$A8A8A8A8,$A8ACACA8,$A8A8A8A8
        long $ACACACAC,$A8A8A8A8,$ACACACAC,$A8A8ACAC
        long $ACACACAC,$A8A8A8AC,$ACACACAC,$A8A8ACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8ACACAC
tile134 long $A9000000,$007B7B79,$9BA90000,$7B6A6A79
        long $9A9BA900,$6A6A7979,$9A9A9A00,$7979799A
        long $9A7B7B79,$A9A99B9A,$7B6A6A79,$A99B9A9A
        long $6A6A7979,$9B9A9AA9,$79797900,$9AAAA9A9
tile135 long $A9A90000,$0000A9A9,$9C9CA900,$0000A99C
        long $9C9C9CA9,$000000A9,$A99C9CA9,$0000A900
        long $00A99C9B,$00A99CA9,$A900A99B,$00A99C9C
        long $9CA99B9B,$00A99C9C,$9C9C9B9B,$0000A99C
tile136 long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$99999999,$99999999
        long $AAAAAAAA,$AAAAAAAA,$99999999,$99999999
        long $00000000,$00000000,$99999999,$99999999
tile137 long $00000000,$00000000,$AAAAAAAA,$AAAAAAAA
        long $00000000,$00000000,$9C9C9C9C,$9C9C9C9C
        long $99999999,$99999999,$99999999,$99999999
        long $00000000,$00000000,$AAAAAAAA,$AAAAAAAA
tile138 long $00000000,$00000000,$00000000,$AAAA0000
        long $00000000,$0000AAAA,$AA000000,$999C0000
        long $00AA0000,$99999C9C,$00AA0000,$9999999C
        long $9900AA00,$00999999,$9C00AA00,$00009999
tile139 long $9900AAAA,$AA009999,$999C00AA,$AA009999
        long $99999C00,$AAAA0099,$99999999,$00AA0099
        long $99999999,$00AAAA00,$00009999,$0000AAAA
        long $AAAA0000,$000000AA,$00AAAAAA,$00000000
tile140 long $AAAAAAAA,$AAAAAAAA,$00000000,$00000000
        long $99999999,$99999999,$99999999,$99999999
        long $9C9C9C9C,$9C9C9C9C,$00000000,$00000000
        long $AAAAAAAA,$AAAAAAAA,$00000000,$00000000
tile141 long $00000000,$00000000,$0000AAAA,$00000000
        long $AAAA0000,$00000000,$00009C99,$000000AA
        long $9C9C9999,$0000AA00,$9C999999,$0000AA00
        long $99999900,$00AA0099,$99990000,$00AA009C
tile142 long $9900AA00,$00009999,$0000AA00,$00999999
        long $00AA0000,$9999999C,$00AA0000,$999C9C00
        long $AA000000,$9C000000,$00000000,$0000AAAA
        long $00000000,$AAAA0000,$00000000,$00000000
tile143 long $99999999,$99999999,$99999999,$99999999
        long $99999900,$99999999,$99999900,$99999999
        long $99990000,$99999999,$99990000,$99990099
        long $00000000,$99000000,$00000000,$99000000
tile144 long $00000000,$D9D90000,$00000000,$D9D90000
        long $00000000,$C8C80000,$00000000,$C8C80000
        long $00000000,$00C8C800,$00000000,$00C8C800
        long $00000000,$00C8C800,$00000000,$00C8C800
tile145 long $0000D9D9,$00000000,$0000D9D9,$00000000
        long $0000C8C8,$00000000,$00C8C8C8,$00000000
        long $00C8C800,$00000000,$C8C8C800,$00000000
        long $C8C8C800,$00000000,$C8C80000,$000000C8
tile146 long $00000000,$9B9B9B00,$00000000,$CAD9D9D9
        long $00000000,$CAD9D9D9,$00000000,$D9D9D9D9
        long $00000000,$D9D9D9C8,$00000000,$CAD9D9C8
        long $00000000,$CAD9C8C8,$00000000,$CACAC8C8
tile147 long $00000000,$00000000,$000000CA,$00000000
        long $0000CACA,$00000000,$0000CACA,$00000000
        long $0000CACA,$00000000,$0000D9CA,$00000000
        long $0000D9CA,$00000000,$0000D9D9,$00000000
tile148 long $ACACACA8,$ACACACAC,$ACACACA8,$ACACACAC
        long $ACACA8A8,$ACACACAC,$ACACA8A8,$ACACACAC
        long $ACACACA8,$ACACACAC,$ACA8A8A8,$ACACACAC
        long $A8A8A8A8,$ACACACAC,$A8A8A8A8,$A8A8A8A8
tile149 long $ACACACAC,$A8ACACAC,$ACACACAC,$A8ACACAC
        long $ACACACAC,$A8A8ACAC,$ACACACAC,$A8A8ACAC
        long $ACACACAC,$A8ACACAC,$ACACACAC,$A8A8A8AC
        long $ACACACAC,$A8A8A8A8,$A8A8A8A8,$A8A8A8A8
tile150 long $A9A90000,$AAAA9C9C,$9C9CA900,$AAA9A99C
        long $9C9C9CA9,$9CA900A9,$A99C9CA9,$9C9CA900
        long $00A99BA9,$9C9C9CA9,$A900A9A9,$A99C9C9C
        long $00000000,$00A9A9A9,$00000000,$00000000
tile151 long $A9A99B9A,$000000A9,$A99B9AAA,$00000000
        long $9B9AAAA9,$00000000,$9A9AA9A9,$000000A9
        long $A90000A9,$0000A99A,$00000000,$00009AA9
        long $00000000,$00000000,$00000000,$00000000
tile152 long $CACA0000,$0000CACA,$D9C8CA00,$00CAD99B
        long $D9C800D9,$00D99BD9,$C8CA00C8,$00D9D9D9
        long $D9C8CA00,$00D9C8C8,$00D9C8C8,$0000D900
        long $C800C8D9,$000000D9,$00000000,$00000000
tile153 long $3B3B3B00,$00000029,$4C3B0029,$0000294C
        long $3B3B0029,$00294C3B,$29292929,$00293B29
        long $4C292900,$00293B29,$3B292900,$0000294C
        long $29290000,$00000029,$00000000,$00000000
tile154 long $7B6AA900,$009C0000,$6A799AA9,$00A99C00
        long $A99A7B6A,$009CA99B,$9AA96A79,$00009C9B
        long $AA9C0000,$0000A99A,$9CA99C00,$00009AA9
        long $009CA99B,$009A0000,$00000000,$00000000
tile155 long $00000000,$00000000,$29000000,$00000029
        long $4C3B0000,$00003B4C,$044C2900,$00294C04
        long $044C2900,$00294C04,$4C3B0000,$00003B4C
        long $29000000,$00000029,$00000000,$00000000
tile156 long $00000000,$00000000,$C8C80000,$00C8C800
        long $CACAC8C8,$C8CACAC8,$CACAD9C8,$CACAD9CA
        long $CAD9D9C8,$CACAD9CA,$D9D9C800,$C8CACAD9
        long $D9C80000,$00C8C8CA,$D9C80000,$0000C8CA
tile157 long $00000000,$00000000,$29290000,$00292900
        long $4C4C2929,$294C4C29,$4C4C3B29,$4C4C3B4C
        long $4C3B3B29,$4C4C3B4C,$3B3B2900,$294C4C3B
        long $3B290000,$0029294C,$3B290000,$0000294C
tile158 long $00000000,$00000000,$A9A90000,$00A9A900
        long $9C9CA9A9,$A99C9CA9,$9C9C9BA9,$9C9C9B9C
        long $9C9B9BA9,$9C9C9B9C,$9B9BA900,$A99C9C9B
        long $9BA90000,$00A9A99C,$9BA90000,$0000A99C
tile159 long $99999900,$00009999,$99990000,$00009999
        long $99000000,$00000099,$99000000,$00000099
        long $99000000,$00000099,$99000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile160 long $00000000,$00C8C8C8,$00000000,$C8C8C8C8
        long $00000000,$C8C8C8C8,$00000000,$D9D9D9D9
        long $D9D9D900,$D9CACACA,$CACACAD9,$D9CACACA
        long $CACACAD9,$D9CAD9D9,$D9D9D9D9,$D9D90000
tile161 long $C8C80000,$000000C8,$C8C80000,$0000C8C8
        long $C8C80000,$0000C8C8,$C8000000,$0000D9D9
        long $D9000000,$00D9CACA,$D9000000,$D9CACACA
        long $D9000000,$D9CACAD9,$D9000000,$D9D9D9D9
tile162 long $C8000000,$CA9B9BC8,$C8000002,$D99B9BC8
        long $AA000003,$C8C8009C,$9C000203,$C8C800AA
        long $009C0203,$00C8C800,$00020303,$00C8C800
        long $02030300,$00C8C800,$03030000,$00020303
tile163 long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$C8050505,$050505C8
        long $C8050505,$050505C8,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
tile164 long $00000000,$CACACAC8,$D9000000,$D9CACACA
        long $CAD90000,$9BD9D9CA,$CACAD900,$D9D9C8C8
        long $00D9D9C8,$D9C8C8C8,$0000D9D9,$D9C8C8C8
        long $0000D9C8,$C8C8CA00,$000000C8,$C8C8D9CA
tile165 long $D9CACACA,$00000000,$CACA9B9B,$000000D9
        long $D99BA99B,$0000D9CA,$9BD99B9B,$0000CACA
        long $A99BD9D9,$0000CA9B,$9B9BD9D9,$0000D99B
        long $9BD9D9D9,$0000D9D9,$D9D9D9C8,$0000D9D9
tile166 long $3B3B0000,$3B3B3B3B,$4C3B3B00,$3B4C4C4C
        long $00002929,$4C4C4C3B,$00002929,$4C3B3B3B
        long $00002929,$3B3B3B3B,$00002929,$3B3B3B3B
        long $29292929,$29292929,$29292929,$29292929
tile167 long $00002929,$00000000,$0029293B,$00000000
        long $29293B4C,$00000000,$293B4C4C,$00000029
        long $4C4C4C3B,$00002929,$4C4C3B3B,$0000294C
        long $4C3B3B3B,$0000294C,$3B3B2929,$0000294C
tile168 long $CACACA00,$0000CACA,$D9C800C8,$00CAD99C
        long $D9C80000,$00D99CD9,$C8D90000,$00D9D9D9
        long $D9C8CA00,$00D9C8C8,$00D9CA00,$00D90000
        long $00D9C800,$0000D900,$00000000,$0000C800
tile169 long $3B3B0000,$00000000,$3B002900,$0000293B
        long $3B002900,$00294C4C,$29292900,$294C3B3B
        long $4C292900,$293B2929,$3B292900,$00293B4C
        long $29290000,$00002929,$00000000,$00000000
tile170 long $7B6AA900,$00000000,$6A799AA9,$00000000
        long $A99A7B6A,$0000A99B,$9AA96A79,$00009C9B
        long $AA9C0000,$0000A99A,$9CA90000,$00009AA9
        long $00000000,$009A0000,$00000000,$00000000
tile171 long $29000000,$00000029,$3B290000,$0000293B
        long $293B2900,$00293B29,$00293B29,$293B2900
        long $00293B29,$293B2900,$293B2900,$00293B29
        long $3B290000,$0000293B,$29000000,$00000029
tile172 long $D9C80000,$0000C8CA,$D9C80000,$0000C8CA
        long $D9C8C800,$0000C8CA,$CACAD9C8,$00C8CAD9
        long $CAD9D9C8,$C8CACAD9,$D9D9C8C8,$C8CACAD9
        long $C8C8C800,$00C8D9D9,$00000000,$0000C8C8
tile173 long $3B290000,$0000294C,$3B290000,$0000294C
        long $3B292900,$0000294C,$4C4C3B29,$00294C3B
        long $4C3B3B29,$294C4C3B,$3B3B2929,$294C4C3B
        long $29292900,$00293B3B,$00000000,$00002929
tile174 long $9BA90000,$0000A99C,$9BA90000,$0000A99C
        long $9BA9A900,$0000A99C,$9C9C9BA9,$00A99C9B
        long $9C9B9BA9,$A99C9C9B,$9B9BA9A9,$A99C9C9B
        long $A9A9A900,$00A99B9B,$00000000,$0000A9A9
tile175 long $99999999,$99999999,$99999999,$00009999
        long $99999999,$00009999,$00999999,$00009999
        long $00999999,$00000099,$00009999,$00000099
        long $00009999,$00000000,$00009999,$00000000
tile176 long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$9C000000,$0000A9AA,$009C0000
        long $0000A9AA,$9C009C00,$0000A9AA,$9C9C009C
tile177 long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$009B0000,$9C009B00
        long $9B009C00,$009C009B,$009B009C,$9C009C00
        long $9B9C9C9C,$9C9C9C9C,$00000000,$00000000
tile178 long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$9C009C00,$00000000
        long $009C009C,$009C009C,$9C9C9C9C,$9C009C00
        long $9C9C9C9C,$9B9C9C9C,$9C9C9C9C,$9C9C9C9C
tile179 long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$C8050505,$050505C8
        long $C8050505,$050505C8,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
tile180 long $CA000000,$D9C8C8D9,$D9CA0000,$00D9C8C8
        long $C8D90000,$0000D9C8,$C8C8D9C8,$000000D9
        long $D9D9D9D9,$D9000000,$00D9D900,$C8C80000
        long $00D90000,$00000000,$00000000,$00000000
tile181 long $D9D9C8C8,$0000D9D9,$D9C8C8C8,$0000C8D9
        long $D9D90000,$000000D9,$D9D9D900,$00000000
        long $00D9D9D9,$00000000,$0000C8D9,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile182 long $29292900,$4C4C2929,$29290000,$4C4C4C29
        long $29290000,$4C3B3B29,$29290000,$3B3B3B29
        long $29000000,$3B292929,$00000000,$29292929
        long $00000000,$00000000,$00000000,$00000000
tile183 long $3B3B2929,$00002929,$3B3B294C,$00002929
        long $293B4C4C,$00000029,$29294C4C,$00000000
        long $0029293B,$00000000,$00002929,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile184 long $C8C80000,$00000000,$CACAC800,$000000C8
        long $CACAD9C8,$C8C8C8CA,$D9D9D9C8,$CACACAD9
        long $CAD9C800,$D9D9D9CA,$D9D9C800,$C8C8C8CA
        long $D9C8C800,$0000C8D9,$C8C80000,$000000C8
tile185 long $29290000,$00000000,$4C4C2900,$00000029
        long $4C4C3B29,$2929294C,$3B3B3B29,$4C4C4C3B
        long $4C3B2900,$3B3B3B4C,$3B3B2900,$2929294C
        long $3B292900,$0000293B,$29290000,$00000029
tile186 long $A9A90000,$00000000,$9C9CA900,$000000A9
        long $9C9C9BA9,$A9A9A99C,$9B9B9BA9,$9C9C9C9B
        long $9C9BA900,$9B9B9B9C,$9B9BA900,$A9A9A99C
        long $9BA9A900,$0000A99B,$A9A90000,$000000A9
tile187 long $D9C80000,$0000C8D9,$CAD9C800,$00C8D9CA
        long $D9CAC8C8,$00C8CAD9,$CAD9CACA,$0000D9CA
        long $CAD9D9D9,$00C8CACA,$D9D9C8C8,$00C8CACA
        long $D9C80000,$0000C8D9,$C8000000,$0000C8C8
tile188 long $3B290000,$0000293B,$4C3B2900,$00293B4C
        long $3B4C2929,$00294C3B,$4C3B4C4C,$0000294C
        long $4C3B3B3B,$00294C4C,$3B3B2929,$00294C4C
        long $3B290000,$0000293B,$29000000,$00002929
tile189 long $9BA90000,$0000A99B,$9C9BA900,$00A99B9C
        long $9B9CA9A9,$00A99C9B,$9C9B9C9C,$0000A99C
        long $9C9B9B9B,$00A99C9C,$9B9BA9A9,$00A99C9C
        long $9BA90000,$0000A99B,$A9000000,$0000A9A9
tile190 long $000000A8,$00000000,$0000A8A8,$00000000
        long $00A8A8A8,$00000000,$00A8A8A8,$00000000
        long $00A8A8A8,$00000000,$A8A8A8A8,$000000A8
        long $A8A8A8A8,$0000A8A8,$A8A8A8A8,$A8A8A8A8
tile191 long $00000000,$00000000,$A8000000,$000000A8
        long $A8000000,$000000A8,$A8000000,$00A800A8
        long $A8A80000,$00A8A8A8,$A8A80000,$00A8A8A8
        long $A8A8A800,$A8A8A8A8,$A8A8A8A8,$A8A8A8A8
tile192 long $9C00A9AA,$009C9C00,$0000A9AA,$009C009C
        long $9B00A9AA,$009C9C00,$0000A9AA,$009C009B
        long $9B00A9AA,$009B9B00,$0000A9AA,$009C009B
        long $9B00A9AA,$009C9C00,$0000A9AA,$009C009C
tile193 long $9C9C9C00,$0000009C,$9C9C9C00,$00000000
        long $009C9C00,$0000009B,$9B009C00,$00000000
        long $009B9B00,$0000009B,$9B009C00,$00000000
        long $009C9C00,$0000009B,$9C009C00,$00000000
tile194 long $9C9C9C9C,$9B9B9B9C,$9C9C9C9C,$9C9C9C9C
        long $9C9C9C9C,$9B9C9C9C,$9C9C9C9C,$9C9B9B9C
        long $9C9C9C9C,$009C9C9C,$9C9C9C9C,$9C009C9C
        long $9C9C9C9C,$009C009C,$9C9C9C9C,$0000009C
tile195 long $A8A8A8A8,$A8A8A8A8,$ACACACA8,$A8A8ACA8
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile196 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2B2C2C2C
        long $2C2C2C2C,$2B2C2C2C,$2C2C2C2C,$AB2B2C2C
        long $2C2C2C2C,$AB2B2C2C,$2C2C2C2C,$ABAB2B2C
        long $2C2C2C2C,$ABAB2B2C,$2C2C2C2C,$ABABAB2B
tile197 long $05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$C8050505,$050505C8
        long $C8050505,$050505C8,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505
tile198 long $9C9CABAB,$2B9C9C9C,$9CABABAB,$9C9C9C9C
        long $9CABABAB,$9C9C9C9C,$9CABABAB,$9C9C9C9C
        long $9CABABAB,$9C9C9C9C,$9CABABAB,$9C9C9C9C
        long $9CABABAB,$9C9C9C9C,$ABABABAB,$9C9C9C9C
tile199 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2B,$2C2C2C2C
        long $2C2C2C2B,$2C2C2C2C,$2C2C2B9C,$2C2C2C2C
        long $2C2C2B9C,$2C2C2C2C,$2C2B9C9C,$2C2C2C2C
        long $2C2B9C9C,$2C2C2C2C,$2B9C9C9C,$2C2C2C2C
tile200 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2B2C2C2C
        long $2C2C2C2C,$2B2C2C2C,$2C2C2C2C,$AB2B2C2C
        long $2C2C2C2C,$AB2B2C2C,$2C2C2C2C,$ABAB2B2C
        long $2C2C2C2C,$ABAB2B2C,$2C2C2C2C,$ABABAB2B
tile201 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2B,$2C2C2C2C,$2C2C2C2B,$2C2C2C2C
        long $2C2C2B9C,$2C2C2C2C,$2C2C2B9C,$2C2C2C2C
        long $2C2B9C9C,$2C2C2C2C,$2C2B9CAB,$2C2C2C2C
tile202 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $4C2C2C2C,$4C2C4C4C,$054C2C2C,$054C0505
        long $054C2B2C,$4C050505,$054C2B2C,$05050505
        long $054C2B2C,$054C4C05,$4C2B2C2C,$0505054C
tile203 long $2C2C2C2C,$2C2C2C2C,$2C4C4C4C,$2C2C2C2C
        long $4C050505,$4C2C2C2C,$05050505,$054C4C4C
        long $4C4C0505,$4C050505,$05054C4C,$05054C05
        long $05050505,$0505054C,$05050505,$0505054C
tile204 long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C4C4C,$2C2C2C2C,$4C4C0505,$2C2C2C4C
        long $05054C05,$2C2C4C05,$0505054C,$2C2B4C05
        long $4C05054C,$2C2B4C05,$054C4C05,$2C2B4C05
tile205 long $00000000,$00000000,$00000000,$A8000000
        long $A8000000,$A8A80000,$A8A80000,$A8A8A800
        long $A8A80000,$A8A8A800,$A8A8A800,$A8A8A8A8
        long $A8A8A8A8,$A8A8A8A8,$A8A8A8A8,$A8A8A8A8
tile206 long $00000000,$00000000,$00000000,$00000000
        long $29292929,$29292929,$4C4C4C4C,$4C4C4C4C
        long $3B3B3B3B,$3B3B3B3B,$29292929,$29292929
        long $00000000,$00000000,$00000000,$00000000
tile207 long $ACACACAC,$ACACACAC,$ACACACAC,$ACACA8A8
        long $A8ACACAC,$ACA8ACAC,$ACAAACAC,$ACA8ACAC
        long $ACACAAAC,$ACACA8AC,$ACACAAAC,$ACACACAA
        long $AAAAACAC,$ACACACAC,$ACACACAC,$ACACACAC
tile208 long $0000A9AA,$9C9C009C,$0000A9AA,$9C009C00
        long $0000A9AA,$009C0000,$0000A9AA,$9C000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
        long $0000A9AA,$00000000,$0000A9AA,$00000000
tile209 long $00000000,$00000000,$9B9C9C9C,$9C9C9C9C
        long $009B009C,$9C009C00,$9B009C00,$009C009B
        long $009B0000,$00009B00,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile210 long $9C009C9C,$00000000,$009C009C,$00000000
        long $00009C00,$00000000,$0000009C,$00000000
        long $00000000,$00000000,$00000000,$00000000
        long $00000000,$00000000,$00000000,$00000000
tile211 long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACAC,$ACACACAC,$ACACACAC,$ACACACAC
        long $ACACACA8,$A8A8ACA8,$A8A8A8A8,$A8A8A8A8
tile212 long $2C2C2C2C,$ABABAB2B,$2B2C2C2C,$ABABABAB
        long $2B2C2C2C,$ABABABAB,$AB2B2C2C,$ABABABAB
        long $AB2B2C2C,$ABABABAB,$ABAB2B2C,$ABABABAB
        long $ABAB2B2C,$ABABABAB,$ABABAB2B,$ABABABAB
tile213 long $ABABABAB,$ABABABAB,$ABABABAB,$ABABABAB
        long $ABABABAB,$ABABABAB,$ABABABAB,$ABABABAB
        long $ABABABAB,$ABABABAB,$ABABABAB,$ABABABAB
        long $ABABABAB,$ABABABAB,$ABABABAB,$ABABABAB
tile214 long $ABABABAB,$9C9C9C9C,$ABABABAB,$9C9C9C9C
        long $ABABABAB,$9C9C9C9C,$ABABABAB,$9C9C9C9C
        long $ABABABAB,$9C9C9C9C,$ABABABAB,$9C9C9CAB
        long $ABABABAB,$9C9C9CAB,$ABABABAB,$9C9C9CAB
tile215 long $2B9C9C9C,$2C2C2C2C,$9C9C9C9C,$2C2C2C2B
        long $9C9C9C9C,$2C2C2C2B,$9C9C9C9C,$2C2C2B9C
        long $9C9C9C9C,$2C2C2B9C,$9C9C9C9C,$2C2B9C9C
        long $9C9C9C9C,$2C2B9C9C,$9C9C9C9C,$2B9C9C9C
tile216 long $2C2C2C2C,$ABABAB2B,$2B2C2C2C,$ABABABAB
        long $2B2C2C2C,$ABABABAB,$AB2B2C2C,$ABABABAB
        long $AB2B2C2C,$ABABABAB,$ABAB2B2C,$ABABABAB
        long $ABAB2B2C,$ABABABAB,$ABABAB2B,$ABABABAB
tile217 long $2B9C9CAB,$2C2C2C2C,$2B9C9CAB,$2C2C2C2C
        long $9C9C9CAB,$2C2C2C2B,$9C9C9CAB,$2C2C2C2B
        long $9C9CABAB,$2C2C2B9C,$9C9CABAB,$2C2C2B9C
        long $9C9CABAB,$2C2B9C9C,$9C9CABAB,$2C2B9C9C
tile218 long $054C2C2C,$05050505,$054C2B2C,$4C050505
        long $054C2B2C,$4C050505,$054C2B2C,$2B4C0505
        long $4C2B2C2C,$2C2B4C4C,$2B2C2C2C,$2C2C2B2B
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile219 long $054C4C4C,$054C4C05,$4C050505,$4C050505
        long $05050505,$4C050505,$0505054C,$2B4C0505
        long $05054C2B,$2C2B4C05,$4C4C2B2C,$2C2C2B4C
        long $2B2B2C2C,$2C2C2C2B,$2C2C2C2C,$2C2C2C2C
tile220 long $05050505,$2C2C2B4C,$05050505,$2C2C2C4C
        long $4C050505,$2C2C2C2B,$2B4C4C4C,$2C2C2C2C
        long $2C2B2B2B,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
        long $2C2C2C2C,$2C2C2C2C,$2C2C2C2C,$2C2C2C2C
tile221 long $00000000,$00A8A800,$00A8A800,$A8000000
        long $A8000000,$00000000,$00000000,$00000000
        long $00000000,$0000A8A8,$00000000,$00A80000
        long $0000A8A8,$00000000,$00A80000,$00000000
tile222 long $00000000,$00000000,$00000000,$00000000
        long $C8C8C8C8,$C8C8C8C8,$CACACACA,$CACACACA
        long $D9D9D9D9,$D9D9D9D9,$C8C8C8C8,$C8C8C8C8
        long $00000000,$00000000,$00000000,$00000000
tile223 long $00000000,$00000000,$00000000,$00000000
        long $A9A9A9A9,$A9A9A9A9,$9C9C9C9C,$9C9C9C9C
        long $9B9B9B9B,$9B9B9B9B,$A9A9A9A9,$A9A9A9A9
        long $00000000,$00000000,$00000000,$00000000

