' REM Asset data file
' spin function to get the address of the tilemap.
PUB tilemap
RETURN @_tilemap

' spin function to get the address of the tiles data.
PUB tiles
RETURN @_tiles

dat
' Start tilemap definition here
_tilemap
' First 16 tile row is called the 'toptilemap' portion of the screen, which is non-scrolling.
' It can used to display score or life status. Please compile and see 'Rem_alien_invader' for
' a working example.
toptilemap    byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
' Same goes for 'bottomtilemap'.
bottomtilemap byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

' The real game tilemap starts here:
' The tilemap is created in Mappy (free Windows map utility), and then translated using 'xgs_convert_mappy.pl'
' Please read readme.txt if you need additional information.
' In this example, the tilemap is 16x60, which represents five complete screen.
tilemap000   byte 43, 44, 45, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39
tilemap001   byte 17, 37, 18, 39, 39, 39, 39, 39, 39, 22, 23, 24, 25, 39, 39, 39
tilemap002   byte 40, 5, 38, 39, 39, 39, 39, 39, 17, 37, 37, 37, 37, 18, 39, 39
tilemap003   byte 40, 1, 38, 39, 39, 39, 39, 22, 40, 4, 4, 4, 4, 38, 39, 39
tilemap004   byte 40, 7, 38, 39, 39, 39, 39, 23, 40, 4, 3, 4, 4, 38, 39, 39
tilemap005   byte 40, 1, 38, 39, 39, 39, 39, 24, 40, 4, 2, 4, 4, 38, 39, 39
tilemap006   byte 40, 9, 38, 39, 39, 39, 39, 25, 40, 4, 4, 4, 4, 38, 39, 39
tilemap007   byte 40, 1, 38, 39, 39, 39, 39, 26, 40, 3, 3, 3, 3, 38, 39, 39
tilemap008   byte 40, 14, 38, 39, 39, 39, 39, 39, 19, 39, 39, 39, 39, 20, 39, 39
tilemap009   byte 19, 39, 20, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39
tilemap010   byte 17, 37, 32, 33, 37, 37, 37, 41, 42, 37, 37, 34, 35, 36, 37, 18
tilemap011   byte 19, 21, 21, 31, 21, 21, 39, 21, 22, 39, 39, 21, 22, 30, 39, 20
tilemap012   byte 43, 44, 45, 39, 39, 39, 39, 22, 23, 24, 25, 26, 27, 28, 39, 39
tilemap013   byte 17, 37, 18, 39, 39, 39, 17, 37, 37, 37, 37, 37, 37, 37, 18, 39
tilemap014   byte 40, 5, 38, 39, 39, 22, 40, 1, 1, 4, 1, 4, 1, 1, 38, 39
tilemap015   byte 40, 1, 38, 39, 39, 23, 40, 1, 1, 4, 4, 4, 1, 1, 38, 39
tilemap016   byte 40, 7, 38, 39, 39, 24, 40, 3, 4, 4, 3, 4, 4, 3, 38, 39
tilemap017   byte 40, 1, 38, 39, 39, 25, 40, 1, 4, 4, 2, 4, 4, 1, 38, 39
tilemap018   byte 40, 9, 38, 39, 39, 26, 40, 3, 3, 4, 4, 4, 3, 3, 38, 39
tilemap019   byte 40, 1, 38, 39, 39, 27, 40, 1, 1, 4, 3, 4, 1, 1, 38, 39
tilemap020   byte 40, 14, 38, 39, 39, 28, 40, 1, 1, 3, 1, 3, 1, 1, 38, 39
tilemap021   byte 19, 39, 20, 39, 39, 39, 19, 39, 39, 39, 39, 39, 39, 39, 20, 39
tilemap022   byte 17, 37, 32, 33, 37, 37, 37, 41, 42, 37, 37, 34, 35, 36, 37, 18
tilemap023   byte 19, 21, 21, 31, 21, 21, 39, 21, 23, 39, 39, 21, 23, 29, 39, 20
tilemap024   byte 43, 44, 45, 39, 39, 39, 39, 22, 23, 24, 25, 26, 27, 28, 39, 39
tilemap025   byte 17, 37, 18, 39, 39, 39, 17, 37, 37, 37, 37, 37, 37, 37, 18, 39
tilemap026   byte 40, 5, 38, 39, 39, 22, 40, 1, 1, 4, 4, 4, 1, 1, 38, 39
tilemap027   byte 40, 1, 38, 39, 39, 23, 40, 1, 1, 4, 4, 4, 1, 1, 38, 39
tilemap028   byte 40, 7, 38, 39, 39, 24, 40, 4, 4, 4, 3, 4, 4, 4, 38, 39
tilemap029   byte 40, 1, 38, 39, 39, 25, 40, 4, 4, 4, 2, 4, 4, 4, 38, 39
tilemap030   byte 40, 9, 38, 39, 39, 26, 40, 3, 3, 4, 4, 4, 3, 3, 38, 39
tilemap031   byte 40, 1, 38, 39, 39, 27, 40, 1, 1, 4, 4, 4, 1, 1, 38, 39
tilemap032   byte 40, 14, 38, 39, 39, 28, 40, 1, 1, 3, 3, 3, 1, 1, 38, 39
tilemap033   byte 19, 39, 20, 39, 39, 39, 19, 39, 39, 39, 39, 39, 39, 39, 20, 39
tilemap034   byte 17, 37, 32, 33, 37, 37, 37, 41, 42, 37, 37, 34, 35, 36, 37, 18
tilemap035   byte 19, 21, 21, 31, 21, 21, 39, 21, 24, 39, 39, 21, 24, 23, 39, 20
tilemap036   byte 43, 44, 45, 39, 39, 39, 22, 23, 24, 25, 26, 27, 28, 29, 30, 39
tilemap037   byte 17, 37, 18, 39, 22, 17, 4, 4, 4, 4, 4, 4, 4, 4, 4, 18
tilemap038   byte 40, 5, 38, 39, 23, 40, 4, 4, 4, 4, 4, 4, 4, 4, 4, 38
tilemap039   byte 40, 1, 38, 39, 24, 40, 4, 4, 4, 4, 4, 4, 4, 4, 4, 38
tilemap040   byte 40, 7, 38, 39, 25, 40, 4, 4, 4, 4, 3, 4, 4, 4, 4, 38
tilemap041   byte 40, 1, 38, 39, 26, 40, 4, 4, 4, 4, 2, 4, 4, 4, 4, 38
tilemap042   byte 40, 9, 38, 39, 27, 40, 4, 4, 4, 4, 4, 4, 4, 4, 4, 38
tilemap043   byte 40, 1, 38, 39, 28, 40, 4, 4, 4, 4, 4, 4, 4, 4, 4, 38
tilemap044   byte 40, 14, 38, 39, 29, 40, 4, 4, 4, 4, 4, 4, 4, 4, 4, 38
tilemap045   byte 19, 39, 20, 39, 30, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 20
tilemap046   byte 17, 37, 32, 33, 37, 37, 37, 41, 42, 37, 37, 34, 35, 36, 37, 18
tilemap047   byte 19, 21, 21, 31, 21, 21, 39, 21, 25, 39, 39, 21, 29, 21, 39, 20
tilemap048   byte 43, 44, 45, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39
tilemap049   byte 17, 37, 18, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 46, 39
tilemap050   byte 40, 5, 38, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 47, 39
tilemap051   byte 19, 39, 20, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39
tilemap052   byte 17, 18, 39, 39, 17, 18, 17, 18, 17, 18, 39, 39, 17, 18, 17, 18
tilemap053   byte 40, 38, 39, 39, 40, 38, 19, 20, 40, 38, 18, 39, 40, 38, 40, 38
tilemap054   byte 40, 38, 17, 18, 40, 38, 17, 18, 40, 38, 17, 18, 40, 38, 40, 38
tilemap055   byte 40, 38, 40, 38, 40, 38, 40, 38, 40, 38, 19, 17, 40, 38, 19, 20
tilemap056   byte 40, 38, 40, 38, 40, 38, 40, 38, 40, 38, 39, 19, 40, 38, 17, 18
tilemap057   byte 19, 39, 39, 39, 39, 20, 19, 20, 19, 20, 39, 39, 19, 20, 19, 20
tilemap058   byte 17, 37, 32, 33, 37, 37, 37, 37, 37, 37, 37, 34, 35, 36, 37, 18
tilemap059   byte 19, 21, 21, 31, 21, 21, 39, 39, 39, 39, 39, 22, 26, 26, 39, 20




_tiles
' Tiles data goes here. Each tile is 16x16.
' You can put as many as you want. The only restriction being memory limit.
tile000 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile001 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile002 long $D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8,$D8D8D9D9,$D9D9D9D8,$D8DADAD9,$D9D9D8D8
        long $D8D8D8D9,$D8D8D8D9,$DBD8D8D8,$D9D8D8D8,$D9D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8DC
        long $D8D9D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8DBD8,$D8D8D9D8,$D9D9D9D8,$D8D8D8D9,$D8DAD8D8
        long $D8D9D9D8,$D9D9D9D9,$D8D8D9D9,$D8DAD8D8,$D9DAD9D8,$D9D9D9D9,$D8D9D9D9,$D8D9D8D8
        long $D9DBD9D8,$D9D9D9D9,$D8D9D9D9,$D8D9D8D8,$DADBD9D8,$D9D9D9D9,$D8D9D9D9,$D8D9D8D8
        long $DCDBD9D8,$D9D9D9D9,$D8D9D9D9,$D8D9D8D8,$DBD9D8D8,$D9D9D9DC,$D8D8D9D9,$D8D8D9D8
        long $D9D8D8D8,$D9DADCDB,$D8D8D8D9,$D8D8D8D9,$D8D8D8D9,$DBDBDBD9,$D9D8D8DA,$D9D8D8D8
        long $D8D8D9D9,$D9D9D9D8,$D8D9D9D9,$D9D9D8D8,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8
tile003 long $D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8,$D8D8D9D9,$D9D9D9D8,$D8DADAD9,$D9D9D8D8
        long $D8D8D8D9,$5A5AD8D8,$DBDA5C5B,$D9D8D8D8,$D8D8D8D8,$035B0202,$5C5C5B03,$D8D8D8DC
        long $02D8D8D8,$03035A02,$5C03035B,$D8D8DB5C,$02D8D8D8,$5B035B02,$03035B04,$D8DADA5C
        long $0259D8D8,$03035B02,$0303035B,$D8DA5C5B,$0259D8D8,$03035A02,$03030303,$D8D95C03
        long $5959D8D8,$03035A02,$03030303,$D8D95C5B,$5959D8D8,$035A0202,$5B5B0303,$D8D95C5B
        long $59D8D8D8,$5A020259,$5A5A5A5A,$D8D9D95B,$59D8D8D8,$02025959,$5A020202,$D8D8D95A
        long $D8D8D8D8,$59595959,$5A5A0259,$D8D8D8D9,$D8D8D8D9,$5A5AD8D8,$D9D95A5A,$D9D8D8D8
        long $D8D8D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D8D8,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8
tile004 long $D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8,$D8D8D9D9,$D9D9D9D8,$D8DADAD9,$D9D9D8D8
        long $D8D8D8D9,$5A5AD8D8,$DBDA5C5B,$D9D8D8D8,$D8D8D8D8,$035B0202,$5C5C5B03,$D8D8D8DC
        long $02D8D8D8,$03035A02,$5C03035B,$D8D8DB5C,$02D8D8D8,$5B035B02,$03035B04,$D8DADA5C
        long $0259D8D8,$03035B02,$0303035B,$D8DA5C5B,$0259D8D8,$03035A02,$03030303,$D8D95C03
        long $5959D8D8,$03035A02,$03030303,$D8D95C5B,$5959D8D8,$035A0202,$5B5B0303,$D8D95C5B
        long $59D8D8D8,$5A020259,$5A5A5A5A,$D8D9D95B,$59D8D8D8,$03035A59,$5A5A0303,$D8D8D95A
        long $D8D8D8D8,$03030359,$59030404,$D8D8D8D9,$D8D8D8D9,$020259D8,$D9D95902,$D9D8D8D8
        long $D8D8D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D8D8,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8
tile005 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$AADBD9D8,$D89B9B9B,$9B9B9BD8,$D8DCD9AA
        long $9BDBD9D8,$AA9C9C9C,$9C9CAAD8,$D8DCD99B,$9BDBD9D8,$9C9C9C9C,$9C9CAAAA,$D8DBD99B
        long $9BDCD9D8,$9C9C9C9C,$9C9CAA9B,$D8DCD99B,$9BDBD9D8,$9C9B9C9C,$9C9CAA9C,$D8DBD99B
        long $9BDBD9D8,$9CAA9C9C,$9C9C9B9C,$D8DBD99B,$9BDCD9D8,$9BAA9C9C,$9C9C9C9C,$D8DBD99B
        long $9BDBD9D8,$AAAA9C9C,$9C9C9C9C,$D8DBD99B,$9BDCD9D8,$D8AA9C9C,$9C9C9CAA,$D8DBD99B
        long $AADCD9D8,$D8AAAAAA,$AAAAAAD8,$D8DBD9AA,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile006 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D8D8D8D8,$D8D8D8D8,$D8DCD9D8
        long $AADBD9D8,$D8D8AAAA,$A9AAAAAA,$D8DCD9D8,$9BDBD9D8,$D8A99B9B,$AA9B9BA9,$D8DBD9D8
        long $9BDCD9D8,$A99B9B9B,$AA9B9BA9,$D8DCD9D8,$9BDBD9D8,$AA9B9B9B,$AA9B9BA9,$D8DBD9D8
        long $9BDBD9D8,$9B9BAA9B,$AA9B9BA9,$D8DBD9D8,$9BDCD9D8,$9B9BA99B,$AA9B9BAA,$D8DBD9D8
        long $9BDBD9D8,$9BAAA99B,$AA9B9B9B,$D8DBD9D8,$9BDCD9D8,$9BA9A99B,$AA9B9B9B,$D8DBD9D8
        long $9BDCD9D8,$A9D8A99B,$AA9B9B9B,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile007 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D89BD8D8,$D8D8D8D8,$D8DCD9D8
        long $D8DBD9D8,$9B9CAAD8,$D8D8D8D8,$D8DCD9D8,$D8DBD9D8,$9B9C9CAA,$AA9B9B9B,$D8DBD9D8
        long $AADCD9D8,$9C9C9C9C,$9B9C9C9C,$D8DCD9AA,$D8DBD9D8,$AA9C9CAA,$9CAAAAAA,$D8DBD99B
        long $D8DBD9D8,$AA9CAAD8,$9CAAD8D8,$D8DBD99B,$D8DCD9D8,$D8AAD8D8,$9CAAD8D8,$D8DBD99B
        long $D8DBD9D8,$9B9BD8D8,$9C9B9B9B,$D8DBD99B,$D8DCD9D8,$9C9CAAD8,$9B9C9C9C,$D8DBD9AA
        long $D8DCD9D8,$AAAAD8D8,$AAAAAAAA,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile008 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D8D8D8D8,$D8D8D8D8,$D8DCD9D8
        long $D8DBD9D8,$D8D8AAD8,$D8D8D8D8,$D8DCD9D8,$D8DBD9D8,$D8AA9BA9,$D8D8D8D8,$D8DBD9D8
        long $A9DCD9D8,$AAAA9B9B,$D8A9AAAA,$D8DCD9D8,$9BDBD9D8,$9B9B9B9B,$A9AA9B9B,$D8DBD9D8
        long $A9DBD9D8,$A9A99B9B,$AA9BA9A9,$D8DBD9D8,$D8DCD9D8,$D8A99BA9,$AA9BA9D8,$D8DBD9D8
        long $D8DBD9D8,$D8D8A9D8,$AA9BA9D8,$D8DBD9D8,$D8DCD9D8,$AAAAAAD8,$AA9BAAAA,$D8DBD9D8
        long $D8DCD9D8,$9B9B9BA9,$A9AA9B9B,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile009 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$9B9BD8D8,$D8D89B9B,$D8DCD9D8
        long $D8DBD9D8,$9C9CAAD8,$D89B9C9C,$D8DCD9D8,$D8DBD9D8,$AA9C9CAA,$9B9C9CAA,$D8DBD9D8
        long $D8DCD9D8,$D8AAAAD8,$9B9C9C9B,$D8DCD9D8,$D8DBD9D8,$9BD8D8D8,$D8AA9C9C,$D8DBD9D8
        long $D8DBD9D8,$9CAAD8D8,$D8D8AA9C,$D8DBD9D8,$D8DCD9D8,$AAD8D8D8,$D8D8D8AA,$D8DBD9D8
        long $D8DBD9D8,$9BD8D8D8,$D8D8D89B,$D8DBD9D8,$D8DCD9D8,$9CAAD8D8,$D8D89B9C,$D8DBD9D8
        long $D8DCD9D8,$AAD8D8D8,$D8D8D8AA,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile010 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D8D8D8D8,$D8D8D8D8,$D8DCD9D8
        long $D8DBD9D8,$AAAAAAD8,$D8D8D8AA,$D8DCD9D8,$D8DBD9D8,$9B9B9BA9,$D8D8AA9B,$D8DBD9D8
        long $A9DCD9D8,$A9A99B9B,$D8AA9B9B,$D8DCD9D8,$D8DBD9D8,$AAD8A9A9,$D8AA9B9B,$D8DBD9D8
        long $D8DBD9D8,$9BAAD8D8,$D8D8A99B,$D8DBD9D8,$D8DCD9D8,$9B9BA9D8,$D8D8D8A9,$D8DBD9D8
        long $D8DBD9D8,$A9A9D8D8,$D8D8D8D8,$D8DBD9D8,$D8DCD9D8,$AAAAD8D8,$D8D8D8D8,$D8DBD9D8
        long $D8DCD9D8,$9B9BA9D8,$D8D8D8AA,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile011 long $D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8,$D8D8D9D9,$D9D9D9D8,$D8DADAD9,$D9D9D8D8
        long $D8D8D8D9,$2929D8D9,$DBD84C2B,$D9D8D8D8,$D9D8D8D8,$2C2B1AD8,$D84C2B2C,$D8D8D8DC
        long $D8D9D8D8,$2C2C291A,$4C2C2C2B,$D8D8DBD8,$1AD8D9D8,$2B2C2B1A,$2C2C2B04,$D8DAD84C
        long $1A18D9D8,$2C2C2B1A,$2C2C2C2B,$D8DA4C2B,$1A18D9D8,$2C2C291A,$2C2C2C2C,$D8D94C2C
        long $1818D9D8,$2C2C291A,$2C2C2C2C,$D8D94C2B,$1818D9D8,$2C291A1A,$2B2B2C2C,$D8D94C2B
        long $1818D9D8,$291A1A18,$29292929,$D8D9D82B,$18D9D8D8,$1A1A1818,$291A1A1A,$D8D8D9D8
        long $D9D8D8D8,$18181818,$D8291A18,$D8D8D8D9,$D8D8D8D9,$292929D9,$D9D82929,$D9D8D8D8
        long $D8D8D9D9,$D9D9D9D8,$D8D9D9D9,$D9D9D8D8,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D9D9D9D8
tile012 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$02DBD9D8,$02030202,$02020202,$D8DCD902
        long $02DBD9D8,$03020102,$02020202,$D8DCD902,$02DBD9D8,$03020201,$01030303,$D8DBD902
        long $01DCD9D8,$02020202,$03020202,$D8DCD901,$02DBD9D8,$01020201,$02010101,$D8DBD903
        long $02DBD9D8,$01020102,$02010202,$D8DBD903,$02DCD9D8,$02010202,$02010202,$D8DBD903
        long $02DBD9D8,$03030202,$02030303,$D8DBD903,$02DCD9D8,$02020102,$03020202,$D8DBD901
        long $02DCD9D8,$01010202,$01010101,$D8DBD902,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile013 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$02DBD9D8,$03030202,$02020303,$D8DCD902
        long $02DBD9D8,$02020102,$02030202,$D8DCD902,$02DBD9D8,$01020201,$03020201,$D8DBD902
        long $02DCD9D8,$02010102,$03020203,$D8DCD902,$02DBD9D8,$03020202,$02010202,$D8DBD902
        long $02DBD9D8,$02010202,$02020102,$D8DBD902,$02DCD9D8,$01020202,$02020201,$D8DBD902
        long $02DBD9D8,$03020202,$02020203,$D8DBD902,$02DCD9D8,$02010202,$02020302,$D8DBD902
        long $02DCD9D8,$01020202,$02020201,$D8DBD902,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile014 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D8D8D8D8,$D8D8D89B,$D8DCD9D8
        long $D8DBD9D8,$AAD8D8D8,$D8D89B9C,$D8DCD9D8,$D8DBD9D8,$D8D8D8D8,$D89B9CAA,$D8DBD9D8
        long $D8DCD9D8,$9B9B9B9B,$9B9C9CAA,$D8DCD9D8,$AADBD9D8,$9C9C9C9C,$9C9C9C9C,$D8DBD99B
        long $AADBD9D8,$9C9C9C9C,$9C9C9C9C,$D8DBD99B,$D8DCD9D8,$AAAAAAAA,$AA9C9CAA,$D8DBD9D8
        long $D8DBD9D8,$D8D8D8D8,$D8AA9CAA,$D8DBD9D8,$D8DCD9D8,$AAD8D8D8,$D8D8AA9C,$D8DBD9D8
        long $D8DCD9D8,$D8D8D8D8,$D8D8D8AA,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile015 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$D8DBD9D8,$D8D8D8D8,$D8D8D8D8,$D8DCD9D8
        long $D8DBD9D8,$AAD8D8D8,$D8D8D8D8,$D8DCD9D8,$D8DBD9D8,$9BA9D8D8,$D8D8D8AA,$D8DBD9D8
        long $D8DCD9D8,$A9D8D8D8,$D8D8AA9B,$D8DCD9D8,$AADBD9D8,$A9AAAAAA,$D8AA9B9B,$D8DBD9D8
        long $9BDBD9D8,$9B9B9B9B,$AA9B9B9B,$D8DBD9D8,$9BDCD9D8,$9B9B9B9B,$AA9B9B9B,$D8DBD9D8
        long $A9DBD9D8,$A9A9A9A9,$D8A99B9B,$D8DBD9D8,$D8DCD9D8,$A9D8D8D8,$D8D8A99B,$D8DBD9D8
        long $D8DCD9D8,$9BA9D8D8,$D8D8D8A9,$D8DBD9D8,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile016 long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$DBDBD9D8,$DBDBDBDB,$DCDBDCDB,$D8DCDCDC
        long $D9DCD9D8,$D9D9D9D9,$D9D9D9D9,$D8DCD9D9,$02DBD9D8,$02020202,$02020203,$D8DCD902
        long $02DBD9D8,$01020202,$02020302,$D8DCD902,$02DBD9D8,$02020202,$02030201,$D8DBD902
        long $02DCD9D8,$03030303,$03020201,$D8DCD902,$01DBD9D8,$02020202,$02020202,$D8DBD903
        long $01DBD9D8,$02020202,$02020202,$D8DBD903,$02DCD9D8,$01010101,$01020201,$D8DBD902
        long $02DBD9D8,$02020202,$02010201,$D8DBD902,$02DCD9D8,$01020202,$02020102,$D8DBD902
        long $02DCD9D8,$02020202,$02020201,$D8DBD902,$DCDCD9D8,$DBDCDBDC,$DBDBDCDB,$D8DBDCDB
        long $D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
tile017 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$DADAD9D9,$DADADADA,$DADADADA,$D9D9D9D9,$D9D9DADA,$D9D9D9D9,$D9D9D9D9
        long $DAD9D9D9,$D9D9D9D9,$D8D8D8D8,$D8D8D8D8,$DAD9D9D9,$D8D8D9D9,$D8D9D8D9,$D8D9D8D9
        long $D9DAD9D9,$D8D9D8D9,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D8D8D9,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
tile018 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DADBDADA,$DBDADCDB,$D9D9DCDB,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DCDCD9D9,$D9D9D9D9
        long $D8D8D8D8,$D8D8D8D8,$D9D9D9D9,$D9D9D9DC,$D8D9D8D9,$D8D9D8D9,$D9D9D8D8,$D9D9D9DC
        long $D9D9D9D9,$D9D9D9D9,$D9D8D9D8,$D9D9DCD9,$D9D9D9D9,$D9D9D9D9,$D9D8D8D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DCD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
tile019 long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DBD9D9,$D9D8D8D9,$D9D9D9D9,$D9D9D9D9,$D9DCD9D9,$D8D9D8D9,$D9D9D9D9,$D9D9D9D9
        long $DBD9D9D9,$D8D8D9D9,$D9D8D9D8,$D9D8D9D8,$DCD9D9D9,$D9D9D9D9,$D8D8D8D8,$D8D8D8D8
        long $D9D9D9D9,$D9D9DBDC,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DBDCD9D9,$DADADADA,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile020 long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D9D8D8D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D9D8D9D8,$D9D9DAD9
        long $D9D8D9D8,$D9D8D9D8,$D9D9D8D8,$D9D9D9DA,$D8D8D8D8,$D8D8D8D8,$D9D9D9D9,$D9D9D9DA
        long $D9D9D9D9,$D9D9D9D9,$DADAD9D9,$D9D9D9D9,$DADADADA,$DADADADA,$D9D9DADA,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile021 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9DADAD9,$D9D9D9D9
        long $D9D9D9D9,$DCD9D9D9,$05050505,$D9D9D9DA,$D9D9D9D9,$05FCD9D9,$05050505,$D9D9D905
        long $D9D9D9D9,$0405CAD9,$0504CADC,$D9D9DA05,$D9D9D9D9,$D905FCD8,$05D8C8D8,$D9D9D905
        long $D9D9D9D9,$D90405D8,$05C8D9D9,$D9D9D905,$D9D9D9D9,$D9DC05D8,$05D8D9D9,$D9D9D9DC
        long $D9D9D9D9,$D9DB05D8,$05CBD9D9,$D9D9D9DA,$D9D9D9D9,$D9DB05D8,$FC04D8D9,$D9D9D9D9
        long $D9D8D9D8,$D90405C8,$DA05CAD9,$D9D8D9D9,$D9D8D8D8,$D90504C8,$D9DC04D9,$D8D8D8D8
        long $D9D9D9D9,$0405D9C8,$D9D9DC05,$D9D9D9D9,$DADADADA,$FCDAC8D8,$DAD9D9CB,$DADADADA
        long $D9D9D9D9,$D8C8D8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile022 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$DB0504DA,$D9D9D9D9,$D9D9D9D9,$DAD9D9D9,$DB050505,$D9D9D9D9
        long $D9D9D9D9,$05D8D9D9,$D9050504,$D9D9D9D9,$D9D9D9D9,$D8C8D9D9,$D90405C8,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9FC05D9,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9DB0502,$D9D9D9D9
        long $D9D9D9D9,$D8D9D9D9,$D9DA05CA,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D904FC,$D9D9D9D9
        long $D9D8D9D8,$C8D9D9D8,$D9D9DB05,$D9D8D9D8,$D8D8D8D8,$D8D9D8D8,$D8D8D905,$D8D8D8D8
        long $D9D9D9D9,$CBD9D9D9,$D9D9D9DC,$D9D9D9D9,$DADADADA,$D8D8DADA,$DADAD9D9,$DADADADA
        long $D9D9D9D9,$D8D8D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile023 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DAD9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$0504DAD9,$D9D9D904,$D9D9D9D9,$D9D9D9D9,$050504D9,$D9D90405,$D9D9D9D9
        long $D9D9D9D9,$050505CB,$D9DA0505,$D9D9D9D9,$D8D9D9D9,$DBC8CA02,$D9FC0505,$D9D9D9D9
        long $D8D9D9D9,$C8D8D9D8,$D90405EC,$D9D9D9D9,$D9D9D9D9,$C8D9D9D9,$D9DC05CB,$D9D9D9D9
        long $D9D9D9D9,$D8D9D9D9,$D9DA05DC,$D9D9D9D9,$D9D9D9D9,$DAD9D9D9,$D9D9FC05,$D9D9D9D9
        long $D9D9D9D8,$05DBD9D9,$D9D9D9FC,$D9D8D9D8,$DAD9D8D8,$CC0405DC,$D9DADBDB,$D8D8D8D8
        long $05D9D9D9,$05050505,$D9D9FCFC,$D9D9D9D9,$D8C8D9DA,$C8C8D8D8,$DAD9D9D8,$DADADADA
        long $D8D8D9D9,$D8D8D8D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile024 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$05DCD9D9,$D9DBFC05,$D9D9D9D9,$D9D9D9D9,$050504D9,$04050505,$D9D9D9D9
        long $D9D9D9D9,$D9CA04D8,$05058CD9,$D9D9D9DA,$D9D9D9D9,$D8D8D8C8,$040504D8,$D9D9D9D9
        long $D9D9D9D9,$FCDBD9D9,$D9DA0404,$D9D9D9D9,$D9D9D9D9,$0505D8D9,$D9DA0405,$D9D9D9D9
        long $D9D9D9D9,$DAC8C8D9,$D9040505,$D9D9D9D9,$D9D9D9D9,$C8D8D9D9,$DA0505DA,$D9D9D9D9
        long $D9D8D9D8,$D8D9D9D9,$DA0505C8,$D9D8D9D9,$DAD9D8D8,$D9D9D9DB,$D9CC0502,$D8D8D8D8
        long $DAD9D9D9,$04FC0505,$D9D9DB05,$D9D9D9D9,$C8D8D9DA,$D8CBDB02,$DADAD9D8,$DADADADA
        long $D8D9D9D9,$D9D8D8D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile025 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$0405DAD9,$DCD9D9D9,$D9D9D9D9,$D9D9D9D9,$0505CCD8,$05ECD9D9,$D9D9D9DA
        long $D9D9D9D9,$FC0504D8,$05CCD8D9,$D9D9D9DA,$D9D9D9D9,$DC0505C8,$0504C8D9,$D9D9D9D9
        long $D9D9D9D9,$DA0505D9,$0405C8D9,$D9D9D9D9,$D9D9D9D9,$D9050502,$0505C8D9,$D9D9D9DA
        long $D8D9D9D9,$D90405CA,$DA05DBD9,$D9D9D9D9,$D8D9D9D9,$DC0405CA,$D9050404,$D9D9D9D9
        long $D8D8D9D8,$DC0504D8,$D9FCFCD9,$D9D8D9D8,$D8D8D8D8,$D8D8C8C8,$D9DB05C8,$D8D8D8D8
        long $D9D9D9D9,$D9D9D9D9,$D9D904D8,$D9D9D9D9,$DADADADA,$D8D9DADA,$DAD9DBCB,$DADADADA
        long $D9D9D9D9,$D8D9D9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile026 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$DAD9D9D9,$DBDBDADA,$D9D9D9D9,$D9D9D9D9,$0505D9D9,$05050505,$D9D9D9DB
        long $D9D9D9D9,$050502D9,$05050505,$D9D9D9DB,$D9D9D9D9,$CA05DAD8,$04CBD8C8,$D9D9D9D9
        long $D9D9D9D9,$D905CBD8,$D9D8D8D8,$D9D9D9D9,$D9D9D9D9,$0405CBD8,$D9D9D9EC,$D9D9D9D9
        long $D9D9D9D9,$0505ECD8,$D9D90505,$D9D9D9D9,$D9D9D9D9,$FCD9C8C8,$D9FC0505,$D9D9D9D9
        long $D9D8D9D8,$C8D8D8D9,$D90505CB,$D9D8D9D8,$D9D8D8D8,$D9DB0404,$D90505CB,$D8D8D8D8
        long $C8D9D9D9,$0504DAC8,$D9DA0505,$D9D9D9D9,$D9DADADA,$CBDAC8D8,$DAD9D8CB,$DADADADA
        long $D9D9D9D9,$D8D8D8D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile027 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$DADC04DC,$D9D9D9D9,$D9D9D9D9,$05DAD9D9,$05050505,$D9D9D9DA
        long $D9D9D9D9,$0505DAD9,$0504D902,$D9D9D9D9,$D9D9D9D9,$D90504D8,$DBDCC8D9,$D9D9D9D9
        long $D9D9D9D9,$D90405D9,$D9D8D8D9,$D9D9D9D9,$D9D9D9D9,$D9DA05CA,$D9D9DAD9,$D9D9D9D9
        long $D8D9D9D9,$FCDB05EC,$DA050505,$D9D9D9D9,$C8D9D9D9,$050505FC,$DB0505EC,$D9D9D9D9
        long $C8D9D9D8,$D8CC05CC,$DA05CAC8,$D9D8D9D9,$E8D9D8D8,$D9DB05CA,$D9ECDCD8,$D8D8D8D8
        long $D8D9D9D9,$DC0504C8,$D9D9FCFC,$D9D9D9D9,$D9DADADA,$CBDAC8C8,$DADAD9CA,$DADADADA
        long $D9D9D9D9,$D8D8D8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile028 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$04DAD9D9,$04FC04FC,$D9D9D9DB,$D9D9D9D9,$0504D9D9,$05050505,$D9D9D9FC
        long $D9D9D9D9,$0405CBD9,$0504CACC,$D9D9D9DB,$D9D9D9D9,$D8CAD9D8,$05DBC8D8,$D9D9D9DA
        long $D9D9D9D9,$D9D9D8D8,$0404D8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DC05C8D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$DA05D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D905CAD8,$D9D9D9D9
        long $D9D8D9D8,$D9D8D9D8,$D9EC03D8,$D9D8D9D8,$D8D8D8D8,$D9D8D8D8,$D9DB04D8,$D8D8D8D8
        long $D9D9D9D9,$D9D9D9D9,$D9D905C8,$D9D9D9D9,$DADADADA,$D9DADADA,$DAD9FCC8,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9DAD8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile029 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$DADBDBDB,$D9D9D9D9,$D9D9D9D9,$05DAD9D9,$05050505,$D9D9D9FC
        long $D9D9D9D9,$0504D9D9,$05DCCBFC,$D9D9D904,$D9D9D9D9,$0505C8D9,$05D9D8D9,$D9D9D9DB
        long $D9D9D9D9,$05ECC8D9,$0404D9CB,$D9D9D9D9,$D9D9D9D9,$0502C8D9,$D9040505,$D9D9D9D9
        long $D9D9D9D9,$0504DAD9,$FC050505,$D9D9D9D9,$D9D9D9D9,$CB0504D8,$0405CBD9,$D9D9D9D9
        long $D9D8D9D8,$DA0505C8,$DB05CAD8,$D9D8D9D9,$D9D8D8D8,$CC05FCC8,$D90404DA,$D8D8D8D8
        long $D9D9D9D9,$0504CBC8,$D9D9CB05,$D9D9D9D9,$DADADADA,$FCCBD8D9,$DAD9D8CB,$DADADADA
        long $D9D9D9D9,$D8D8D9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile030 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$0505DCD9,$D9D9D904,$D9D9D9D9,$DAD9D9D9,$05050505,$D9D9DC05
        long $D9D9D9D9,$05DAD9D9,$04FC0505,$D9D90505,$D9D9D9D9,$05CCD8D9,$02C8D804,$D9D90505
        long $D9D9D9D9,$0505D8D9,$D9D8D9DA,$D9D90505,$D9D9D9D9,$0505C8D9,$CAD9D9D9,$D9D9EC05
        long $D9D9D9D9,$05DCC8D9,$04D9D9DB,$D9D9DB05,$D9D9D9D9,$05D8C8D9,$05050505,$D9D9D904
        long $D9D8D9D8,$C8C8D9D8,$0504CB02,$D9D8D9DA,$D8D8D8D8,$D8D9D8D8,$DC05ECD9,$D8D8D8D9
        long $D9D9D9D9,$05DBD9D9,$D9DA0505,$D9D9D9D9,$DADADADA,$ECCBD9DA,$DAD9D8CB,$DADADADA
        long $D9D9D9D9,$D8D8D9D9,$D9D9D9C8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile031 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9DB0504,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9DA0505,$D9D9D9D9
        long $D9D9D9D9,$C8D9D9D9,$D9D9DBCB,$D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9D9D8,$D9D9D9D9
        long $D9D8D9D8,$FCD9D9D8,$D9D9DC05,$D9D8D9D8,$D8D8D8D8,$05C8D9D8,$D8D9DB05,$D8D8D8D8
        long $D9D9D9D9,$02C8D9D9,$D9D9D9DB,$D9D9D9D9,$DADADADA,$D8D8DADA,$DADAD9D9,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile032 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DAD9D9D9,$D9D9D9DA,$D9D9D9D9
        long $DADADADA,$ECD9DADA,$DADAD905,$DADADADA,$D9D9D9D9,$CCC8D9FC,$D9D9D905,$D9D9D9D9
        long $05D9D8D8,$C8E8D905,$D8D8D9D8,$D8D8D8D8,$05D8D9D8,$DAD9DA05,$DAD9D9DA,$D9DADAD9
        long $0505D8D9,$ECDA0505,$05DBD905,$FC0505DC,$0505C8D9,$CCD90505,$05CAC805,$05050505
        long $0548C8D9,$ECC8D805,$05CAC805,$0504C8EC,$05C8D9D9,$ECE8D905,$05CAC805,$05ECC8DB
        long $05C8D9D9,$ECC8D905,$05CAC805,$05CCE8DB,$05C8D9D9,$ECC8D905,$05CAC805,$05CCC8DB
        long $0548D9D9,$ECE8D905,$05CAC805,$05ECC8DB,$05C8D9D9,$ECD90505,$05CAC805,$05CCE8DB
        long $CB48D9D9,$ECCA0505,$05CAC805,$05ECC8DB,$C8C8D9D9,$C8C8D9D8,$D8C8C8D8,$D8C8E8D9
tile033 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DADADADA,$DADADADA,$DADADADA,$DADADADA,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D8D8D8D8,$D9D8D8D8,$D8D8D8D9,$D8D8D9D9,$D9DADAD9,$FCDBD9D8,$D9D8D9DC,$D9D904FC
        long $DA0505DB,$0505DAD9,$C8D90405,$D9D90505,$05050404,$DA05FCD8,$C8D90504,$D9D90505
        long $0505D9DA,$C80405C8,$E8DA05DA,$D9D9DAD8,$050588DA,$FC0405D8,$D8DB0504,$D9D9D9D8
        long $0505C8DA,$050505D8,$D9DB0505,$D9D9D9D9,$0505C8DA,$D80405C8,$D9D9D9D8,$D9D9D9D9
        long $050500DA,$D80404C8,$D9CB05DB,$D9D904FC,$0505C8DA,$0505CBE8,$C8D90505,$D9D90505
        long $0505C8DA,$05CCC8C8,$C8D9DB04,$D9D90505,$D9C800D9,$C8E8C8E9,$48D9D9D8,$D9D9D9C8
tile034 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DADADADA,$DADADADA,$DADADADA,$DADADADA,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D9D8,$DAD9DADA,$DBD9D9DA,$D9D9D8D9,$D9DADBDB
        long $05DB05FC,$05FCDB05,$FCD9D904,$DB050505,$040405CC,$04040505,$05D8CB05,$0405E804
        long $E8CA05EC,$CAD80505,$CAD8EC05,$0505C8DB,$C8DA05CC,$CAD80505,$CAD8FC05,$050505FC
        long $C8DA05EC,$CAD80505,$05CA0405,$0505CC05,$48DA05CC,$CAD80505,$05DBEC05,$0505C8DA
        long $C8DA05EC,$CAD80505,$05BCFC05,$0505CADB,$88DA05CC,$CAD80505,$05CACC05,$05050404
        long $C8EA05EC,$D8D80505,$04E8FC05,$0505DC05,$00D9D8C8,$C8D8D9C8,$D8C8D9C8,$D9C8C8D9
tile035 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DADAD9D9,$D9D9D9D9,$D9DAD9D9
        long $DADADADA,$0505D8DA,$DADADAD9,$DB05DBD9,$D9D9D9D9,$0505C8D9,$D9D9D9DA,$DB05CAD8
        long $D8D8D8D8,$0505C8D8,$D8D8D8DA,$DB05CAE8,$D9DADAD9,$0505E8DA,$D9D9DADA,$DB05CAD8
        long $FC05FCD8,$0505D805,$DA0505FC,$DB05CAD8,$0505CAC8,$0505D805,$DC050405,$DB05CAD8
        long $0505CAD8,$0505C8DB,$0505D8CA,$DB05CAD8,$DC05CAD8,$0505C8D9,$0505C8DA,$DB05CAD8
        long $DB05CAD8,$0505E8D8,$0505C8DA,$CB05CAD8,$DB05CAD8,$0505C8D9,$0505E8DA,$CB05CAD8
        long $DB05CAD8,$0504C8D9,$0505CADA,$DB05CAD8,$DB05CAD8,$0505E8D9,$DC050405,$DB05CAD8
        long $DB05CAD8,$0505C8D8,$DA0405CB,$DB05CAD8,$D9D8C8D8,$E8C848D9,$D9D9D9C8,$D9D8C8E8
tile036 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DADADAD9,$DADADADA,$DADADADA,$DADADADA,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D8D8D9,$D8D8D8D8,$D8D9D8D8,$D8D9D8D8,$04DBD9D9,$D9D9D9DB,$D9DBDBD9,$DCFCDAD9
        long $0505DBD9,$D9D9DB05,$04050505,$FC05D9D8,$CA0405D8,$CAD90405,$0504CC05,$0405CADA
        long $C8DB05D9,$CAD805DC,$DBD8CA05,$DAD9C8D9,$EC0405D9,$CADA0505,$DA040505,$D9D8D8D9
        long $050505D9,$C8D90505,$050505CB,$D9D9D9DA,$CACB05D8,$D8D9DAD8,$05FCD8D8,$D9D9D9DB
        long $D8DC05D8,$CBDA0504,$05CBCA05,$DCFCDADB,$040504C8,$CAD80405,$05050505,$FC05D9DA
        long $0504D8C8,$C8D8DAFC,$DB0405EC,$0405CAD8,$C8C8E8D8,$E8D9D9D8,$D9D8C8C8,$D9C8C8D8
tile037 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DADADADA,$DADADADA,$DADADADA,$DADADADA,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D9D8D9,$D8D9D8D9,$D8D9D8D9,$D8D9D8D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile038 long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DAD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DBD9
        long $D9D9D9D9,$D9D9D9D9,$D8D9D9D9,$D9D9DBD9,$D9D9D9D9,$D9D9D9D9,$D8D8D9D9,$D9D9DAD9
tile039 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DADADADA,$DADADADA,$DADADADA,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile040 long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
        long $D9DAD9D9,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9DAD9D9,$D9D9D9D8,$D9D9D9D9,$D9D9D9D9
tile041 long $DADAD9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DB05D8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DB05D8D9,$DADADAD9,$DADADADA,$DADADADA,$DB05D8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DB05D8D9,$ECDAD8D9,$DAD8DAFC,$D9D8D9DA,$DB05D8D9,$0505D9D9,$DBD90405,$DBD90405
        long $DB05D8D9,$CB05CBD9,$D8CA05DC,$CBD80405,$DB05D8D9,$D805CCD8,$C8DB05D8,$CCC80505
        long $DB05D8D9,$FC0504C8,$C8FC0504,$05D905FC,$DB05D8D9,$050505C8,$C8FC0505,$05CA05CB
        long $DB05D8D9,$D805ECC8,$D8DAD9D9,$050405CA,$DB05D8D9,$D90503C8,$D8CC05CA,$050505C8
        long $DB05D8D9,$050502C8,$D9DB0505,$040504C8,$DB05D8D9,$05CBC8D8,$D9D9DB04,$FC0503E8
        long $D9C8C8D9,$C848C8D9,$D9D9D9D8,$D9C8C8C8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile042 long $D9D9D9D9,$D9D9D9D9,$DADAD9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DB05D8D9,$D9D9D9D9
        long $DADADADA,$DADADADA,$DB05D8D9,$DADADAD9,$D9D9D9D9,$D9D9D9D9,$DB05D8D9,$D9D9D9D9
        long $D9D9D9DA,$D9DAFCDC,$DB05D8D9,$D904FCD9,$04D9DB05,$DA050505,$DB05D8D9,$D90505C8
        long $05CADA05,$DC05CAEC,$DB05D8D9,$D90505C8,$05CAD805,$0405C8CA,$DB05D8D9,$D9D9D8E8
        long $0503D8FC,$0505EC04,$DB05D8D9,$D9D9D9D9,$05ECC8DB,$05050505,$DB05D8D9,$D9D9D9D9
        long $05CAE8DA,$DAD8CACA,$DB05D8D9,$D9D9D9D9,$05CAD8D9,$0505D8DA,$DB05D8D9,$D9FC04D9
        long $05D8D8D9,$DC050505,$DB05D8D9,$D90505C8,$CAC8D9D9,$D9DC0504,$DB05D8D9,$D90505C8
        long $C8D8D9D9,$D9D9C8C8,$D9D8D8D9,$D9D9C848,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile043 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D9D9D9,$D9D9DADB,$DAECDCD9,$D9DBDCD9,$05D9D9D9,$D9D90405,$040505DC,$D90405D8
        long $05C8D9D9,$C8D90505,$05050505,$D904DAC8,$05CAD8D9,$D8D904C8,$0502CA05,$D904D8DB
        long $05CBD8D9,$D8D9D9D9,$04C8D804,$D905D8DB,$05E8D8D9,$C8D8DA04,$04C8D904,$D905D8CB
        long $CBC8D8D9,$D8D90405,$04E8D904,$D905D8DA,$E8D9D9D9,$C80405D8,$04C8D904,$D905D8CA
        long $CA05D8D9,$C80402C8,$05C8D904,$D904D8D8,$DA04C8D9,$C8DCDAD8,$04D8DADC,$0505CAD8
        long $04CAE8D9,$C8DA0504,$DBCC04D9,$0405CBD8,$D9C8D8D9,$D9D9D9CB,$D904DCC8,$D8CA02D8
        long $D8D8D9D9,$D9D9D9D8,$D9D9C8E8,$D9D9D8D8,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile044 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DBD9D9D9,$DADADAD9,$D9D9D9DB,$D9D9D9DA,$05CBD9D9,$050504DA,$D9D9DB05,$D9D90404
        long $05E8D8D9,$05CC05D8,$D8D9DCDC,$D8DA0505,$05C8D8D9,$05D8E8C8,$C8D9DAD8,$D8DC04FC
        long $05C8D9D9,$05D8D8D8,$C8D9D9D8,$D9FCCB05,$05C8D9D9,$04D8D8D9,$E8D9D9D9,$D905D9EC
        long $05C8D9D9,$04D9D8D9,$D9D9D9D9,$D9050505,$05C8D9D9,$04C8D9D9,$CBD8D9D9,$DA04C804
        long $04C8D8D9,$04C8D9D9,$04D8D9D9,$DA04C8D9,$04C8DA04,$04C8D9D9,$04C8D9D9,$DA04D8D9
        long $DBC8DADB,$04E8D9D9,$DAD9D9D9,$D904D8D9,$DAD8D9D8,$04C8D9D9,$D9D8D8D9,$D9DCD8D9
        long $D9D8D9D9,$DAC8D9D9,$D9D9D9D9,$D9D9C8D9,$D9D9D9D9,$D9D8D9D9,$D9D9D9D9,$D9D9D9D9
tile045 long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $DBD9DBD9,$D9D9D9DC,$DCDBDBD9,$D9D9D9D9,$04D905CB,$D9D9DC05,$050505D8,$D9D9D9DC
        long $04D905E8,$D9DA0505,$050405C8,$D9D9D904,$D8D905C8,$D9050505,$D8C805C8,$D9D9D9DB
        long $D8D905C8,$DB0502CA,$D9EC0548,$D9D9D9D9,$D8D905C8,$05DCC8DB,$D90405C8,$D9D9D9D9
        long $D8D905C8,$05D8E8DB,$D9D905DA,$D9D9D9D9,$D8D905C8,$0504D9DC,$D9D904E8,$D9D9D9D9
        long $D8D9FCC8,$DA040505,$D9D904C8,$D9D9D9D9,$D8D904C8,$D9D90504,$DCDCDBC8,$D9D9D9DB
        long $D8D9DBE8,$D9DBFC02,$DB05D9E8,$D9D9D9D9,$D8D9DAD8,$D904D9D8,$D9E8C8D9,$D9D9D9D9
        long $D9D9D9D8,$DADCC8D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D8C8D9,$D9D9D9D9,$D9D9D9D9
tile046 long $D90505D9,$D9D9D9D9,$D905D9D9,$D9D9D9D9,$D9D9D9DC,$D90505DC,$D90505DC,$D90505DC
        long $D9D9D9DC,$D905D9DC,$D905D9DC,$D9D9DCDC,$D9DCDCD9,$D9DCDCDC,$D9DCDCDC,$D90505DC
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D905DCD9,$0505DCD9,$D9D9DCD9,$D9D905D9
        long $05D9DCD9,$D9D9DCD9,$D9DCDCD9,$D9D90505,$D9DCDCD9,$D9DCDCD9,$05D9DCD9,$D9D905D9
        long $DCD9DCD9,$0505DCD9,$D9D9DCD9,$D9D905D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DADADADA,$DADADADA,$DADADADA,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile047 long $05D9D9D9,$D9D9D905,$D9D9D9D9,$D9D9D9D9,$D9DCD9D9,$05DCD9D9,$D9DCD905,$D9D9D905
        long $D9DCD9D9,$DCDCD905,$DCD9D9D9,$D9D9D9D9,$DCD9D9D9,$D9DCD9DC,$D9DCD9D9,$D9D9D9DC
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9DC,$D905DCD9,$D9D9D9D9
        long $D9D9D9D9,$DCD9D9DC,$05D9DCD9,$D9D9D9D9,$D9D9D9D9,$D9D9D9DC,$D9DCDCD9,$D9D9D9D9
        long $D9D9D9D9,$D90505DC,$D9D9DCD9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
        long $D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D9D8D9D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8,$D8D8D8D8
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$DADADADA,$DADADADA,$DADADADA,$DADADADA
        long $D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9,$D9D9D9D9
tile048 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile049 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile050 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile051 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile052 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile053 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile054 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile055 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile056 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile057 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile058 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile059 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile060 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile061 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile062 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
tile063 long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505
        long $05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505,$05050505

