{
  ORE_TV version 005
  Modified version of 8x8 Char Mode 8 driver by potatohead
} 
CON  NTSC_color_frequency       =     3_579_545
     NTSC_hsync_clocks          =     624
     NTSC_active_video_clocks   =     3008

     horizontal_pixels  =  160  
     clocks_per_gfx_pixel = 2560 / horizontal_pixels
     horizontal_offset    = 00

     bytes_per_line = horizontal_pixels / 8
     waitvids = bytes_per_line 
     clocks_per_gfx_frame   =  clocks_per_gfx_pixel*8
     frames_per_gfx_line    = horizontal_pixels / 8
     overscan = 448 
     backporch = 208 + horizontal_offset
     frontporch = (overscan - backporch)
    
PUB start(tvpointer)
  cognew(@entry,tvpointer)

DAT                     org
entry                   jmp     #initialization         'Jump past the constants

NTSC_color_freq                long  NTSC_color_frequency
NTSC_hsync_VSCL                long  160368
NTSC_control_signal_palette    long  $00_00_02_8a
NTSC_hsync_pixels              long  %%11_0000_1_2222222_11
NTSC_active_video_VSCL         long  NTSC_active_video_clocks
user_data_VSCL                 long  (clocks_per_gfx_pixel) << 12 +  clocks_per_gfx_frame


' Video hardware setup

initialization
'get parameters from parameter block, and pass them to COG code here

                        mov     C, PAR                 ' get parameter block address
                        rdlong  A, C                   ' get screen address
                        mov     bmp, A                 ' store another copy
                        
                        add     C, #4                  'index to fonttab address
                        rdlong  fonttab, C             'store it      

                        add     C, #4                  'index to Vsync variable
                        mov     VSyncPtr, C            'store it   
                                                
                        add     C, #4                   'index to base pin number
                        rdlong  A, C
                                                
                        and     A,#%100 WZ              ' top or bottom nibble
              IF_NZ     mov     A,#%0_01_000_000        ' top nibble
                        or      A,#%0_10_001_000
                        mov     vcfg_2_color_mode,A                          
                        or      A,#%0_10_101_000
                        mov     vcfg_4_color_mode,A                          

                        ' VCFG: setup Video Configuration register and 3-bit tv DAC pins to output

                        mov     A,#%0000_0111           ' mask top or bottom pins
              IF_NZ     shl     A,#4
                        movs    VCFG, A                 ' VCFG'S = pinmask (pin31: 0000_0111 : pin24)

                        rdlong  A, C
                        shr     A,#3
                        movd    VCFG, A                 ' VCFG'D = pingroup (grp. 3 i.e. pins 24-31)

                        movi    VCFG, vcfg_4_color_mode

                        rdlong  A,C
                        mov     tvport_mask,#%0111
                        shl     tvport_mask, A
                        or      DIRA, tvport_mask       ' set DAC pins to output


                        ' CTRA: setup Frequency to Drive Video
                        movi    CTRA,#%00001_111        ' pll internal routed to Video, PHSx+=FRQx (mode 1) + pll(16x)
                        mov     r1, NTSC_color_freq     ' r1: Color frequency in Hz (3.579_545MHz)
                        rdlong  v_clkfreq, #0           ' copy clk frequency. (80Mhz)
                        mov     r2, v_clkfreq           ' r2: CLKFREQ (80MHz)
                        call    #dividefract            ' perform r3 = 2^32 * r1 / r2
                        mov     v_freq, r3              ' v_freq now contains frqa.       (191)
                        mov     FRQA, r3                ' set frequency for counter

'-----------------------------------------------------------------------------
                        'vertical overscan (26 blank lines)
frame_loop                                                            
                        mov     line_loop, #26          '(26 so far)

:vert_back_porch        mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, hsync
                        
                        
                        mov     VSCL, NTSC_active_video_VSCL
                        waitvid brown_border_in_color0, #0      'draw blank line
                        djnz    line_loop, #:vert_back_porch
'-----------------------------------------------------------------------------


                        mov     line_loop, #192    'setup number of display lines
                        mov     fontline, #0       'set font scan offset to 0

                        wrlong zero,VsyncPtr
                        
user_graphics_lines     mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, hsync    'hsync
                                                             
                        mov     VSCL,#backporch
                        waitvid green_border_in_color0, #0   'left overscan
                        
 
                        mov     VSCL, user_data_VSCL  'set VSCL for 8 pixel blocks                         
                        movi    VCFG, vcfg_4_color_mode   'two color mode
                        mov     r1, #waitvids  'number of horiz pixels / 8

                        mov     fontsum, fonttab         'pre add these to save instruction time
                        add     fontsum, fontline        'in waitvid later on


draw_pixels             rdlong  B, A            'get a character and colors from screen memory (A)
                        mov     colors, B       'set up colors 
                        shr     B, #24
                        shl     B, #4 
                        add     B, fontsum
                        rdword  C, B            'read the character data

                        shl    colors, #8
                        or    colors, color_mask 
                        
                        waitvid colors, C  'draw them to screen           
                        
                        add     A, #4    'point to next set of chars and colors
                        djnz    r1, #draw_pixels  'line done?

                        
'===============================================================================================
  
                        mov    VSCL,#frontporch
                        waitvid blue_border_in_color0 , border 'overscan to the right...
                        movi    VCFG, vcfg_4_color_mode    '4 color mode
                                                                            
                        add        fontline, #2
                        and        fontline, #%1111  wz
                if_nz   sub        A, #bytes_per_line*4                        
                       
                        
frame_draw              djnz    line_loop, #user_graphics_lines   'done with visible screen?                      

                        wrlong one,VsyncPtr
                        
                        mov     A, bmp          'reset screen memory pointer for next frame
'-----------------------------------------------------------------------------
                        'Overscan at the bottom of screen.  
                        mov     line_loop, #26          '(244)
                        'hsync
vert_front_porch        mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, hsync
                        mov     VSCL, NTSC_active_video_VSCL
                        waitvid magenta_border_in_color0, #0
                        djnz    line_loop, #vert_front_porch

'-----------------------------------------------------------------------------
                        'This is the vertical sync.  It consists of 3 sections of 6 lines each.
                        mov     line_loop, #6           '(250)
:vsync_higha            mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, vsync_high_1
                        mov     VSCL, NTSC_active_video_VSCL
                        waitvid NTSC_control_signal_palette, vsync_high_2
                        djnz    line_loop, #:vsync_higha
'-----------------------------------------------------------------------------
                        mov     line_loop, #6           '(256)
:vsync_low              mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, vsync_low_1
                        mov     VSCL, NTSC_active_video_VSCL
                        waitvid NTSC_control_signal_palette, vsync_low_2
                        djnz    line_loop, #:vsync_low
'-----------------------------------------------------------------------------
                        mov     line_loop, #6           '(250)
:vsync_highb            mov     VSCL, NTSC_hsync_VSCL
                        waitvid NTSC_control_signal_palette, vsync_high_1
                        mov     VSCL, NTSC_active_video_VSCL
                        waitvid NTSC_control_signal_palette, vsync_high_2
                        djnz    line_loop, #:vsync_highb
'-----------------------------------------------------------------------------
                        

                        jmp     #frame_loop

' General Purpose Registers
r0                      long                    $0    ' should typically equal 0
r1                      long                    $0
r2                      long                    $0
r3                      long                    $0

A                       long                    $0  'coupla more general purpose registers
B                       long                    $0
C                       long                    $0  

bmp                     long                    $0  'tvpointer ends up here

zero                    long                    $0
one                     long                    $1



colors                  long                    $00_00_00_00     'default, if not set by calling program
chars                   long                    $0 
fontline                long                    $0   'scanline counter
fonttab                 long                    $0   'HUB memory address of font table

fontsum                 long                    $0   'this is fontline + fonttab

color_mask              long                    $00_00_00_02
                                                          

' Video (TV) Registers
tvport_mask             long                    %0000_1111<<12
vcfg_2_color_mode       long                    %0_11_011_000
vcfg_4_color_mode       long                    %0_11_111_000

v_freq                  long                    0

' Graphics related vars.
v_coffset               long                    $02020202  ' color offset (every color is added by $02)
v_clkfreq               long                    $0

' /////////////////////////////////////////////////////////////////////////////
' dividefract:
' Perform 2^32 * r1/r2, result stored in r3 (useful for TV calc)
' This is taken from the tv driver.
' NOTE: It divides a bottom heavy fraction e.g. 1/2 and gives the result as a 32-bit fraction.
' /////////////////////////////////////////////////////////////////////////////
dividefract                                     
                        mov     r0,#32+1
:loop                   cmpsub  r1,r2           wc
                        rcl     r3,#1
                        shl     r1,#1
                        djnz    r0,#:loop

dividefract_ret         ret                             '+140


'Pixel streams
'  These are shifted out of the VSU to the right, so lowest bits are actioned first.
'
hsync                   long    %%11_0000_1_2222222_11  ' Used with NTSC_control_signal_palette so:
                                                        '      0 = blanking level
                                                        '      1 = Black
                                                        '      2 = Color NTSC_control_signal_palette (yellow at zero value)
vsync_high_1            long    %%11111111111_222_11
vsync_high_2            long    %%1111111111111111
vsync_low_1             long    %%22222222222222_11
vsync_low_2             long    %%1_222222222222222
all_black               long    %%1111111111111111
border                  long    %%0000000000000000

' Some unimportant irrelevant constants for generating demo user display etc.
line_loop               long    0
tile_loop               long    0


' Overscan color choices --need to set these as parameters
'  These are always 4 colors (or blanking level) stored in reverse order:
'                               Color3_Color2_Color1_Color0

blue_border_in_color0    long    $02020202     'All set to grey
green_border_in_color0   long    $02020202
magenta_border_in_color0 long    $02020202
brown_border_in_color0   long    $02020202

'VSync Pointer variable
VSyncPtr                 long    $0                      