CON ''------------------------------------------------- ADMINISTRA
_CLKMODE     = XTAL1 + PLL16X
_XINFREQ     = 5_000_000


'
'          hbeat   --------+
'          clk     -------+|
'          /wr     ------+||
'          /hs     -----+||| +------------------------- /cs
'                       |||| |                 +------+ d0..d7
'                       |||| |                 |      |
DB_IN            = %00001001_00000000_00000000_00000000 'dira-wert für datenbuseingabe
DB_OUT           = %00001001_00000000_00000000_11111111 'dira-wert für datenbusausgabe

M1               = %00000010_00000000_00000000_00000000 'busclk=1? & /prop1=0?
M2               = %00000010_10000000_00000000_00000000 'maske: busclk & /cs (/prop1)

M3               = %00000000_00000000_00000000_00000000 'busclk=0?
M4               = %00000010_00000000_00000000_00000000 'maske: busclk
'


#0,     D0,D1,D2,D3,D4,D5,D6,D7                         'datenbus
'#8,     ADM_SOUNDL,ADM_SOUNDR                           'sound (stereo 2 pin)
'#10,    ADM_SDD0,ADM_SDCLK,ADM_SDCMD,ADM_SDD3           'sd-cardreader (4 pin)
#23,    ADM_SELECT                                      'administra-auswahlsignal
#24,    HBEAT                                           'front-led
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal

var
  ' sound vars
  long  sd_pin_left
  long  sd_pin_right
  long  sd_freq_left
  long  sd_freq_right
  long  sd_volume_left
  long  sd_volume_right

OBJ
    'debug  : "serialMirror"

  hss           : "ym2413a_hss_v1"

PUB main | cmd,err,i,background_song_ptr                                      'chip: kommandointerpreter
''funktionsgruppe               : chip
''funktion                      : kommandointerpreter
''eingabe                       : -
''ausgabe                       : -

  init_chip                                             'bus/vga/keyboard/maus initialisieren
  repeat

    cmd := bus_getchar                                  'kommandocode empfangen
    !outa[hbeat]
    'debug.dec(cmd)
    case cmd
'       ------------ Sound-Engine1-Commands -------------------------
        1:hss.sfx_play(2, @TeleportFX)
        2:hss.sfx_play(2, @WaterDropFX)
        3:hss.sfx_play(2, @HeartBeatFX)
        4:hss.sfx_play(2, @RocketFX1)
        5:hss.sfx_play(2, @RocketFX2)
        6:hss.sfx_play(2, @RocketFX3)
        7:hss.sfx_play(2, @KillBadFX1)

    'waitcnt(cnt+(clkfreq>>8))

PUB init_chip|i                                         'chip: initialisierung des administra-chips
''funktionsgruppe               : chip
''funktion                      : - initialisierung des businterface
''                                - grundzustand definieren (hss aktiv, systemklänge an)
''eingabe                       : -
''ausgabe                       : -


    repeat i from 0 to 7                                'evtl. noch laufende cogs stoppen
      ifnot i == cogid
        cogstop(i)

  'businterface initialisieren
  outa[bus_hs] := 1                                     'handshake inaktiv             ,frida
  dira := db_in                                         'datenbus auf eingabe schalten ,frida
  waitcnt(cnt+(clkfreq>>8))
  hss.start 'Start HSS Engine
  hss.hmus_vol(15)
  hss.hmus_load(@bgmusic) 'Load Hmus file into player.
  hss.hmus_play 'Play loaded file.
  'debug.start(31,30,0,19200)


PUB bus_getlong:wert                                    'sub: long empfangen
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen long-wert von regnatix zu empfangen
''eingabe                       : -
''ausgabe                       : 32bit-wert der empfangen wurde
''busprotokoll                  : [get.byte1][get.byte2][get.byte3][get.byte4]
''                              : [  hsb    ][         ][         ][   lsb   ]

  wert :=        bus_getchar << 24                      '32 bit empfangen hsb/lsb
  wert := wert + bus_getchar << 16
  wert := wert + bus_getchar << 8
  wert := wert + bus_getchar


PUB bus_getchar : zeichen                               'chip: ein byte über bus empfangen
''funktionsgruppe               : chip
''funktion                      : emfangsroutine für ein byte von regnatix über den systembus
''eingabe                       : -
''ausgabe                       : byte zeichen

  waitpeq(M1,M2,0)                                      'busclk=1? & /prop1=0?
  zeichen := ina[7..0]                                  'daten einlesen
  outa[bus_hs] := 0                                     'daten quittieren
  outa[bus_hs] := 1
  waitpeq(M3,M4,0)                                      'busclk=0?

DAT

bgmusic                 file    "yma-dreams.hmus"

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
SoundFX1                byte    $06, $FF, $5F, $0F, $01, $03, $01, $00
                                'Att 'Dec 'Sus 'Rel
                        byte    $C9, $28, $00, $e0

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX1               byte    $05, $ff, $06, $0F, $01, $03, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX2               byte    $05, $ff, $09, $0F, $01, $04, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX3               byte    $05, $ff, $0c, $0F, $01, $05, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
TeleportFX              byte    $06, $FF, $5F, $0F, $01, $03, $01, $00
                                'Att 'Dec 'Sus 'Rel
                        byte    $FF, $14, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
TelephoneFX             byte    $05, $15, $4F, $0F, $01, $04, $05, $00
                                'Att 'Dec 'Sus 'Rel
                        byte    $FF, $00, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
HeartBeatFX             byte    $00, $FF, $06, $0F, $09, $FF, $04, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $F4, $00, $0F
                        byte    $F1, $78, $3C, $00, $00, $00, $F1, $78, $3C, $00, $00, $00, $00, $00, $00, $00

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
KillBadFX1              byte    $09, $ff, $1f, $0F, $09, $ff, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $20, $03, $f8

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
WaterDropFX             byte    $05, $ff, $06, $0F, $01, $03, $04, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $F4, $01, $f0

