'' /////////////////////////////////////////////////////////////////////////////
'' Customisable constants for Defender Remake
'' (C) Steve Waddicor
''
'' You can tweak these to alter the gameplay if you like.  I've tried to set them
'' to be as close as possible to the bahaviour of the original machine.  Bear in
'' mind Defender is HARD.  IF you are a beginner, then it should take a while to
'' master level one.  And if you're not an expert player you're only supposed to
'' get to level 2 or 3, perhaps 4.  Higher levels are for the real ACES.
'' //////////////////////////////////////////////////////////////////////////////

CON
    CUST_PLAYER_SPEED_LIMIT         = 220               'Player max X velocity
    CUST_PLAYER_CLIMB_LIMIT         = 128               'Player max Y velocity
    CUST_PLAYER_THRUST_ACCEL        = 4
    CUST_PLAYER_VERTICAL_ACCEL      = 6
    CUST_PLAYER_DRAG                = 2                 'Deceleration due to atmosphere

    CUST_HUMANOID_WAVE              = 110               'Number of frames till humanoids appear
    CUST_FIRST_WAVE                 = 220               'Number of frames till first wave of landers appears
    CUST_SECOND_WAVE                = 800               'Number of frames till second wave of landers appears
    CUST_FIRST_BAITER               = 3072
    CUST_SECOND_BAITER              = 512
    CUST_THEN_BAITER_EACH           = %111111111        'Mask for frame count.  Append a one to make the period twice as long.
    CUST_BAITER_SPEED_SHIFT         = 6                 'Add one to halve the speed
    CUST_BAITER_INACCURACY_SHIFT    = 3

    CUST_LEVEL_COMPLETED_FRAMES     = 256

    CUST_SWARMER_HATCH_FRAMES       = 64                'Number of frames after shooting pod before swarmer behaves as a normal swarmer
    CUST_SWARMER_HORIZONTAL_SPEED   = 64
    CUST_SWARMER_INACCURACY_SHIFT   = 6                 'The bigger the number, the more inaccurate swarmer bullets are.

    CUST_BULLET_RATE_MASK_LANDER    = %11111111         'Removing a 1 will make aliens shoot twice as often. Limited by NUMBER_OF_LASER_SHOTS in globals file
    CUST_BULLET_RATE_MASK_LAND_TAR  = %1111111          'Mask for landers that have targeted humanoids (i.e. moving vertically down)
    CUST_BULLET_RATE_MASK_LAND_ASC  = %111111           'Mask for landers that are ascending with abducted humanoids
    CUST_BULLET_RATE_MASK_MUTANT    = %1111111
    CUST_BULLET_RATE_MASK_SWARMER   = %1111111
    CUST_BULLET_RATE_MASK_BAITER    = %111111

    CUST_MINE_RATE_MASK_BOMBER      = %1111111          'This is similar but different to the bullet rate.
                                                        'Whereas that is a mask for a random number, this is a mask for the frame count.
                                                        'So mines are dropped regularly (limited by NUMBER_OF_LASER_SHOTS ion globals file) 
  
    CUST_BULLET_SPEED_SHIFT         = 7                 'Speed of bullets is distance of alien to player divided by a power of 2
                                                        'Adding one will make bullets half speed
    CUST_BULLET_SPEED_SHIFT_SWARM   = 6                 'Swarmer bullets are faster

    CUST_POINT_BLANK_RANGE          = 16                'Seems unfair if the aliens shoot you when they are too close up.
                                                        'And in any case produces very slow bullets.
                                                        'Increase this value to make the no shoot area around your ship bigger.
                                                        'Value is horizontal distance plus vertical distance in pixels  
                                                        
    CUST_BULLET_TIME_TO_LIVE        = 196               'Number of frames that bullets live for
    CUST_MINE_TIME_TO_LIVE          = 256               'Number of frames that mines live for

PUB dummy