' //////////////////////////////////////////////////////////////////////
' TITLE: EPM_Defnder_Sound_Engine2_xxx.spin
'
' DESCRIPTION:
'
' AUTHOR:  Eric Moyer, Copyright (C)2007
'
'
'  Rev  Date      Description
'  ---  --------  ---------------------------------------------------
'  001  12-01-07  Initial Creation (Split sound into two engines)
'  002  12-02-07  Add POD sound
'  004  12-05-07  Switch from bitmap to command model. 
'                           
' //////////////////////////////////////////////////////////////////////
'
'  Audio channel usage:
'     0: Thrust
'     1: (All others)
'
' //////////////////////////////////////////////////////////////////////
CON

  CLOCK_RATE_HYDRA       = 80_000_000
  CLOCK_RATE_HYBRID      = 80_000_000
  PIN__AUDIO = %00000000_00000000_00000010_00000000

  AUDIO_SAMPLE_RATE      = 22_000  'Audio generation rate

  '------------------------------------
  'HARDWARE IDs
  '------------------------------------
  HARDWARE_HYDRA         = 1 
  HARDWARE_HYBRID        = 1
  
  '------------------------------------
  'SOUND EFFECT COMMANDS
  '------------------------------------

  IS_UNINTERRUPTIBLE     = 256'%1_0000_0000
  IS_EXPLOSION           = 128'%0_1000_0000

  'Thrust Commands
  CMD__THRUST_OFF        = 0
  CMD__THRUST_HIGH       = 1
  CMD__THRUST_LOW        = 2

  'Sound Effect Commands (Engine 1)
  CMD__IDLE              = 3                                         
  CMD__HUMAN_DIE         = 4  | IS_EXPLOSION
  CMD__FIRE              = 5  | IS_EXPLOSION 
  CMD__WARP              = 6  | IS_EXPLOSION
  CMD__YOU_DIE           = 7  | IS_EXPLOSION | IS_UNINTERRUPTIBLE 
  CMD__PLANET_EXPLODE    = 8  | IS_EXPLOSION | IS_UNINTERRUPTIBLE
  CMD__MUTANT            = 9  
  CMD__LANDER_FIRE       = 10 
  CMD__LANDER_DIE        = 11 | IS_UNINTERRUPTIBLE
  CMD__HUMAN_ABDUCTED    = 12 | IS_UNINTERRUPTIBLE   
  CMD__HUMAN_FALLING     = 13 
  CMD__HUMAN_CAUGHT      = 14 
  CMD__POD               = 15 
  CMD__SWARMER           = 16
  CMD__HUMAN_RETURNED    = 17  
  CMD__EXTRA_LIFE        = 18
  CMD__EXTRA_LIFE2       = 19   'NOTE: This is the 2nd part of the 'Extra Life' sound, and should not
                                '      be called by the game engine.  EXTRA_LIFE will be followed by
                                '      EXTRA_LIFE2 automatically.

  'Sound Effect Commands (Engine 2)   
  CMD__LEVEL_DONE        = 20
  CMD__START_GAME        = 21
  CMD__HIGHSCORE         = 22

  CMD__QUIET             = $7f

     
  '------------------------------------
  'Flags
  '------------------------------------  
  FLAG_RISING_EDGE       = %00000001
  FLAG_FALLING_EDGE      = %00000010

  '------------------------------------
  'Misc
  '------------------------------------  
  MUTANT_SAMPLE_WIDTH_INIT = 2
  MUTANT_SAMPLES_PER_LWORD = 16

  LFIRE_SAMPLE_WIDTH_INIT = 3 
  LFIRE_SAMPLES_PER_LWORD = 32

  COG_STOPPED             = 99
  
OBJ
  'dbg       :       "PasDebug"                       '<---- Add for Debugger
  
VAR
   long               this_cog 

PUB init 
   this_cog := COG_STOPPED
  
PUB start (sfx_control_block_p)
  if this_cog == COG_STOPPED
    this_cog := cognew(@sfx_entry,sfx_control_block_p)
'   dbg.start(31,30,@sfx_entry)                 '<---- Add for Debugger   

PUB stop 
  if (this_cog <> COG_STOPPED)  
    cogstop(this_cog)
    this_cog := COG_STOPPED

'///////////////////////////////////////////////////////////////////////
' DATA SECTION /////////////////////////////////////////////////////////
'///////////////////////////////////////////////////////////////////////

DAT
          
'------------------------------------
'Entry
'------------------------------------
                        org        0
                        
sfx_entry

'  --------- Debugger Kernel add this at Entry (Addr 0) ---------
'   long $34FC1202,$6CE81201,$83C120B,$8BC0E0A,$E87C0E03,$8BC0E0A
'   long $EC7C0E05,$A0BC1207,$5C7C0003,$5C7C0003,$7FFC,$7FF8
'  -------------------------------------------------------------- 

                        'get pointers to parameters in the Effect Control block
                        mov     r1,PAR             'Get pointer to Effect Control block

                        'Get Pointer to sfx_command
                        mov     p_sfx_cmd, r1
                        add     r1, #4

                        'Get Pointer to thrust_command
                        mov     p_thrust_cmd, r1
                        add     r1, #4

                        'Get (and process) sfx_hardware_type
                        rdlong  r2, r1             ' Get hardware id
                        cmp     r2, #HARDWARE_HYDRA wz
              if_z      mov     sample_interval_ticks, SAMPLE_INTERVAL_HYDRA
              if_nz     mov     sample_interval_ticks, SAMPLE_INTERVAL_HYBRID  

'------------------------------------
'Effect processing loop
'------------------------------------

                        '------------------------------------
                        'Init 
                        '------------------------------------
                        mov     sfx_cmd, #CMD__QUIET
                        mov     thrust_cmd, #CMD__THRUST_OFF

                        'Configure audio pin
                        andn    outa,_PIN__AUDIO       ' Set audio pin LOW          "0"
                        or      dira,_PIN__AUDIO       ' Set audio pin to OUTPUT
                        mov     ctra, CTRAVAL
                        mov     frqa, LONG_HALF
                        mov     phsa, #$ff

                        'DEBUG LED
                        or       dira, #1

                        'seed the LFSR pseudo-random generator
                        mov     random_number, #1  

:restart                        
                        mov     next_sample_start_time, cnt
                        add     next_sample_start_time, sample_interval_ticks

                        mov     previous_pulse_level, #0


:sample_sync            'wait for next audio sample start time
                        waitcnt next_sample_start_time, sample_interval_ticks

                        
                        mov     flags, #0
                        mov     AUDIO_channel_0, #0

                        '------------------------------------
                        'Generate LFSR Pseudo random number                                      
                        '------------------------------------
                        mov    x, #32                              'Generate 32 bits
:lfsr_loop              mov    y, random_number
                        and    y, #1
                        neg    y, y
                        and    y, LFSR_32_TAPS
          
                        xor    random_number, y
                        ror    random_number, #1
                        sub    x, #1  wz
              if_nz     jmp    #:lfsr_loop  
 

                        '------------------------------------
                        'Get thrust command
                        '------------------------------------
                        rdlong  thrust_cmd, p_thrust_cmd 

                        '------------------------------------
                        'Get sfx command
                        '------------------------------------
                        rdlong  r1, p_sfx_cmd
                        cmp     r1, sfx_cmd_previous wz                         'IF   no new commnand
                        mov     sfx_cmd_previous, r1                           
              if_nz     cmp     r1, #CMD__IDLE wz                               'OR   command == IDLE
              if_z      jmp     #:start_bypass                                  'THEN bypass START code

                        test    sfx_cmd, #IS_UNINTERRUPTIBLE wz                 'IF   current sound is uninterruptable
              if_nz     cmp     r1, #CMD__QUIET wz                              'AND  the new sound is not CMD__QUIET
              if_nz     jmp     #:start_bypass                                  'THEN bypass START code (i.e. ignore the new command)
                        
                        
                        '================================================================================
                        'Sound STARTs
                        '================================================================================

                        mov     sfx_cmd, r1              'Accept the new command
                        
                        '------------------------------------
                        'START: Level Done
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__LEVEL_DONE  wz
              if_z      mov     pulse1_init, LONG_HALF
              if_z      sub     pulse1_init, PULSE1_INIT_START
              if_z      mov     pulse1_base_init, PULSE1_INIT_START
              if_z      mov     pulse1_end, LONG_HALF
              if_z      add     pulse1_end, PULSE1_END_START
                        
              if_z      mov     pulse2_init, LONG_HALF
              if_z      sub     pulse2_init, PULSE2_INIT_START
              if_z      mov     pulse2_end, LONG_HALF
              if_z      add     pulse2_end, PULSE2_END_START

              if_z      mov     pulse1_val, pulse1_init
              if_z      mov     pulse2_val, pulse2_init 

                        '------------------------------------
                        'START: Start Game 
                        '------------------------------------
                        cmp     sfx_cmd,#CMD__START_GAME       wz
              if_z      mov     SGAME_angle, #0
              if_z      mov     SGAME_scale, #1

:start_bypass
                        

                        '================================================================================
                        'PLAY: Level Done
                        '================================================================================
                        cmp     sfx_cmd, #CMD__LEVEL_DONE wz
              if_nz     jmp     #:ldone_bypass

                         'Compute pulse waveforms
                        add     pulse1_val, PULSE_STEP              'increment pulse counter  
                        cmp     pulse1_end, pulse1_val   wc         'if pulse end reached
        if_nc           jmp     #:ldone_pulse2                      '{
                        add     pulse1_init, #2                     '   reduce low time by 1 sample
                        mov     pulse1_val, pulse1_init             '   adopt new pulse timing
                        
                        cmp     pulse1_init, LONG_HALF wc           '   if low time has reached zero
        if_c            jmp     #:ldone_pulse2                      '   {
                        sub     pulse1_end, PULSE_MOD_STEP          '      reduce high time by 1 sample
                        add     pulse1_base_init, PULSE_MOD_STEP
                        mov     pulse1_init, LONG_HALF              '      set low time back to starting width
                        sub     pulse1_init, pulse1_base_init

                        mov     pulse2_init, LONG_HALF
                        sub     pulse2_init, PULSE2_INIT_START
                                         '
                        cmp     pulse1_end, LONG_HALF   wc          '      if high time reached zero
                                                                    '      {
        if_c            mov     sfx_cmd, #CMD__QUIET                '         clear "in progress" mask (i.e. done)
                                                                    '      }      
                                                                    '   }
                                                                    '} 
:ldone_pulse2           add     pulse2_val, PULSE_STEP              'increment pulse counter
                        cmp     pulse1_end, pulse2_val    wc        'if pulse end reached   
        if_c            mov     pulse2_val, pulse2_init             '   reload pulse 2

                        '------------------------------------
                        'Determine output waveform state
                        '------------------------------------
                        
                        'Output high if PULSE_BIT is high in either pulse generator
                        mov     AUDIO_channel_0, #00

                        cmp     pulse2_val, PULSE_BIT wc
              if_nc     mov     AUDIO_channel_0,#$ff
         
                        cmp     pulse1_val, PULSE_BIT wc
              if_nc     mov     AUDIO_channel_0,#$ff


                        'Add edge emphasis if transitioning
                        cmp     previous_pulse_level, #0  wz
                  if_nz jmp     #:ldone_check_falling
                        cmp     AUDIO_channel_0, #$ff  wz
                   if_z or      flags, #FLAG_RISING_EDGE
                        jmp     #:ldone_bypass

:ldone_check_falling    cmp     AUDIO_channel_0, #0   wz
                   if_z or      flags, #FLAG_FALLING_EDGE  
               
:ldone_bypass

                        '================================================================================
                        'PLAY: Start Game
                        '================================================================================
                        cmp     sfx_cmd, #CMD__START_GAME   wz
              if_nz     jmp     #:sgame_bypass

                         '------------------------------------
                        'Do null interval
                        '------------------------------------
                        
                        cmp     SGAME_angle, #$80  wc
                 if_nc  jmp     #:sgame_wave
                        add     SGAME_angle, #1
                        mov     y, #0
                        jmp     #:sgame_done
                        

                        '------------------------------------
                        'Do wave cycle interval
                        '------------------------------------
:sgame_wave
                        'Get sine of current angle
                        add     SGAME_angle, SGAME_ANGLE_STEP
                        mov     sin, SGAME_angle
                        shr     sin, #10
                        call    #getsin
                        add     sin, HALF_MAX_SIN
                        shr     sin, #9

                        'Scale by current scaling factor 
                        mov     x, sin
                        mov     y, SGAME_scale
                        shr     y, #5
                        cmp     y, #5
                   if_z neg     y, y
                   if_z add     y, #9
                        call    #mult

                        'Truncate
                        and     y, #$ff

                        'Update
                        cmp     SGAME_angle, SGAME_ANGLE_END wc
                 if_c   jmp     #:sgame_done
                        mov     SGAME_angle, #0
                        add     SGAME_scale, #1
                        mov     x,SGAME_scale
                        and     x, #$1f
                        cmp     x, #$12   wz
                 if_nz  jmp     #:sgame_done
                        add     SGAME_scale, #$20
                        andn    SGAME_scale, #$1f
                        cmp     SGAME_scale, #$1A0  wc
                 if_nc   mov     sfx_cmd, #CMD__QUIET 
                        
:sgame_done  
                        '------------------------------------
                        'Set PWM output
                        '------------------------------------
                        shl     y,#2
                        mov     AUDIO_channel_0, y
                 
:sgame_bypass

                        '================================================================================
                        'Audio Mixing
                        '================================================================================

                        '------------------------------------
                        'Adjust zero bias
                        '------------------------------------                                                                                                        
                        shl     AUDIO_channel_0, #18
                        add     AUDIO_channel_0, LONG_HALF

                        '------------------------------------
                        'Add edge emphasis to increase square wave rise times
                        '------------------------------------
                        
                        'Add edge emphasis if transitioning
                        test    flags, #FLAG_RISING_EDGE   wz
                  if_nz add     AUDIO_channel_0, EDGE_EMPHASIS_INIT             'add edge emphasis
                        test    flags, #FLAG_FALLING_EDGE  wz
                  if_nz sub     AUDIO_channel_0, EDGE_EMPHASIS_INIT             'add edge emphasis
                        
                        '------------------------------------
                        'Output wave data
                        '------------------------------------
                        mov     frqa, AUDIO_channel_0

                        

                        '================================================================================
                        'Done main loop
                        '================================================================================
                        
                        jmp     #:sample_sync


'------------------------------------ 
' Get sine/cosine
'
'       quadrant:    1            2            3            4
'          angle:    $0000..$07FF $0800..$0FFF $1000..$17FF $1800..$1FFF
'    table index:    $0000..$07FF $0800..$0001 $0000..$07FF $0800..$0001
'         mirror:    +offset      -offset      +offset      -offset
'           flip:    +sample      +sample      -sample      -sample
'
' on entry: sin[12..0] holds angle (0? to just under 360?)
' on exit: sin holds signed value ranging from $0000FFFF ('1') to
' $FFFF0001 ('-1')
'------------------------------------ 
getcos                  add     sin,sin_90      'for cosine, add 90?
getsin                  test    sin,sin_90 wc   'get quadrant 2|4 into c
                        test    sin,sin_180 wz  'get quadrant 3|4 into nz
                        negc    sin,sin         'if quadrant 2|4, negate offset
                        or      sin,sin_table   'or in sin table address >> 1
                        shl     sin,#1          'shift left to get final word address
                        rdword  sin,sin         'read word sample from $E000 to $F000
                        negnz   sin,sin         'if quadrant 3|4, negate sample
getsin_ret
getcos_ret              ret                     '39..54 clocks
                                                '(variance due to HUB sync on RDWORD)
sin_90                  long    $0800
sin_180                 long    $1000
sin_table               long    $E000 >> 1      'sine table base shifted right
sin                     long    0
HALF_MAX_SIN            long    $FFFF                               


'------------------------------------
'Multiply                                    
'------------------------------------
' Multiply x[15..0] by y[15..0] (y[31..16] must be 0)
' on exit, product in y[31..0]
'------------------------------------
mult                    shl x,#16               'get multiplicand into x[31..16]
                        mov t,#16               'ready for 16 multiplier bits
                        shr y,#1 wc             'get initial multiplier bit into c
:loop
                        if_c add y,x wc         'conditionally add multiplicand into product
                        rcr y,#1 wc             'get next multiplier bit into c.
                                                ' while shift product
                        djnz t,#:loop           'loop until done
mult_ret                ret                     'return with product in y[31..0]

'------------------------------------
'Initialized Data                                      
'------------------------------------
_PIN__AUDIO             long    PIN__AUDIO

SAMPLE_INTERVAL_HYDRA   long   (CLOCK_RATE_HYDRA / AUDIO_SAMPLE_RATE)
SAMPLE_INTERVAL_HYBRID  long   (CLOCK_RATE_HYBRID / AUDIO_SAMPLE_RATE)    

CTRAVAL                 long   %00110 << 26 + 10  'DUTY single-ended, APIN=7        '
LONG_HALF               long   $7FFF_FFFF

LFSR_32_TAPS            long   $800000c2

'EDGE_EMPHASIS_INIT     long   $0fffffff
EDGE_EMPHASIS_INIT      long   $02ffffff 

LDIE_ANGLE_STEP_INIT    long   $0000693a
LDIE_ANGLE_MULTIPLY     long   $00007Fd9 

FIRE_PHASE_TICK_INIT    long   $00000300

'RANDOM_DELTA            long   $9e3779b9

SGAME_ANGLE_STEP        long   $0000f587
SGAME_ANGLE_END         long   $00800000

PULSE_BIT               long   $8000_0000
PULSE1_INIT_START       long   44 * 8
PULSE1_END_START        long   14 * 8
PULSE2_INIT_START       long   162 * 8
PULSE2_END_START        long   12 * 8
PULSE_MOD_STEP          long   10
PULSE_STEP              long   8

'------------------------------------
'Uninitialized Data
'------------------------------------
sfx_cmd_previous          res     1
sfx_cmd                   res     1
thrust_cmd                res     1

p_sfx_cmd                 res     1
p_thrust_cmd              res     1

                          
r1                        res     1
r2                        res     1
sfx_id_mask               res     1
flags                     res     1
sample_interval_ticks     res     1

x                         res     1    ' for multiply
y                         res     1    ' for multiply
t                         res     1    ' for multiply

previous_pulse_level      res     1

next_sample_start_time    res     1

random_number             res     1

pulse1_base_init          res     1
pulse1_init               res     1
pulse2_init               res     1
pulse1_end                res     1
pulse2_end                res     1
pulse1_val                res     1
pulse2_val                res     1

'START parameters
SGAME_angle               res     1
SGAME_scale               res     1

'Audio channels
AUDIO_channel_0           res     1                                       


                          fit                
