CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000


OBJ

  v     : "sub_vocaltract"

  
VAR

  byte  aa,ga,gp,vp,vr,f1,f2,f3,f4,na,nf,fa,ff  'vocal tract parameters
  

PUB start

  v.start(@aa, 8, 9, -1)              'start tract, output to pins 10,11
 
  repeat                                'keep repeating talk
    gp := rnd(50, 100)                  'set random glottal pitch
    vp := rnd(4, 24)                    'set random vibrato pitch
    vr := rnd(4, 10)                    'set random vibrato rate
    talk                                'talk


PRI talk

  setformants(880,1075,2350,3050)        'set "inhale" formants
  v.go(1)

  aa := 30                               'slowly ramp up
  v.go(1000)

  v.go(500)                              'sustain
 
  aa := 0                                'slowly ramp down
  v.go(1500)


  setformants(500,800,1100,2325)         'set "exhale" formants 
  v.go(1)

  aa := 10                               'ramp up
  v.go(500)

  aa := 0                                'slowly ramp down
  v.go(2500)

  v.go(500)                              'pause between breaths


PRI setformants(s1, s2, s3, s4)

  f1 := s1 * 100 / 1953
  f2 := s2 * 100 / 1953
  f3 := s3 * 100 / 1953
  f4 := s4 * 100 / 1953


PRI rnd(low, high)

  return low + ||(?cnt // (high - low + 1))