{{ Ethernet-Testcode }}
CON
  _clkmode = xtal1+pll16x
  _xinfreq = 5_000_000

OBJ
  web     : "sub_api_telnet_serial"
  
DAT
  mac_addr      byte    $10, $00, $00, $00, $00, $01    'mac-adresse
  ip_addr       byte    192, 168, 1, 235                'ip
  ip_subnet     byte    255, 255, 255, 0                'subnet-maske
  ip_gateway    byte    192, 168, 1, 200                'gateway
  ip_dns        byte    192, 168, 1, 200                'dns

PUB main                                                'webServer
  web.start(14,  15, 16, 17,  -1,      -1, @mac_addr,    @ip_addr)  
  \web.listen(80)
  repeat
    \web.rxcheck
    \web.resetBuffers
    if web.isConnected
      if \webIndex == 0
        \web.txflush
      \web.close  

PRI webIndex | c, fname
  c := webRead
  if c == "G"
    repeat 4                    ' GET /
      webRead
  elseif c == "P"
    repeat 5                    ' POST /
      webRead
  else
    return -1                   ' unrecognized method
  fname := webRead              ' single char filename
  web.str(@index)
  return 0

PRI webRead | c
  c := web.rxtime(500)
  if c == -1
    abort -1
  return c


DAT
index         file  "index.htm"
              byte   0



  
