CON

  _clkmode      = xtal1 + pll16x
  _xinfreq      = 5_000_000

  voices        = 4                         'voices can be 1..4
  buffer_size   = $1000                     'spatializer buffer size


OBJ

  v   [voices]  : "sub_blah"
  s             : "sub_stereospatializer"


VAR

  word  input[4], angle[4], depth[4], knobs 'spatializer parameters
  long  buffer[buffer_size]                 'spatializer delay buffer


PUB start | i, r

  repeat i from 0 to voices - 1             'start voices and connect     
    input[i] := v[i].start                  '..to spatializer inputs

  knobs := %000_011_100_101                 'start spatializer
  s.start(@input, @buffer, buffer_size, 8, -1, 9, -1)

  repeat                                    'scan for done voices
    repeat i from 0 to voices - 1       
      if v[i].done                          'if voice done
        angle[i] := ?r                      '..set new random angle
        depth[i] := ?r & $FFF               '..set new random depth
        v[i].go                             '..start new "blah"