CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

  cols = 64
  rows = 48
  tiles = cols * rows

  spacetile = $8000 + $20 << 6

  bitmap_base = $4000                                   
  display_base = $6000

  w_x = 40
  w_y = 30
  w_left = w_x * 16
  w_right = w_left + 256
  w_top = (48 - w_y) * 16
  w_bottom = w_top - 128

  vga_basport = 8                                       ' vga startport
  vga_resx = cols * 16                                  ' vga anzahl pixel x
  vga_resy = rows * 16                                  ' vga anzahl pixel y

OBJ

  vga     : "sub_vga_1024x768_tile_driver"              '3 cogs mit cursor
  gr      : "sub_graphics"                              '1 cog
  
VAR

  long  col, row, color
  long  boxcolor, boxptr

  long  array[tiles/2]
  

PUB start | i, j, k

  'start vga tile driver
  vga.start(vga_basport, @array, @vgacolors, 0, 0, 0)

  'start and setup graphics
  gr.start
  gr.setup(16, 8, 128, 64, bitmap_base)

  'fill screen with text
  print($100)
  print_string(@text)

  box(30, 1, 0, string("Compile"))
  box(40, 1, 1, string("Execute"))
  box(50, 1, 2, string("Quit"))

  'make some graphics tiles on the screen
  repeat i from 0 to 7
    repeat j from 0 to 15
      array.word[cols * (w_y + i) + j + w_x] := display_base + i << 6 + j <<9 + 21

  'keep updating screen
  repeat
    'do some graphics
    gr.clear

    gr.colorwidth(3,0)
    repeat i from 1 to 8
      gr.vec(0, 0, (k & $7F) << 3 + i << 4, k << 6 + i << 8, @vecdef)

    gr.textmode(10,7,6,5)
    gr.colorwidth(1,7)
    i := ||(k>>5 // 10) + "0"
    gr.textarc(0, 0, 80, 20, -k << 7 / 3, @i)
      
    gr.textmode(2,4,6,5)
    gr.colorwidth(2,2)
    gr.textarc(0, 0, 50, 40, k << 6, @@strings[k >> 8 & 3])

    gr.copy(display_base)
    k++

PRI box(left, top, clr, str) | width, height, x, y, i

' Draw a box

  boxcolor := $10 + clr
  color := clr + 5

  width := strsize(str)
  height := 2

  boxptr := top * cols + left
  boxchr($0)
  repeat i from 1 to width
    boxchr($C)
  boxchr($8)
  repeat i from 1 to height
    boxptr := (top + i) * cols + left
    boxchr($A)
    boxptr += width
    boxchr($B)
  boxptr := (top + height + 1) * cols + left
  boxchr($1)
  repeat i from 1 to width
    boxchr($D)
  boxchr($9)

  col := left + 1
  row := top + 1
  print_string(str)
  

PRI boxchr(c): i

  array.word[boxptr++] := $8000 + c << 6 + boxcolor


PRI print_string(ptr)

  repeat while byte[ptr]
    print(byte[ptr++])
    

PRI print(c) | i, k

'' Print a character
''
''       $0D = new line
''  $20..$FF = character
''      $100 = clear screen
''      $101 = home
''      $108 = backspace
''$110..$11F = select color

  case c
    $0D:                'return?
      newline

    $20..$FF:           'character?
      k := color << 1 + c & 1
      i := $8000 + (c & $FE) << 6 + k
      array.word[row * cols + col] := i
      array.word[(row + 1) * cols + col] := i | $40
      if ++col == cols
        newline

    $100:               'clear screen?
      wordfill(@array, spacetile, tiles)
      col := row := 0

    $101:               'home?
      col := row := 0

    $108:               'backspace?
      if col
        col--

    $110..$11F:         'select color?
      color := c & $F


PRI newline | i

  col := 0
  if (row += 2) == rows
    row -= 2
    'scroll lines
    repeat i from 0 to rows-3
      wordmove(@array.word[i*cols], @array.word[(i+2)*cols], cols)
    'clear new line
    wordfill(@array.word[(rows-2)*cols], spacetile, cols<<1)
      

DAT
  
vgacolors long

  long $3C043C04       'lt grey on dk grey
  long $3C3C0404
  long $C000C000       'red
  long $C0C00000
  long $30003000       'green
  long $30300000
  long $0C000C00       'blue
  long $0C0C0000
  long $FC00FC00       'white
  long $FCFC0000
  long $FF80FF80       'red/white
  long $FFFF8080
  long $FF20FF20       'green/white
  long $FFFF2020
  long $FF28FF28       'cyan/white
  long $FFFF2828
  long $C0408080       'redbox
  long $3010F020       'greenbox
  long $3C142828       'cyanbox
  long $FC54A8A8       'greybox
  long $3C14FF28       'cyanbox+underscore
  long $F030C050       'graphics colors

text file "test.txt"
     byte 0

vecdef word $4000+$2000/3*0         'triangle
       word 50
       word $8000+$2000/3*1+1
       word 50
       word $8000+$2000/3*2-1
       word 50
       word $8000+$2000/3*0
       word 50
       word 0

strings word @s0,@s1,@s2,@s3
s0      byte "1024x768 Tile Driver",0
s1      byte "Grafik & Text",0
s2      byte "Hive",0
s3      byte  0