{{
  PropTCP Sockets - FullDuplexSerial API Layer
  --------------------------------------------
  
  Copyright (C) 2007-2008 Harrison Pham

  This file is part of PropTCP.
   
  PropTCP is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.
   
  PropTCP is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
   
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
}}

OBJ
  tcp : "sub_driver_socket"
  'dbg : "vga_irc_text"
  'dbg : "vga_text"
  
VAR
  long handle
  word listenport
  byte listening

PUB start(cs, sck, si, so, int, xtalout, macptr, ipconfigptr)

  tcp.start(cs, sck, si, so, int, xtalout, macptr, ipconfigptr)

  'dbg.start(16)

PUB stop

  tcp.stop

PUB trace
  {dbg.str(string(13,"D "))
  dbg.dec(handle)
  dbg.out(" ")
  dbg.dec(tcp.getSocketState(handle))}

PUB connect(ipaddr, remoteport)

  listening := false
  return (handle := tcp.connect(ipaddr, remoteport))

PUB listen(port)

  listenport := port
  listening := true
  handle := tcp.listen(listenport)

  {dbg.str(string(13,"L "))
  dbg.dec(handle)
  dbg.out(" ")
  dbg.dec(tcp.getSocketState(handle))}
  
  if handle == -1
    'dbg.str(string("Out of sockets!",13))
    abort -1

  'dbg.str(string(13,"socket: "))
  'dbg.dec(handle)
  'dbg.str(string(" "))

  return handle

PUB isConnected

  return tcp.isConnected(handle)

PUB resetBuffers

  tcp.resetBuffers(handle)

PUB waitConnectTimeout(ms) | t

  t := cnt
  repeat until isConnected or (((cnt - t) / (clkfreq / 1000)) > ms)

PUB close

  'dbg.str(string(13,"FORCE CLOSE",13))
  {dbg.str(string(13,"C "))
  dbg.dec(handle)
  dbg.out(" ")
  dbg.dec(tcp.getSocketState(handle))}

  tcp.close(handle)

PUB rxflush

  repeat while rxcheck => 0

PUB rxcheck

  if listening
    ifnot tcp.isValidHandle(handle)
      'dbg.str(string(13,"DEATH RX",13))
      listen(listenport)
  else
    ifnot tcp.isConnected(handle)
      abort -1

  return tcp.readByteNonBlocking(handle)

PUB rxtime(ms) : rxbyte | t

  t := cnt
  repeat until (rxbyte := rxcheck) => 0 or (cnt - t) / (clkfreq / 1000) > ms

  'if rxbyte == -1
    'dbg.str(string(13,"TIMEOUT",13))

PUB rx : rxbyte

  repeat while (rxbyte := rxcheck) < 0

PUB txflush

  'dbg.str(string(13,"FLUSH",13))

  tcp.flush(handle)

PUB txcheck(txbyte)

  if listening
    ifnot tcp.isValidHandle(handle)
      'dbg.str(string(13,"DEATH TX",13))
      listen(listenport)
  'else
  '  ifnot tcp.isConnected(handle)
  '    abort -1

  ifnot tcp.isConnected(handle)        'TEMP TEMP TEMP!!! FIX THIS MAKE IT BETTER!!!
    abort -1

  return tcp.writeByteNonBlocking(handle, txbyte)

PUB tx(txbyte)

  repeat while txcheck(txbyte) < 0

PUB txdata(ptr, len)

  tcp.writeData(handle, ptr, len)

PUB str(stringptr)                

  {repeat strsize(stringptr)
    tx(byte[stringptr++])}
  txdata(stringptr, strsize(stringptr))    

PUB dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    tx("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      tx(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      tx("0")
    i /= 10


PUB hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    tx(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PUB bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    tx((value <-= 1) & 1 + "0")
