''
'' VGA scanline driver 400x300 - image feeder
''
''   Based on "Ball" demo for Gameduino
''   Copyright (c) 2011 by James Bowman <jamesb@excamera.com>
''
''        Author: Marko Lukat
'' Last modified: 2013/01/03
''       Version: 0.6
''
'' 20121225: adjusted palette (brighter)
'' 20121226: 256 colour setup (RRGGBBgr)
'' 20130103: minor tweak to palette table
''
OBJ
  system: "boing-bel-corecon"
  
VAR
  long  guard_before, buffer[BSIZE/4], guard_after
  byte  image[BSIZE*BSIZE]

  long  GD_srcp, GD_mask, GD_stack[32]

PUB null
'' This is not a top level object.

PUB init(ID, mailbox)

  long[mailbox][-3] := @image{0} >< 32 | @buffer{0}
  return system.launch(ID, @entry, mailbox)

PUB uncompress(wait{boolean})

  ifnot wait
    if cognew(GD_uncompress(256, @ball), @GD_stack{0}) +1
      return

  GD_uncompress(256, @ball)
  
PRI GD_uncompress(offs, srcp) | b_off, b_len, minlen, offset

  GD_srcp := srcp
  GD_mask := $01010101

  b_off  := GD_getn(4)
  b_len  := GD_getn(4)
  minlen := GD_getn(2)

  repeat GD_getn(16)
    ifnot GD_get1
      image[GD_translate(offs++)] := !GD_getn(8)
      next
    offset := offs - GD_getn(b_off) - 1
    repeat GD_getn(b_len) + minlen   
      image[GD_translate(offs++)] := image[GD_translate(offset++)]

PRI GD_getn(n) : r

  repeat n
    r := r << 1 | GD_get1

PRI GD_get1 : r

  if byte[GD_srcp] & GD_mask
    r := 1

  if (GD_mask <-= 1) == $01010101
    GD_srcp++
  
PRI GD_translate(offs) : r

  if offs => constant(256*(5+1))
    offs += 256
  if offs => constant(256*(40+2))
    offs += 256

  r := offs.byte[1]
  return (r / 7)*constant(16*112) + (r // 7) << 4 + offs & 15 + (offs & $F0)*7

DAT             org     0                       ' image feeder

entry           jmpret  $, #setup               ' once
                
                rdlong  indx, blnk              ' |
                cmpsub  indx, scry wz           ' |
        if_ne   jmp     #$-2                    ' waiting for last line to be fetched

' The foreground renderer starts reading the colour buffer after 26 sync lines
' and 161+5 hub windows. We have to be done before that happens. Using the assumed
' hubop (161 hub windows) as reference we simply go back by 112*2+4 hub windows.

                mov     cnt, cnt
                add     cnt, $+1
                long    13{18} + 14 + 132*16*26 + 16*(161 - 2) - 228*16

loop            waitcnt cnt, one                ' initial sync point
'               cogid   $ nr                    ' assumed hubop

                call    #transfer               ' palette translation

                add     indx, #1                ' line done, advance
                cmpsub  indx, scry wz           ' optionally wrap line index
        if_nz   jmp     #loop

' per frame updates (during the first frame mask is off-screen)

                rdlong  temp, blnk              ' |
                cmp     temp, scry wz           ' |
        if_ne   jmp     #$-2                    ' wait for ?/scry transition

                rdword  msky, crdy              ' |
                shl     msky, #16               ' |
                sar     msky, #16               ' update and sign-extend mask coordinate

                maxs    msky, scry              ' reasonable limit (off-screen)
                mov     mskc, msky              ' |
                add     mskc, #BSIZE -1         ' bounding box setup

one             long    132*16*2                ' skip two scan lines
two             long    132*16*28               ' skip all sync lines

                call    #update                 ' update palette
                
                add     cnt, two
                jmp     #loop

' support code

transfer        cmps    indx, msky wc           ' |
        if_nc   cmps    mskc, indx wc           ' |
        if_c    jmp     transfer_ret            ' vertical bounds check

                rdlong  addr, feed              ' crs/dst
                mov     arg0, addr
                rev     arg0, #{32-}0           ' tsd/src
                
                mov     temp, indx              '
                sub     temp, msky              ' active row

                mov     arg1, temp
                shl     arg1, #3                ' *8
                sub     arg1, temp              ' *7
                shl     arg1, #4                ' *112

                add     arg0, arg1              ' apply offset
                
                mov     ecnt, #BSIZE

                rdbyte  phsb, arg0
                movd    $+2, phsb
                add     arg0, #1
                wrbyte  phsb, addr
                add     addr, #1
                djnz    ecnt, #$-5              ' translate index to colour
        
transfer_ret    ret

update          mov     arg0, #32*7             ' slot 7

                call    #cycle                  ' |
                cmpsub  arg0, #32*1 wz          ' |
        if_nz   jmp     #$-2                    ' for all slots except 0
        
update_ret      ret

cycle           mov     arg1, arg0              ' |
                add     arg1, #palette          ' apply base

                movd    :cy2, arg1              ' head
                add     arg1, #30               ' |
                movs    :cy1, arg1              ' |
                add     arg1, #1                ' |
                movd    :cy1, arg1              ' body
                movs    :cy0, arg1              ' tail
                
                mov     ecnt, #32-1

:cy0            mov     temp, 1-1               ' preserve last entry
:cy1            mov     1-1, 0-0                ' long rotate
                sub     $-1, d1s1
                djnz    ecnt, #:cy1

:cy2            mov     0-0, temp               ' close rotate
cycle_ret       ret

' initialised data and/or presets

feed            long    -12                     ' |
crdy            long    -6                      ' |
                                                ' quick access relative to par
blnk            long    -4                      ' |
base            long    NEGX                    ' |

d1s1            long    |< 9 | 1                ' dst/src +/- 1

                long    0[$ & 1]
palette         long    $00[32]                 ' unused/transparent
                long    $FF[16], $C1[16]        ' 1: $F0 - %111_1
                long    $FF[16], $C1[16]        ' 2: $E0   %111_0
                long    $FC[16], $C0[16]        ' 3: $D0   %110_1
                long    $FC[16], $C0[16]        ' 4: $C0   %110_0
                long    $AB[16], $81[16]        ' 5: $B0   %101_1
                long    $AB[16], $81[16]        ' 6: $A0   %101_0
                long    $A8[16], $80[16]        ' 7: $90 - %100_1

' Stuff below is re-purposed for temporary storage.

setup           add     crdy, par               ' mask coordinate       (%%)
                add     feed, par               ' mask buffer location
                
                add     base, par               ' scanline buffer 
                add     blnk, base wc           ' frame indicator

                rdword  indx, blnk wz           '                       (%%)
        if_nz   mov     scry, indx wc           '                       (%%)
   if_c_or_nz   jmp     #$-2                    ' auto-detect res_y

' The loop is only left once a non-zero value has been written to scry
' and indx transitions to zero afterwards.

                mov     msky, scry              ' move off-screen

                movi    ctrb, #%0_11111_000     ' LOGIC always (relocation support)
                mov     frqb, #palette >> 1     ' |

                jmp     %%0                     ' return

                fit
                
' uninitialised data and/or temporaries

                org     setup
                
scry            res     1                       ' must be 1st..4th      (%%)
indx            res     1                       ' |

addr            res     1                       ' scanline reference
ecnt            res     1                       ' element count

mskc            res     1                       ' upper limit (inclusive)
mskx            res     1                       ' mask coordinates
msky            res     1                       ' signed 16bit

arg0            res     1
arg1            res     1

temp            res     1

tail            fit

CON
  zero  = $1F0                                  ' par (dst only)

  BSIZE = 112                                   ' mask width/height (4n)
  
DAT
        
ball    byte  $c9, $a1, $dc, $f9, $0f, $e0, $41, $3c, $88, $07, $f1, $20, $1e, $c4, $83, $78
        byte  $10, $0f, $e2, $41, $3c, $88, $07, $71, $ff, $06, $ed, $85, $f2, $20, $68, $d8
        byte  $be, $5d, $5b, $c1, $df, $bf, $d1, $70, $60, $c7, $94, $8d, $e0, $6f, $d9, $bc
        byte  $59, $d3, $26, $4d, $18, $0b, $be, $d6, $2c, $99, $37, $63, $ca, $a4, $71, $63
        byte  $46, $82, $8f, $15, $8b, $e6, $82, $83, $89, $e0, $68, $38, $78, $5b, $b1, $10
        byte  $9c, $8d, $1a, $31, $6c, $28, $78, $da, $b4, $1c, $dc, $0d, $19, $0c, $1e, $36
        byte  $82, $7b, $b8, $30, $68, $c0, $bf, $f5, $e0, $9a, $14, $82, $93, $fd, $6a, $1f
        byte  $c4, $83, $b8, $1d, $9b, $d6, $ad, $5a, $0e, $b6, $06, $82, $a1, $35, $2b, $96
        byte  $2c, $5a, $08, $5e, $86, $ec, $d9, $0e, $8b, $c1, $ca, $9c, $d9, $e0, $61, $d0
        byte  $6e, $b0, $ab, $11, $66, $4c, $07, $eb, $28, $61, $39, $4a, $98, $0f, $07, $c1
        byte  $c1, $94, $1d, $5b, $36, $ac, $25, $8a, $38, $18, $ac, $5b, $40, $1c, $b2, $6c
        byte  $c9, $42, $38, $09, $0e, $c6, $c3, $41, $e2, $0a, $ee, $c6, $8c, $96, $6a, $7b
        byte  $76, $e3, $62, $b8, $0c, $ee, $76, $6c, $db, $b2, $69, $c3, $7a, $70, $30, $d2
        byte  $22, $0c, $84, $03, $3b, $c1, $25, $6e, $5a, $69, $11, $c1, $3d, $38, $58, $b5
        byte  $62, $d9, $80, $fd, $e0, $19, $8d, $83, $b3, $a5, $e0, $6e, $2d, $5a, $5a, $d6
        byte  $a4, $29, $dc, $59, $0f, $4e, $9a, $4b, $87, $ad, $8e, $59, $1c, $22, $45, $8a

        byte  $ca, $90, $d6, $cb, $b2, $e9, $ad, $b0, $0e, $97, $43, $15, $d8, $1c, $66, $8b
        byte  $dc, $3a, $cc, $06, $f6, $83, $7d, $e5, $8d, $b2, $c1, $32, $1c, $a6, $c3, $5a
        byte  $1c, $55, $ec, $05, $47, $dd, $17, $a3, $16, $46, $9d, $e0, $a0, $a7, $0c, $04
        byte  $cb, $70, $a7, $37, $67, $ea, $cc, $04, $d1, $3c, $5c, $e8, $b2, $a9, $d3, $48
        byte  $70, $29, $01, $7a, $83, $a3, $2d, $9d, $36, $82, $b3, $7e, $fb, $fa, $ec, $da
        byte  $d1, $6d, $3b, $3c, $e8, $b8, $17, $03, $50, $41, $70, $d4, $13, $ad, $74, $e8
        byte  $d0, $de, $20, $34, $5a, $50, $6f, $4f, $6f, $78, $d4, $15, $9e, $b4, $59, $0c
        byte  $8e, $e6, $d4, $99, $55, $a3, $3a, $5a, $85, $87, $e0, $a1, $c1, $bc, $7a, $75
        byte  $6a, $cd, $04, $0f, $53, $2a, $55, $da, $d0, $6e, $4d, $9b, $86, $68, $61, $4e
        byte  $6d, $78, $30, $ad, $4a, $95, $4a, $15, $ca, $95, $2b, $d3, $fa, $db, $83, $e8
        byte  $99, $7c, $45, $a1, $dd, $5e, $ff, $6e, $14, $46, $43, $ec, $9e, $56, $6e, $4c
        byte  $a9, $62, $43, $0a, $ed, $87, $a4, $52, $bc, $34, $15, $19, $54, $50, $28, $74
        byte  $87, $88, $cb, $50, $31, $ac, $69, $d5, $b2, $26, $34, $9a, $af, $19, $b6, $75
        byte  $6a, $6f, $10, $b9, $e0, $34, $6a, $b2, $a8, $a1, $30, $a8, $09, $1e, $3a, $0a
        byte  $86, $75, $6d, $e1, $b9, $74, $54, $42, $93, $2a, $4a, $a6, $55, $2d, $a7, $23
        byte  $3c, $55, $0a, $d5, $25, $43, $7b, $b8, $d0, $6a, $45, $b3, $26, $8d, $e1, $a1
                                                                                            
        byte  $56, $d4, $82, $e0, $11, $2d, $c2, $4b, $7c, $a8, $0d, $6a, $6a, $a6, $b6, $e0
        byte  $90, $0e, $c2, $63, $2b, $0c, $0f, $c1, $2b, $19, $bc, $ca, $e8, $10, $fc, $c2
        byte  $73, $b2, $0c, $3e, $22, $55, $64, $cd, $5f, $10, $9e, $d5, $aa, $11, $1d, $3d
        byte  $44, $68, $89, $57, $c1, $5b, $8c, $6a, $d5, $f1, $b3, $ff, $07, $f1, $20, $1e
        byte  $c4, $83, $78, $10, $0f, $e2, $41, $3c, $88, $07, $f1, $20, $a2, $4d, $73, $08
        byte  $0f, $c2, $d6, $b4, $68, $52, $1f, $e2, $83, $a0, $72, $a5, $9a, $35, $aa, $53
        byte  $15, $e2, $fd, $07, $0f, $25, $8a, $34, $88, $0d, $e1, $c1, $43, $99, $12, $c5
        byte  $0a, $f5, $ab, $51, $a9, $24, $a2, $de, $04, $25, $82, $15, $2a, $90, $27, $5b
        byte  $44, $08, $15, $1e, $3e, $05, $29, $d0, $a7, $57, $96, $0e, $21, $11, $3a, $7c
        byte  $08, $55, $ac, $48, $a0, $7e, $b9, $ba, $65, $6a, $13, $2c, $27, $7d, $29, $0b
        byte  $de, $f2, $f4, $c8, $92, $a1, $55, $52, $08, $54, $2e, $4c, $a9, $60, $41, $0a
        byte  $05, $c8, $8b, $80, $d2, $a5, $48, $94, $5d, $ff, $83, $78, $10, $0f, $c2, $36
        byte  $82, $7b, $10, $b6, $69, $25, $f8, $07, $21, $5b, $56, $2c, $06, $ff, $20, $64
        byte  $d5, $92, $f9, $e0, $1f, $04, $ad, $59, $b2, $60, $36, $f8, $07, $01, $e3, $8a
        byte  $0d, $d8, $b3, $13, $fc, $fd, $9b, $54, $62, $d0, $be, $5d, $dd, $c1, $df, $bf
        byte  $51, $43, $fa, $f5, $da, $d6, $15, $fc, $a3, $85, $82, $68, $a1, $cb, $66, $f0

        byte  $53, $65, $c4, $60, $78, $d0, $ad, $b3, $f8, $1b, $53, $d4, $0b, $ec, $84, $07
        byte  $ed, $e1, $57, $85, $11, $85, $f6, $e3, $85, $4e, $1d, $da, $82, $6f, $78, $d4
        byte  $ab, $47, $97, $0d, $ed, $c1, $57, $45, $d6, $d0, $67, $27, $5e, $e8, $b0, $a6
        byte  $35, $fc, $18, $55, $94, $0c, $c2, $83, $8e, $f0, $a0, $c5, $86, $65, $0b, $e6
        byte  $cc, $98, $32, $61, $dc, $98, $11, $c3, $86, $0c, $1a, $b0, $6f, $2f, $38, $9b
        byte  $0c, $0e, $46, $83, $8b, $5d, $8b, $e1, $32, $38, $19, $09, $d7, $76, $ed, $98
        byte  $37, $6b, $da, $a4, $09, $63, $46, $a3, $65, $34, $b4, $17, $3c, $82, $43, $3c
        byte  $0c, $4e, $f1, $28, $38, $d8, $4e, $fa, $e1, $d1, $ae, $9e, $e6, $61, $cb, $a6
        byte  $75, $6b, $e1, $21, $1e, $5d, $0c, $3b, $7a, $74, $d7, $88, $82, $61, $55, $8b
        byte  $65, $4d, $1a, $15, $e8, $d7, $17, $1e, $6d, $b5, $80, $82, $61, $45, $b3, $25
        byte  $8b, $1a, $cc, $9b, $53, $ab, $26, $5c, $b4, $40, $6d, $e1, $41, $b3, $46, $0d
        byte  $ea, $d5, $a9, $55, $6b, $46, $b5, $2a, $95, $2a, $b4, $6b, $0d, $8f, $1a, $2d
        byte  $a8, $0f, $8f, $aa, $4d, $a9, $0c, $1e, $0d, $22, $5a, $84, $67, $35, $aa, $c3
        byte  $93, $f2, $68, $99, $0c, $a2, $53, $f0, $88, $16, $e1, $41, $b9, $16, $cd, $c1
        byte  $d1, $7c, $bc, $08, $af, $c1, $23, $6b, $86, $37, $15, $2a, $84, $2b, $0b, $4f
        byte  $e9, $30, $5a, $46, $07, $11, $ca, $95, $29, $ab, $89, $15, $c1, $86, $8d, $4a
                                                                                            
        byte  $a0, $55, $4b, $69, $d2, $68, $c7, $76, $70, $b0, $19, $1c, $0a, $85, $55, $2b
        byte  $71, $42, $53, $e9, $b0, $1d, $3c, $c3, $a5, $b6, $f0, $90, $3b, $d2, $84, $05
        byte  $0d, $c1, $49, $7b, $cd, $68, $98, $49, $c2, $62, $11, $d4, $b5, $33, $36, $45
        byte  $29, $28, $4c, $85, $4b, $7d, $8b, $b2, $16, $ad, $72, $67, $b4, $c8, $12, $36
        byte  $37, $41, $b4, $48, $9b, $b9, $b3, $36, $a9, $d3, $b1, $0b, $ad, $b6, $4c, $4d
        byte  $d1, $ba, $72, $e8, $b0, $ae, $2d, $5a, $95, $a6, $ca, $18, $3c, $d2, $66, $b4
        byte  $0e, $af, $6a, $2b, $82, $52, $a5, $2d, $23, $3c, $8b, $57, $27, $6e, $62, $04
        byte  $4f, $25, $4a, $14, $2b, $d2, $a8, $51, $82, $fa, $89, $25, $46, $59, $78, $08
        byte  $8e, $82, $14, $2a, $50, $a0, $5e, $9c, $3a, $b1, $6a, $82, $a7, $10, $25, $82
        byte  $15, $29, $54, $28, $40, $bf, $7c, $7d, $72, $d5, $8a, $51, $1d, $de, $82, $87
        byte  $be, $03, $a0, $e7, $00, $08, $0d, $17, $8a, $a3, $45, $78, $d4, $2f, $4f, $ae
        byte  $5c, $39, $b2, $65, $ef, $01, $75, $6b, $69, $6d, $8e, $8b, $e1, $a8, $d4, $fc
        byte  $38, $5a, $5a, $26, $55, $28, $cf, $5a, $c1, $c1, $6c, $2e, $30, $bd, $95, $82
        byte  $c7, $b4, $50, $aa, $c4, $dc, $5a, $dc, $aa, $45, $f9, $72, $2e, $ed, $78, $25
        byte  $4c, $a9, $10, $c5, $6a, $a2, $c5, $19, $12, $19, $af, $a3, $83, $e0, $e0, $10
        byte  $5e, $b6, $86, $30, $65, $79, $23, $1f, $84, $27, $51, $8f, $33, $1d, $85, $c7

        byte  $e8, $a1, $46, $b4, $2a, $55, $d1, $22, $3c, $0a, $0b, $0f, $f1, $41, $50, $8d
        byte  $c8, $9a, $2a, $83, $c3, $95, $a8, $13, $c1, $a1, $49, $c4, $0b, $51, $57, $20
        byte  $1d, $c6, $ab, $f0, $a8, $48, $75, $74, $10, $29, $32, $3c, $09, $cd, $86, $e1
        byte  $41, $a0, $ea, $f0, $94, $8e, $85, $08, $11, $2c, $48, $91, $c0, $f0, $a0, $32
        byte  $bc, $8d, $0e, $41, $5d, $42, $54, $36, $50, $21, $42, $78, $bc, $14, $1a, $1e
        byte  $c2, $87, $40, $81, $ba, $64, $ca, $0c, $0e, $ca, $85, $55, $c5, $64, $19, $1e
        byte  $04, $44, $82, $b5, $a5, $7e, $6d, $94, $c1, $a8, $10, $17, $96, $e1, $3c, $58
        byte  $1b, $ea, $96, $66, $96, $6c, $14, $8a, $33, $e6, $da, $98, $06, $4b, $a1, $0a
        byte  $b6, $ca, $bd, $b0, $0e, $14, $ac, $4d, $bd, $7a, $3a, $53, $52, $58, $86, $02
        byte  $83, $87, $bc, $65, $b0, $34, $64, $c9, $52, $19, $3d, $14, $15, $04, $05, $02
        byte  $f6, $82, $de, $f0, $a1, $3b, $2b, $ca, $10, $1e, $2d, $c2, $e3, $51, $94, $13
        byte  $3e, $75, $ca, $d0, $21, $3d, $3c, $2a, $08, $0e, $f2, $f4, $ca, $d1, $2d, $3b
        byte  $7c, $c8, $90, $ae, $3d, $78, $5c, $e9, $e0, $21, $3b, $3e, $84, $0f, $e9, $d2
        byte  $2a, $44, $78, $90, $9f, $2c, $c3, $87, $ac, $2a, $11, $3e, $82, $87, $80, $e8
        byte  $72, $25, $82, $87, $8c, $e0, $15, $9e, $e5, $ea, $09, $1e, $f1, $31, $7c, $97
        byte  $8d, $e8, $14, $1f, $65, $06, $87, $f8, $21, $20, $1f, $06, $9f, $f8, $2c, $2d
                                                                                            
        byte  $38, $24, $cb, $2f, $14, $5f, $b8, $05, $8f, $aa, $55, $8d, $a2, $83, $0c, $ee
        byte  $d2, $a4, $0e, $05, $a5, $0d, $51, $41, $4c, $d0, $2d, $4b, $86, $36, $c9, $12
        byte  $44, $4d, $89, $c9, $51, $b2, $62, $42, $0c, $90, $2e, $45, $92, $b8, $29, $70
        byte  $33, $26, $63, $22, $c8, $11, $32, $a5, $4b, $8d, $00, $97, $62, $76, $b6, $84
        byte  $e0, $91, $10, $65, $48, $8b, $00, $4b, $70, $35, $a6, $4a, $b9, $05, $22, $7f
        byte  $48, $e5, $fc, $28, $83, $87, $c2, $e0, $25, $27, $01, $a4, $0f, $29, $19, $e2
        byte  $34, $0a, $0c, $be, $32, $b8, $05, $4f, $29, $92, $05, $05, $1f, $d9, $3c, $13
        byte  $00, $d7, $f0, $11, $3c, $24, $49, $0c, $5f, $7c, $64, $cb, $e4, $91, $21, $a4
        byte  $4a, $0d, $5e, $12, $c4, $f3, $ab, $99, $bc, $2a, $00, $b7, $e0, $27, $8e, $6d
        byte  $f8, $08, $de, $52, $c2, $27, $47, $0e, $e2, $d9, $89, $15, $c3, $5a, $16, $4f
        byte  $e9, $e1, $23, $38, $70, $8e, $1f, $d1, $83, $1d, $db, $e0, $21, $8a, $25, $f7
        byte  $e0, $c1, $45, $b2, $24, $4e, $12, $39, $b0, $17, $27, $96, $0d, $6b, $56, $2c
        byte  $45, $30, $4b, $0e, $e1, $21, $78, $48, $60, $1f, $3d, $d8, $88, $0e, $1e, $2c
        byte  $98, $71, $8d, $1e, $c1, $21, $7e, $b1, $0d, $5f, $2c, $98, $fb, $0f, $e0, $41
        byte  $44, $44, $f0, $0f, $22, $62, $85, $85, $f0, $20, $2c, $9e, $b5, $e0, $10, $1e
        byte  $84, $24, $88, $65, $19, $fc, $83, $90, $24, $f6, $62, $52, $7e, $f0, $e6, $20

        byte  $96, $15, $d3, $08, $1f, $04, $38, $4b, $64, $cf, $46, $04, $a3, $10, $ee, $9f
        byte  $8b, $24, $09, $6c, $59, $31, $0b, $fe, $fe, $a5, $70, $e2, $c0, $8e, $3d, $0b
        byte  $c6, $21, $9c, $0b, $67, $8e, $ec, $d9, $92, $62, $c6, $3f, $84, $6d, $88, $e0
        byte  $c9, $9a, $05, $e1, $e0, $c7, $95, $73, $0c, $20, $c7, $86, $25, $33, $02, $21
        byte  $94, $2b, $97, $e0, $91, $21, $48, $11, $8f, $60, $4c, $99, $50, $e2, $48, $9e
        byte  $6d, $0c, $60, $1a, $41, $83, $07, $63, $86, $ec, $c9, $91, $26, $49, $8c, $50
        byte  $29, $0f, $02, $2a, $94, $28, $d4, $a7, $47, $b7, $4e, $1d, $da, $b4, $6a, $09
        byte  $d5, $ca, $14, $29, $d0, $ab, $47, $97, $0e, $ed, $da, $b4, $68, $0e, $5e, $2a
        byte  $c3, $83, $7e, $bd, $e1, $49, $6a, $f0, $51, $ae, $58, $41, $74, $d0, $a5, $33
        byte  $3c, $68, $d5, $ac, $29, $7c, $8a, $56, $aa, $28, $3c, $c8, $d6, $29, $43, $bb
        byte  $56, $29, $9a, $25, $05, $4f, $1d, $5a, $14, $ca, $8b, $17, $e1, $41, $5a, $b2
        byte  $90, $a4, $31, $78, $4a, $d3, $a4, $41, $ac, $1a, $59, $c9, $42, $5a, $bc, $b8
        byte  $12, $c1, $43, $b7, $56, $8d, $e2, $d5, $8a, $56, $29, $42, $58, $78, $90, $1c
        byte  $26, $82, $87, $0c, $29, $1a, $d5, $a9, $51, $a5, $52, $b9, $30, $a1, $8a, $9f
        byte  $60, $f0, $d0, $26, $39, $3a, $88, $11, $25, $42, $b8, $52, $25, $82, $15, $29
        byte  $14, $10, $3c, $a4, $4a, $52, $2f, $56, $b5, $4a, $15, $e1, $41, $88, $60, $81
                                                                                            
        byte  $0a, $e4, $fb, $d7, $15, $1d, $c4, $a9, $11, $25, $52, $b8, $32, $a5, $e1, $41
        byte  $a0, $00, $fd, $fe, $65, $48, $96, $20, $4e, $8c, $aa, $e8, $20, $2c, $3c, $08
        byte  $0a, $1e, $e1, $43, $7b, $7c, $14, $2d, $4a, $85, $70, $a1, $f1, $21, $5e, $c8
        byte  $97, $e7, $5f, $9a, $24, $f1, $62, $45, $8b, $cc, $16, $42, $85, $84, $a7, $e0
        byte  $21, $55, $a2, $f8, $74, $11, $1f, $a2, $ab, $bc, $06, $a1, $51, $83, $7a, $75
        byte  $6a, $d5, $88, $2e, $10, $2a, $62, $41, $2a, $d0, $14, $1c, $c4, $07, $07, $31
        byte  $aa, $55, $a9, $12, $19, $1c, $95, $09, $6d, $10, $e1, $41, $5c, $78, $16, $11
        byte  $9e, $94, $46, $db, $f0, $11, $1e, $94, $d7, $44, $21, $1a, $25, $88, $0f, $2f
        byte  $d1, $49, $69, $cd, $48, $c6, $f1, $a1, $02, $44, $8b, $f0, $24, $44, $82, $7a
        byte  $71, $fd, $20, $1d, $86, $47, $61, $c9, $42, $89, $e2, $e0, $a0, $56, $6d, $78
        byte  $69, $10, $25, $a1, $66, $84, $67, $51, $d9, $40, $44, $b4, $10, $a6, $34, $38
        byte  $08, $ce, $07, $62, $c3, $73, $0b, $14, $da, $10, $05, $c9, $93, $ab, $47, $4c
        byte  $73, $a8, $1f, $c2, $93, $b5, $e0, $e0, $29, $47, $b7, $2c, $99, $f3, $42, $f8
        byte  $f0, $88, $0f, $82, $83, $87, $3e, $b9, $72, $64, $07, $0f, $19, $32, $82, $a7
        byte  $90, $01, $29, $28, $38, $06, $2f, $e9, $d2, $a4, $49, $4d, $96, $3d, $21, $3c
        byte  $cb, $94, $11, $3c, $a4, $4a, $95, $22, $59, $52, $f0, $8d, $0e, $c1, $53, $4a

        byte  $f0, $e4, $28, $31, $63, $2a, $12, $a4, $50, $81, $00, $f9, $fa, $f4, $fd, $84
        byte  $b4, $a8, $44, $88, $e2, $5d, $b1, $3a, $f5, $e7, $81, $b8, $a0, $5b, $b6, $ae
        byte  $45, $21, $28, $bc, $c8, $d3, $2b, $27, $4b, $ca, $0a, $af, $6b, $40, $6f, $78
        byte  $96, $55, $10, $37, $c3, $61, $90, $57, $39, $c3, $43, $9e, $3c, $85, $97, $32
        byte  $3c, $47, $47, $5d, $32, $2b, $84, $c2, $53, $a9, $2f, $59, $c9, $0e, $8f, $32
        byte  $b3, $41, $78, $c8, $06, $d1, $31, $59, $97, $81, $12, $11, $1e, $a3, $83, $dc
        byte  $da, $13, $bc, $04, $84, $f7, $d6, $11, $3c, $e2, $55, $78, $eb, $5c, $d1, $22
        byte  $bc, $25, $4b, $9e, $3c, $a4, $07, $7f, $d9, $bc, $c2, $13, $f7, $64, $cb, $47
        byte  $36, $ef, $e0, $10, $1e, $c2, $47, $b2, $e0, $2f, $8f, $5f, $3a, $08, $1e, $b2
        byte  $78, $c9, $4c, $16, $dc, $b9, $73, $90, $9f, $2c, $f9, $86, $c7, $e8, $10, $9e
        byte  $b8, $57, $08, $1d, $3a, $a4, $4b, $3f, $13, $83, $b3, $2a, $08, $8c, $17, $91
        byte  $70, $1a, $ce, $03, $29, $cb, $28, $78, $ea, $94, $19, $1e, $83, $c3, $3c, $9c
        byte  $57, $c9, $22, $61, $84, $07, $6d, $e1, $71, $1e, $04, $0f, $89, $12, $25, $c8
        byte  $5f, $8b, $6b, $7b, $19, $4a, $0a, $9e, $e2, $d7, $52, $74, $0d, $1e, $12, $38
        byte  $04, $8f, $74, $70, $14, $b7, $66, $74, $d8, $06, $12, $d8, $07, $ef, $a3, $28
        byte  $85, $b3, $24, $4e, $f1, $22, $3c, $04, $cf, $f0, $c8, $25, $59, $85, $07, $0e
                                                                                            
        byte  $e1, $43, $5c, $74, $e4, $9a, $0d, $b8, $84, $27, $8e, $c1, $81, $3d, $3b, $ee
        byte  $dc, $92, $05, $d7, $f0, $10, $bc, $c2, $83, $f8, $e0, $f1, $06, $83, $43, $78
        byte  $90, $1c, $2f, $38, $72, $e0, $10, $1c, $c4, $85, $0f, $a9, $c1, $23, $59, $47
        byte  $47, $f1, $ec, $d8, $26, $8b, $f8, $10, $9e, $38, $85, $e7, $e0, $11, $1f, $a2
        byte  $13, $27, $49, $e9, $92, $7d, $74, $08, $9f, $5c, $b9, $86, $f7, $e0, $c1, $96
        byte  $ed, $36, $97, $c5, $b3, $0d, $70, $cf, $1a, $e3, $69, $3a, $f0, $5e, $16, $d3
        byte  $4a, $3a, $37, $ae, $d3, $e2, $2e, $5c, $a5, $79, $c1, $43, $46, $78, $90, $16
        byte  $bc, $f8, $ca, $99, $0f, $f3, $52, $c6, $3a, $08, $0f, $52, $d9, $8b, $bb, $8b
        byte  $d1, $29, $3e, $70, $8f, $8e, $52, $c5, $65, $04, $31, $fb, $88, $a7, $4c, $1e
        byte  $75, $31, $6b, $88, $13, $c7, $56, $0c, $1b, $d1, $ac, $d2, $65, $f0, $8c, $1e
        byte  $5c, $c2, $83, $d8, $e0, $c0, $5a, $14, $4b, $96, $2c, $a4, $27, $87, $a2, $19
        byte  $9e, $58, $b3, $66, $25, $32, $78, $30, $67, $1e, $1e, $a2, $07, $bb, $f0, $c0
        byte  $26, $3c, $b0, $0a, $0e, $2c, $98, $33, $63, $c6, $94, $09, $17, $b6, $d1, $89
        byte  $55, $f0, $23, $c2, $98, $2d, $9b, $f0, $10, $1d, $e2, $23, $73, $e2, $cc, $88
        byte  $86, $8f, $e0, $1d, $5e, $a2, $07, $53, $a2, $e1, $2b, $59, $b2, $22, $c9, $82
        byte  $04, $73, $62, $e1, $83, $09, $13, $c2, $d1, $81, $74, $74, $09, $1e, $e1, $21

        byte  $38, $04, $4f, $d6, $a4, $c2, $73, $7c, $8a, $0e, $8c, $b9, $70, $59, $8a, $4b
        byte  $62, $4e, $64, $8e, $c8, $99, $0b, $ae, $c4, $56, $d8, $c3, $59, $20, $78, $4f
        byte  $03, $ce, $4b, $71, $2e, $06, $4f, $52, $2c, $53, $45, $74, $5c, $1a, $7b, $b0
        byte  $71, $90, $09, $5f, $c4, $c3, $07, $a7, $f0, $15, $1c, $c2, $37, $8b, $e0, $c5
        byte  $71, $2f, $ac, $09, $b2, $79, $30, $73, $44, $0f, $ce, $f1, $89, $03, $f9, $e8
        byte  $44, $ba, $51, $90, $20, $1e, $7c, $c2, $57, $7c, $20, $55, $19, $82, $07, $25
        byte  $4e, $14, $c3, $43, $f0, $24, $13, $9e, $89, $45, $87, $e4, $40, $21, $38, $90
        byte  $63, $9b, $1e, $c2, $43, $74, $60, $c6, $98, $52, $72, $a0, $10, $1f, $c8, $06
        byte  $8f, $f0, $11, $1d, $89, $11, $66, $c4, $90, $40, $7e, $20, $47, $36, $7d, $90
        byte  $0e, $5f, $c4, $08, $11, $0a, $1e, $04, $f8, $47, $c7, $f8, $11, $bc, $19, $31
        byte  $22, $18, $1c, $e8, $d3, $a3, $1b, $1c, $c2, $2f, $c3, $e0, $41, $9f, $5f, $f0
        byte  $a0, $43, $9b, $56, $f4, $21, $c8, $80, $40, $78, $a4, $1b, $3c, $69, $d2, $44
        byte  $41, $1c, $19, $d1, $91, $c1, $90, $01, $3b, $36, $a4, $88, $13, $a1, $e7, $3f
        byte  $00, $ad, $c4, $18, $40, $8f, $0e, $29, $12, $44, $09, $06, $ef, $95, $c8, $88
        byte  $01, $7d, $be, $b4, $49, $66, $09, $ba, $21, $88, $59, $f4, $20, $94, $00, $e8
        byte  $d2, $a6, $49, $1c, $31, $fd, $e0, $45, $2c, $78, $30, $ca, $01, $c1, $93, $3a
                                                                                            
        byte  $15, $84, $38, $43, $20, $33, $22, $84, $09, $11, $a4, $9f, $1e, $68, $d1, $c0
        byte  $4a, $09, $6f, $f0, $0c, $9f, $c1, $33, $05, $e0, $a2, $41, $0d, $33, $ba, $e0
        byte  $c9, $34, $7c, $07, $0f, $5a, $38, $82, $07, $86, $18, $98, $3e, $a2, $17, $3d
        byte  $3c, $b4, $71, $62, $a3, $82, $11, $75, $04, $08, $de, $f8, $c3, $07, $6e, $9a
        byte  $d8, $b1, $60, $44, $1b, $7c, $e9, $e3, $a3, $83, $1b, $27, $76, $ac, $98, $c0
        byte  $05, $6f, $44, $04, $c3, $07, $de, $e8, $11, $3c, $d1, $83, $f0, $1f, $bd, $10
        byte  $86, $0f, $bc, $e1, $0b, $32, $7a, $50, $fe, $91, $12, $41, $4c, $08, $61, $f8
        byte  $0c, $1e, $38, $b0, $62, $c6, $00, $3a, $7c, $20, $21, $8c, $88, $00, $7e, $7c
        byte  $e1, $13, $07, $34, $c8, $10, $c0, $04, $6f, $04, $c1, $07, $1b, $66, $8c, $60
        byte  $fd, $cb, $96, $22, $51, $9c, $18, $51, $22, $84, $0b, $15, $22, $58, $90, $40
        byte  $f9, $f2, $e4, $ca, $94, $22, $21, $f8, $09, $14, $10, $3c, $65, $48, $96, $20
        byte  $56, $b4, $48, $11, $c2, $c2, $47, $78, $08, $5e, $d2, $25, $8b, $0f, $9e, $c2
        byte  $83, $47, $74, $60, $28, $80, $bf, $3c, $be, $dc, $39, $89, $67, $2b, $9a, $a5
        byte  $70, $66, $42, $18, $c7, $47, $7e, $72, $f9, $48, $93, $c4, $5e, $0c, $2b, $91
        byte  $c9, $81, $89, $60, $46, $e1, $49, $0e, $b3, $e0, $25, $82, $b9, $d0, $e0, $11
        byte  $9d, $e5, $08, $63, $28, $8e, $8d, $28, $16, $cc, $99, $0a, $61, $24, $90, $81

        byte  $fc, $e8, $c9, $8c, $21, $3f, $3e, $c1, $83, $19, $53, $c6, $af, $83, $01, $7f
        byte  $7e, $7c, $a3, $47, $f0, $e4, $c5, $42, $18, $d3, $f8, $10, $3e, $d2, $05, $1f
        byte  $de, $e1, $8b, $17, $0f, $6e, $e1, $2b, $3c, $06, $1f, $9e, $c1, $83, $0b, $e7
        byte  $53, $11, $fc, $78, $f3, $e4, $ce, $2d, $78, $70, $a2, $10, $3c, $e8, $86, $0f
        byte  $e2, $0c, $e9, $f1, $a6, $c9, $9d, $1a, $17, $ca, $1c, $39, $b0, $67, $c7, $37
        byte  $78, $32, $0a, $5e, $e1, $93, $23, $05, $f6, $e4, $d8, $92, $e1, $45, $92, $50
        byte  $f6, $88, $1e, $d4, $a8, $70, $a6, $c8, $81, $3c, $3b, $32, $ac, $59, $c9, $91
        byte  $23, $5b, $96, $4c, $19, $d2, $a5, $49, $93, $ca, $45, $32, $67, $49, $12, $25
        byte  $06, $a7, $e0, $c1, $5d, $1a, $57, $a9, $52, $82, $83, $a4, $44, $20, $87, $b7
        byte  $2c, $9e, $32, $c2, $27, $57, $29, $c1, $93, $a3, $44, $0e, $e1, $83, $57, $78
        byte  $e4, $c6, $2d, $3a, $70, $96, $cc, $29, $3a, $70, $90, $2d, $9b, $57, $f8, $88
        byte  $0f, $d1, $99, $53, $74, $e0, $c0, $3b, $3c, $c8, $e4, $51, $3c, $c2, $43, $72
        byte  $08, $0e, $d1, $41, $7c, $78, $e2, $2e, $9d, $1b, $d7, $0a, $c0, $39, $78, $94
        byte  $cc, $f0, $51, $2f, $c2, $43, $7c, $cc, $16, $f1, $81, $43, $c5, $48, $4f, $c1
        byte  $83, $6b, $f8, $e4, $14, $1f, $d9, $b3, $4f, $16, $e1, $2b, $38, $b4, $40, $8e
        byte  $d1, $31, $78, $26, $8b, $f0, $19, $1f, $29, $05, $87, $86, $c0, $2e, $7c, $a4
                                                                                            
        byte  $cb, $e4, $50, $3f, $a2, $53, $43, $0c, $1e, $34, $ba, $45, $7c, $a4, $cc, $89
        byte  $62, $74, $6c, $09, $b4, $e2, $4b, $f8, $88, $0e, $14, $29, $04, $07, $72, $c1
        byte  $83, $06, $75, $6e, $54, $e3, $4b, $74, $24, $c7, $92, $46, $fc, $a0, $c6, $95
        byte  $0a, $65, $4a, $d1, $23, $3c, $8c, $c8, $02, $21, $fe, $50, $dc, $86, $c6, $28
        byte  $b3, $71, $54, $41, $09, $e2, $d9, $89, $63, $cb, $a6, $57, $f0, $6a, $8d, $79
        byte  $8a, $7d, $f0, $10, $1b, $3c, $44, $b3, $16, $95, $07, $f3, $54, $78, $16, $c3
        byte  $7a, $0e, $88, $64, $c9, $42, $7a, $13, $dc, $04, $ec, $c4, $b2, $61, $13, $1c
        byte  $58, $05, $87, $57, $c1, $bc, $0c, $b0, $8f, $17, $d1, $21, $3c, $b2, $0c, $5e
        byte  $cc, $5e, $07, $3b, $76, $c1, $21, $3c, $84, $8f, $e0, $41, $82, $39, $73, $62
        byte  $c1, $8f, $15, $a9, $e8, $cc, $8c, $28, $d3, $f0, $10, $5d, $48, $b2, $08, $1f
        byte  $d1, $81, $28, $13, $76, $64, $d9, $9c, $0a, $d2, $c9, $82, $65, $70, $20, $4e
        byte  $8c, $69, $f0, $8c, $4f, $a4, $d2, $65, $7c, $0a, $9e, $64, $1f, $06, $eb, $f0
        byte  $40, $92, $24, $09, $16, $e1, $21, $3e, $30, $21, $12, $7c, $d2, $0d, $51, $a2
        byte  $44, $88, $84, $07, $36, $e1, $81, $54, $78, $20, $41, $9c, $78, $ba, $24, $42
        byte  $38, $ba, $24, $8b, $e8, $48, $2c, $3c, $12, $26, $4b, $86, $34, $e9, $f0, $10
        byte  $3e, $c2, $43, $70, $08, $5e, $47, $f2, $ac, $0e, $89, $aa, $91, $2c, $96, $e2

        byte  $5e, $bc, $ca, $e3, $a2, $6e, $9e, $a9, $3b, $31, $0d, $ae, $02, $f9, $ae, $10
        byte  $1e, $d8, $9c, $a9, $27, $45, $21, $3a, $92, $63, $9b, $2c, $82, $e7, $5e, $d8
        byte  $1a, $7b, $23, $3c, $46, $47, $32, $4c, $f7, $44, $74, $e4, $18, $1e, $82, $07
        byte  $39, $b2, $e1, $81, $4d, $85, $60, $4c, $f8, $2c, $06, $cf, $21, $19, $3c, $58
        byte  $13, $61, $42, $98, $11, $21, $86, $04, $8f, $42, $ba, $08, $1f, $5d, $81, $34
        byte  $93, $f0, $c0, $88, $20, $43, $02, $0c, $e8, $93, $eb, $13, $e1, $91, $74, $8d
        byte  $08, $4f, $04, $e8, $f3, $a7, $47, $8f, $2f, $99, $aa, $19, $1e, $08, $45, $87
        byte  $f0, $48, $9f, $1e, $5d, $ba, $74, $e8, $d0, $26, $45, $38, $3e, $10, $24, $48
        byte  $20, $7c, $84, $87, $e0, $49, $9b, $36, $2d, $c6, $e1, $21, $78, $d2, $0f, $0f
        byte  $e1, $23, $3c, $06, $8f, $74, $49, $90, $41, $78, $88, $ae, $b4, $70, $11, $26
        byte  $14, $dd, $e3, $05, $6e, $5a, $b4, $a2, $3b, $5e, $3a, $78, $e2, $23, $ce, $b3
        byte  $b9, $2e, $f6, $d1, $d9, $d8, $06, $f9, $80, $d0, $3e, $67, $36, $1d, $ab, $46
        byte  $f0, $24, $75, $35, $48, $1c, $c3, $65, $9d, $2e, $f6, $21, $ab, $e8, $b8, $0e
        byte  $96, $75, $b2, $08, $1e, $e1, $61, $59, $30, $3f, $06, $c1, $77, $1f, $3d, $85
        byte  $75, $79, $35, $92, $45, $3e, $dc, $06, $ac, $8f, $11, $b1, $f0, $1c, $bc, $ef
        byte  $66, $78, $0c, $de, $88, $08, $21, $4c, $17, $57, $fb, $18, $b5, $85, $aa, $79
                                                                                            
        byte  $b6, $ee, $46, $74, $42, $42, $18, $31, $22, $82, $e1, $23, $3a, $23, $23, $86
        byte  $94, $48, $f0, $20, $14, $3c, $10, $d0, $a2, $59, $0c, $90, $67, $8b, $af, $10
        byte  $9e, $10, $22, $24, $40, $93, $26, $0d, $1a, $c4, $91, $21, $0b, $4f, $88, $93
        byte  $05, $42, $04, $34, $71, $e2, $a0, $8e, $9d, $1a, $55, $a2, $48, $90, $c4, $0b
        byte  $44, $c1, $01, $01, $ce, $f0, $80, $1d, $1b, $36, $ac, $58, $a9, $60, $26, $1c
        byte  $1c, $82, $07, $7e, $9a, $38, $c2, $07, $36, $6a, $58, $b1, $60, $c1, $8c, $09
        byte  $13, $46, $04, $08, $f0, $ef, $83, $65, $b4, $b4, $68, $45, $85, $38, $41, $6c
        byte  $99, $6c, $a5, $2c, $41, $23, $09, $60, $0d, $5e, $5b, $93, $0e, $6e, $da, $b8
        byte  $c2, $47, $f0, $8a, $4e, $f4, $e7, $41, $70, $08, $1f, $38, $d2, $44, $f8, $d8
        byte  $3a, $4b, $23, $3c, $a4, $85, $e0, $8d, $9f, $3e, $3e, $ba, $78, $a2, $47, $72
        byte  $c0, $11, $3f, $f2, $40, $74, $c4, $47, $0f, $6f, $78, $c0, $1d, $3e, $a2, $63
        byte  $f0, $40, $40, $00, $7f, $70, $08, $1f, $47, $22, $78, $17, $0e, $04, $f4, $f1
        byte  $47, $47, $3c, $e1, $b1, $0e, $c4, $47, $28, $e1, $11, $5f, $74, $08, $5e, $55
        byte  $00, $3b, $b4, $f0, $19, $1e, $82, $27, $ee, $f8, $0a, $15, $0b, $fe, $f8, $18
        byte  $3e, $82, $43, $7c, $80, $11, $1e, $a1, $04, $0f, $7c, $d1, $05, $66, $74, $80
        byte  $8e, $0d, $2a, $14, $cc, $d1, $05, $76, $ba, $84, $1e, $be, $20, $07, $0f, $bc

        byte  $78, $e1, $44, $07, $58, $30, $a3, $63, $72, $80, $02, $39, $3a, $c0, $c5, $93
        byte  $2e, $60, $e1, $c4, $09, $03, $3a, $b4, $e8, $00, $19, $32, $d2, $c5, $31, $2a
        byte  $f1, $85, $84, $04, $00, $0d, $32, $44, $b0, $c0, $a8, $ce, $86, $e0, $15, $13
        byte  $22, $00, $36, $28, $c1, $03, $c4, $e4, $0c, $df, $b0, $83, $07, $b4, $e0, $01
        byte  $0e, $c4, $e2, $98, $0d, $18, $f0, $a7, $c4, $e8, $19, $3c, $41, $86, $4f, $8c
        byte  $18, $c0, $a3, $c5, $03, $1b, $66, $f2, $88, $1f, $e0, $82, $27, $a4, $e0, $01
        byte  $0e, $2d, $18, $50, $38, $a1, $43, $0d, $3e, $98, $20, $a2, $0f, $5e, $20, $81
        byte  $07, $6f, $cc, $e1, $11, $3c, $3a, $b0, $e1, $23, $78, $00, $0d, $5f, $c1, $13
        byte  $02, $f8, $f0, $01, $1a, $14, $08, $e0, $40, $01, $03, $8c, $1f, $90, $a3, $03
        byte  $84, $e8, $01, $26, $f8, $00, $80, $0b, $32, $78, $81, $8f, $0e, $c1, $13, $58
        byte  $f8, $08, $1e, $30, $21, $c7, $0f, $08, $e0, $82, $27, $48, $10, $c0, $80, $00
        byte  $0a, $1e, $30, $20, $41, $8c, $8f, $c9, $29, $78, $c3, $09, $be, $d1, $21, $3d
        byte  $84, $4f, $f8, $70, $a0, $87, $ef, $e4, $0a, $10, $3e, $6c, $68, $c1, $33, $3e
        byte  $65, $17, $78, $b0, $a1, $f8, $27, $44, $8f, $0e, $4d, $ee, $dc, $a8, $70, $a2
        byte  $c8, $81, $3c, $5b, $32, $a4, $59, $f9, $27, $4c, $9f, $0f, $4d, $ea, $d4, $b8
        byte  $50, $e2, $48, $81, $1d, $59, $36, $a4, $49, $f9, $27, $42, $9f, $0e, $af, $e0
                                                                                            
        byte  $41, $85, $12, $c5, $e0, $49, $86, $75, $f0, $20, $4a, $80, $0e, $2d, $1a, $d1
        byte  $8b, $02, $b9, $e8, $4d, $9c, $00, $dd, $e0, $41, $2d, $7c, $91, $23, $1b, $3f
        byte  $c2, $87, $7f, $82, $c1, $9b, $72, $f4, $08, $be, $88, $e8, $d1, $a6, $11, $3e
        byte  $82, $7f, $0a, $c0, $87, $9b, $26, $36, $2a, $c1, $df, $3f, $36, $fa, $78, $68
        byte  $62, $a7, $8a, $99, $22, $06, $72, $68, $c9, $a0, $8e, $9f, $fe, $11, $e2, $c1
        byte  $49, $1d, $2b, $65, $8c, $14, $d0, $91, $45, $43, $1a, $a5, $ff, $00, $80, $09
        byte  $2f, $2e, $ec, $58, $31, $63, $0a, $fe, $d8, $d0, $e1, $c6, $41, $0d, $13, $26
        byte  $0c, $e4, $d1, $a2, $41, $4d, $32, $7c, $fa, $c7, $80, $06, $05, $36, $2c, $c1
        byte  $03, $7d, $f0, $8c, $5e, $fe, $21, $a1, $45, $89, $2c, $f8, $a2, $0a, $5f, $fe
        byte  $c1, $a1, $42, $8e, $14, $33, $46, $f4, $e8, $a2, $47, $f0, $81, $08, $1a, $05
        byte  $50, $c4, $00, $83, $37, $49, $16, $c4, $b9, $51, $e3, $ca, $85, $33, $a5, $01
        byte  $c4, $be, $26, $b0, $24, $41, $9c, $18, $51, $aa, $e5, $a1, $7b, $34, $00, $f2
        byte  $e4, $82, $47, $f8, $64, $46, $94, $09, $11, $c2, $e1, $91, $42, $f0, $20, $4b
        byte  $96, $64, $f8, $0a, $0e, $84, $09, $11, $0c, $0e, $c1, $3f, $78, $10, $0a, $1e
        byte  $04, $e8, $07, $4f, $32, $e1, $37, $78, $d3, $a3, $47, $37, $f8, $13, $24, $18
        byte  $3e, $82, $03, $5d, $3c, $e1, $17, $51, $70, $40, $40, $1f, $1f, $5d, $bc, $74

        byte  $48, $20, $27, $86, $94, $28, $92, $e4, $80, $90, $00, $fe, $e0, $89, $07, $4f
        byte  $7a, $40, $16, $1c, $88, $20, $0e, $9f, $c1, $9b, $0e, $0a, $e2, $c1, $93, $30
        byte  $61, $44, $08, $11, $e0, $c7, $17, $3d, $f0, $e0, $46, $81, $1c, $19, $52, $24
        byte  $e1, $21, $7c, $c4, $47, $bc, $78, $83, $57, $fc, $08, $9e, $08, $c3, $57, $f0
        byte  $09, $df, $c1, $21, $7a, $86, $87, $e8, $1f, $7c, $71, $c7, $bf, $e8, $98, $3c
        byte  $e2, $23, $6c, $36, $2f, $93, $54, $2f, $c8, $0d, $bd, $91, $68, $eb, $24, $f3
        byte  $30, $49, $55, $82, $4e, $39, $18, $88, $04, $2f, $d2, $a4, $83, $43, $2d, $0c
        byte  $cf, $a5, $83, $50, $78, $0b, $5e, $b5, $a1, $74, $44, $f7, $ca, $10, $1d, $10
        byte  $37, $8e, $e0, $49, $12, $65, $2b, $a8, $95, $8d, $21, $7c, $20, $22, $44, $fb
        byte  $25, $04, $5f, $a4, $f1, $a2, $31, $d2, $c6, $45, $0b, $27, $89, $56, $58, $2b
        byte  $6b, $43, $67, $0c, $5e, $34, $70, $b4, $82, $5a, $41, $a4, $35, $21, $c4, $8d
        byte  $0b, $27, $4e, $1c, $d4, $b1, $63, $a3, $da, $29, $c3, $43, $6b, $c0, $1d, $1d
        byte  $82, $47, $70, $c0, $86, $15, $0b, $16, $cc, $c1, $0b, $57, $f8, $c0, $81, $23
        byte  $f8, $62, $c2, $d4, $18, $82, $17, $f6, $e0, $81, $35, $7c, $60, $c6, $8c, $09
        byte  $22, $46, $08, $f1, $29, $78, $43, $c1, $0c, $19, $13, $c6, $e0, $85, $03, $46
        byte  $78, $80, $16, $9f, $20, $85, $0f, $0c, $e1, $03, $66, $7c, $0c, $0e, $50, $a1
                                                                                            
        byte  $40, $0e, $0f, $10, $21, $62, $00, $7f, $85, $ce, $04, $fd, $b3, $44, $27, $6f
        byte  $64, $83, $c7, $71, $24, $d6, $e2, $59, $c2, $5d, $36, $8a, $c6, $16, $b8, $12
        byte  $47, $82, $1e, $de, $3b, $11, $9e, $69, $86, $0f, $04, $e1, $65, $2d, $44, $87
        byte  $a2, $59, $21, $ee, $10, $be, $a5, $10, $1e, $ea, $72, $bc, $c4, $bf, $26, $de
        byte  $c0, $93, $08, $4f, $75, $a1, $42, $84, $0f, $7a, $e1, $61, $2b, $46, $67, $1c
        byte  $7b, $38, $3a, $c6, $27, $9c, $45, $03, $7a, $b2, $88, $8e, $77, $28, $bc, $04
        byte  $af, $cf, $71, $07, $61, $e3, $86, $15, $1e, $eb, $c2, $63, $c0, $0f, $0f, $2f
        byte  $dc, $64, $15, $bc, $a0, $63, $47, $00, $3f, $3c, $86, $0f, $d8, $b0, $61, $e1
        byte  $8a, $17, $30, $a0, $43, $c3, $10, $1e, $f0, $c1, $85, $83, $07, $36, $2e, $58
        byte  $30, $61, $06, $07, $ec, $d0, $d0, $83, $47, $07, $36, $3a, $c0, $8d, $17, $e1
        byte  $25, $78, $80, $0b, $1e, $60, $d1, $80, $8e, $0e, $e1, $29, $3a, $40, $03, $0f
        byte  $0e, $1c, $5a, $30, $60, $40, $83, $02, $05, $12, $46, $74, $08, $1e, $50, $f7
        byte  $06, $76, $ea, $eb, $60, $3c, $2d, $0b, $8c, $18, $92, $05, $0e, $1a, $eb, $68
        byte  $59, $cf, $8b, $f1, $80, $7e, $6b, $6c, $f3, $69, $81, $01, $3d, $b8, $e0, $b5
        byte  $8d, $21, $85, $a7, $6c, $70, $74, $b6, $c1, $3e, $5c, $96, $e1, $63, $6f, $42
        byte  $4d, $96, $eb, $20, $7c, $40, $88, $0f, $f9, $20, $5e, $41, $c5, $02, $19, $73

        byte  $70, $80, $08, $01, $7c, $78, $00, $5b, $21, $b0, $05, $87, $e8, $00, $29, $bc
        byte  $80, $0b, $9e, $58, $c3, $e3, $d1, $0a, $0f, $65, $03, $2c, $58, $68, $e1, $01
        byte  $4a, $78, $3a, $1b, $c1, $a3, $2a, $80, $05, $03, $2d, $59, $5c, $c5, $e8, $10
        byte  $2f, $82, $4f, $78, $4c, $16, $90, $21, $85, $a7, $e8, $d8, $24, $a0, $3e, $89
        byte  $f0, $11, $de, $db, $40, $f0, $7c, $13, $e1, $2d, $3e, $80, $0e, $ef, $7d, $30
        byte  $38, $06, $cf, $f0, $9e, $0d, $06, $e7, $3a, $c0, $0b, $67, $6b, $1e, $c9, $32
        byte  $11, $35, $d2, $c0, $b4, $08, $1e, $f3, $68, $2d, $e6, $85, $34, $19, $3c, $d0
        byte  $80, $41, $bd, $b6, $83, $63, $f0, $04, $3b, $2f, $40, $83, $46, $05, $12, $04
        byte  $f4, $b9, $19, $1c, $21, $a6, $8c, $75, $b0, $0c, $41, $00, $07, $16, $9d, $83
        byte  $67, $78, $58, $1b, $20, $82, $27, $50, $20, $80, $2b, $67, $ce, $0c, $cf, $e1
        byte  $23, $78, $02, $02, $08, $60, $6f, $81, $8c, $0f, $c1, $31, $f8, $46, $f7, $e8
        byte  $00, $28, $7c, $9d, $85, $f0, $0c, $2c, $bc, $c0, $0f, $ef, $e1, $01, $70, $78
        byte  $0c, $1e, $d9, $24, $bc, $c1, $8b, $8e, $d9, $24, $3e, $a6, $0b, $f8, $f0, $b2
        byte  $79, $b4, $86, $07, $b7, $68, $64, $63, $20, $e1, $35, $78, $96, $85, $a2, $17
        byte  $2d, $e0, $c2, $39, $95, $87, $60, $70, $44, $82, $14, $01, $18, $00, $3c, $58
        byte  $fe, $83, $77, $2a, $8c, $18, $40, $00, $01, $80, $0b, $33, $78, $4f, $c6, $58
                                                                                            
        byte  $50, $3c, $00, $c1, $87, $03, $c3, $ff, $a1, $6c, $89, $29, $13, $28, $60, $80
        byte  $c1, $03, $7a, $f0, $e9, $81, $f1, $11, $20, $3c, $d8, $50, $83, $57, $74, $04
        byte  $19, $5f, $92, $83, $ff, $4b, $94, $1c, $e2, $63, $74, $8a, $0f, $fe, $73, $26
        byte  $98, $e8, $1e, $1f, $82, $47, $41, $80, $0d, $2b, $ba, $e4, $0b, $28, $fe, $fd
        byte  $d7, $88, $e3, $00, $73, $1f, $40, $ad, $0f, $f0, $f3, $65, $f0, $0a, $0f, $c1
        byte  $63, $6d, $40, $86, $08, $0e, $76, $74, $f4, $1f, $9d, $ce, $26, $14, $48, $10
        byte  $c0, $82, $02, $12, $1e, $82, $e7, $39, $80, $11, $9e, $c0, $83, $01, $11, $1c
        byte  $fd, $c7, $8b, $e0, $71, $16, $c2, $23, $38, $d0, $c0, $82, $4f, $b2, $3a, $02
        byte  $e0, $c1, $82, $0c, $4e, $fe, $93, $65, $78, $4c, $96, $a0, $81, $07, $ef, $40
        byte  $12, $0e, $90, $01, $41, $08, $00, $dd, $97, $00, $15, $7c, $c0, $83, $02, $8e
        byte  $04, $10, $02, $78, $78, $bf, $44, $24, $4d, $07, $dd, $03, $00, $7c, $bc, $f1
        byte  $22, $f8, $82, $07, $09, $ac, $05, $16, $03, $5c, $89, $0c, $0c, $f0, $e9, $09
        byte  $0f, $4e, $8f, $0c, $31, $10, $40, $02, $9d, $1f, $c1, $03, $76, $26, $8f, $00
        byte  $31, $28, $f8, $87, $8e, $08, $d8, $11, $82, $7f, $f0, $00, $0b, $fc, $00, $c2
        byte  $29, $e5, $41, $00, $54, $82, $88, $00, $c1, $3f, $08, $82, $88, $00, $70, $83
        byte  $7f, $10, $02, $76, $12, $82, $7f, $10, $02, $03, $04, $40, $f0, $0f, $c2, $20

        byte  $01, $05, $ff, $20, $d2, $cb, $43, $1f, $0a, $e0, $c8, $80, $22, $01, $8c, $08
        byte  $20, $02, $f8, $f8, $f6, $02, $1e, $d8, $b8, $50, $06, $2f, $c4, $80, $86, $01
        byte  $fe, $7e, $81, $17, $0e, $ee, $b3, $80, $1c, $18, $52, $20, $e1, $3b, $3c, $04
        byte  $af, $65, $f1, $25, $80, $84, $0f, $80, $c3, $00, $5f, $bf, $d8, $46, $38, $f6
        byte  $41, $f8, $8b, $0f, $57, $0b, $3a, $54, $28, $90, $01, $85, $cf, $27, $05, $eb
        byte  $1c, $06, $2f, $48, $10, $a3, $47, $f0, $81, $75, $8f, $8e, $03, $44, $08, $e0
        byte  $83, $37, $cc, $6b, $1d, $bc, $c1, $81, $4d, $4e, $b0, $61, $9e, $07, $a8, $c1
        byte  $17, $0c, $e8, $70, $11, $3c, $de, $55, $fc, $88, $1e, $e1, $23, $78, $80, $02
        byte  $b9, $21, $12, $40, $06, $08, $fe, $20, $e1, $c6, $c0, $1c, $98, $3c, $c3, $0f
        byte  $fc, $08, $08, $ad, $00, $04, $7f, $80, $11, $20, $01, $c7, $1f, $90, $bb, $20
        byte  $02, $64, $88, $04, $04, $3e, $7a, $26, $07, $10, $b8, $5a, $00, $74, $ec, $d0
        byte  $b0, $42, $c5, $82, $39, $17, $60, $8c, $95, $30, $71, $c2, $c0, $5e, $20, $b0
        byte  $42, $81, $82, $19, $52, $26, $c0, $10, $2b, $70, $c2, $c4, $01, $1d, $5b, $47
        byte  $48, $11, $25, $33, $3c, $82, $8f, $0e, $0d, $10, $6a, $8e, $0c, $3e, $e0, $e2
        byte  $63, $0d, $8c, $0e, $c1, $a1, $64, $66, $c2, $e0, $1f, $1c, $a2, $53, $f8, $82
        byte  $16, $5f, $21, $84, $c7, $e0, $1d, $9f, $d2, $65, $f0, $02, $0b, $23, $39, $c5
                                                                                            
        byte  $27, $88, $d1, $39, $78, $40, $4f, $4e, $90, $07, $54, $74, $02, $0b, $22, $38
        byte  $c4, $a7, $e8, $04, $be, $26, $06, $0f, $e0, $c0, $e2, $73, $74, $02, $d7, $10
        byte  $41, $04, $0f, $a0, $40, $80, $44, $57, $b0, $60, $c1, $04, $6f, $c0, $80, $01
        byte  $25, $1b, $30, $c1, $f7, $78, $9c, $c0, $e8, $04, $3a, $3a, $dc, $cf, $f0, $10
        byte  $1c, $4e, $f0, $8a, $40, $9f, $30, $62, $01, $68, $d0, $43, $02, $24, $88, $b8
        byte  $50, $25, $23, $d1, $e6, $0c, $5e, $c0, $d3, $22, $d0, $f0, $3a, $25, $d3, $64
        byte  $5c, $8c, $ee, $c1, $21, $3c, $01, $29, $88, $d1, $39, $5e, $02, $0b, $8f, $40
        byte  $0a, $62, $b2, $89, $d7, $40, $00, $a7, $83, $f0, $1e, $9e, $82, $67, $78, $07
        byte  $5a, $07, $aa, $40, $85, $c8, $1b, $e9, $3c, $3a, $00, $8a, $16, $45, $3b, $de
        byte  $56, $81, $78, $1f, $af, $1b, $47, $f0, $7c, $04, $79, $37, $5c, $04, $8f, $64
        byte  $95, $77, $7b, $25, $40, $80, $f1, $7e, $14, $84, $27, $00, $c1, $33, $3c, $01
        byte  $cf, $5a, $d1, $02, $00, $80, $36, $16, $9e, $a2, $c5, $20, $b8, $f3, $7d, $08
        byte  $6c, $b4, $f8, $e2, $5d, $18, $14, $a8, $92, $f8, $46, $ba, $60, $d6, $ca, $c4
        byte  $00, $8e, $72, $59, $ce, $c4, $4b, $13, $de, $a2, $01, $b1, $16, $b7, $22, $7c
        byte  $78, $70, $e1, $c0, $81, $1d, $2f, $56, $01, $a0, $5c, $14, $1c, $83, $07, $6c
        byte  $d8, $b0, $60, $7e, $8b, $23, $1d, $5e, $82, $43, $f0, $80, $1e, $de, $c3, $45

        byte  $78, $fc, $07, $25, $0b, $5e, $bc, $8c, $36, $ff, $20, $99, $47, $6b, $68, $50
        byte  $1b, $44, $32, $81, $15, $ad, $83, $67, $70, $c8, $da, $69, $2b, $5a, $40, $85
        byte  $02, $3f, $ed, $c3, $08, $4e, $c1, $23, $5c, $e4, $c5, $68, $fd, $2e, $db, $45
        byte  $da, $cf, $0a, $f1, $20, $38, $40, $5a, $46, $6b, $61, $5c, $16, $c1, $b8, $54
        byte  $23, $f6, $52, $af, $cc, $83, $85, $69, $1e, $85, $8b, $e0, $0f, $7b, $2f, $7c
        byte  $a6, $4e, $d9, $33, $d3, $50, $f0, $0c, $0f, $40, $83, $5f, $a1, $00, $1e, $de
        byte  $e3, $15, $2c, $18, $c1, $23, $6d, $a5, $e3, $11, $50, $09, $73, $41, $c5, $88
        byte  $f7, $fd, $b3, $10, $43, $84, $00, $3e, $5a, $c3, $ac, $49, $90, $21, $ef, $40
        byte  $f0, $db, $e1, $68, $84, $87, $68, $15, $5c, $b7, $45, $59, $cc, $02, $35, $31
        byte  $5a, $1e, $23, $50, $79, $21, $2d, $00, $0a, $97, $c1, $73, $1f, $be, $81, $ac
        byte  $00, $04, $10, $80, $78, $1e, $2d, $5a, $03, $60, $80, $f0, $92, $0e, $98, $70
        byte  $01, $22, $38, $c1, $87, $13, $4f, $93, $36, $c0, $e0, $00, $1d, $76, $c1, $84
        byte  $1a, $0b, $20, $80, $05, $e5, $3f, $00, $57, $84, $82, $91, $31, $20, $82, $03
        byte  $0d, $3c, $f8, $84, $17, $f0, $60, $41, $06, $17, $ff, $15, $11, $0a, $24, $08
        byte  $e1, $dd, $3f, $8c, $8a, $00, $19, $62, $78, $8f, $04, $f1, $32, $3c, $01, $8d
        byte  $ae, $fe, $c3, $33, $18, $10, $c1, $cd, $7f, $bf, $08, $0f, $59, $2f, $14, $25
                                                                                            
        byte  $63, $60, $e1, $dd, $7f, $32, $8c, $f6, $a1, $0a, $10, $7c, $b8, $30, $c3, $7d
        byte  $10, $04, $00, $17, $56, $70, $0f, $42, $f0, $60, $43, $0d, $fe, $41, $08, $36
        byte  $b4, $e0, $1e, $84, $a1, $07, $f7, $20, $1e, $c4, $83, $30, $94, $04, $d1, $30
        byte  $0a, $45, $c3, $58, $99, $93, $32, $64, $40, $ce, $10, $d0, $47, $c4, $e4, $08
        byte  $7e, $25, $01, $0c, $4c, $68, $95, $69, $13, $84, $ef, $58, $09, $3a, $02, $ac
        byte  $8e, $5e, $70, $92, $92, $c9, $b4, $80, $92, $00, $83, $7f, $28, $00, $0d, $0c
        byte  $f0, $24, $08, $fe, $91, $08, $68, $93, $00, $fb, $12, $86, $78, $48, $00, $7a
        byte  $0e, $e0, $3c, $8c, $b6, $df, $b6, $8f, $45, $39, $0f, $c2, $70, $fa, $7e, $63
        byte  $0f, $e2, $41, $3c, $88, $07, $f1, $20, $1e, $c4, $83, $78, $10, $0f, $a2, $c0
        byte  $81, $01, $05, $02, $04, $30, $20, $80, $00, $e0, $c3, $83, $07, $17, $0e, $6c
        byte  $d8, $c1, $2b, $38, $04, $6f, $b8, $c1, $13, $56, $f0, $09, $0f, $e1, $33, $3c
        byte  $05, $ff, $e8, $10, $9e, $61, $86, $bf, $e0, $19, $2f, $61, $05, $af, $64, $1d
        byte  $bc, $83, $03, $8c, $f0, $91, $6e, $93, $51, $f0, $4f, $36, $c1, $11, $7a, $f8
        byte  $0e, $ee, $30, $a0, $43, $df, $0a, $80, $8b, $51, $74, $82, $19, $1c, $a0, $9d
        byte  $6d, $00, $65, $29, $5a, $41, $fb, $86, $57, $07, $76, $70, $81, $d2, $98, $b6
        byte  $c4, $59, $8e, $0b, $50, $a1, $40, $6e, $ad, $57, $b2, $0d, $16, $09, $88, $dd

        byte  $3f, $08, $b4, $82, $34, $d8, $ff, $83, $28, $2c, $90, $20, $40, $34, $cc, $41
        byte  $d0, $4b, $e0, $c3, $cc, $85, $c0, $e2, $52, $a3, $2a, $9d, $c1, $31, $75, $35
        byte  $a2, $89, $5d, $b2, $a0, $66, $4e, $48, $90, $20, $ce, $e4, $8a, $58, $0a, $72
        byte  $03, $e4, $e0, $00, $01, $3c, $78, $70, $60, $e1, $04, $cf, $70, $11, $3c, $82
        byte  $63, $f0, $08, $0e, $60, $40, $c7, $c3, $68, $05, $11, $42, $70, $01, $0d, $2d
        byte  $5a, $85, $8b, $e0, $11, $0d, $c3, $05, $68, $50, $c1, $3d, $1a, $05, $07, $90
        byte  $d1, $38, $dc, $36, $82, $72, $90, $94, $82, $7b, $95, $cc, $c2, $e0, $a2, $51
        byte  $47, $ac, $83, $b9, $2b, $d8, $37, $ca, $cc, $12, $76, $6a, $d1, $9c, $4c, $95
        byte  $1d, $09, $c8, $2b, $82, $0b, $a3, $86, $a6, $0c, $f8, $1b, $01, $16, $0c, $a8
        byte  $e1, $f3, $76, $2c, $cd, $da, $9d, $0e, $5f, $4d, $a7, $6e, $d4, $b7, $75, $6d
        byte  $67, $ad, $68, $b8, $67, $21, $47, $cb, $46, $00, $fb, $88, $05, $17, $b0, $d9
        byte  $30, $a9, $15, $e5, $22, $57, $79, $cb, $f8, $c7, $8e, $9b, $65, $7a, $6b, $15
        byte  $47, $d8, $b9, $01, $5a, $4b, $ac, $4d, $f0, $4b, $67, $e6, $80, $0e, $15, $f2
        byte  $19, $8a, $5a, $b9, $23, $1c, $fe, $05, $70, $e1, $70, $77, $c2, $8d, $13, $30
        byte  $a0, $05, $cb, $57, $14, $15, $83, $35, $44, $b0, $2f, $29, $58, $45, $49, $c8
        byte  $e0, $df, $2f, $9c, $8e, $01, $0d, $f2, $2f, $0f, $e2, $41, $7c, $fa, $6c, $0e
                                                                                            
        byte  $e0, $40, $01, $03, $84, $7f, $2f, $fc, $9f, $66, $50, $a5, $22, $38, $43, $8f
        byte  $0c, $6b, $3b, $b8, $42, $8b, $95, $60, $6f, $41, $b8, $85, $9d, $b0, $83, $43
        byte  $dc, $81, $17, $5c, $fc, $83, $0e, $0e, $c0, $e2, $06, $00, $b8, $30, $33, $2c
        byte  $c8, $16, $b0, $07, $00, $c0, $c9, $fe, $d0, $81, $42, $86, $08, $0e, $54, $e1
        byte  $f7, $0f, $15, $12, $04, $30, $a5, $3e, $08, $86, $83, $6a, $1e, $c4, $83, $78
        byte  $10, $0f, $e2, $41, $3c, $88, $07, $f1, $20, $1e, $c4, $83, $78, $10, $0f, $02

DAT
{{

 TERMS OF USE: MIT License

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the
 following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial
 portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}
DAT
