'Propeller port of CP/M Ladder game
'(C) 2008 Raymond Allen
'ported from *nix curses version by Kevin Handy
'original author appears to be unknown  although menu gives this:  (c) in 1982, 1983: Yahoo Software, cloned by Andreas Burmester."
'requires monitor capable of 1280x1024 resolution and keyboard

CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

  cols = 80
  rows = 48
  tiles = cols * rows
  spacetile = $220

 DIMROW = 20
 DIMCOL = 80
 DIMSCRN =7
 HISPEED =5

 CLAD  =  "g"
 CDER  =  "o"
 CGOLD =  "&"
 CRELEAS ="V"
 CLADDER ="H"
 CTARGET ="$"
 CEXIT   ="*"
 CBAR    ="|"
 CGROUND = "="
 CHAZARD ="."
 CTRAP0  ="^"
 CTRAP1  ="-"
 CFREE   =" "

 KEY_LEFT=192
 KEY_RIGHT=193
 KEY_UP=194
 KEY_DOWN=195
 KEY_ESC=203
 KEY_CTRLC=611

 MAXSCORE   =5

 NReleases = 3 'number of possible release points
 EOF = 255

 #0, NONE, #0, STOP , XUP , XDOWN , LEFT , RIGHT 
 #0, NORMAL, #0, NOTHING_HAPPENED , EXIT, PAUSE, DEAD, FINISH

 MAXDERS = 10  'added by RJA as new way of dealing with ders array


OBJ

  vga     : "VGA_1280x1024_Tile_Driver_With_Cursor"
  'mouse   : "mouse"
  kb    : "bel-keyb"'keyboard"

  
VAR
  'screen
  long  col, row, color
  long  array[tiles/2]
  'game
  long boni[DIMSCRN]  'time for bonus
  long bonus
  long lads  'lives remaining
  long speed 'game speed
  long scrno 'there are 5 screens
  long hi_scrno 'screen increments until here and then level increases
  long level  'difficulty level
  long score
  word releases[NReleases] 'points where ders can fall...  byte.1=row, byte.0=column
  byte bg[DIMROW*DIMCOL] 'screen buffer
  long ders[MAXDERS]    'byte.3=launch byte.2=dir  byte.1=row, byte.0=column
  long lad_row,lad_col,lad_st_row,lad_st_col,lad_dir,lad_jst
  long last, diff 'time vars
  long Random  'for random number

  long scores[MAXSCORE]       'word.0=score, word.1=level
  

PUB start |  j, k

  'start vga tile driver
  vga.start(8, @array, @vgacolors, 0, 0, 0)

  'init keyboard
  kb.start(17, 16)

  clear 'clear screen

  'repeat  'look at key codes
  '  dec(kb.getkey)
  '  print(" ")

  'initializations
  speed:=0


  repeat
    case menu
      "p","P":
        play
        clear
      "i","I":
        instructions
        clear
      "l","L":
        if ++speed==HISPEED
          speed:=0
      "e","E":
        clear
        repeat
      other:
        clear

PRI Instructions|ps,brow,pbg,c,i
  clear
  'show instructions screen
  ps := @instruct  'points to screen data
  'decipher instruct screen data and print
  bytefill(@bg," ",DIMROW*DIMCOL) 'clear the screen data buffer 
  brow:=0  
  pbg:=@bg
  repeat until brow=>20
    c:=byte[ps++]
    case c
      "\": 'backlash followed by 3-digit octal code      
        i:=210-((byte[ps++]-"0")*64+(byte[ps++]-"0")*8+(byte[ps++]-"0"))
        repeat i
          byte[pbg++]:=" "        
      ",": 'comma code for cr,lf
          
        'print row
        pbg:= @bg[brow*DIMCOL]
        col:=4
        row:=brow<<1
        repeat i from 1 to DIMCOL
          print(byte[pbg++]) 
        'advance to next row         
        brow++
        pbg:=@bg[brow*DIMCOL]
      other:
        byte[pbg++]:=c

  repeat until kb.getkey==13
        
PRI Clear  'clear screen
  print($100)  

PRI Menu:key|ps,brow,pbg,c,i,r,LM, RM0, RM1
  'show splash screen
  ps := @splash  'points to screen data
  'decipher splash screen data and print
  bytefill(@bg," ",DIMROW*DIMCOL) 'clear the screen data buffer 
  brow:=1  
  pbg:=@bg
  repeat until brow=>8
    c:=byte[ps++]
    case c
      "\": 'backlash followed by 3-digit octal code      
        i:=210-((byte[ps++]-"0")*64+(byte[ps++]-"0")*8+(byte[ps++]-"0"))
        repeat i
          byte[pbg++]:=" "        
      ",": 'comma code for cr,lf
          
        'print row
        pbg:= @bg[brow*DIMCOL]
        col:=11
        row:=brow<<1
        repeat i from 1 to DIMCOL
          print(byte[pbg++])    
        'advance to next row         
        brow++
        pbg:=@bg[brow*DIMCOL]
      other:
        byte[pbg++]:=c

  'show menu options
  r:=10
  LM:=2
  RM0:=33
  RM1:=40
  mvaddstr(r,LM,string("(c) in 1982, 1983: Yahoo Software, Spun by Rayman 2008."))
        '"(c) in 1982, 1983: Yahoo Software, cloned by Andreas Burmester.");
  r += 2
  mvaddstr(r,LM,string("Version:    n/a"))
  mvaddstr(r,RM0,string("Up = k|8  Down = j|2  Left = h|4  Right = l|6"))
  r++
  mvaddstr(r,LM,string("Terminal:   Propeller"))
  mvaddstr(r,RM0,string("Jump = Space   Stop = Other"))
  r++
  mvaddstr(r,LM,string("Play Speed: "))
  dec(speed + 1)
  r++
  prt_score(r,RM1)
  r++
  mvaddstr(r++,LM,string("P = Play game"))
  mvaddstr(r++,LM,string("L = Change level of difficulty"))
  mvaddstr(r++,LM,string("I = Instructions"))
  mvaddstr(r++,LM,string("E = Exit Ladder"))
  r++
  refresh

  'return a key
  kb.clearkeys
  return kb.getkey

PRI Prt_Score(r,c)|i,s

    mvaddstr(r,c,string("High Scores"))
    repeat  i from  0 to MAXSCORE-1
        row:=2*(r+i+2)
        col:=c
        dec(i+1)
        print_string(string(")  "))
        s:=scores[i]   'score
        if( s.word[0]>0 )  'score
          dec(s.word[0])
          print_string(string("00  "))
          dec(s.word[1]+1) 'level
          Print_string(string("  "))
        else
           print_string(string("          "))


PRI Play |s,l,i,f,sl
  longmove(@boni,@st_boni,DIMSCRN)  'had to make boni a long array in order to subract...?

  lads := 5
  score := 0
  scrno := 0
  hi_scrno := 1
  clear
  Random:=cnt

  level:=0

  'level:=19  'CHEAT HERE :)
  'scrno:=6
  'score:=1104
  
  repeat
    if( lplay == DEAD )
      quit
    boni[scrno] -= 2
    if( ++scrno > hi_scrno )
        if( hi_scrno <> (DIMSCRN - 1))
          hi_scrno++
        scrno:= 0
    level++

  'upd_score  'store high score!
  f:=false
  repeat i from 0 to 4
    sl:=scores[i]
    s:=sl.word[0]
    l:=sl.word[1]
    if score>s
      sl.word[0]:=score
      sl.word[1]:=level
      scores[i]:=sl
      score:=s
      level:=l
      f:=true
    else
      if f
        quit
       
  

PRI lPlay | tick , r

    ldscreen
        

    repeat while( lads > 0 )
        bonus:= boni[scrno]
  
        ctplay
        stat_lads
        stat_level
        stat_score
        stat_bonus
        
        mvaddstr(DIMROW + 2,0,string("Get ready! "))
        refresh
        
        repeat tick from 7 to 0
          waitct
        mvaddstr(DIMROW + 2,0,string("           "))  

        'row:=0
        'col:=0
        'dec(scrno)
        'repeat until kb.getkey=="p"
        
        tick:=20*bonus
        repeat while tick>0 ' from  20 * bonus to 1
          tick--
          if( ((tick - 1) // 20)==0 )
            bonus--
            stat_bonus

          r:=drv_ders
          if( r <> DEAD )
              r:= drv_lad
              'kb.clearkeys
            'move(LINES - 1,0);
          refresh
          waitct
          
          if( r == PAUSE )
             pause1
             r:= NORMAL
          if( r <> NORMAL )
             quit
        
        if( tick==0 )
           r:= DEAD

        if( r == DEAD )
          lads--
          stat_lads
          lad_died

        if( r == FINISH )
            do_the_hooka
            return NORMAL
        reldscreen

   return DEAD


PRI Pause1
  mvaddstr(DIMROW + 2,0,string("Press Return to continue"))
  repeat until kb.getkey==13  
  mvaddstr(DIMROW + 2,0,string("                         ")) 

PRI do_the_hooka
  bonus-- 
  repeat while bonus=>0    
    add_score(1)
    stat_bonus
    if( bonus & 1 )
        mvaddstr(DIMROW + 2,0,string("Hooka!"))  
    else
        mvaddstr(DIMROW + 2,0,string("      "))  
    'move(LINES - 1,0);
    refresh
    waitct
    bonus-- 


PRI drv_lad:r|c0,c1,arow,acol,dir,jst,ch,jc,jr,s

    arow:= lad_row
    acol:= lad_col
    dir:= lad_dir
    jst:= lad_jst

    repeat while kb.gotkey
      ch:= kb.getkey
      case ch
        "h","4","w", KEY_LEFT:
          dir:= LEFT
          quit

        "l","6","d", KEY_RIGHT:
          dir:= RIGHT
          quit

        "k","8","w", KEY_UP:
          if( jst==0 )
            dir:= XUP
          quit

        "j","2","s",KEY_DOWN:
          if( jst==0 )
            dir:= XDOWN
          quit

        " ","x": 'jump
          if( jst==0 )     ' /* not while we"re jumping */
            jst:= 1
          quit

         '"R"-"@":
         '"L"-"@":
         'KEY_CLEAR:
         '   wrefresh(curscr)
         '   break

        KEY_ESC:
          return PAUSE

        KEY_CTRLC:' "C"-"@":       /* who does set INTR to ^C, anyway? */
          repeat while (lads-- =>1)  'for(  lads >= 1 lads-- )            
            stat_lads
            'move(LINES - 1, 0)
            refresh
            waitct            
          lads:= 1
          return DEAD

        other:
          dir:= STOP
     
    

    c0:= bg[arow*DIMCOL+acol]
    c1:= bg[(arow + 1)*DIMCOL+acol]
    if (jst < 2) and (not SOLID(c1)) and (c0 <> CLADDER) and not((jst == 1) and (c0 == CHAZARD))     
      '/* then fall */
      jst:= 0       ' /* no request for jumping */
      arow++
 
    else
      if( jst => 1 )  ' /* request for or within a jump */
        
        if( (jst == 1) and (c1 == CFREE) and (c0 <> CHAZARD) )
          jst:= 0
                'repeat 
        else
          'static jra[7] =  0, -1, -1, 0, 0, 1, 1 
          'int jc,jr
          over_der(arow,acol)
          if( dir == XUP or dir == XDOWN )
            dir:= STOP
          repeat while jst<>7                       'for(  jst != 7 jst++ )
            jr:= jra[jst]
            'row:=0
            'col:=0
            'dec(jra)
            'print(" ")
            'repeat
            'kb.getkey
            if (dir==STOP)
              jc:=0
            else
              if  (dir == LEFT)
                JC:= -1
              else
                JC:=1
            c0:= bg[(arow + jr)*DIMCOL+acol + jc]
            if( c0 <> CBAR and c0 <> CGROUND and not(jr == 1 and c0 == CTRAP1) )            
              arow+=jr
              if( (arow  < 0) or ( arow > DIMROW - 2) )
                  arow-= jr
              acol+=jc
              if( (acol < 0) or ( acol > DIMCOL - 2) )
                  acol-= jc
              quit
            jst++  
                  
              
          if( ++jst => 7 )
              jst:= 0
          if( bg[arow*DIMCOL+acol] == CLADDER )           
              jst:= 0
              dir:= STOP           
          if( dir <> STOP )
              over_der(arow,acol)
            
        
      else
       
        if( c1  == CTRAP1 )
          bg[(arow + 1)*DIMCOL+acol]:= CFREE
          mvaddch(arow + 1,acol,bg[(arow + 1)*DIMCOL+acol] )
        case dir        
          LEFT:
              c1:= bg[arow*DIMCOL+acol - 1]
              if( acol <> 0 and c1 <> CBAR and c1 <> CGROUND )
                  acol--
              else
                  dir:= STOP
          RIGHT:
              c1:= bg[arow*DIMCOL+acol + 1]
              if( acol <> DIMCOL - 2 and c1 <> CBAR and c1 <> CGROUND )
                  acol++
              else
                  dir:= STOP
          XUP:
              if( c0 == CLADDER)
                c0:= bg[(arow - 1)*DIMCOL+acol]
                if ((c0 == CLADDER or c0 == CTARGET) )
                   arow--
                else
                   dir:= STOP
              else
                dir:=STOP
          XDOWN:
              if( c0 == CLADDER and c1 <> CGROUND )
                  arow++
              else
                  dir:= STOP
'            
        

    if( lad_row <> arow or lad_col <> acol or lad_dir <> dir or lad_jst <> jst )
        mvaddch(lad_row,lad_col,bg[lad_row*DIMCOL+lad_col])
        
        '/* remove rubbish */
        
        s:= string(CGOLD,CRELEAS,CLADDER,CTARGET,CEXIT,CBAR,CGROUND,CHAZARD,CTRAP0,CTRAP1,CFREE)
        if( not strchr(s,bg[arow*DIMCOL+acol]) )
          bg[arow*DIMCOL+acol]:= CFREE
          mvaddch(arow,acol,bg[arow*DIMCOL+acol])
        
        '/* check for anything that matters */
        if( bg[arow*DIMCOL+acol] == CGOLD )
          bg[arow*DIMCOL+acol]:= CFREE        
          mvaddch(arow,acol,bg[arow*DIMCOL+acol])
          add_score(bonus)
        
        if( bg[arow*DIMCOL+acol] == CHAZARD )
          if ((?Random)&$1)>0        
            dir:=LEFT
          else
            dir:=RIGHT
          jst:= (?Random)&$1
        
        lad_row:= arow
        lad_col:= acol
        lad_dir:= dir
        lad_jst:= jst
        if( mvinch(arow,acol) == CDER )
            return DEAD
        mvaddch(arow,acol,laddirs[dir])
    
    case bg[arow*DIMCOL+acol]     
      CTARGET:
        return FINISH
      CTRAP0:
        return DEAD
    
    return NORMAL

PRI over_der(arow,acol)
    '/* Funny how lad jumps over "Sc`o're" - avoid it? Na. */
    if( (mvinch(arow + 1,acol) == CDER) or (mvinch(arow + 2,acol) == CDER) )
        add_score(2)

PRI add_score(adder)
    if( score / 100 < (score + adder) / 100 )
      lads++
      stat_lads
    score += adder
    stat_score


PRI Lad_Died |i,j,rot
    rot:=string( "b+d+q+p+")
    ctnplay
    repeat i from 0 to 4
      repeat j from 0 to strsize(rot) - 1
         mvaddch(lad_row,lad_col,byte[rot+j])
         'move(LINES - 1,0);
         refresh
         waitct


PRI ctnplay  '/* for killed lad & hookas */
    setct(25)

PRI drv_ders| derp,d ,r, n, s  

    'DER *derp;
    'for( derp = ders; derp->row != EOF; derp++ )
    repeat derp from 0 to MAXDERS-1
      d:=ders[derp]
      if (d.byte[3]== 255)'-1 ) 'launch 
        next  
      if(d.byte[3] == 0 )
        r:=drv_der(derp)
        if( r == DEAD )
          return DEAD
        if( r == EXIT )
          d.byte[3]:= 5   '    /* set new start time */
          ders[derp]:=d
        next
      
      d.byte[3]--
      ders[derp]:=d
      if ( d.byte[3] == 0 )
        '/* select a point of release */
        repeat
          n:= (?Random>>1) // nreleases
          s:= releases[n]
          if( s.byte[1] <> EOF )
            d.byte[1]:=s.byte[1]
            d.byte[0]:=s.byte[0]
            d.byte[2]:= XDOWN
            ders[derp]:=d
            quit

    return NOTHING_HAPPENED

PRI drv_der(derp):r|LorR, LorRorD, arow, acol, dir, c, d
    LorR:=dchoice[(?Random>>1)//2]'    dchoice[rand() % 2]
    LorRorD:=dchoice[(?Random>>1)//3]' dchoice[rand() % 3] 

    'static DIR dchoice[] = {LEFT,RIGHT,XDOWN};
    d:=ders[derp]
    arow:=d.byte[1]
    acol:=d.byte[0]
    dir:=d.byte[2]
    
    c:= bg[arow*DIMCOL+acol]  '       /* restore prev content */
    mvaddch(arow,acol,c)
    if( c == CEXIT )
        return EXIT
    repeat    
      if( dir == XDOWN )
        c:= bg[(arow + 1)*DIMCOL+acol]
        if( SOLID(c) )
          dir:= LorR
          next
        arow++        
        quit

      if( dir == LEFT )
        if( acol == 0) or (bg[arow*DIMCOL+acol - 1] == CBAR )
            dir:= RIGHT
            next
        acol--


      if( dir == RIGHT )
        if( acol == DIMCOL - 2) or (bg[arow*DIMCOL+acol + 1] == CBAR )
          dir:= LEFT
          next
        acol++
     
          
      if( bg[arow*DIMCOL+acol] == CLADDER )
        dir:= LorRorD
      else
        c:= bg[(arow + 1)*DIMCOL+acol]
        if( not SOLID(c) )
            dir:= XDOWN
      quit

    c:= mvinch(arow,acol)
    mvaddch(arow,acol,CDER)
    d.byte[1]:= arow
    d.byte[0]:= acol
    d.byte[2]:= dir
    ders[derp]:=d
    if (strchr(@laddirs,c))
      return DEAD
    else
      return NORMAL

PRI strchr(p,c):bool|char 'is c in string p?
  repeat
    char:=byte[p++]
    if (char==c)
      return true
  while char>0
  return false

PRI mvinch(arow,acol):char|i  'retrieve character from screen
  arow<<=1
  i:= array.word[arow * cols + acol]
  char:=(i&$FE)+((i>>10)&$1) 
  

PRI Solid(c):bool
  bool:=(C) == CBAR or (C) == CGROUND or (C) == CTRAP1
  
PRI Stat_Lads 'show # lads
  'row:=DIMROW*2
  'col:=0
  'Print_String(string("Lads "))
  mvaddstr(DIMROW,0,string("Lads "))    
  dec(lads)

PRI Stat_Level 'show # lads
  'row:=DIMROW*2
  'col:=14
  'Print_String(string("Level "))
  mvaddstr(DIMROW,14,string("Level "))    
  dec(level+1)

PRI Stat_Score 'show # lads
  'row:=DIMROW*2
  'col:=29
  'Print_String(string("Score "))
  mvaddstr(DIMROW,29,string("Score "))    
  dec(score*100)

PRI Stat_Bonus 'show # lads
  'row:=DIMROW*2
  'col:=59
  'Print_String(string("Bonus time "))
  mvaddstr(DIMROW,59,string("Bonus time "))
  print(" ")
  dec(bonus*100)
  print_string(string("  "))
  
PRI mvaddstr(arow,acol, s)
  row:=arow*2
  col:=acol
  Print_String(s)

PRI mvaddch(arow,acol,c)
  row:=arow*2
  col:=acol
  Print(c)    
  
PRI CtPlay  'select game speed
  setct(speeds[speed])

PRI SetCt(ms)   'set game speed
  diff:=ms*(CLKFREQ/1000)
  last:=CNT

PRI waitct |now
  'wait for next game clock tick
  now:=CNT    
  last += diff
  if( (last-now)<1000)
    last:= now
  else
    waitcnt(last)
  
  

PRI LdScreen | ps, c, i , brow, pbg, rel,r,d
  'decipher screen data into screen data buffer
  bytefill(@bg," ",DIMROW*DIMCOL) 'clear the screen data buffer
  'init #release points
  rel:=0
    
  ps := @@screens[scrno]  'points to screen data
  'decipher screen data and store in bg
  brow:=0
  pbg:=@bg
  repeat until brow=>(DIMROW)
    c:=byte[ps++]
    case c
      "\": 'backlash followed by 3-digit octal code
        d:=byte[ps++]
        if d<>"\"
          i:=210-((d-"0")*64+(byte[ps++]-"0")*8+(byte[ps++]-"0"))
          repeat i
            byte[pbg++]:=" "
        else   'literal backslash
          byte[pbg++]:=d     
      ",": 'comma code for cr,lf
        '/* find points of release */ for this row before switching to next row
        pbg:= @bg[brow*DIMCOL] 
        repeat i from 0 to DIMCOL-1  '( s = t; s = strchr(s,CRELEAS); s++ )
          if byte[pbg][i]==CRELEAS
            'found a release point
            r.byte[1]:=brow 'rel->lrow = lrow;
            r.byte[0]:=i 'rel->col = s - t;
            releases[rel++]:=r
          
        'print row
        pbg:= @bg[brow*DIMCOL]
        col:=0
        row:=brow<<1
        repeat i from 1 to DIMCOL
          print(byte[pbg++])    
        'advance to next row         
        brow++
        pbg:=@bg[brow*DIMCOL]

      other:
        byte[pbg++]:=c


  '/* mark the rest of releases */
  repeat i from rel to nReleases-1 'for( ; rel < &releases[DIM(releases)]; rel++ )
    r.byte[1]:=r.byte[0]:=EOF                         'rel->lrow = rel->col = EOF; 
    releases[i]:=r

  '/* find lad */
  repeat brow from 0 to DIMROW-1
    pbg:= @bg[brow*DIMCOL]
    repeat i from 0 to DIMCOL-1
      if byte[pbg][i]==CLAD
      '/* nasty, check for CLAD's surrounded by CFREEs */
        if (byte[pbg][i-1]==CFREE) and (byte[pbg][i+1]==CFREE)
          lad_col:=lad_st_col:=i 'column
          lad_row:=lad_st_row:=brow 'row
          lad_dir:=NONE  'dir
          lad_jst:=0   'jst
          byte[pbg][i]:=CFREE
          quit
              
  '/* init ders */
  repeat i from 0 to hiders[scrno]-1
    d.byte[3]:= i + 1  'launch
    d.byte[2]:=XDOWN   'dir
    ders[i]:=d  
  repeat i from hiders[scrno] to MAXDERS-1
    d.byte[3]:=255  '-1  'launch
    ders[i]:=d


    
  refresh  


PRI Refresh | i,j,k  'update screen


PRI Reldscreen|arow,i,j, k,d  'reload/render screen
  row:=0
  col:=0
  k:=@bg
  repeat j from 1 to DIMROW
    repeat i from 1 to DIMCOL
      print(byte[k++])

  '/* deal with lad */
  lad_row:= lad_st_row
  lad_col:= lad_st_col
  lad_dir:= NONE
  lad_jst:= 0
  mvaddch(lad_row,lad_col,CLAD)
   
  '/* deal with ders */
  repeat i from 0 to hiders[scrno]-1
    d:=ders[i]
    d.byte[3]:= i + 1
    d.byte[2]:=XDOWN
    ders[i]:=d
   
  'move(LINES - 1, 0)
  refresh


PRI print_string(ptr)

  repeat while byte[ptr]
    print(byte[ptr++])
    

PRI print(c) |i, k

'' Print a character
''
''       $0D = new line
''  $20..$FF = character
''      $100 = clear screen
''      $101 = home
''      $108 = backspace
''$110..$11F = select color

  case c
    $0D:                'return?
      newline

    $20..$FF:           'character?
      k := color << 1 + c & 1
      i := $200 + (c & $FE) + k << 10
      array.word[row * cols + col] := i
      array.word[(row + 1) * cols + col] := i | 1
      if ++col == cols
        newline

    $100:               'clear screen?
      wordfill(@array, spacetile, tiles)
      col := row := 0

    $101:               'home?
      col := row := 0

    $108:               'backspace?
      if col
        col--

    $110..$11F:         'select color?
      color := c & $F


PRI newline | i

  col := 0
  if (row += 2) == rows
    row -= 2
    'scroll lines
    repeat i from 0 to rows-3
      wordmove(@array.word[i*cols], @array.word[(i+2)*cols], cols)
    'clear new line
    wordfill(@array.word[(rows-2)*cols], spacetile, cols<<1)

PUB dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    print("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      print(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      print("0")
    i /= 10


PUB hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    print(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PUB bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    print((value <-= 1) & 1 + "0")      

DAT

vgacolors long

  long $30003000'$3C043C04       'green on black
  long $30300000
  long $C000C000       'red
  long $C0C00000
  long $30003000       'green
  long $30300000
  long $0C000C00       'blue
  long $0C0C0000
  long $FC00FC00       'white
  long $FCFC0000
  long $FF80FF80       'red/white
  long $FFFF8080
  long $FF20FF20       'green/white
  long $FFFF2020
  long $FF28FF28       'cyan/white
  long $FFFF2828
  long $C0408080       'redbox
  long $3010F020       'greenbox
  long $3C142828       'cyanbox
  long $FC54A8A8       'greybox
  long $3C14FF28       'cyanbox+underscore
  long $F030C050       'graphics colors
  long $881430FC
  long $8008FCA4

hiders byte  5, 8, 5, 5, 7, 6, 6
st_boni long 35,45,33,32,29,29,22
speeds byte  125,100,80,60,40


jra long 0, -1, -1, 0, 0, 1, 1

dchoice byte left,right,xdown
laddirs byte "gbdqp",0


splash byte
        byte "LL\275dd\313dd,"
        byte "LL\275dd\313dd\274tm,"
        byte "LL\311aaaa\315ddddd\316ddddd\316eeee\317rrrrrrr,"
        byte "LL\312aa\320aa\317dd\320dd\317dd\320dd\317ee\320ee\320rr\316rr,"
        byte "LL\312aa\320aa\317dd\320dd\317dd\320dd\317eeeeee\320rr,"
        byte "LL\312aa\320aa\317dd\320dd\317dd\320dd\317ee\314rr,"
        byte "LLLLLLLL\317aaa\321aa\317ddd\321dd\317ddd\321dd\317eeee\317rr,"


instruct byte
        byte "You are a Lad trapped in a maze.  Your mission is to explore the,"
        byte "dark corridors never before seen by human eyes and find hidden,"
        byte "treasures and riches.,"," ,"
        byte "You control Lad by typing the direction buttons and jumping by,"
        byte "typing SPACE.  But beware of the falling rocks called Der rocks.,"
        byte "You must find and grasp the treasure (shown as $) BEFORE the,"
        byte "bonus time runs out.,"," ,"
        byte "A new Lad will be awarded for every 10000 points.,"
        byte "Extra points are awarded for touching the gold,"
        byte "statues (shown as &).  You will receive the bonus time points,"
        byte "that are left when you have finished the level.,"
        byte "Remember:  There is more than one way to skin a cat. (Chum),"
        byte "Type an ESCape to pause the game.,"," ,"
        byte "Good luck Lad.,"," ," ," ,"
        byte "Type RETURN to return to main menu: ,"

screens word @screen0, @screen1, @screen2, @screen3, @screen4, @screen5, @screen6
screen0 byte    'using comma to indicate next line!
        byte "\253V\301$,"
        byte "\231H,"
        byte "\302H\252H,"
        byte "\313=========H==================================================,"
        byte "\302H,"
        byte "\302H,"
        byte "\302H\310H\265H,"
        byte "================H==========H==================\317========H=====================,"
        byte "\302&\310H\265H\310|\313|,"
        byte "\231H\311Easy\321Street,"
        byte "\302H\252H,"
        byte "\313=========H==========H=========\320=======================,"
        byte "\302H,"
        byte "\302H,"
        byte "\302H\252H,"
        byte "========================\321======================\321=========H==============,"
        byte "\231H,"
        byte "\231H,"
        byte "*\316g\237H\276*,"
        byte "===============================================================================,"

screen1 byte
        byte "\210$,"
        byte "\217&\314H,"
        byte "\316H\313|V\235V|\315H,"
        byte "====H=======================\321=========================\321======================,"
        byte "\316H,"
        byte "\316H,"
        byte "\316H\276&\321|\271.\321.\300H,"
        byte "==========================\321======\320===================\321===================H==,"
        byte "\210H,"
        byte "\260|\253H,"
        byte "\316H\265|\301.\320.\300H,"
        byte "====H=====================\317======\320================\320======================,"
        byte "\316H,"
        byte "\316H\274|,"
        byte "\316H\274|\272.\317.\301H,"
        byte "=========================\320========\316==============\317==================H==,"
        byte "\210H,"
        byte "==============\274|\255H,"
        byte "\321Long\321Island\321|\317g\311*\312|\301*\277H,"
        byte "===============================================================================,"

screen2 byte
        byte "\266V\303V\307V\303$,"
        byte "\213$$$,"
        byte "\315g\316H\236H\314$$$$$\317H,"
        byte "==========H===\242=H==============H,"
        byte "\310H\236H\304H,"
        byte "\310H\264&\275H\304H,"
        byte "\315==============\317====\315=\316======\316=\317====\316=====H=====\311H,"
        byte "\316G\304^^^\316^^^^^\321^^^^\314^^^^\321^^^\316^^^\275$,"
        byte "\316h\221|,"
        byte "\316o\315|\275H\265&\313|,"
        byte "\316s\315======================H==============================\321===========,"
        byte "\316t\312&\300H,"
        byte "\262H,"
        byte "\304|\301H\301H\277H,"
        byte "\316T\311==================H=================H===================H=======,"
        byte "\316o\245H\277H,"
        byte "\316w\221H,"
        byte "\316n\267^\255H,"
        byte "*\264^^^\256H\313*,"
        byte "===============================================================================,"
screen3 byte
        byte "\246V\273V,"
        byte ","
        byte "\315H\305H\271|\302H,"
        byte "=====H=====--======H==========================\315===----====H===========,"
        byte "\315H\305H\302|&&\273H,"
        byte "\315H\305H\302==================\312H,"
        byte "\315H\305H\273tunnel\320H\310H,"
        byte "\315H\307=======---===----=================H=\311H\307H,"
        byte "\315H\311|\267vision\320H\310H\307H,"
        byte "\315H\311=========---&\314-----============H\310H\307H,"
        byte "\315H\307H\261H\321|\312H\307H,"
        byte "\315H\307H=========----===----================\312H\320==============,"
        byte "\301H\252&\317H,"
        byte "\301H\252|\317H,"
        byte "====---====\314H\252|\317H,"
        byte "|\311|\316================---===---===================\317H,"
        byte "|\317===\317|\237H\312H\316g,"
        byte "|\316$\316|\237H\315===H=======,"
        byte "|*\320$$$\320*|\317*\302*\313*\275*H\313*H,"
        byte "===============================================================================,"
screen4 byte
        byte "\311$,"
        byte "\311H\237V,"
        byte "\311H,"
        byte "\311HHHHHHHHHHHHH\315.HHHHHHHHHHHHHH\270H\316g,"
        byte "\311&\277V\307H\272==H==========,"
        byte "\251H\270H,"
        byte "\317H\255H\312.\301H,"
        byte "===H==============-----------============H====\274H,"
        byte "\317H\234H\311H,"
        byte "\317H\241=====H==============,"
        byte "\317H\255H\302H,"
        byte "\317H\304&..^^^.....^..^\321.\321^^\317H==---------\315H,"
        byte "\317H\311============================H\316&\307H\305H,"
        byte "\317H\311===\314===\314===\313H\316---------=================H======,"
        byte "\317H\255H\264H,"
        byte "\317H\270&\310H\310&\277H,"
        byte "\317==========-------------------------=======----------===================,"
        byte ","
        byte "^^^*\311^^^^^^^^^^^^^^^^^^^^^^^^^*\315*^^^^^^^^^^*Point\321of\321No\321Return*^^^^,"
        byte "===============================================================================,"
screen5 byte
        byte "\312Bug\321City\305HHHHHHHH\270V,"
        byte "\267HHH\314HHH,"
        byte "\317H\250>mmmmmmmm,"
        byte "\317H===============\277====================\310H,"
        byte "\317H\304|=====\313\\\320/\311V\300=====H==========,"
        byte "\317H\266\\/\260H,"
        byte "\317H\252|\321$\275H,"
        byte "\317H\307H\266|\321H\275H,"
        byte "\317H\313====H=======\310g\310|&H\316H\302H,"
        byte "\317H\307H\305======================H\307======,"
        byte "\317H\307H\314&|\267H\276H,"
        byte "\317H\307H\314&|\276H\314H\315}{\312=====H====,"
        byte "===H===&\313H\313=====================H\314H\276H,"
        byte "\303H\266H\314H\276H,"
        byte "\303H\266H\314&\276H,"
        byte "\311======H===\317=======\316H\316<>\316&\267H,"
        byte "\261H==========\313=====\315=\315============,"
        byte "\315}i{\271H,"
        byte "*\262H\246*,"
        byte "===============================================================================,"
screen6 byte
        byte "\276=Gang\321Land=\265V\311.,"
        byte "\277==\314_\320==\254.,"
        byte "\314g\316H\312|\320[]\321|_|\321|\300&\276.\320H,"
        byte "===========H\312|\315|_|\321|\313H\311===\317===================H,"
        byte "\314V\316H\312=============\315H======\266H,"
        byte "\307H\270H\275&\306H,"
        byte "\307H\270H\302|\316|\306H,"
        byte "\316H\314H\312^^^&&^^^\321&\321^\320^^^\321H\307H\316|\316=============H,"
        byte "\316H======H\317=======================H===========H=====\310&\314H,"
        byte "\316H\261H\307H\316|\311&&&\315H,"
        byte "\316H\261H\307H\316|\312&&&&&\316H,"
        byte "\316H\261H\307H\316|\316=============H,"
        byte "\304=====------=================\312H\316|\313$\315$,"
        byte "\251|\312H\316|\314$$$\317$$$,"
        byte "====------===\266|\312H\316|\315$$$$$\321$$$$$,"
        byte "\306|\313=\276|\321=============\316============,"
        byte "\306|\313$\275^\310&,"
        byte "\306|^^^^^^^^^^^^^^\314$\321^\304======,"
        byte "*\277.\314&\317^\321H*^\276^\320^\313^^^^^^^^^^^^,"
        byte "===============================================================================,"        
