'******************************************************************************
'*  trs80_video.spin - Output a 12 scanline bitmap
'*
'*  This is based on ideas and code from Debug_1pinTV by "Cluso99"
'*
'*  (c) Juergen Buchmueller <pullmoll@t-online.de>
'*
'* $Id: video.spin,v 1.1.1.1 2010-05-11 16:35:19 pm Exp $
'******************************************************************************
CON
	_xinfreq		= 5_000_000		' Quartz is 5MHz
	_clkmode		= xtal1 + pll16x	' System clock is 80MHz

#ifdef NTSC
'' NTSC 64x16 at 6x15px
ocols			=	64			' number of columns
orows			=	16*12/8			' number of rows
ocolsfrq		=	22_478			' Hz per active pixel
oequal1			=	6			' number of equalization pulses
oserr			=	6			' number of serration pulses
oequal2			=	6			' number of equalization pulses
oblank1			=	12			' number of blank lines
oactive			=	240			' number of active lines
oblank2			=	1			' number of blank lines
ohalf			=	274			' VSCL half line
obackp			=	75	 		' VSCL back porch (sync to active)
ofrontp			=	49			' VSCL front porch (active to sync)
oequal			=	20			' VSCL equalization pulse (sync/2)
osync			=	40			' VSCL sync pulse
osynch			=	234			' VSCL half-sync
oequalh			=	254			' VSCL half-equal
ovsclch			=	24			' VSCL character (24 pixels)
ictra			=	12			' CTRA with PLLdiv
ifrqa			=	231701456		' required FRQA value (5MHz*16) (xfrqa replaced by start routine)
ifrqb			=	$4924_0000		' 40/140 << 32 = 1,227,096,064

ifrqa_80MHz		=	231701456		' required FRQA value (5MHz*16)
ifrqa_96MHz		=	257446064		' required FRQA value (6MHz*16)
ifrqa_100MHz		=	247148224		' required FRQA value (6.25MHz*16)
ifrqa_104MHz		=	237642512		' required FRQA value (6.5MHz*16)
ifrqa_108MHz		=	228840944		' required FRQA value (13.5MHz*8)
ifrqa_115MHz		=	161813984		' required FRQA value (14.319MHz*8)
#endif

'--------------------------------------------------------------------------------------------------
#ifdef PAL
'' PAL	64x16 at 6x15px
ocols			=	64			' number of columns
orows			=	16*12/8			' number of rows
ocolsfrq		=	22_321			' Hz per active pixel
oequal1			=	4			' number of equalization pulses
oserr			=	5			' number of serration pulses
oequal2			=	5			' number of equalization pulses
oblank1			=	39			' number of blank lines
oactive			=	240			' number of active lines
oblank2			=	25			' number of blank lines
ohalf			=	273			' VSCL half line
obackp			=	80			' VSCL back porch (sync to active)
ofrontp			=	43			' VSCL front porch (active to sync)
oequal			=	19			' VSCL equalization pulse (sync/2)
osync			=	39			' VSCL sync pulse
osynch			=	234			' VSCL half-sync
oequalh			=	254			' VSCL half-equal
ovsclch			=	24			' VSCL character (24 pixels)
ictra			=	12			' CTRA with PLLdiv
ifrqa			=	230083104		' required FRQA value (5MHz*16) (xfrqa replaced by start routine)
ifrqb			=	$4924_0000		' 40/140 << 32 = 1,227,096,064

ifrqa_80MHz		=	230083104		' required FRQA value (5MHz*16)
ifrqa_96MHz		=	191735920		' required FRQA value (6MHz*16)
ifrqa_100MHz		=	184066480		' required FRQA value (6.25MHz*16)
ifrqa_104MHz		=	176987008		' required FRQA value (6.5MHz*16)
ifrqa_108MHz		=	170431936		' required FRQA value (13.5MHz*8)
ifrqa_115MHz		=	160683776		' required FRQA value (14.319MHz*8)
#endif
'--------------------------------------------------------------------------------------------------

VAR
	long	cog
	long	i

PUB start(params) : okay
' bitmap is the address of the bitmap buffer * 32 + the tvPin number

	stop
	Setforxtalfreq					'set ifrqa in hub for the current clkfreq before cognew 
	screen_ptr := long[params][0]
	pin_no := long[params][1]
	okay := cog := COGNEW(@entry, 0) + 1

PUB stop
	if cog
		COGSTOP(cog - 1)
		cog := 0

PRI Setforxtalfreq
'' Set the frqa value depending on the actual clkfreq
	Case clkfreq
		 80_000_000: xfrqa := ifrqa_80MHz	' 5.00 MHz
		 96_000_000: xfrqa := ifrqa_96MHz	' 6.00 MHz
		100_000_000: xfrqa := ifrqa_100MHz	' 6.25 MHz
		104_000_000: xfrqa := ifrqa_104MHz	' 6.50 MHz
		108_000_000: xfrqa := ifrqa_108MHz	'13.50 MHz
		114_552_000: xfrqa := ifrqa_115MHz      '14.319 MHz

DAT
		org	0
entry
		mov	FRQB, xfrqb			' default = 40/140

		movi	CTRA, #ictra
		mov	FRQA, xfrqa

		movs	CTRB, pin_no			' set pin
		mov	count, #1
		shl	count, pin_no
		mov	DIRA, count			' set pin mask
		mov	count, pin_no
		shr	count, #3
		movd	VCFG, count			' set VGroup
		mov	count, #1
		and	pin_no, #7
		shl	count, pin_no
		movs	VCFG, count			' set VPins
		movi	VCFG, #%0_01_0_0_0_000		' VGA mode, 1 bit per pixel
		movd	VSCL, #(1 << 3)			' 1 PLL per pixel

'**************************************************************************************************
frame		add	framectr, #1			' inc frame counter
		mov	rows, #oequal1
		call	#equalizing
'--------------------------------------------------------------------------------------------------
		mov	rows, #oserr			' serration pulses
		call	#serration
'--------------------------------------------------------------------------------------------------
		mov	rows, #oequal2
		call	#equalizing
'==================================================================================================
		mov	rows, #oblank1
		call	#doblank
'==================================================================================================
'display active lines
		mov	fontindex, font_ptr
		mov	scrptr0, screen_ptr		' initialize bitmap pointer
		mov	rows, #oactive
doactive
		movs	VSCL, #osync			' 4.7uSec @ -40 IRE
		waitvid xFF00, #0
		movi	CTRB, #0			' turn off blank
		movs	VSCL, #obackp			' back porch
		waitvid xFF00, #0
		movi	CTRB, #%0_00110_000		' turn on blank
		movs	VSCL, #ovsclch			' 1 PLLA per pixel, 24 PLLA per frame
		mov	count, #ocols/4			' character sper line / 2, since we do 2 at a time
		mov	scrptr, scrptr0
'--------------------------------------------------------------------------------------------------
:active
		rdlong	ch4, scrptr			' fetch 4 character codes
		add	scrptr, #4			' advance to next long
		mov	ch, ch4				' get characters
		and	ch, #$ff			' mask first one
		cmp	ch, #$20	WC
	if_c	add	ch, #$40
		add	ch, fontindex			' + fontindex = address of font long
		rdbyte	bits0, ch			' read to bits0
		shr	ch4, #8
		mov	ch, ch4				' get characters
		and	ch, #$ff			' mask second one
		cmp	ch, #$20	WC
	if_c	add	ch, #$40
		add	ch, fontindex			' + fontindex = address of font long
		rdbyte	bits1, ch			' read to bits1
		shr	ch4, #8
		mov	ch, ch4				' get characters
		and	ch, #$ff			' mask third one
		cmp	ch, #$20	WC
	if_c	add	ch, #$40
		add	ch, fontindex			' + fontindex = address of font long
		rdbyte	bits2, ch			' read to bits2
		shr	ch4, #8
		shl	bits1, #6			' put bitmask 1 in 11..6
		shl	bits2, #12			' put bitmask 2 in 17..12
		cmp	ch4, #$20	WC
	if_c	add	ch4, #$40
		add	ch4, fontindex			' fourth character + fontindex = address of font byte
		rdbyte	bits3, ch4			' read to bits3
		shl	bits3, #18			' put bitmask 3 in 23..18
		or	bits0, bits1			' combine the bitmasks
		or	bits0, bits2
		or	bits0, bits3
		waitvid	xFF00, bits0			' output to screen
		djnz	count, #:active			' do entire line
'--------------------------------------------------------------------------------------------------

		add	fontindex, #256
		cmp	fontindex, font_end	WZ
	if_z	mov	fontindex, font_ptr
	if_z	add	scrptr0, #ocols

		movs	VSCL, #ofrontp			' front porch
		waitvid xFF00, #0			' output blank
		djnz	rows, #doactive			' next row
'==================================================================================================
		mov	rows, #oblank2
		call	#doblank
'==================================================================================================
		jmp	#frame
'**************************************************************************************************
equalizing
		movs	VSCL, #oequal			' equalizing pulse (short)
		waitvid xFF00, #0
		movi	CTRB, #0			' turn off blank
		movs	VSCL, #oequalh			' equalizing pulse (long)
		waitvid xFF00, #0
		movi	CTRB, #%0_00110_000		' turn on blank
		djnz	rows, #equalizing
equalizing_ret
		ret
'--------------------------------------------------------------------------------------------------
serration
		movs	VSCL, #osynch			' serration pulse (long)
		waitvid xFF00, #0		
		movi	CTRB, #0			' turn off blank
		movs	VSCL, #osync			' serration pulse (short)
		waitvid xFF00, #0
		movi	CTRB, #%0_00110_000		' turn on blank
		djnz	rows, #serration
serration_ret
		ret
'--------------------------------------------------------------------------------------------------
doblank
		movs	VSCL, #osync			' 4.7uSec @ -40 IRE
		waitvid xFF00, #0
		movi	CTRB, #0			' turn off blank
		movs	VSCL, #osynch			' serration pulse (long)
		waitvid xFF00, #0
		movi	CTRB, #%0_00110_000		' turn on blank
		movs	VSCL, #ohalf			' half line ???
		waitvid xFF00, #0
		djnz	rows, #doblank
doblank_ret
		ret
'--------------------------------------------------------------------------------------------------
'constants > $1FF
xhalf		long	ohalf
xfrqa		long	ifrqa
xfrqb		long	ifrqb

xFF00		long	$FF00			' white / black
x400		long	$400
font_ptr	long	@@@font
font_end	long	@@@font + 256*15
screen_ptr	long	0
pin_no		long	0

ch		long	0
ch4		long	0
bits0		long	0
bits1		long	0
bits2		long	0
bits3		long	0
fontindex	long	0
fontshift	long	0
scrptr0		long	0			' pointer to screen data per character row
scrptr		long	0			' pointer to screen data per scanline
framectr	long	0
count		long	0			' all purpose counter
rows		long	0			' row counter
t1		long	0

		fit	$1f0

font
				' scanrow 0
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######

				' scanrow 1
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%000100	' ..#...
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%100000	' .....#
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%010100	' ..#.#.
		byte	%010100	' ..#.#.
		byte	%001000	' ...#..
		byte	%000110	' .##...
		byte	%000100	' ..#...
		byte	%001100	' ..##..
		byte	%010000	' ....#.
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%010000	' ....#.
		byte	%111110	' .#####
		byte	%011000	' ...##.
		byte	%111110	' .#####
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%011110	' .####.
		byte	%011100	' ..###.
		byte	%011110	' .####.
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%111100	' ..####
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%011110	' .####.
		byte	%011100	' ..###.
		byte	%011110	' .####.
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%011000	' ...##.
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%100000	' .....#
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%001000	' ...#..
		byte	%000100	' ..#...
		byte	%000100	' ..#...
		byte	%010100	' ..#.#.
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######

				' scanrow 2
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%101000	' ...#.#
		byte	%010100	' ..#.#.
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%010100	' ..#.#.
		byte	%010100	' ..#.#.
		byte	%111100	' ..####
		byte	%100110	' .##..#
		byte	%001010	' .#.#..
		byte	%001100	' ..##..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%001100	' ..##..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%011000	' ...##.
		byte	%000010	' .#....
		byte	%000100	' ..#...
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%010100	' ..#.#.
		byte	%100100	' ..#..#
		byte	%100010	' .#...#
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%010010	' .#..#.
		byte	%000010	' .#....
		byte	%110110	' .##.##
		byte	%100110	' .##..#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100000	' .....#
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%011000	' ...##.
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%100000	' .....#
		byte	%000000	' ......
		byte	%101000	' ...#.#
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######

				' scanrow 3
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%010000	' ....#.
		byte	%110110	' .##.##
		byte	%010000	' ....#.
		byte	%100010	' .#...#
		byte	%011110	' .####.
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%000100	' ..#...
		byte	%110110	' .##.##
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%010000	' ....#.
		byte	%010100	' ..#.#.
		byte	%100000	' .....#
		byte	%010100	' ..#.#.
		byte	%011100	' ..###.
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%010100	' ..#.#.
		byte	%111110	' .#####
		byte	%001010	' .#.#..
		byte	%010000	' ....#.
		byte	%001010	' .#.#..
		byte	%000100	' ..#...
		byte	%000100	' ..#...
		byte	%010000	' ....#.
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%110010	' .#..##
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%100000	' .....#
		byte	%010100	' ..#.#.
		byte	%011110	' .####.
		byte	%000010	' .#....
		byte	%010000	' ....#.
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001100	' ..##..
		byte	%001100	' ..##..
		byte	%000100	' ..#...
		byte	%111110	' .#####
		byte	%010000	' ....#.
		byte	%100000	' .....#
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%001010	' .#.#..
		byte	%000010	' .#....
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%010100	' ..#.#.
		byte	%010100	' ..#.#.
		byte	%010000	' ....#.
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%000100	' ..#...
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%011010	' .#.##.
		byte	%011100	' ..###.
		byte	%101100	' ..##.#
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%101100	' ..##.#
		byte	%011010	' .#.##.
		byte	%001100	' ..##..
		byte	%100000	' .....#
		byte	%010010	' .#..#.
		byte	%001000	' ...#..
		byte	%010110	' .##.#.
		byte	%011010	' .#.##.
		byte	%011100	' ..###.
		byte	%011010	' .#.##.
		byte	%101100	' ..##.#
		byte	%011010	' .#.##.
		byte	%111100	' ..####
		byte	%111110	' .#####
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%010000	' ....#.
		byte	%010100	' ..#.#.
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######

				' scanrow 4
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%111100	' ..####
		byte	%101010	' .#.#.#
		byte	%001010	' .#.#..
		byte	%111110	' .#####
		byte	%100100	' ..#..#
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%111110	' .#####
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%111110	' .#####
		byte	%111010	' .#.###
		byte	%111010	' .#.###
		byte	%101110	' .###.#
		byte	%101110	' .###.#
		byte	%101010	' .#.#.#
		byte	%010100	' ..#.#.
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%000100	' ..#...
		byte	%111110	' .#####
		byte	%101110	' .###.#
		byte	%101110	' .###.#
		byte	%111010	' .#.###
		byte	%111010	' .#.###
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%010100	' ..#.#.
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%000100	' ..#...
		byte	%000010	' .#....
		byte	%000100	' ..#...
		byte	%010000	' ....#.
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%011000	' ...##.
		byte	%010010	' .#..#.
		byte	%100000	' .....#
		byte	%011110	' .####.
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%111100	' ..####
		byte	%000000	' ......
		byte	%001100	' ..##..
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%100000	' .....#
		byte	%010000	' ....#.
		byte	%101100	' ..##.#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%000010	' .#....
		byte	%100100	' ..#..#
		byte	%001110	' .###..
		byte	%001110	' .###..
		byte	%110010	' .#..##
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%000110	' .##...
		byte	%000010	' .#....
		byte	%101010	' .#.#.#
		byte	%110010	' .#..##
		byte	%100010	' .#...#
		byte	%011110	' .####.
		byte	%100010	' .#...#
		byte	%011110	' .####.
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%010100	' ..#.#.
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%100000	' .....#
		byte	%100110	' .##..#
		byte	%100010	' .#...#
		byte	%110010	' .#..##
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%110010	' .#..##
		byte	%100110	' .##..#
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001010	' .#.#..
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%100110	' .##..#
		byte	%100010	' .#...#
		byte	%100110	' .##..#
		byte	%110010	' .#..##
		byte	%100110	' .##..#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%010100	' ..#.#.
		byte	%100010	' .#...#
		byte	%010000	' ....#.
		byte	%000100	' ..#...
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111111	' ######

				' scanrow 5
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%001000	' ...#..
		byte	%110110	' .##.##
		byte	%000110	' .##...
		byte	%010100	' ..#.#.
		byte	%101000	' ...#.#
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%101010	' .#.#.#
		byte	%000100	' ..#...
		byte	%110110	' .##.##
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%000110	' .##...
		byte	%010100	' ..#.#.
		byte	%100000	' .....#
		byte	%010100	' ..#.#.
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%111110	' .#####
		byte	%101000	' ...#.#
		byte	%000100	' ..#...
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%010000	' ....#.
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%100110	' .##..#
		byte	%001000	' ...#..
		byte	%000010	' .#....
		byte	%100000	' .....#
		byte	%111110	' .#####
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%000100	' ..#...
		byte	%100010	' .#...#
		byte	%100000	' .....#
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%111110	' .#####
		byte	%010000	' ....#.
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%111110	' .#####
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%001010	' .#.#..
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%101010	' .#.#.#
		byte	%001010	' .#.#..
		byte	%100000	' .....#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%010100	' ..#.#.
		byte	%101010	' .#.#.#
		byte	%010100	' ..#.#.
		byte	%001000	' ...#..
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%000100	' ..#...
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%111100	' ..####
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%110010	' .#..##
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%000110	' .##...
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%010100	' ..#.#.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 6
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%010000	' ....#.
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%010100	' ..#.#.
		byte	%100000	' .....#
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%010100	' ..#.#.
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%101010	' .#.#.#
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%010100	' ..#.#.
		byte	%011110	' .####.
		byte	%110010	' .#..##
		byte	%010010	' .#..#.
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%001000	' ...#..
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%001100	' ..##..
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%010000	' ....#.
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%010000	' ....#.
		byte	%001100	' ..##..
		byte	%001100	' ..##..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100100	' ..#..#
		byte	%100010	' .#...#
		byte	%100100	' ..#..#
		byte	%000010	' .#....
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%010010	' .#..#.
		byte	%000010	' .#....
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%000010	' .#....
		byte	%010010	' .#..#.
		byte	%010010	' .#..#.
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%110110	' .##.##
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%100010	' .#...#
		byte	%100110	' .##..#
		byte	%100010	' .#...#
		byte	%110010	' .#..##
		byte	%000010	' .#....
		byte	%001000	' ...#..
		byte	%101100	' ..##.#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%001010	' .#.#..
		byte	%001000	' ...#..
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%100110	' .##..#
		byte	%110010	' .#..##
		byte	%000010	' .#....
		byte	%100000	' .....#
		byte	%101000	' ...#.#
		byte	%110010	' .#..##
		byte	%010100	' ..#.#.
		byte	%101010	' .#.#.#
		byte	%010100	' ..#.#.
		byte	%111100	' ..####
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%101010	' .#.#.#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 7
		byte	%111110	' .#####
		byte	%000010	' .#....
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%100000	' .....#
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%110110	' .##.##
		byte	%100000	' .....#
		byte	%000000	' ......
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%110110	' .##.##
		byte	%100000	' .....#
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%010100	' ..#.#.
		byte	%001000	' ...#..
		byte	%110000	' ....##
		byte	%101100	' ..##.#
		byte	%000000	' ......
		byte	%010000	' ....#.
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%111110	' .#####
		byte	%011100	' ..###.
		byte	%010000	' ....#.
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%000010	' .#....
		byte	%011100	' ..###.
		byte	%001100	' ..##..
		byte	%000000	' ......
		byte	%001100	' ..##..
		byte	%010000	' ....#.
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%100010	' .#...#
		byte	%011110	' .####.
		byte	%011100	' ..###.
		byte	%011110	' .####.
		byte	%111110	' .#####
		byte	%000010	' .#....
		byte	%111100	' ..####
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%011100	' ..###.
		byte	%100010	' .#...#
		byte	%111110	' .#####
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%000010	' .#....
		byte	%101100	' ..##.#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%100010	' .#...#
		byte	%100010	' .#...#
		byte	%001000	' ...#..
		byte	%111110	' .#####
		byte	%001000	' ...#..
		byte	%001000	' ...#..
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%111110	' .#####
		byte	%000000	' ......
		byte	%111100	' ..####
		byte	%011010	' .#.##.
		byte	%011100	' ..###.
		byte	%101100	' ..##.#
		byte	%011100	' ..###.
		byte	%001000	' ...#..
		byte	%100000	' .....#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%100000	' .....#
		byte	%010010	' .#..#.
		byte	%011100	' ..###.
		byte	%101010	' .#.#.#
		byte	%100010	' .#...#
		byte	%011100	' ..###.
		byte	%011010	' .#.##.
		byte	%101100	' ..##.#
		byte	%000010	' .#....
		byte	%011110	' .####.
		byte	%010000	' ....#.
		byte	%101100	' ..##.#
		byte	%001000	' ...#..
		byte	%010100	' ..#.#.
		byte	%100010	' .#...#
		byte	%100000	' .....#
		byte	%111110	' .#####
		byte	%010000	' ....#.
		byte	%001000	' ...#..
		byte	%000100	' ..#...
		byte	%000000	' ......
		byte	%010100	' ..#.#.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 8
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000100	' ..#...
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%100010	' .#...#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%100010	' .#...#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%100000	' .....#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%100010	' .#...#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 9
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000010	' .#....
		byte	%100000	' .....#
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%011100	' ..###.
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 10
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 11
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 12
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 13
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######

				' scanrow 14
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000000	' ......
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%000111	' ###...
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111000	' ...###
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
		byte	%111111	' ######
{{
+------------------------------------------------------------------------------------------------------------------------------+
|				    TERMS OF USE: Parallax Object Exchange License					       |
+------------------------------------------------------------------------------------------------------------------------------+
|Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    | |files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    |
|modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software|
|is furnished to do so, subject to the following conditions:                                                                   |
|                                                                                                                              |
|The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.|
|                                                                                                                              |
|THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE	       |
|WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         |
|COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   |
|ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         |
+------------------------------------------------------------------------------------------------------------------------------+
}}
