DAT
	org	0


' period_a is half the period of the square wave. Here, in each loop I add period_a
' twice, so that at the end of the loop the square wave is in the same status (0 or 1)
' it was at the start.
' vola is also incremented by period_a, since the wave has been 1 exactly half
' of the time, regardless of the initial position.
' If we exit the loop in the middle, output_a has to be inverted and vola
' incremented only if the exit status of the square wave is 1.

update
			mov	nextevent, step
			min	nextevent, count_n
:channel_a
			test	outn, #%00001000	wz	' channel A enabled?
		if_nz	jmp	#:channel_a_off

			cmp	output_a, #0		wz
		if_nz	add	vola, count_a
			sub	count_a, nextevent
:channel_a_on_loop
			cmps	count_a, #0		wz, wc
		if_a	jmp	#:channel_a_on_done
			add	count_a, period_a
			cmps	count_a, #0		wz, wc
		if_a	xor	output_a, #1		wz
		if_a	add	vola, period_a
		if_a	jmp	#:channel_a_on_done
			add	count_a, period_a
			add	vola, period_a
			jmp	#:channel_a_on_loop
:channel_a_on_done
			cmp	output_a, #1		wz
		if_z	sub	vola, period_a
			jmp	#:channel_b
:channel_a_off
			sub	count_a, nextevent
:channel_a_off_loop
			cmps	count_a, #0		wz, wc
		if_a	jmp	#:channel_b
			add	count_a, period_a
			cmps	count_a, #0		wz, wc
		if_a	xor	output_a, #1		wz
		if_a	jmp	#:channel_b
			add	count_a, period_a
			jmp	#:channel_a_off_loop

:channel_b
			test	outn, #%00010000	wz	' channel B enabled?
		if_nz	jmp	#:channel_b_off

			cmp	output_b, #0		wz
		if_nz	add	volb, count_b
			sub	count_b, nextevent
:channel_b_on_loop
			cmps	count_b, #0		wz, wc
		if_b	jmp	#:channel_b_on_done
			add	count_b, period_b
			cmps	count_b, #0		wz, wc
		if_a	xor	output_b, #1		wz
		if_a	add	volb, period_b
		if_a	jmp	#:channel_b_on_done
			add	count_b, period_b
			add	volb, period_b
			jmp	#:channel_b_on_loop
:channel_b_on_done
			cmp	output_b, #1		wz
		if_z	sub	volb, period_b
			jmp	#:channel_c
:channel_b_off
			sub	count_b, nextevent
:channel_b_off_loop
			cmps	count_b, #0		wz, wc
		if_b	jmp	#:channel_c
			add	count_b, period_b
			cmps	count_b, #0		wz, wc
		if_a	xor	output_b, #1		wz
		if_a	jmp	#:channel_c
			add	count_b, period_b
			jmp	#:channel_b_off_loop

:channel_c
			test	outn, #%00100000	wz	' channel C enabled?
		if_nz	jmp	#:channel_c_off

			cmp	output_c, #0		wz
		if_nz	add	volc, count_c
			sub	count_c, nextevent
:channel_c_on_loop
			cmps	count_c, #0		wz, wc
		if_b	jmp	#:channel_c_on_done
			add	count_c, period_c
			cmps	count_c, #0		wz, wc
		if_a	xor	output_c, #1		wz
		if_a	add	volc, period_c
		if_a	jmp	#:channel_c_on_done
			add	count_c, period_c
			add	volc, period_c
			jmp	#:channel_c_on_loop
:channel_c_on_done
			cmp	output_c, #1		wz
		if_z	sub	volc, period_c
			jmp	#:channel_n
:channel_c_off
			sub	count_c, nextevent
:channel_c_off_loop
			cmps	count_c, #0		wz, wc
		if_b	jmp	#:channel_n
			add	count_c, period_c
			cmps	count_c, #0		wz, wc
		if_a	xor	output_c, #1		wz
		if_a	jmp	#:channel_c
			add	count_c, period_c
			jmp	#:channel_c_off_loop


nextevent	long	0
count_a		long	0
count_b		long	0
count_c		long	0
output_a	long	0
output_b	long	0
output_c	long	0
update_step	long	0
step		long	$8000
