'******************************************************************************
'*  trs80.spin - Demo mode for the TRS80 video and render cogs
'*
'*  (c) Juergen Buchmueller <pullmoll@t-online.de>
'*
'* $Id: trs80.spin,v 1.3 2010-06-05 06:38:15 pm Exp $
'******************************************************************************
CON
	_xinfreq		= 5_000_000		' Quartz is 5MHz
	_clkmode		= xtal1 + pll16x	' System clock is 80MHz

' We need a Z80 to run
#define CPU_Z80

' Memory access dispatch tables for TRS-80 in yaz80
#define TRS80

' If you want to use 1pin TV out, define TV and the video norm
'#define TV
'#define NTSC
#define PAL

' If you want to use VGA out, define VGA and disable the #define TV above
#define VGA

'#define TriBladeProp
'#define RamBladeProp
#define DracBladeProp

' Uncomment to have debug code inserted
'#define DEBUG

' Uncomment to emulate interrupts (NMI and IRQ)
'#define INTERRUPTS

' Uncomment to count cycles
'#define COUNT_C

' Uncomment to count R register
#define COUNT_R


#ifdef TriBladeProp
' serial I/O pins on the TriBladeProp #2
	SI			= 31
	SO			= 30
' SD pins on the TriBladeProp #2
	doPin			= 9
	clkPin			= 28
	diPin			= 8
	csPin			= 14
' TV out pin
	tvPin			= 14
' Keyboard pins
	kbDpin			= 26
	kbCpin			= 27
' audio pin
	auPin			= 16	' ???
#endif

#ifdef RamBladeProp
' serial I/O pins on the RamBladeProp
	SI			= 23
	SO			= 22
' microSD pins on RamBladeProp
	doPin			= 24
	clkPin			= 26
	diPin			= 25
	csPin			= 19
' TV out pin
	tvPin			= 14
' Keyboard pins
	kbDpin			= 26
	kbCpin			= 27
' audio pin
	auPin			= 22	' ??? instead of SO?
#endif

#ifdef DracBladeProp
' serial I/O pins on the DracBladeProp
	SI			= 31
	SO			= 30
' SD pins on the DracBladeProp
	doPin			= -1'12
	clkPin			= -1'13
	diPin			= -1'14
	csPin			= -1'15
' TV out pin
	tvPin			= 8'16
' Keyboard pins
	kbDpin			= 17'26
	kbCpin			= 16'27
' audio pin
	auPin			= -1'24	' SIO2 TX
#endif
con

        speccy_rom_load         = 1

'          HC138   --------+
'          clk     -------+|
'          /wr     ------+||
'          /hs     -----+||| +------------------------- /cs
'                       |||| |                 -------- d0..d7
DB_IN            = %00001000_00000000_00000000_00000000 'maske: dbus-eingabe
DB_OUT           = %00001000_00000000_00000000_11111111 'maske: dbus-ausgabe

M1               = %00000010_00000000_00000000_00000000
M2               = %00000010_10000000_00000000_00000000 'busclk=1? & /cs=0?

M3               = %00000000_00000000_00000000_00000000
M4               = %00000010_00000000_00000000_00000000 'busclk=0?


'signaldefinitionen bellatrixix

#24,    HC138                                           'front-led, HC138
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal

VAR
	byte	pins[10]
	long	params[3]

OBJ
	io	: "io"
	qz80	: "qz80"

PUB     main : okay
        dira := db_in                                                                                          'datenbus auf eingabe schalten
        outa[bus_hs] := 1

	pins[ 0] := SI					' currently unused
	pins[ 1] := SO
	pins[ 2] := doPin
	pins[ 3] := clkPin
	pins[ 4] := diPin
	pins[ 5] := csPin
	pins[ 6] := kbDpin
	pins[ 7] := kbCpin
	pins[ 8] := auPin
	pins[ 9] := tvPin

	okay := io.start(@pins)
	if okay < 0
		repeat

	params[0] := io.command_addr
	params[1] := 0					' interrupts not used
	params[2] := io.get_videoram
	qz80.start(@params, 0)

''      MIT LICENSE
{{
'  Permission is hereby granted, free of charge, to any person obtaining
'  a copy of this software and associated documentation files
'  (the "Software"), to deal in the Software without restriction,
'  including without limitation the rights to use, copy, modify, merge,
'  publish, distribute, sublicense, and/or sell copies of the Software,
'  and to permit persons to whom the Software is furnished to do so,
'  subject to the following conditions:
'
'  The above copyright notice and this permission notice shall be included
'  in all copies or substantial portions of the Software.
'
'  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
'  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
'  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
'  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
'  CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
'  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
'  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
}}
