#!/bin/sh
################################################################################
## 20170514/yeti
##
## - Uebersetung des DOSWIN-World-make.bat in make.bstc.sh
## - relative Pfade beginnen deutlichkeitshalber mit "./"
## - Umlaute vermeiden
## - Doku-Kommentare sind Doppel-#, Kommentare zum Code ausblenden Einzel-#
##------------------------------------------------------------------------------
## 20170515/yeti
##
## - auch Enddatum ausgeben
################################################################################
set -e ## exit on error
set -x ## echo commands
##------------------------------------------------------------------------------
## Startzeit?

date
echo

##------------------------------------------------------------------------------
## Pfade

sd="./bin/sdcard"
sd_sys="./bin/sdcard/system"
flash="./bin/flash"
libpath="./lib"

BSTC="/opt/bst/bin/bstc"

##------------------------------------------------------------------------------
## Alte Versionen loeschen

rm -f ${flash}/*.*
rm -f ${sd}/*.*
rm -f ${sd_sys}/*.*

##------------------------------------------------------------------------------
## Flashdateien erzeugen
## --> ./bin/flash

${BSTC} -L ${libpath} -b -O a ./flash/administra/admflash.spin
cp admflash.binary ${flash}/
mv admflash.binary ${sd_sys}/admsys.adm

${BSTC} -L ${libpath} -D __VGA -b -O a ./flash/bellatrix/belflash.spin
cp belflash.binary ${flash}
mv belflash.binary ${sd_sys}/vga.bel

${BSTC} -L ${libpath} -D __TV -b -O a ./flash/bellatrix/belflash.spin
mv belflash.binary ${sd_sys}/tv.bel

${BSTC} -L ${libpath} -b -O a ./flash/regnatix/regflash.spin
mv regflash.binary ${flash}

##------------------------------------------------------------------------------
## Startdateie erzeugen
## reg.sys	(Regime)
## --> ./bin/sdcard/

${BSTC} -L ${libpath} -b -O a ./system/regnatix/regime.spin
mv regime.binary ${sd}/reg.sys

##------------------------------------------------------------------------------
## Slave-Dateien erzeugen
## admsid, admay, admterm
## htxt, g0key

${BSTC} -L ${libpath} -b -O a ./system/administra/admsid/admsid.spin
${BSTC} -L ${libpath} -b -O a ./system/administra/admay/admay.spin
${BSTC} -L ${libpath} -b -O a ./system/administra/admnet/admnet.spin
for i in *.binary ; do mv ${i} ${sd_sys}/${i%%.binary}.adm ; done


${BSTC} -L ${libpath} -b -O a ./system/bellatrix/bel-htext/htext.spin
${BSTC} -L ${libpath} -b -O a ./system/bellatrix/bel-g0/g0key.spin
for i in *.binary ; do mv ${i} ${sd_sys}/${i%%.binary}.bel ; done

##------------------------------------------------------------------------------
## Systemdateien erzeugen
## - div. externe Kommandos
## - div. Systemdateien (Farbtabellen usw.)
## --> ./bin/sdcard/system/

for x in ./system/regnatix/*.spin ; do ${BSTC} -L ${libpath} -b -O a ${x} ; done
for i in *.binary ; do mv ${i} ${sd_sys}/${i%%.binary}.bin ; done

cp ./forth/*.* ${sd_sys}
cp ./system/sonstiges/* ${sd_sys}

##------------------------------------------------------------------------------
## Wann fertig?

echo
date
##==============================================================================
