{{
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ Autor: Ingo Kripahle                                                                                 │
│ Copyright (c) 2010 Ingo Kripahle                                                                     │
│ See end of file for terms of use.                                                                    │
│ Die Nutzungsbedingungen befinden sich am Ende der Datei                                              │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘

Informationen   : hive-project.de
Kontakt         : drohne235@googlemail.com
System          : TriOS
Name            :
Chip            : Regnatix
Typ             : Programm
Version         : 
Subversion      : 
Funktion        : Dateiauswahlbox
Komponenten     : -
COG's           : -
Logbuch         :
Kommandoliste   :
Notizen         :

}}

OBJ

  ios      : "reg-ios"
  gcon     : "gui-con"
  gc       : "glob-con"

CON


VAR

  byte  box_win,box_x0,box_y0,box_x1,box_y1
  long  box_ladr,box_fadr
  byte  box_view,box_maxpos,box_pos
  byte  box_cols
  byte  box_stat
  byte  ctrl_pos
  byte  fname[gcon#MAX_LEN+1]
  byte  f_list[gcon#MAX_BUFFER]  'verzeichnisliste sdcard
  byte  f_flags[gcon#MAX_FILES]  'flags (selktiert, typ)
  long  f_len[gcon#MAX_FILES]    'dateilängen
  byte  f_number               'anzahl der dateien

PUB define(win,x0,y0,x1,y1)                             'dateibox initialisieren

  box_win    := win             'fensternummer
  box_x0     := x0              'koordinaten
  box_x1     := x1
  box_y0     := y0
  box_y1     := y1
  box_view   := 0               'position in der liste
  box_pos    := 0               'position im fenster
  box_maxpos := gcon#MAX_FILES  'max. anzahl in liste
  box_ladr   := @f_list         'adresse dateinamenliste
  box_fadr   := @f_flags        'adresse dateiflags
  box_cols   := (box_x1-box_x0)/(gcon#MAX_LEN+2)
  box_stat   := 0
  ctrl_pos   := 0
  ios.windefine(box_win,box_x0,box_y0,box_x1,box_y1)
  ios.winset(box_win)
  ios.printcls
  clrlist
  readdir

PUB draw                                                'dateibox darstellen

  ios.winset(box_win)
  ios.printcls
  clrlist
  readdir
  redraw

PUB redraw | i                                          'dateibox neu zeichnen

  ios.winset(box_win)
  ios.winoframe
  ios.curhome
  ios.curoff
  ios.setcolor(gcon#COL_DEFAULT)
  i := 0
  repeat gcon#WROWS
    repeat box_cols
      print_file(box_view+i,i)
      i++
    ios.printnl

PUB setpos(npos)|opos,i,col,row                         'selektorposition setzen

  opos    := box_pos
  box_pos := npos

'  redrawx(npos,opos)

  ios.winset(box_win)

  'alte position neu zeichnen
  row := opos / box_cols
  col := (opos - (row * box_cols)) * (gcon#MAX_LEN + 2)
  ios.wincursety(row)
  ios.wincursetx(col)
  print_file(box_view + opos, opos)

  'neue position neu zeichnen
  row := npos / box_cols
  col := (npos - (row * box_cols)) * (gcon#MAX_LEN + 2)
  ios.wincursety(row)
  ios.wincursetx(col)
  print_file(box_view + npos, npos)

PUB getpos: w_pos

  return box_pos

PUB getfn:fnadr|i,stradr                                'adresse des ausgewählten dateinamens

  i := 0
  stradr := @f_list + gcon#MAX_LEN * (ctrl_pos + box_view)
  repeat
    fname[i++] := byte[stradr + i]
  until (byte[stradr+i] == " ") OR (i == gcon#MAX_LEN)
  fname[i] := 0
  fnadr := @fname

PUB setview(view)

  box_view := view
  redraw

PUB getcols: cols                                       'abfrage anzahl spalten in box

  return box_cols


PUB defocus

  ios.winset(box_win)
  box_stat := box_stat & !gcon#FL_FOCUS
  redraw

PUB ctrl(key):status                                    'tastaturfunktionen

  status := 0
  case key
    gc#KEY_CURUP:    key_curup
    gc#KEY_CURDOWN:  key_curdown
    gc#KEY_CURLEFT:  key_curleft
    gc#KEY_CURRIGHT: key_curright
    gc#KEY_PAGEUP:   key_pageup
    gc#KEY_PAGEDOWN: key_pagedown
    gc#KEY_RETURN:   status := key_return

    other:           status := 1

PRI key_return:status

  'nur verzeichnisse
  if f_flags[ctrl_pos] & gcon#FL_DIR
    ios.sdchdir(getfn)
    clrlist
    readdir
    draw
    status := 0
  else
    status := 1


PRI key_curup                                           'cursor hoch

  if ctrl_pos > 1
    ctrl_pos -= box_cols
  setpos(ctrl_pos)

PRI key_curdown                                         'cursor runter

  if ctrl_pos < (gcon#WROWS * box_cols - box_cols)
    ctrl_pos += box_cols
  setpos(ctrl_pos)

PRI key_curleft                                         'cursor links

  if ctrl_pos
    ctrl_pos--
  setpos(ctrl_pos)

PRI key_curright                                        'cursor rechts

  if ctrl_pos < (gcon#WROWS * box_cols - 1)
    ctrl_pos++
  setpos(ctrl_pos)

PRI key_pageup                                            'fkt: seite zurück

  if (box_view - gcon#WROWS * box_cols) => 0
    box_view -= gcon#WROWS * box_cols
  setview(box_view)

PRI key_pagedown | number                                 'fkt: seite weiter

  if (box_view + gcon#WROWS * box_cols) =< f_number
    box_view += gcon#WROWS * box_cols
  setview(box_view)

PRI clrlist | i                                         'dateiliste löschen

  i := 0
  repeat gcon#MAX_FILES
    f_flags[i] := 0
    f_len[i] := 0
    i++
  i := 0
  repeat gcon#MAX_BUFFER
    f_list[i] := " "
    i++

PRI readdir | stradr,i,j                                'dateiliste einlesen

  i := 0
  ios.sddir
  repeat while (stradr := ios.sdnext)
    if ios.sdfattrib(ios#F_DIR)
      f_flags[i] := gcon#FL_DIR
    j := 0
    repeat gcon#MAX_LEN
      f_list[i*gcon#MAX_LEN+j] := byte[stradr+j]
      j++
    f_len[i] := ios.sdfattrib(ios#F_SIZE)
    if i++ => gcon#MAX_FILES - 1
      return

  f_number := i

PRI print_file(fnr,posnr) | i,c

  i := 0
  c := gcon#COL_DEFAULT

  if byte[box_fadr+fnr] & gcon#FL_SEL                     'eintrag selektiert?
    c := gcon#COL_SELECT

  if (posnr == box_pos)                                   'eintrag an cursorpos?
    ios.setcolor(c+8)
  else
    ios.setcolor(c)

  if byte[box_fadr+fnr] & gcon#FL_DIR                     'eintrag verzeichnis?
    ios.printq(string(" ▶"))
  else
    ios.print(string("  "))

  repeat gcon#MAX_LEN
    ios.bus_putchar2(byte[box_ladr][fnr*gcon#MAX_LEN+i])
    i++
  ios.setcolor(gcon#COL_DEFAULT)

DAT
     
{{

┌──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
│                                                   TERMS OF USE: MIT License                                                  │                                                            
├──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    │ 
│files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    │
│modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software│
│is furnished to do so, subject to the following conditions:                                                                   │
│                                                                                                                              │
│The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.│
│                                                                                                                              │
│THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          │
│WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         │
│COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   │
│ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         │
└──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
}}
