{
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ Autor: Ingo Kripahle                                                                                 │
│ Copyright (c) 2010 Ingo Kripahle                                                                     │
│ See end of file for terms of use.                                                                    │
│ Die Nutzungsbedingungen befinden sich am Ende der Datei                                              │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘

Informationen   : hive-project.de
Kontakt         : drohne235@gmail.com
System          : mental
Name            : Regnatix-Flash
Chip            : Regnatix
Typ             : Flash

Funktion        : Dieser Code enthält den zentralen Core von mental und repräsentiert
ein minimalistisches auf der Programmiersprache Forth basierendes System. Im Gegensatz zu einem
klassichen Forth sind einige Funktionen in die Slavechips ausgelagert, um im hRAM so viel nutzbaren
freien Speicher wie möglich zur Verfügung zu halten. Der relativ langsame eRAM (nur die erste Bank
von 512 KByte) stehen komplett für Daten bereit. Um eine möglichst hohe Abarbeitungsgeschwindigkeit
zu realisieren, läuft der Forthcode im hRAM.

Logbuch         :

-──────────────────────────────────────────────────────────────────────────────────────────────────────-

Forthcode: Der Forthcode wird im hRAM im 16 Bit Format gespeichert. Das ist ein guter
Kompromiss zwischen Geschwindigkeit und Speicherverbrauch. Ca. 64 primäre Befehle sind in Maschinencode
in der COG realisiert. Der resultierende Forthcode besteht ausschließlich aus Call Anweisungen um primären
oder sekundären Forthcode aufzurufen. Da es nur zwei Formen des Call Befehls gibt (primär/sekundär), ist
der Befehl und die Sprungadresse kompakt in einen 16 Bit Opcode verpackt. Bei den primären Calls ist zudem
noch Platz für ein 6 Bit Literal direkt im Opcode. Primäre Maschinencodeunterprogramme befinden sich im
COG-RAM, sekundäre Unterprogramme im Hub-RAM:

1nnnnnnc_cccccccc		Primäre, c = 9 Bit COG Call Adresse, n = 6 Bit Literal
0hhhhhhh_hhhhhhhh		Sekundäre, h = 15 Bit hRAM Call Adresse

Stack: Return- und Datenstack befinden sich in der COG und haben eine Größe von 32 Einträgen
zu je 32 Bit.

- Beide Stacks wachsen zur höheren Adresse.
- Der Stackpointer zeigt immer auf das erste freie Element.
- Fehlerprüfung: Über- oder Unterschreitung der Stackgrenze
- Bei einem Forth-Call wird momentan keine Fehlerprüfung durchgeführt!


Speicherinterface: Da m mit 16 Bit Adressen und Forthcode, sowie einer 32 Bit ALU und 32 Bit Stacks
arbeitet, ergeben sich Besonderheiten.

        cRAM:            9 Bit Adresse (512 Register)
	hRAM:		16 Bit Adresse (64 KB)
        xRAM:           20 Bit Adresse (1 MB)
	Code:		16 Bit Code
	ALU/Stacks:     32 Bit Verarbeitungsbreite

Das normale Speicherinterface (@ und !) arbeitet mit 32 Bit Werten. Für Word- und
Bytezugriffe gibt es entsprechend die Worte w@ w! und b@ b!.

Weitere Besonderheiten: Bedingt durch die Architektur der Propeller-Mikrocontroller ist
m eine Chimäre bezüglich der verwendeten Datenformate. Der Forthcode und das
Wörterbuch ist durchgängig an Word-Grenzen ausgerichtet, um einen schnellen
Zugriff durch den Maschinencode zu gewährleisten. Die ALU und die Stacks
verarbeiten aber Daten mit 32 Bit Breite.

Das grundlegende Datenformat für den Forthcode und das Wörterbuch ist durch
die Ausrichtung also 16 Bit Word. Die Worte @ und ! sind zwar in Maschinencode
programmiert, bestehen aber durch ebend jene Ausrichtung aus zwei Word-Zugriffen,
(möglich wäre ja auch die Verwendung des 32 Bit rdlong/wrlong Befehls)
um einen sinnvollen Kompromiss zwischen Speicherverbrauch, Geschwindigkeit und
Einfachheit zu realisieren.


}

OBJ

  gc         : "m-glob-con"

CON                                                     'chipkonfiguration      '

_CLKMODE = XTAL1 + PLL16X
_XINFREQ = 5_000_000

CON                                                     'pasm-fehlercodes       '

ASM_ERR_ST      = gc#M_ERR_ST   ' stackfehler

CON                                                     'strukturcodes          '

STR_FOR         = 1             ' for..next
STR_IF          = 2             ' if..else..then
STR_DO          = 3             ' do..loop/+loop
STR_BEGIN       = 4             ' begin..until/again


PUB main                                                'spin: startroutine     '

  waitcnt(cnt + clkfreq/3)
  core_start := @m_start
  cognew(@m_cbase,@core_start)

CON                                                     'M-WÖRTERBUCH           '

{
wörterbuchaufbau

linkfeld      word      - zeiger zum namensfeld des vorhergehenden wortes
                        - das erste wort hat als adresse eine 0

namensfeld    byte      %76543210
                        %ip-llll
                        i       - flag 1 = immediate wort
                        p       - flag 1 = primäres wort
                        llll    - 4 bit (16 zeichen) länge namen
              byte[n]   name des wortes (wird vom spin-compiler automatisch
                        auf wortgrenze aufgefüllt)

parameterfeld word[n]   liste mit 16 bit forthcode

datenfeld     word[n]   datenbereich variabler größe

Aufbau des Forthcodes:

plllllla_aaaaaaaa
                        p = 0 sekundäres wort (im hRAM)
                        p = 1 primäres wort (im cRAM)

                        llllll - 6 bit immediate literal

                        a_aaaaaaaa - 9 bit cog-adresse des codes

1lllllla_aaaaaaaa       primäres wort mit 9 bit codeadresse (cRAM) und bei bedarf 6 bit immediate daten
0aaaaaaa_aaaaaaaa       sekundäres wort mit 15 bit codeadresse (hRAM)
}

CON                                                     'm-dict: konstanten     '

PRIM    = $8000                 ' codeadresse als primär kennzeichnen

NF_IM   = %10000000             ' flag im namensfeld für immediate ausführung
NF_PR   = %01000000             ' flag im namensfeld für die kennzeichnung als primäres wort
NF_SE   = %11110000             ' maske zur trennung der flags im namensfeld

dat                                                     'core-variablen         '
                        ' core-variablen
                        ' diese zwei variablen werden von spin verwendet,
                        ' um die cores zu starten
                        ' core_start - enthält die pfa des startwortes
                        ' core_error - enthält den core-errorcode

                        ' reihenfolge der long-variablen darf nicht verändert werden!

CORE_START              long    0                       ' adresse start-pfa für vm
CORE_ERROR              long    0                       ' errorcode vm

dat                                                     'm-dict: wortdefinitionen

m_dbase
dat                                                     'm: dp                  '
                        ' variable dp
                        word    0
DP_NFA                  byte    $02,"dp"
DP_PFA                  word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@m_dpointer

dat                                                     'm: here                '
                        ' : here ( -- dp) dp w@ ;
                        word    @@@DP_NFA
HERE_NFA                byte    $04,"here"
HERE_PFA                word    @@@DP_PFA
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: drop                '
                        word    @@@HERE_NFA
DROP_NFA                byte    $04 + NF_PR,"drop"
DROP_PFA                word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: dup                 '
                        word    @@@DROP_NFA
DUP_NFA                 byte    $03 + NF_PR,"dup"
DUP_PFA                 word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: pick                '
                        word    @@@DUP_NFA
PICK_NFA                byte    $04 + NF_PR,"pick"
PICK_PFA                word    (@m_pick - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: rot                 '
                        word    @@@PICK_NFA
ROT_NFA                 byte    $03 + NF_PR,"rot"
ROT_PFA                 word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: >r                  '
                        word    @@@ROT_NFA
D_TO_R_NFA              byte    $02 + NF_PR,">r"
D_TO_R_PFA              word    (@m_d_to_r - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: r>                  '
                        word    @@@D_TO_R_NFA
R_TO_D_NFA              byte    $02 + NF_PR,"r>"
R_TO_D_PFA              word    (@m_r_to_d - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: swap                '
                        word    @@@R_TO_D_NFA
SWAP_NFA                byte    $04 + NF_PR,"swap"
SWAP_PFA                word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: over                '
                        ' : over swap dup rot swap ;

                        word    @@@SWAP_NFA
OVER_NFA                byte    $04,"over"
OVER_PFA                word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: nip                 '
                        ' : nip swap drop ;

                        word    @@@OVER_NFA
NIP_NFA                 byte    $03,"nip"
NIP_PFA                 word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: <                   '
                        word    @@@NIP_NFA
LT_NFA                  byte    $01 + NF_PR,"<"
LT_PFA                  word    (@m_lt - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: =                   '
                        word    @@@LT_NFA
EQ_NFA                  byte    $01 + NF_PR,"="
EQ_PFA                  word    (@m_eq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: >                   '
                        word    @@@EQ_NFA
GT_NFA                  byte    $01 + NF_PR,">"
GT_PFA                  word    (@m_gt - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: <>                  '
                        word    @@@GT_NFA
NEQ_NFA                 byte    $02 + NF_PR,"<>"
NEQ_PFA                 word    (@m_neq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: =0                  '
                        word    @@@NEQ_NFA
EQ0_NFA                 byte    $02 + NF_PR,"0="
EQ0_PFA                 word    (@m_0eq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: and                 '
                        word    @@@EQ0_NFA
AND_NFA                 byte    $03 + NF_PR,"and"
AND_PFA                 word    (@m_and - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: andn                '
                        word    @@@AND_NFA
ANDN_NFA                byte    $04 + NF_PR,"andn"
ANDN_PFA                word    (@m_andn - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: or                  '
                        word    @@@ANDN_NFA
OR_NFA                  byte    $02 + NF_PR,"or"
OR_PFA                  word    (@m_or - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: xor                 '
                        word    @@@OR_NFA
XOR_NFA                 byte    $03 + NF_PR,"xor"
XOR_PFA                 word    (@m_xor - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: not                 '
                        word    @@@XOR_NFA
NOT_NFA                 byte    $03 + NF_PR,"not"
NOT_PFA                 word    (@m_not - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: <shift              '
                        word    @@@NOT_NFA
LSHIFT_NFA              byte    $06 + NF_PR,"<shift"
LSHIFT_PFA              word    (@m_lshift - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: shift>              '
                        word    @@@LSHIFT_NFA
RSHIFT_NFA              byte    $06 + NF_PR,"shift>"
RSHIFT_PFA              word    (@m_rshift - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: rot>                '
                        word    @@@RSHIFT_NFA
ROTR_NFA                byte    $04 + NF_PR,"rot>"
ROTR_PFA                word    (@m_ror - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: <rot                '
                        word    @@@ROTR_NFA
ROTL_NFA                byte    $04 + NF_PR,"<rot"
ROTL_PFA                word    (@m_rol - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: +                   '
                        word    @@@ROTL_NFA
ADD_NFA                 byte    $01 + NF_PR,"+"
ADD_PFA                 word    (@m_add - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: -                   '
                        word    @@@ADD_NFA
SUB_NFA                 byte    $01 + NF_PR,"-"
SUB_PFA                 word    (@m_sub - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: um*                 '
                        word    @@@SUB_NFA
UMSTAR_NFA              byte    $03 + NF_PR,"um*"
UMSTAR_PFA              word    (@m_umstar - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: *                   '
                        ' : * um* drop ;

                        word    @@@UMSTAR_NFA
MUL_NFA                 byte    $01,"*"
MUL_PFA                 word    @@@umstar_pfa
                        word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: um/mod              '
                        word    @@@MUL_NFA
USLASHMOD_NFA           byte    $06 + NF_PR,"um/mod"
USLASHMOD_PFA           word    (@m_uslashmod - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: sign                '
                        ' : sign $80000000 and ;

                        word    @@@USLASHMOD_NFA
SIGN_NFA                byte    $04,"sign"
SIGN_PFA                word    (@m_litl - @m_cbase) / 4 + PRIM                 '
                        word    $8000
                        word    $0000
                        word    (@m_and - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: 2dup                '
                        ' : 2dup dup rot dup rot
                        ' >r >r swap r> r> ;

                        word    @@@SIGN_NFA
TWODUP_NFA              byte    $04,"2dup"
TWODUP_PFA              word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_r_to_d - @m_cbase) / 4 + PRIM
                        word    (@m_r_to_d - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: /mod                '

                        ' : /mod
                        ' 2dup xor sign >r abs swap abs swap um/mod r>
                        ' if negate swap negate swap then ;

                        word    @@@TWODUP_NFA
SLASHMOD_NFA            byte    $04,"/mod"
SLASHMOD_PFA            word    @@@twodup_pfa                                   '2dup
                        word    (@m_xor - @m_cbase) / 4 + PRIM                  'xor
                        word    @@@sign_pfa                                     'sign
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               '>r
                        word    (@m_abs - @m_cbase) / 4 + PRIM                  'abs
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
                        word    (@m_abs - @m_cbase) / 4 + PRIM                  'abs
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
                        word    @@@uslashmod_pfa                                'um/mod
                        word    (@m_r_to_d - @m_cbase) / 4 + PRIM               'r>
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' if
                        word    @@@slashmod_m1
                        word    (@m_neg - @m_cbase) / 4 + PRIM                  'negate
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
                        word    (@m_neg - @m_cbase) / 4 + PRIM                  'negate
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
slashmod_m1             word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: /                   '
                        ' : / /mod nip ;

                        word    @@@SLASHMOD_NFA
DIV_NFA                 byte    $01,"/"
DIV_PFA                 word    @@@slashmod_pfa
                        word    @@@nip_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: abs                 '
                        word    @@@DIV_NFA
ABS_NFA                 byte    $03 + NF_PR,"abs"
ABS_PFA                 word    (@m_abs - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: negate              '
                        word    @@@ABS_NFA
NEGATE_NFA              byte    $06 + NF_PR,"negate"
NEGATE_PFA              word    (@m_neg - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: @                   '
                        word    @@@NEGATE_NFA
FETCH_NFA               byte    $01 + NF_PR,"@"
FETCH_PFA               word    (@m_fetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: !                   '
                        word    @@@FETCH_NFA
STORE_NFA               byte    $01 + NF_PR,"!"
STORE_PFA               word    (@m_store - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: w@                  '
                        word    @@@STORE_NFA
WFETCH_NFA              byte    $02 + NF_PR,"w@"
WFETCH_PFA              word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: w!                  '
                        word    @@@WFETCH_NFA
WSTORE_NFA              byte    $02 + NF_PR,"w!"
WSTORE_PFA              word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: c@                  '
                        word    @@@WSTORE_NFA
CFETCH_NFA              byte    $02 + NF_PR,"c@"
CFETCH_PFA              word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: c!                  '
                        word    @@@CFETCH_NFA
CSTORE_NFA              byte    $02 + NF_PR,"c!"
CSTORE_PFA              word    (@m_cstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: exit                '
                        word    @@@CSTORE_NFA
EXIT_NFA                byte    $04 + NF_PR,"exit"
EXIT_PFA                word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: execute             '
                        word    @@@EXIT_NFA
EXECUTE_NFA             byte    $07 + NF_PR,"execute"
EXECUTE_PFA             word    (@m_execute - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: <8                  '
                        word    @@@EXECUTE_NFA
ROT8_NFA                byte    $02,"<8"
ROT8_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (8 << 9) ' 8 <rol ;
                        word    (@m_rol - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: 8>                  '
                        word    @@@ROT8_NFA
ROT8R_NFA               byte    $02,"8>"
ROT8R_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (8 << 9) ' 8 ror> ;
                        word    (@m_ror - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a!                  '
                        word    @@@ROT8R_NFA
APUT_NFA                byte    $02 + NF_PR,"a!"
APUT_PFA                word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a@                  '
                        word    @@@APUT_NFA
AGET_NFA                byte    $02 + NF_PR,"a@"
AGET_PFA                word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a!w                 '
                        ' : a!w (16b --)
                        '   dup 8> a! a! ;
                        word    @@@AGET_NFA
APUTW_NFA               byte    $03,"a!w"
APUTW_PFA               word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    @@@ROT8R_PFA
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a@w                 '
                        word    @@@APUTW_NFA
AGETW_NFA               byte    $03,"a@w"
                        '  a@    <8
AGETW_PFA               word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  a@ or ;
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a!l                 '
                        word    @@@AGETW_NFA
APUTL_NFA               byte    $03,"a!l"
APUTL_PFA               word    @@@ROT8_PFA     ' <8 dup a!
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM

                        ' <8 dup a!
                        word    @@@ROT8_PFA
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM

                        ' <8 dup a!
                        word    @@@ROT8_PFA
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM

                        ' <8 a! ;
                        word    @@@ROT8_PFA
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a@l                 '
                        ': a@l
                        word    @@@APUTL_NFA
AGETL_NFA               byte    $03,"a@l"
                        '  a@    <8
AGETL_PFA               word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  a@ or <8
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  a@ or <8
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  a@ or ;
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a@s                 '
                        ': a@s     / ( -- cstr) string von administra empfangen
                        '  a@ dup tok c! tok 1+ swap
                        '  for dup a@ swap c! 1+ next drop tok ;
                        word    @@@AGETL_NFA
AGETS_NFA               byte    $03,"a@s"
AGETS_PFA               word    (@m_aget - @m_cbase) / 4 + PRIM                 ' b@
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@tok_pfa                                      ' tok
                        word    (@m_cstore - @m_cbase) / 4 + PRIM               ' c!
                        word    @@@tok_pfa                                      ' tok
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
AGETS_M1                word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 ' b@
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_cstore - @m_cbase) / 4 + PRIM               ' c!
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@AGETS_M1
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 ' drop
                        word    @@@tok_pfa                                      ' tok
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: a!s                 '
                        ': a!s     / ( cstr -- ) string an administra senden
                        '  dup c@ dup a! for 1+ dup c@ a! next drop ;
                        '
                        word    @@@AGETS_NFA
APUTS_NFA               byte    $03,"a!s"
APUTS_PFA               word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
aputs_m1                word    @@@add1_pfa
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_fnext - @m_cbase) / 4 + PRIM
                        word    @@@aputs_m1
                        word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: b!                  '
                        word    @@@APUTS_NFA
BPUT_NFA                byte    $02 + NF_PR,"b!"
BPUT_PFA                word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: b@                  '
                        word    @@@BPUT_NFA
BGET_NFA                byte    $02 + NF_PR,"b@"
BGET_PFA                word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: b!w                 '
                        ' : b!w (16b --)
                        '   dup 8> b! b! ;
                        word    @@@BGET_NFA
BPUTW_NFA               byte    $03,"b!w"
BPUTW_PFA               word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    @@@ROT8R_PFA
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: b@w                 '
                        word    @@@BPUTW_NFA
BGETW_NFA               byte    $03,"b@w"
                        '  b@    <8
BGETW_PFA               word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  b@ or ;
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: b!l                 '
                        word    @@@BGETW_NFA
BPUTL_NFA               byte    $03,"b!l"
BPUTL_PFA               word    @@@ROT8_PFA     ' <8 dup b!
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM

                        ' <8 dup b!
                        word    @@@ROT8_PFA
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM

                        ' <8 dup b!
                        word    @@@ROT8_PFA
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM

                        ' <8 b! ;
                        word    @@@ROT8_PFA
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: b@l                 '
                        ': b@l
                        word    @@@BPUTL_NFA
BGETL_NFA               byte    $03,"b@l"
                        '  b@    <8
BGETL_PFA               word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  b@ or <8
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  b@ or <8
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    @@@rot8_pfa
                        '  b@ or ;
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_or - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: b@s                 '
                        ': b@s     / ( -- cstr) string von bella empfangen
                        '  b@ dup tok c! tok 1+ swap
                        '  for dup b@ swap c! 1+ next drop tok ;
                        word    @@@BGETL_NFA
BGETS_NFA               byte    $03,"b@s"
BGETS_PFA               word    (@m_bget - @m_cbase) / 4 + PRIM                 ' b@
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@tok_pfa                                      ' tok
                        word    (@m_cstore - @m_cbase) / 4 + PRIM               ' c!
                        word    @@@tok_pfa                                      ' tok
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
BGETS_M1                word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_bget - @m_cbase) / 4 + PRIM                 ' b@
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_cstore - @m_cbase) / 4 + PRIM               ' c!
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@BGETS_M1
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 ' drop
                        word    @@@tok_pfa                                      ' tok
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: b!s                 '
                        ': b!s     / ( cstr -- ) string zu bellatrix senden
                        '  dup c@ dup b! for 1+ dup c@ b! next drop ;
                        '
                        word    @@@BGETS_NFA
BPUTS_NFA               byte    $03,"b!s"
BPUTS_PFA               word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
bputs_m1                word    @@@add1_pfa
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_fnext - @m_cbase) / 4 + PRIM
                        word    @@@bputs_m1
                        word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: emit                '
                        word    @@@BPUTS_NFA
EMIT_NFA                byte    $04 + NF_PR,"emit"
EMIT_PFA                word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: key                 '
                        ' 0 b! bel_key_wait b! b@
                        word    @@@EMIT_NFA
KEY_NFA                 byte    $03,"key"
KEY_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#bel_key_wait << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: inkey               '
                        ' 0 b! bel_key_code b! b@
                        word    @@@KEY_NFA
INKEY_NFA               byte    $05,"inkey"
INKEY_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#bel_key_code << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_bget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: .                   '
                        ' : . dup drop 0 b! 22 b! b!l digits @ b! ;
                        ' die sequenz "dup drop" provoziert nur vor der
                        ' kommunikation mit bella einen stackerror
                        ' falls der stack leer ist, da sonst der fehler
                        ' nicht korrekt abgefangen wird

                        word    @@@INKEY_NFA
DOT_NFA                 byte    $01,"."
DOT_PFA                 word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 ' drop
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)     ' lit 0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (22 << 9)    ' lit 22
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    @@@BPUTL_PFA                                    ' b!l - wert sende
                        word    @@@digits_pfa                                   ' digits
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' @
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: .name               '
                        ' : .name (nfa -- ) / ausgabe namenstring
                        '   dup 1+ swap c@ 0f and for dup c@ emit 1+ next drop ;
                        word    @@@DOT_NFA
DOTNAME_NFA             byte    $05,".name"
DOTNAME_PFA             word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + ($0F << 9)   ' $0f
                        word    (@m_and - @m_cbase) / 4 + PRIM                  ' and
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
DOTNF_M1                word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    @@@EMIT_PFA                                     ' emit
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@DOTNF_M1
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 'drop
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: 1+                  '
                        word    @@@DOTNAME_NFA
ADD1_NFA                byte    $02,"1+"
ADD1_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (1 << 9)
                        word    (@m_add - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: 1-                  '
                        word    @@@ADD1_NFA
SUB1_NFA                byte    $02,"1-"
SUB1_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (1 << 9)
                        word    (@m_sub - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: link                '
                        word    @@@SUB1_NFA
LINK_NFA                byte    $04,"link"
LINK_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (2 << 9)      ' 2 - @
                        word    (@m_sub - @m_cbase) / 4 + PRIM
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: space               '
                        word    @@@LINK_NFA
SPACE_NFA               byte    $05,"space"
SPACE_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + ($20 << 9)
                        word    @@@emit_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: spaces              '
                        ' : spaces ( n -- ) for space next ;
                        word    @@@SPACE_NFA
SPACES_NFA              byte    $06,"spaces"
SPACES_PFA              word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
spaces_m1               word    @@@space_pfa                                    ' space
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@spaces_m1
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: cr                  '
                        word    @@@SPACES_NFA
CR_NFA                  byte    $02,"cr"
CR_PFA                  word    (@m_lit6b - @m_cbase) / 4 + PRIM + ($0D << 9)
                        word    @@@EMIT_PFA
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: cls                 '
                        word    @@@CR_NFA
CLS_NFA                 byte    $03,"cls"
CLS_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (1 << 9)
                        word    @@@EMIT_PFA
                        word    (@m_exit - @m_cbase) / 4 + PRIM
dat                                                     'm: stop?               '
                        ' : stop? ( -- )
                        '   inkey if key drop then ;
                        word    @@@CLS_NFA
STOPQ_NFA               byte    $05,"stop?"
STOPQ_PFA               word    @@@INKEY_PFA
                        word    (@m_0branch - @m_cbase) / 4 + PRIM
                        word    @@@stopq_m1
                        word    @@@KEY_PFA
                        word    (@m_drop - @m_cbase) / 4 + PRIM
stopq_m1                word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: words               '
                        ' : words
                        '   cr last w@
                        '   begin dup .name space stop? link dup =0 until
                        '   drop ;

                        word    @@@STOPQ_NFA
WORDS_NFA               byte    $05,"words"
WORDS_PFA               'word    @@@cr_pfa                                       ' cr
                        word    @@@LAST_PFA                                     ' last
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' w@
WORDS_M1                word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@DOTNAME_PFA                                  ' .name
                        word    @@@SPACE_PFA                                    ' space
                        word    @@@STOPQ_PFA                                    ' stop?
                        word    @@@LINK_PFA                                     ' link
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_0eq - @m_cbase) / 4 + PRIM                  ' =0
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' until
                        word    @@@WORDS_M1
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 ' drop
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: tok                 '
                        '64 + 2 byte puffer für token
                        word    @@@WORDS_NFA
TOK_NFA                 byte    $03,"tok"
TOK_PFA                 word    (@m_data - @m_cbase) / 4 + PRIM
                        byte    0 [65]

dat                                                     'm: str1                '
                        '64 + 2 byte puffer für strings
                        word    @@@TOK_NFA
STR0_NFA                byte    $04,"str0"
STR0_PFA                word    (@m_data - @m_cbase) / 4 + PRIM
                        byte    0 [65]

dat                                                     'm: str1                '
                        '64 + 2 byte puffer für strings
                        word    @@@STR0_NFA
STR1_NFA                byte    $04,"str1"
STR1_PFA                word    (@m_data - @m_cbase) / 4 + PRIM
                        byte    0 [65]

dat                                                     'm: .str                '
                        ' : .str dup 1+ swap c@ for dup c@ emit 1+ next drop ;
                        word    @@@STR1_NFA
DOTSTR_NFA              byte    $04,".str"
DOTSTR_PFA              word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
DOTSTR_M1               word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    @@@emit_pfa                                     ' emit
                        word    @@@add1_pfa                                     ' 1+
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@DOTSTR_M1
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 ' drop
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: nop                 '
                        word    @@@DOTSTR_NFA
NOP_NFA                 byte    $03,"nop"
NOP_PFA                 word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: btoken              '
                        ' sprungtabelle token von bella empfangen
                        word    @@@NOP_NFA
BTOKEN_NFA              byte    06,"btoken"
BTOKEN_PFA              word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@bgets_pfa            'token für interpreter
                        word    @@@bgets_pfa            'token für create
                        word    @@@bgets_pfa            'token für für compile
                        word    @@@bgetl_pfa            'wert für number
                        word    @@@bgetl_pfa            'wert für number-literal
                        word    @@@bgets_pfa            'token für sting
                        word    @@@bgets_pfa            'token für sting-literal
                        word    @@@bgets_pfa            'token für data
                        word    @@@bgets_pfa            'token für remark
                        word    @@@aget_pfa             'tag für eos

dat                                                     'm: atoken              '
                        ' sprungtabelle token von administra empfangen
                        word    @@@BTOKEN_NFA
ATOKEN_NFA              byte    06,"atoken"
ATOKEN_PFA              word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@agets_pfa            'token für interpret
                        word    @@@agets_pfa            'token für create
                        word    @@@agets_pfa            'token für compile
                        word    @@@agetl_pfa            'wert für number
                        word    @@@agetl_pfa            'wert für number-literal
                        word    @@@agets_pfa            'token für string
                        word    @@@agets_pfa            'token für string-literal
                        word    @@@agets_pfa            'token für data
                        word    @@@agets_pfa            'token für remark
                        word    @@@aget_pfa             'tag für eos

dat                                                     'm: function            '
                        ' sprungtabelle tokenfunktion
                        word    @@@ATOKEN_NFA
FUNCTION_NFA            byte    08,"function"
FUNCTION_PFA            word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@interpret_pfa        'interpret
                        word    @@@create_pfa           'create
                        word    @@@compile_pfa          'compile
                        word    @@@nop_pfa              'number
                        word    @@@nliteral_pfa         'number-literal
                        word    @@@string_pfa           'string
                        word    @@@sliteral_pfa         'string-literal
                        word    @@@data_pfa             'data
                        word    @@@drop_pfa             'remark
                        word    @@@drop_pfa             'end of screen


dat                                                     'm: token               '
' : token ( -- ) nächstes token empfangen und verarbeiten
'   0 b! 20 b! b@ gc#m_c_tag1 - dup
'   btoken perform swap function perform ;
                        word    @@@FUNCTION_NFA
TOKEN_NFA               byte    $05,"token"
                        ' 0 b! 20 b! b@ gc#m_c_tag1 -
TOKEN_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)           '0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                       'b!
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (20 << 9)          '20
                        word    (@m_bput - @m_cbase) / 4 + PRIM                       'b!
                        word    (@m_bget - @m_cbase) / 4 + PRIM                       'b@
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#m_c_tag1 << 9) 'gc#m_c_tag1
                        word    (@m_sub - @m_cbase) / 4 + PRIM                        '-
                        word    (@m_dup - @m_cbase) / 4 + PRIM                        'dup
                        ' btoken perform swap
                        word    @@@btoken_pfa
                        word    @@@perform_pfa
                        word    (@m_swap - @m_cbase) / 4 + PRIM                        'swap
                        ' function perform ;
                        word    @@@function_pfa
                        word    @@@perform_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: interpret           '
                        ' : interpret (cstr -- )
                        '   last w@ find dup 0= 3 ?error nfa>pfa execute ;

                        word    @@@TOKEN_NFA
INTERPRET_NFA           byte    $09,"interpret"
INTERPRET_PFA           word    @@@last_pfa                                     ' last
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' w@
                        word    (@m_find - @m_cbase) / 4 + PRIM                 ' find
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_0eq - @m_cbase) / 4 + PRIM                  ' 0=
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_IN << 9)' lit ERR_IN
                        word    @@@qerror_pfa                                   ' ?error
                        word    @@@nfatopfa_pfa                                 ' nfa>pfa
                        word    (@m_execute - @m_cbase) / 4 + PRIM              ' execute
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: +!                  '
                        ' : +! (n adr -- )
                        '   dup w@ rot + swap ! ;
                        word    @@@INTERPRET_NFA
ADDSTORE_NFA            byte    $02,"+!"
ADDSTORE_PFA            word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_add - @m_cbase) / 4 + PRIM
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: allot               '
                        ' : allot (n -- )
                        '   dp +! ;
                        word    @@@ADDSTORE_NFA
ALLOT_NFA               byte    $05,"allot"
ALLOT_PFA               word    @@@dp_pfa
                        word    @@@addstore_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: ,                   '
                        ' : , (n -- ) compiliert wert, erhöht compilerpointer
                        '   here 2 allot ! ;
                        word    @@@ALLOT_NFA
COMMA_NFA               byte    $01,","
COMMA_PFA               word    @@@here_pfa
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (2 << 9)
                        word    @@@allot_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: cmove               '
                        ' cmove (adr1 adr2 n -- )
                        word    @@@COMMA_NFA
CMOVE_NFA               byte    $05 + NF_PR,"cmove"
CMOVE_PFA               word    (@m_cmove - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: strcopy             '
                        ' : strcopy (adr1 adr2 -- )
                        '   swap dup c@ swap rot rot 1+ cmove ;
                        word    @@@CMOVE_NFA
STRCOPY_NFA             byte    $07,"strcopy"
STRCOPY_PFA             word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    (@m_rot - @m_cbase) / 4 + PRIM
                        word    @@@add1_pfa
                        word    (@m_cmove - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: new                 '
                        ' variable, enthält nfa des neuen wortes beim compilieren
                        word    @@@STRCOPY_NFA
NEW_NFA                 byte    $03,"new"
NEW_PFA                 word    (@m_data - @m_cbase) / 4 + PRIM
                        word    0

dat                                                     'm: lit32               '
                        ' : lit32 (n -- )
                        '   lit-litl , dup 16 shift> , , ;
                        word    @@@NEW_NFA
LIT32_NFA               byte    5,"lit32"
LIT32_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_litl - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (16 << 9)
                        word    (@m_rshift - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@comma_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: lit16               '
                        ' : lit16 (n -- )
                        '   lit-litw , , ;
                        word    @@@LIT32_NFA
LIT16_NFA               byte    5,"lit16"
LIT16_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@comma_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: lit6                '
                        ' : lit6 (n -- )
                        '   lit-$3F and lit-$9 <shift lit-lit6b or , ;
                        word    @@@LIT16_NFA
LIT6_NFA                byte    4,"lit6"
LIT6_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + ($3F << 9)   'lit $3F
                        word    (@m_and - @m_cbase) / 4 + PRIM                  'and
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (9 << 9)     'lit $9
                        word    (@m_lshift - @m_cbase) / 4 + PRIM               '<shift
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit-word
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM                'opcode lit6b
                        word    (@m_or - @m_cbase) / 4 + PRIM                   'or
                        word    @@@comma_pfa                                    ',
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: reduce              '
                        ' : reduce (n -- )
                        '   dup abs lit($40) < if lit6
                        '   else dup abs lit($10000) < if lit16
                        '   else lit32 then then ;
                        word    @@@LIT6_NFA
REDUCE_NFA              byte    6,"reduce"
REDUCE_PFA              word    (@m_dup - @m_cbase) / 4 + PRIM                  'dup
                        word    (@m_abs - @m_cbase) / 4 + PRIM                  'abs
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 'litw
                        word    $0040                                           '$40
                        word    (@m_lt - @m_cbase) / 4 + PRIM                   '<

                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'if
                        word    @@@reduce_m1
                        word    @@@lit6_pfa                                     'lit6
                        word    (@m_branch - @m_cbase) / 4 + PRIM
                        word    @@@reduce_m3

reduce_m1               word    (@m_dup - @m_cbase) / 4 + PRIM                  '(else) dup
                        word    (@m_abs - @m_cbase) / 4 + PRIM                  'abs
                        word    (@m_litl - @m_cbase) / 4 + PRIM                 'litl
                        word    $0001                                           '$10000
                        word    $0000
                        word    (@m_lt - @m_cbase) / 4 + PRIM                   '<

                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'if
                        word    @@@reduce_m2
                        word    @@@lit16_pfa                                    'lit16
                        word    (@m_branch - @m_cbase) / 4 + PRIM
                        word    @@@reduce_m3

reduce_m2               word    @@@lit32_pfa                                    '(else) lit32
reduce_m3               word    (@m_exit - @m_cbase) / 4 + PRIM                 '(then)(then) ;

dat                                                     'm: nliteral            '
                        ' : nliteral (n -- )
                        '   dup sign if lit32 else reduce then ;
                        word    @@@REDUCE_NFA
NLITERAL_NFA            byte    8,"nliteral"
NLITERAL_PFA            word    (@m_dup - @m_cbase) / 4 + PRIM                  'dup
                        word    @@@sign_pfa                                     'sign
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'if
                        word    @@@nliteral_m1
                        word    @@@lit32_pfa                                    'lit32
                        word    (@m_branch - @m_cbase) / 4 + PRIM
                        word    @@@nliteral_m2
nliteral_m1             word    @@@reduce_pfa                                   '(else) reduce
nliteral_m2             word    (@m_exit - @m_cbase) / 4 + PRIM                 '(then) ;

dat                                                     'm: sliteral            '
                        ' : sliteral (cstr -- )
                        '   lit-lits ,
                        '   tok here strcopy
                        '   c@ 1+ alignw dp +! ;
                        word    @@@NLITERAL_NFA
SLITERAL_NFA            byte    8,"sliteral"
SLITERAL_PFA            word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_lits - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@tok_pfa
                        word    @@@here_pfa
                        word    @@@strcopy_pfa
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    @@@add1_pfa
                        word    @@@alignw_pfa
                        word    @@@dp_pfa
                        word    @@@addstore_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: string              '
                        ' : string (cstr1 -- cstr2)
                        '   drop tok str strcopy str ;
                        word    @@@SLITERAL_NFA
STRING_NFA              byte    6,"string"
STRING_PFA              word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    @@@tok_pfa
                        word    @@@str0_pfa
                        word    @@@strcopy_pfa
                        word    @@@str0_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ;data               '
                        ' : ;data
                        '   0 new dup @ last ! ! ;
                        word    @@@STRING_NFA
SEMICOLONDATA_NFA       byte    $05 + NF_IM,";data"
SEMICOLONDATA_PFA       word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    @@@new_pfa
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    @@@last_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ;                   '
                        ' : ;
                        '   ?csp 5 ?error
                        '   lit-exit ,
                        '   ;data ;
                        word    @@@SEMICOLONDATA_NFA
SEMICOLON_NFA           byte    $01 + NF_IM,";"
SEMICOLON_PFA           word    @@@qcsp_pfa
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)
                        word    @@@qerror_pfa
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@semicolondata_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: create              '
                        ' : create (cstr -- )
                        ' --------------------          lfa schreiben
                        '   last w@ ,
                        ' --------------------          new auf nfa setzen
                        '   here new !
                        ' --------------------          string kopieren
                        '   dup here strcopy            ' tok here strcopy
                        ' --------------------          dp berechnen und auf wortgrenze ausrichten
                        '   c@ 1+ alignw dp +!
                        ' --------------------          stackpos sichern
                        ' ds csp ! ;                    (für prüfung auf ausgeglichenen stack)

                        word    @@@SEMICOLON_NFA
CREATE_NFA              byte    $06,"create"
CREATE_PFA              word    @@@last_pfa
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@here_pfa
                        word    @@@new_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        'word    @@@tok_pfa
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    @@@here_pfa
                        word    @@@strcopy_pfa
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    @@@add1_pfa
                        word    @@@alignw_pfa
                        word    @@@dp_pfa
                        word    @@@addstore_pfa
                        word    (@m_ds - @m_cbase) / 4 + PRIM
                        word    @@@csp_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: data                '
                        ' : data (cstr -- )
                        ' --------------------          lfa schreiben
                        ' create
                        ' --------------------          data-code compilieren
                        ' data-lit , ;
                        word    @@@CREATE_NFA
DATA_NFA                byte    $04,"data"
DATA_PFA                word    @@@create_pfa
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: word                '
                        ' : word 2 allot ;
                        word    @@@DATA_NFA
WORD_NFA                byte    $04,"word"
WORD_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (2 << 9)
                        word    @@@allot_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: long                '
                        ' : word 4 allot ;
                        word    @@@WORD_NFA
LONG_NFA                byte    $04,"long"
LONG_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (4 << 9)
                        word    @@@allot_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: csp                 '
                        word    @@@LONG_NFA
CSP_NFA                 byte    $03,"csp"
CSP_PFA                 word    (@m_data - @m_cbase) / 4 + PRIM
                        word    0

dat                                                     'm: ?csp                '
                        ' : ?csp ( -- fl)
                        '   ds csp @ <> ;
                        word    @@@CSP_NFA
QCSP_NFA                byte    $04,"?csp"
QCSP_PFA                word    (@m_ds - @m_cbase) / 4 + PRIM
                        word    @@@csp_pfa
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_neq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: i?                  '
                        ' : i? (nfa -- i-flag)
                        '   c@ NF_IM and ;
                        word    @@@QCSP_NFA
IQUERY_NFA              byte    2,"?i"
IQUERY_PFA              word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    NF_IM
                        word    (@m_and - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: p?                  '
                        ' : p? (nfa -- p-flag)
                        '   c@ NF_PR and ;
                        word    @@@IQUERY_NFA
PQUERY_NFA              byte    2,"?p"
PQUERY_PFA              word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    NF_PR
                        word    (@m_and - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: s?                  '
                        ' : s? (nfa -- flag)
                        '   -1 swap c@ NF_SE and if not then ;
                        word    @@@PQUERY_NFA
SQUERY_NFA              byte    2,"?s"
SQUERY_PFA              word    (@m_litl - @m_cbase) / 4 + PRIM                 ' -1
                        word    $ffff
                        word    $ffff
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' NF_SE
                        word    NF_SE
                        word    (@m_and - @m_cbase) / 4 + PRIM                  ' and
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' if
                        word    @@@squery_m1
                        word    (@m_not - @m_cbase) / 4 + PRIM                  ' not
squery_m1               word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: compile             '
                        ' : compile (cstr -- err)
                        '   last w@ find
                        '   dup 0= 4 ?error
                        '   dup i? if nfa>pfa execute else     / immediate-wort - wird sofort ausgeführt
                        '     dup p? if nfa>pfa w@ , else      / primäres wort - vm-code wird compiliert
                        '       dup s? if nfa>pfa , then       / sekundäres wort - forth-code wird compiliert
                        '   then then ;
                        word    @@@SQUERY_NFA
COMPILE_NFA             byte    $07,"compile"
COMPILE_PFA             word    @@@last_pfa                                     ' last
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' w@
                        word    (@m_find - @m_cbase) / 4 + PRIM                 ' find
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_0eq - @m_cbase) / 4 + PRIM                  ' 0=
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_CP << 9)' lit ERR_CP
                        word    @@@qerror_pfa                                   ' ?error
                        '------------------------------------------
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@iquery_pfa                                   ' i?
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' if
                        word    @@@compile_ma
                        word    @@@nfatopfa_pfa                                 ' nfa>pfa
                        word    (@m_execute - @m_cbase) / 4 + PRIM              ' execute
                        word    (@m_branch - @m_cbase) / 4 + PRIM               ' else
                        word    @@@compile_mc
                        '------------------------------------------
compile_ma              word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@pquery_pfa                                   ' p?
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' if
                        word    @@@compile_mb
                        word    @@@nfatopfa_pfa                                 ' nfa>pfa
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' w@
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_branch - @m_cbase) / 4 + PRIM               ' else
                        word    @@@compile_mc
                        '------------------------------------------
compile_mb              word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@squery_pfa                                   ' s?
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' if
                        word    @@@compile_mc
                        word    @@@nfatopfa_pfa                                 ' nfa>pfa
                        word    @@@comma_pfa                                    ' ,
                        '------------------------------------------
compile_mc              word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ds                  '
                        word    @@@COMPILE_NFA
DS_NFA                  byte    $02 + NF_PR,"ds"
DS_PFA                  word    (@m_ds - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: .s                  '
                        ' : .s
                        '   ds dup if for i pick . space next else drop then ;
                        word    @@@DS_NFA
DOTS_NFA                byte    $02,".s"
DOTS_PFA                word    (@m_ds - @m_cbase) / 4 + PRIM
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_0branch - @m_cbase) / 4 + PRIM
                        word    @@@dots_m2
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
dots_m1                 word    (@m_index - @m_cbase) / 4 + PRIM
                        word    (@m_pick - @m_cbase) / 4 + PRIM
                        word    @@@dot_pfa
                        word    @@@space_pfa
                        word    (@m_fnext - @m_cbase) / 4 + PRIM
                        word    @@@dots_m1
                        word    (@m_exit - @m_cbase) / 4 + PRIM
dots_m2                 word    (@m_drop - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: abort               '
                        word    @@@DOTS_NFA
ABORT_NFA               byte    $05 + NF_PR,"abort"
ABORT_PFA               word    (@m_abort - @m_cbase) / 4 + PRIM

dat                                                     'm: error               '
                        ' : error / ( n -- )
                        ' 0 b! 23 b! b!
                        ' cold 0 w! abort
                        ' cold rücksetzen, damit das system nicht endlos versucht
                        ' von sdcard zu booten

                        word    @@@ABORT_NFA
ERROR_NFA               byte    $05,"error"
ERROR_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (23 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)
                        word    @@@cold_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_abort - @m_cbase) / 4 + PRIM

dat                                                     'm: ?error              '
                        ' : ?error / ( fl n -- )
                        '   swap if error else drop then ;
                        word    @@@ERROR_NFA
QERROR_NFA              byte    $06,"?error"
QERROR_PFA              word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_0branch - @m_cbase) / 4 + PRIM
                        word    @@@qerror_m1
                        word    @@@error_pfa
                        word    (@m_branch - @m_cbase) / 4 + PRIM
                        word    @@@qerror_m2
qerror_m1               word    (@m_drop - @m_cbase) / 4 + PRIM
qerror_m2               word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: base                '
                        ' : base 0 b! 21 b! b! ; ( base -- )
                        word    @@@QERROR_NFA
BASE_NFA                byte    $04,"base"
BASE_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (21 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: dec                 '
                        word    @@@BASE_NFA
DEC_NFA                 byte    $03,"dec"
DEC_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (10 << 9)
                        word    @@@base_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: hex                 '
                        word    @@@DEC_NFA
HEX_NFA                 byte    $03,"hex"
HEX_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (16 << 9)
                        word    @@@base_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: bin                 '
                        word    @@@HEX_NFA
BIN_NFA                 byte    $03,"bin"
BIN_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (2 << 9)
                        word    @@@base_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: =str                '
                        word    @@@BIN_NFA
STREQ_NFA               byte    $04 + NF_PR,"=str"
STREQ_PFA               word    (@m_cstreq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: =name               '
                        word    @@@STREQ_NFA
NAMEEQ_NFA              byte    $05 + NF_PR,"=name"
NAMEEQ_PFA              word    (@m_nameeq - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: find                '
                        word    @@@NAMEEQ_NFA
FIND_NFA                byte    $04 + NF_PR,"find"
FIND_PFA                word    (@m_find - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: alignw              '
                        ' : alignw 1+ 1 andn ;
                        word    @@@FIND_NFA
ALIGNW_NFA              byte    $06,"alignw"
ALIGNW_PFA              word    @@@add1_pfa
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (1 << 9)
                        word    (@m_andn - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: nfa>pfa             '
                        ' : nfa>pfa ( nfa -- pfa )
                        '  dup c@ $0F and + 1+ alignw ;
                        word    @@@ALIGNW_NFA
NFATOPFA_NFA            byte    $07,"nfa>pfa"
NFATOPFA_PFA            word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + ($0F << 9)
                        word    (@m_and - @m_cbase) / 4 + PRIM
                        word    (@m_add - @m_cbase) / 4 + PRIM
                        word    @@@add1_pfa
                        word    @@@alignw_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: free                '
                        ' : free $7FFF here - ;
                        word    @@@NFATOPFA_NFA
FREE_NFA                byte    $04,"free"
FREE_PFA                word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    $7FFF
                        word    @@@here_pfa
                        word    (@m_sub - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: digits              '
                        word    @@@FREE_NFA
DIGITS_NFA              byte    $06,"digits"
DIGITS_PFA              word    (@m_data - @m_cbase) / 4 + PRIM
                        word    8


dat                                                     'm: next                '
                        ' : next c:(adr struk -- )
                        '   STR_FOR <> ERR_SI ?error
                        '   lit_fnext , , ;
                        word    @@@DIGITS_NFA
NEXT_NFA                byte    $04 + NF_IM,"next"
NEXT_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_FOR << 9)      'for-next strukturcode
                        word    (@m_neq - @m_cbase) / 4 + PRIM                         'vergleichen
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)  'errorcode
                        word    @@@qerror_pfa                                          'error, wenn strukturcode falsch
                        word    (@m_litw - @m_cbase) / 4 + PRIM                        'literal
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                       'next
                        word    @@@comma_pfa                                           'next compilieren
                        word    @@@comma_pfa                                           'adresse compilieren
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: i                   '
                        word    @@@NEXT_NFA
INDEX_NFA               byte    $01 + NF_PR,"i"
INDEX_PFA               word    (@m_index - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: for                 '
                        ' : for c:( -- adr struk)
                        '   lit_dtor ,          / >r compilieren
                        '   here STR_IF ;            / adresse und strukturkennung
                        word    @@@INDEX_NFA
FOR_NFA                 byte    $03 + NF_IM,"for"
FOR_PFA                 word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
                        word    @@@comma_pfa
                        word    @@@here_pfa
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_FOR << 9)
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: then                '
                        ' : then (ref struk -- )
                        ' STR_IF <> ERR_SI ?error    / strukturfehler?
                        ' here swap ! ;         / adresse an referenz schreiben
                        word    @@@FOR_NFA
THEN_NFA                byte    $04 + NF_IM,"then"
THEN_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_IF << 9)
                        word    (@m_neq - @m_cbase) / 4 + PRIM
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#M_ERR_SI
                        word    @@@qerror_pfa
                        word    @@@here_pfa
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: else                '
                        ' : else (ref struk -- ref struk)
                        '   STR_IF <> ERR_SI ?error     / strukturfehler?
                        '   here swap !                 / if-referenz auflösen
                        '   lit-branch , here 0 , STR_IF/ neue referenz erstellen
                        '   rot here swap ! ;           / if-referenz auflösen
                        word    @@@THEN_NFA
ELSE_NFA                byte    $04 + NF_IM,"else"
ELSE_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_IF << 9)' lit 2
                        word    (@m_neq - @m_cbase) / 4 + PRIM                  ' <>
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)' lit ERR_SI
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_branch - @m_cbase) / 4 + PRIM               ' branch
                        word    @@@comma_pfa                                    ' ,
                        word    @@@here_pfa                                     ' here
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)     ' lit 0
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_IF << 9)' lit STR_IF
                        word    (@m_rot - @m_cbase) / 4 + PRIM                  ' swap
                        word    @@@here_pfa                                     ' here
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               ' !
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: if                  '
                        ' : if c:( -- ref struk)
                        '   lit-0branch , here 0 , STR_IF ;
                        word    @@@ELSE_NFA
IF_NFA                  byte    $02 + NF_IM,"if"
IF_PFA                  word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' 0branch
                        word    @@@comma_pfa                                    ' ,
                        word    @@@here_pfa                                     ' here
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)     ' lit 0
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_IF << 9)' lit STR_IF
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: empty               '
                        ' : empty
                        ' lit-pointer1 last !
                        ' lit-pointer2 dp ! ;
                        word    @@@IF_NFA
EMPTY_NFA               byte    $05,"empty"
EMPTY_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    @@@last_nfa                                     ' zeiger auf letzte nfa
                        word    @@@last_pfa                                     ' last
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               ' !
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    @@@m_dpointer                                   ' zeiger auf leeres wörterbuchende
                        word    @@@dp_pfa                                       ' dp
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               ' !
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: forget              '
                        ' : forget ( cstr -- )
                        '   last @ find dup =0 3 ?error dup
                        '   link last !
                        '   2 - dp ! ;
                        word    @@@EMPTY_NFA
FORGET_NFA              byte    $06,"forget"
FORGET_PFA              word    @@@last_pfa                                     ' last
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM               ' @
                        word    @@@find_pfa                                     ' find
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_0eq - @m_cbase) / 4 + PRIM                  ' =0
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_IN << 9)' lit 3
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    @@@link_pfa                                     ' link
                        word    @@@last_pfa                                     ' last
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               ' !
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (2 << 9)     ' lit 2
                        word    (@m_sub - @m_cbase) / 4 + PRIM                  ' -
                        word    @@@dp_pfa                                       ' dp
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               ' !
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: do                  '
                        ' : do c:( -- adr struk)
                        '   lit_swap , lit_dtor , lit_dtor ,    / swap >r >r compilieren
                        '   here STR_DO ;                       / adresse und strukturkennung
                        word    @@@FORGET_NFA
DO_NFA                  byte    $02 + NF_IM,"do"
DO_PFA                  word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 ' swap
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' >r
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' >r
                        word    @@@comma_pfa                                    ' ,
                        word    @@@here_pfa                                     ' here
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_DO << 9)' lit STR_DO
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: loop                '
                        ' : loop c:(adr struk -- )
                        '   STR_DO <> ERR_SI ?error
                        '   lit_loop , , ;
                        word    @@@DO_NFA
LOOP_NFA                byte    $04 + NF_IM,"loop"
LOOP_PFA                word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_DO << 9)' lit STR_DO
                        word    (@m_neq - @m_cbase) / 4 + PRIM                  ' <>
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)' lit ERR_SI
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_loop - @m_cbase) / 4 + PRIM                 ' (loop)
                        word    @@@comma_pfa                                    ' ,
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: +loop               '
                        ' : +loop c:(adr struk -- )
                        '   STR_DO <> ERR_SI ?error
                        '   lit_loop , , ;
                        word    @@@LOOP_NFA
PLOOP_NFA               byte    $05 + NF_IM,"+loop"
PLOOP_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (STR_DO << 9)' lit STR_DO
                        word    (@m_neq - @m_cbase) / 4 + PRIM                  ' <>
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)' lit ERR_SI
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_ploop - @m_cbase) / 4 + PRIM                 ' (ploop)
                        word    @@@comma_pfa                                    ' ,
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: leave               '
                        word    @@@PLOOP_NFA
LEAVE_NFA               byte    $05 + NF_PR,"leave"
LEAVE_PFA               word    (@m_leave - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: begin               '
                        ' : begin c:( -- adr struk)
                        '   here STR_BEGIN ;            / adresse und strukturkennung
                        word    @@@LEAVE_NFA
BEGIN_NFA               byte    $05 + NF_IM,"begin"
BEGIN_PFA               word    @@@here_pfa                                     ' here
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(STR_BEGIN<<9)     ' lit STR_BEGIN
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: until               '
                        ' : until c:(adr struk -- )
                        ' STR_BEGIN <> ERR_SI ?error
                        '   lit_0branch , , ;
                        word    @@@BEGIN_NFA
UNTIL_NFA               byte    $05 + NF_IM,"until"
UNTIL_PFA               word    (@m_lit6b - @m_cbase)/4+PRIM+(STR_BEGIN<<9)     ' lit STR_BEGIN
                        word    (@m_neq - @m_cbase) / 4 + PRIM                  ' <>
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)' lit ERR_SI
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              ' (0branch)
                        word    @@@comma_pfa                                    ' ,
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: again               '
                        ' : again c:(adr struk -- )
                        ' STR_BEGIN <> ERR_SI ?error
                        '   lit_branch , , ;
                        word    @@@UNTIL_NFA
AGAIN_NFA               byte    $05 + NF_IM,"again"
AGAIN_PFA               word    (@m_lit6b - @m_cbase)/4+PRIM+(STR_BEGIN<<9)     ' lit STR_BEGIN
                        word    (@m_neq - @m_cbase) / 4 + PRIM                  ' <>
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SI << 9)' lit ERR_SI
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    (@m_branch - @m_cbase) / 4 + PRIM               ' (branch)
                        word    @@@comma_pfa                                    ' ,
                        word    @@@comma_pfa                                    ' ,
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: cnt                 '
                        word    @@@AGAIN_NFA
CNT_NFA                 byte    $03 + NF_PR,"cnt"
CNT_PFA                 word    (@m_cnt - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: wait                '
                        word    @@@CNT_NFA
WAIT_NFA                byte    $04 + NF_PR,"wait"
WAIT_PFA                word    (@m_wait - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: clkfreq             '
                        word    @@@WAIT_NFA
CLKFREQ_NFA             byte    $07,"clkfreq"
CLKFREQ_PFA             word    (@m_litl - @m_cbase) / 4 + PRIM                 '
                        word    $04C4
                        word    $B400
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: x@                  '
                        word    @@@CLKFREQ_NFA
XFETCH_NFA              byte    $02 + NF_PR,"x@"
XFETCH_PFA              word    (@m_xfetch - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: x!                  '
                        word    @@@XFETCH_NFA
XSTORE_NFA              byte    $02 + NF_PR,"x!"
XSTORE_PFA              word    (@m_xstore - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ed                  '
                        word    @@@XSTORE_NFA
ED_NFA                  byte    $02,"ed"
ED_PFA                  word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#BEL_SCR_EDIT << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: mount               '
                        ' : mount ( -- err )
                        '   SD_MOUNT a! ?mount ;
                        word    @@@ED_NFA
MOUNT_NFA               byte    05,"mount"
MOUNT_PFA               word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#ADM_SD_MOUNT << 9)
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@qmount_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: unmount             '
                        ' : unmount ( -- )
                        '   SD_UNMOUNT a! ;
                        word    @@@MOUNT_NFA
UNMOUNT_NFA             byte    07,"unmount"
UNMOUNT_PFA             word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#ADM_SD_UNMOUNT << 9)
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ?mount              '
                        ' : ?mount ( -- )
                        '   SD_CHECKMOUNT a! a@ =0 ERR_SD ?error ;
                        word    @@@UNMOUNT_NFA
QMOUNT_NFA              byte    06,"?mount"
QMOUNT_PFA              word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#ADM_SD_CHECKMOUNTED << 9)
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_0eq - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_SD << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: tab                 '
                        ' : tab 9 b! ;
                        word    @@@QMOUNT_NFA
TAB_NFA                 byte    03,"tab"
TAB_PFA                 word    (@m_lit6b - @m_cbase) / 4 + PRIM + (9 << 9)
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: read                '
                        ' : read ( n -- err )
                        '   SCR_READ a! a!l a@ ERR_RW ?error ;
                        word    @@@TAB_NFA
READ_NFA                byte    04,"read"
READ_PFA                word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_READ
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@aputl_pfa
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_RW << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: write               '
                        ' : write ( n -- )
                        '   SCR_WRITE a! a!l a@ ERR_RW ?error ;
                        word    @@@READ_NFA
WRITE_NFA               byte    05,"write"
WRITE_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_WRITE
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@aputl_pfa
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_RW << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: fill                '
                        ' : fill ( n -- )
                        '   SCR_FILL a! a! ;
                        word    @@@WRITE_NFA
FILL_NFA                byte    04,"fill"
FILL_PFA                word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_FILL
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: scr@                '
                        ' : scr@ ( -- c )
                        '   SCR_GETC a! a@ ;
                        word    @@@FILL_NFA
SCRGET_NFA              byte    04,"scr@"
SCRGET_PFA              word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_GETC
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: scr!                '
                        ' : scr! ( c -- )
                        '   SCR_PUTC a! a! ;
                        word    @@@SCRGET_NFA
SCRPUT_NFA              byte    04,"scr!"
SCRPUT_PFA              word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_PUTC
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: pos!                '
                        ' : pos! ( n -- )
                        '   SCR_SETPOS a! a!l ;
                        word    @@@SCRPUT_NFA
POSPUT_NFA              byte    04,"pos!"
POSPUT_PFA              word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_SETPOS
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@aputl_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: list                '
                        ' : list ( n -- )
                        '   read 0 pos! 1024 for scr@ emit next ;
                        word    @@@POSPUT_NFA
LIST_NFA                byte    04,"list"
LIST_PFA                word    @@@read_pfa
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)
                        word    @@@posput_pfa
                        word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    1024
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM
LIST_M1                 word    @@@scrget_pfa
                        word    (@m_bput - @m_cbase) / 4 + PRIM
                        word    (@m_fnext - @m_cbase) / 4 + PRIM
                        word    @@@list_m1
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: edrd                '
                        ' : edrd ( n -- )
                        '   read 0 pos!
                        '   0 b! BEL_SCR_PUT b!
                        '   1024 for scr@ b! next
                        '   0 b! BEL_SCR_SETNR b! scrnr b!l scrmax b!l ed ;
                        word    @@@LIST_NFA
EDREAD_NFA              byte    04,"edrd"
EDREAD_PFA              word    @@@read_pfa                                     ' read
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             ' lit 0
                        word    @@@posput_pfa                                   ' pos!
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             ' lit 0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(gc#BEL_SCR_PUT<<9)   ' lit bel_scr_put
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    1024                                            ' 1024
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
EDREAD_M1               word    @@@scrget_pfa                                   ' scr@
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@edread_m1
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             ' lit 0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(gc#BEL_SCR_SETNR<<9) ' lit bel_scr_setnr
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    @@@scrnr_pfa                                    ' scrnr
                        word    @@@bputl_pfa                                    ' b!l
                        word    @@@scrmax_pfa                                   ' scrmax
                        word    @@@bputl_pfa                                    ' b!l
                        word    @@@ed_pfa                                       ' ed
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: edwr                '
                        ' : edwr ( -- )
                        '   0 pos!
                        '   0 b! BEL_SCR_GET b!
                        '   1024 for b@ scr! next scrnr write ;
                        word    @@@EDREAD_NFA
EDWRITE_NFA             byte    04,"edwr"
EDWRITE_PFA             word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             ' lit 0
                        word    @@@posput_pfa                                   ' pos!
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             ' lit 0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(gc#BEL_SCR_GET<<9)   ' lit bel_scr_get
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 ' b!
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 ' lit
                        word    1024                                            ' 1024
                        word    (@m_d_to_r - @m_cbase) / 4 + PRIM               ' for
EDWRITE_M1              word    (@m_bget - @m_cbase) / 4 + PRIM                 ' b@
                        word    @@@scrput_pfa                                   ' scr!
                        word    (@m_fnext - @m_cbase) / 4 + PRIM                ' next
                        word    @@@edwrite_m1
                        word    @@@scrnr_pfa                                    ' scrnr
                        word    @@@write_pfa                                    ' write
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: scrnr               '
                        ' : scrnr ( -- n )
                        '   SCR_GETNR a! a@l ;
                        word    @@@EDWRITE_NFA
SCRNR_NFA               byte    05,"scrnr"
SCRNR_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_GETNR
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@agetl_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: scrmax              '
                        ' : scrmax ( -- n )
                        '   SCR_MAXSCR a! a@l ;
                        word    @@@SCRNR_NFA
SCRMAX_NFA              byte    06,"scrmax"
SCRMAX_PFA              word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_MAXSCR
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@agetl_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ed+                 '
                        ' : ed+ ( -- )
                        '   scrnr 1+ edread ;
                        word    @@@SCRMAX_NFA
EDPLUS_NFA              byte    03,"ed+"
EDPLUS_PFA              word    @@@scrnr_pfa
                        word    @@@add1_pfa
                        word    @@@edread_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ed-                 '
                        ' : ed+ ( -- )
                        '   scrnr 1+ edread ;
                        word    @@@EDPLUS_NFA
EDMINUS_NFA             byte    03,"ed-"
EDMINUS_PFA             word    @@@scrnr_pfa
                        word    @@@sub1_pfa
                        word    @@@edread_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: ed0                 '
                        ' : ed0 ( -- )
                        '   0 edrd ;
                        word    @@@EDMINUS_NFA
EDZERO_NFA              byte    03,"ed0"
EDZERO_PFA              word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)
                        word    @@@edread_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: perform             '
                        ' perform ( index adr -- ) - sprung zu zeiger in index bei adr

                        word    @@@EDZERO_NFA
PERFORM_NFA             byte    07,"perform"
PERFORM_PFA             word    (@m_perform - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: eos?                '
                        ' : eos? ( -- fl )
                        '   scr_eos lit a! a@ ;
                        word    @@@PERFORM_NFA
EOSQ_NFA                byte    04,"eos?"
EOSQ_PFA                word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_EOS
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: (load)              '
                        ' : (load)
                        '   begin gc#adm_m_parse a! a@ gc#m_c_tag1 -
                        '     dup atoken perform
                        '     swap function perform
                        '   eos? until ;

                        word    @@@EOSQ_NFA
CLAMPEDLOAD_NFA         byte    06,"(load)"
                        ' begin gc#adm_m_parse a! a@ gc#m_c_tag1 -
CLAMPEDLOAD_PFA         word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#adm_m_parse
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#m_c_tag1 << 9)
                        word    (@m_sub - @m_cbase) / 4 + PRIM
                        ' dup atoken perform
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    @@@atoken_pfa
                        word    @@@perform_pfa
                        ' swap function perform
                        word    (@m_swap - @m_cbase) / 4 + PRIM
                        word    @@@function_pfa
                        word    @@@perform_pfa
                        ' eos? until ;
                        word    @@@eosq_pfa
                        word    (@m_0branch - @m_cbase) / 4 + PRIM
                        word    @@@CLAMPEDLOAD_PFA
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: >s                  '
                        ' : >s ( scrnr -- )
                        '   SCR_CALL a! a!l a@ ERR_RW ?error ;

                        word    @@@CLAMPEDLOAD_NFA
SCRCALL_NFA             byte    02,">s"
SCRCALL_PFA             word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_CALL
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    @@@aputl_pfa
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_RW << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: s>                  '
                        ' : s> ( -- )
                        '   SCR_RET a! a@ ERR_RW ?error ;

                        word    @@@SCRCALL_NFA
SCRRET_NFA              byte    02,"s>"
SCRRET_PFA              word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    gc#ADM_SCR_RET
                        word    (@m_aput - @m_cbase) / 4 + PRIM
                        word    (@m_aget - @m_cbase) / 4 + PRIM
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_RW << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: load (nested)       '
                        ' : load >s (load) s> ;

                        word    @@@SCRRET_NFA
LOAD_NFA                byte    04,"load"
LOAD_PFA                word    @@@scrcall_pfa
                        word    @@@clampedload_pfa
                        word    @@@scrret_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: -->                 '
                        ' : --> scrnr 1+ read (load) ;

                        word    @@@LOAD_NFA
NEXTSCR_NFA             byte    $03,"-->"
NEXTSCR_PFA             word    @@@scrnr_pfa
                        word    @@@add1_pfa
                        word    @@@read_pfa
                        word    @@@clampedload_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: sys                 '
                        ' : sys adm_scr_sys a! ;

                        word    @@@NEXTSCR_NFA
SYS_NFA                 byte    $03,"sys"
SYS_PFA                 word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit
                        word    gc#adm_scr_sys                                  'sys
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: home                '
                        ' : home ADM_SCR_HOME a! a@ ERR_NF ?error ;

                        word    @@@SYS_NFA
HOME_NFA                byte    $04,"home"
HOME_PFA                word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit
                        word    gc#adm_scr_home                                 'sys
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 'a@
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_NF << 9)
                        word    @@@qerror_pfa                                   '?error
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: m                   '
                        ' : m
                        '   ?cerr cold w@
                        '   if sys 0 dup load cold w! then
                        '   begin token again ;

                        word    @@@HOME_NFA
M_NFA                   byte    $01,"m"
M_START                 ' bootscreen laden
                        ' ?cerr cold w@ if 0 dup load cold w!
                        word    @@@qcerr_pfa
                        word    @@@cold_pfa
                        word    (@m_wfetch - @m_cbase) / 4 + PRIM
                        word    (@m_0branch - @m_cbase) / 4 + PRIM
                        word    @@@m_pfa
                        word    @@@sys_pfa
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)
                        word    (@m_dup - @m_cbase) / 4 + PRIM
                        word    @@@load_pfa
                        word    @@@cold_pfa
                        word    (@m_wstore - @m_cbase) / 4 + PRIM
                        ' then begin
M_PFA                   word    @@@token_pfa
                        ' again ;
m_m6                    word    (@m_branch - @m_cbase) / 4 + PRIM
                        word    @@@m_pfa

dat                                                     'm: cold                '
                        'kaltstartvariable

                        word    @@@M_NFA
COLD_NFA                byte    $04,"cold"
COLD_PFA                word    (@m_data - @m_cbase) / 4 + PRIM
                        word    1


dat                                                     'm: ?cerr               '
                        ' core-error auswerten (stackfehler)
                        ' : ?cerr
                        '   lit core_error dup c@ swap 0 swap c! 9 ?error ;

                        word    @@@COLD_NFA
QCERR_NFA               byte    $05,"?cerr"
QCERR_PFA               word    (@m_litw - @m_cbase) / 4 + PRIM
                        word    @@@core_error
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  ' dup
                        word    (@m_cfetch - @m_cbase) / 4 + PRIM               ' c@
                        word    (@m_swap - @m_cbase) / 4 + PRIM                  ' swap
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)     ' 0
                        word    (@m_swap - @m_cbase) / 4 + PRIM                  ' swap
                        word    (@m_cstore - @m_cbase) / 4 + PRIM               ' c!
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (9 << 9)     ' 9
                        word    @@@qerror_pfa                                   ' ?error
                        word    (@m_exit - @m_cbase) / 4 + PRIM                 ' ;

dat                                                     'm: (use)               '
                        ' : use (cstr -- err)
                        '   SCR_USE a! a!s a@ ;
                        word    @@@QCERR_NFA
CLAMPUSE_NFA            byte    $05,"(use)"
CLAMPUSE_PFA            word    (@m_litw - @m_cbase) / 4 + PRIM                 ' scr_use
                        word    gc#ADM_SCR_USE
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    @@@aputs_pfa                                    'a!s
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 'a@
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: use                 '
                        ' : use (cstr -- )
                        '   (use) M_ERR_NF ?error ;
                        word    @@@CLAMPUSE_NFA
USE_NFA                 byte    $03,"use"
USE_PFA                 word    (@m_litw - @m_cbase) / 4 + PRIM                 ' scr_use
                        word    gc#ADM_SCR_USE
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    @@@aputs_pfa                                    'a!s
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 'a@
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_NF << 9)
                        word    @@@qerror_pfa
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: dir                 '
                        ' : dir
                        '   cr #adm_sd_opendir a! 1
                        '   begin
                        '     #adm_sd_nextfile a! a@ dup
                        '     if a@s .str space
                        '       swap dup 4 = if drop 0 cr then 1+ swap
                        '     then stop? 0=
                        '   until drop ;

                        word    @@@USE_NFA
LS_NFA                  byte    $03,"dir"
LS_PFA                  word    @@@cr_pfa                                       'cr
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit
                        word    gc#ADM_SD_OPENDIR                               'opendir
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (1 << 9)     'lit 1
LS_M1                                                                           'begin
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit
                        word    gc#ADM_SD_NEXTFILE                              'nextfile
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 'a@
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  'dup
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'if
                        word    @@@LS_M2
                        word    @@@agets_pfa                                    'a@s
                        word    @@@dotstr_pfa                                   '.str
                        word    @@@space_pfa                                    'space
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  'dup
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (4 << 9)     'lit 4
                        word    (@m_eq - @m_cbase) / 4 + PRIM                   '=
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'if
                        word    @@@LS_M3
                        word    (@m_drop - @m_cbase) / 4 + PRIM                 'drop
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (0 << 9)     'lit 0
                        word    @@@cr_pfa                                       'cr
LS_M3                                                                           'then
                        word    @@@add1_pfa                                     '1+
                        word    (@m_swap - @m_cbase) / 4 + PRIM                 'swap
LS_M2                                                                           'then
                        word    @@@stopq_pfa                                    'stop?
                        word    (@m_0eq - @m_cbase) / 4 + PRIM                  '0=
                        word    (@m_0branch - @m_cbase) / 4 + PRIM              'until
                        word    @@@LS_M1
                        word    (@m_exit - @m_cbase) / 4 + PRIM


dat                                                     'm: cd                  '
                        ' : cd #adm_sd_chdir a! a!s a@
                        '   M_ERR_NF ?error ;
                        word    @@@LS_NFA
CD_NFA                  byte    $02,"cd"
CD_PFA                  word    (@m_litw - @m_cbase) / 4 + PRIM                 'lit
                        word    gc#ADM_SD_CHDIR                                 'chdir
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    @@@aputs_pfa                                    'a!s
                        word    (@m_aget - @m_cbase) / 4 + PRIM                 'a@
                        word    (@m_lit6b - @m_cbase) / 4 + PRIM + (gc#M_ERR_NF << 9)
                        word    @@@qerror_pfa                                   '?error
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: reset               '

                        word    @@@CD_NFA
RESET_NFA               byte    $05 + NF_PR,"reset"
RESET_PFA               word    (@m_reset - @m_cbase) / 4 + PRIM
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: reboot              '
                        ' : reboot sys cls 1 cold w! empty abort ;             '

                        word    @@@RESET_NFA
REBOOT_NFA              byte    $06,"reboot"
REBOOT_PFA              word    @@@sys_pfa                                      'sys
                        word    @@@cls_pfa
                        word    (@m_lit6b - @m_cbase)/4+PRIM+(1<<9)             '1
                        word    @@@cold_pfa                                     'cold
                        word    (@m_wstore - @m_cbase) / 4 + PRIM               'w!
                        word    @@@empty_pfa                                    'empty
                        word    @@@abort_pfa                                    'abort
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: bye                 '
                        ' : bye 0 b! BEL_REBOOT dup b! a! reset ;             '

                        word    @@@REBOOT_NFA
BYE_NFA                 byte    $03,"bye"
BYE_PFA                 word    (@m_lit6b - @m_cbase)/4+PRIM+(0<<9)             '0
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 'b!
                        word    (@m_litw - @m_cbase) / 4 + PRIM                 'bel_reboot
                        word    gc#bel_reboot
                        word    (@m_dup - @m_cbase) / 4 + PRIM                  'dup
                        word    (@m_bput - @m_cbase) / 4 + PRIM                 'b!
                        word    (@m_aput - @m_cbase) / 4 + PRIM                 'a!
                        word    @@@reset_pfa                                    'reset
                        word    (@m_exit - @m_cbase) / 4 + PRIM

dat                                                     'm: last                '
                        ' dieses wort muss beim compilieren am ende des wb stehen
                        ' variable mit dem zeiger auf die letzte nfa im wb

                        word    @@@BYE_NFA
LAST_NFA                byte    $04,"last"
LAST_PFA                word    (@m_data - @m_cbase) / 4 + PRIM
                        word    @@@LAST_NFA

dat                                                     'm: div. pointer        '
m_dpointer
m_dend


CON                                                     'M-CORE
DAT                                                     'pasm-code              '

m_cbase                 org     0


' ---------------------------------------------------------------------
' INITIALISIERUNG
' ---------------------------------------------------------------------
                        mov     REG_A,PAR
                        rdlong  IP,REG_A         ' adresse startcode einlesen
                        add     REG_A,#4
                        mov     ECP,REG_A        ' zeiger auf errorcode setzen
                        add     REG_A,#4
                        jmp     #m_next

' ---------------------------------------------------------------------
' P R I M Ä R E   F U N K T I O N E N
' ---------------------------------------------------------------------


' ---------------------------------------------------------------------
' system
' ---------------------------------------------------------------------

m_cnt                   mov     REG_A,cnt
                        jmp     #m_pushnext

m_wait                  call    #m_dspop
                        mov     REG_B,cnt
                        add     REG_B,REG_A
                        waitcnt REG_B,REG_A
                        jmp     #m_next

' ---------------------------------------------------------------------
' stackmanipulation
' ---------------------------------------------------------------------

m_r_to_d                call    #m_rspop        ' R>
                        call    #m_dspush
                        jmp     #m_next

m_d_to_r                call    #m_dspop        ' >R
                        call    #m_rspush
                        jmp     #m_next

m_drop                  call    #m_dspop
                        jmp     #m_next

m_swap                  call    #m_2pop
                        mov     REG_C,REG_A
                        mov     REG_A,REG_B
                        call    #m_dspush
                        mov     REG_A,REG_C
                        call    #m_dspush
                        jmp     #m_next

m_dup                   call    #m_dspop
                        call    #m_dspush
                        call    #m_dspush
                        jmp     #m_next

m_rot                   call    #m_2pop
                        mov     REG_C,REG_A
                        call    #m_dspop
                        mov     REG_D,REG_A
                        mov     REG_A,REG_C
                        call    #m_dspush
                        mov     REG_A,REG_B
                        call    #m_dspush
                        mov     REG_A,REG_D
                        call    #m_dspush
                        jmp     #m_next

m_pick                  call    #m_dspop
                        mov     REG_B,DP
                        sub     REG_B,REG_A
                        movs    :modify,REG_B
                        movs    m_dspush_ret, #m_next
  :modify               mov     REG_A,REG_A
                        jmp     #m_dspush

m_litw                  rdword  REG_A,IP
                        add     IP,#2
                        jmp     #m_pushnext

m_litl                  rdword  REG_A,IP
                        add     IP,#2
                        shl     REG_A,#16
                        rdword  REG_B,IP
                        add     IP,#2
                        or      REG_A,REG_B
                        jmp     #m_pushnext

m_lit6b                 shr     REG_A,#9
                        and     REG_A,#$3F      'M_6B
                        jmp     #m_pushnext

m_lits                  rdbyte  REG_B,IP        ' längenbyte einlesen
                        mov     REG_A,IP
                        call    #m_dspush       ' cstr-adresse --> stack
                        add     IP,REG_B        ' längenbyte zu ip addieren
                        add     IP,#2           ' ip ausrichten
                        andn    IP,#1
                        jmp     #m_next

m_ds                    mov     REG_A,DP
                        sub     REG_A,D0
                        jmp     #m_pushnext

' ---------------------------------------------------------------------
' wortdefinitionen
' ---------------------------------------------------------------------

m_data                  mov     REG_A,IP        ' adresse der daten
                        call    #m_dspush       ' adresse --> datenstack
                        jmp     #m_exit         ' return

{
m_dovarw                mov     REG_A,IP
                        add     IP,#2
                        jmp     #m_pushnext

m_dovarl                mov     REG_A,IP
                        add     IP,#4
                        jmp     #m_pushnext



m_doconstw              rdword  REG_A,IP
                        add     IP,#2
                        jmp     #m_pushnext

m_doconstl              rdword  REG_A,IP
                        add     IP,#2
                        shl     REG_A,#16
                        rdword  REG_B,IP
                        add     IP,#2
                        or      REG_A,REG_B
                        jmp     #m_pushnext

}
' ---------------------------------------------------------------------
' logische funktionen
' ---------------------------------------------------------------------

m_not                   call    #m_dspop
                        xor     REG_A,M_32B
                        jmp     #m_pushnext

m_and                   call    #m_2pop
                        and     REG_A,REG_B
                        jmp     #m_pushnext

m_andn                  call    #m_2pop
                        andn    REG_A,REG_B
                        jmp     #m_pushnext

m_or                    call    #m_2pop
                        or      REG_A,REG_B
                        jmp     #m_pushnext

m_xor                   call    #m_2pop
                        xor     REG_A,REG_B
                        jmp     #m_pushnext

m_lshift                call    #m_2pop
                        shl     REG_A,REG_B
                        jmp     #m_pushnext

m_rshift                call    #m_2pop
                        shr     REG_A,REG_B
                        jmp     #m_pushnext

m_rol                   call    #m_2pop
                        rol     REG_A,REG_B
                        jmp     #m_pushnext

m_ror                   call    #m_2pop
                        ror     REG_A,REG_B
                        jmp     #m_pushnext

' ---------------------------------------------------------------------
' vergleichsfunktionen
' ---------------------------------------------------------------------

m_eq                                                    ' =
                        call    #m_2pop
                        cmp     REG_A,REG_B    wz, wc
                        jmp     #m_0eq_m1
m_0eq                   call    #m_dspop                '0=
'                        cmp     REG_A,#0    wz, wc
m_0eq_m1                muxz    REG_A,M_32B
                        jmp     #m_pushnext

m_neq                                                   ' <>
                        call    #m_2pop
                        cmp     REG_A,REG_B    wz, wc
                        muxnz   REG_A,M_32B
                        jmp     #m_pushnext

m_gt                                                    ' >
                        call    #m_2pop
                        cmps    REG_B,REG_A    wz, wc
                        jmp     #m_lt_m1
m_lt                    call    #m_2pop                 ' <
                        cmps    REG_A,REG_B    wz, wc
m_lt_m1                 muxc    REG_A,M_32B
                        jmp     #m_pushnext

' ---------------------------------------------------------------------
' integer arithmetic
' ---------------------------------------------------------------------

m_add                   call    #m_2pop
                        add     REG_A,REG_B
                        jmp     #m_pushnext

m_sub                   call    #m_2pop
                        sub     REG_A,REG_B
                        jmp     #m_pushnext

m_umstar                                                ' um*
                        call    #m_2pop
                        mov     REG_C, #0
                        mov     REG_D, #0
                        mov     REG_E, #0
  :loop
                        shr     REG_B, #1      wz,wc
        if_nc           jmp     #:mark1
                        add     REG_E, REG_A   wc
                        addx    REG_C, REG_D
  :mark1
                        shl     REG_A, #1      wc
                        rcl     REG_D, #1
        if_nz           jmp     #:loop
                        mov     REG_A,REG_E
                        call    #m_dspush
                        mov     REG_A,REG_C
                        call    #m_dspush
                        jmp     #m_next

m_uslashmod                                             ' U/MOD
                        call    #m_2pop         ' reg_a = n2, reg_b = n1
                        '       REG_A           ' n1 divident
                        '       REG_B           ' n2 divisor
                        mov     REG_D,#$20      ' bitzähler 32 bit
                        mov     REG_C,#0        ' rest
                        mov     REG_E,#0        ' quotient
  :loop
                        shl     REG_A,#1    wc  ' divident - oberste stelle --> carry
                        rcl     REG_C,#1        ' rest - unterste stelle <-- carry
                        cmpsub  REG_C,REG_B wc  ' vergleiche rest divisor
                        rcl     REG_E,#1        ' ergebnis in unterse stelle quotient schieben
                        djnz    REG_D,#:loop

                        mov     REG_A,REG_C
                        call    #m_dspush
                        mov     REG_A,REG_E
                        call    #m_dspush
                        jmp     #m_next

m_abs                   call    #m_dspop
                        abs     REG_A,REG_A
                        jmp     #m_pushnext

m_neg                   call    #m_dspop                ' NEGATE
                        neg     REG_A,REG_A
                        jmp     #m_pushnext

' ---------------------------------------------------------------------
' speicher hub-ram
' ---------------------------------------------------------------------

m_fetch                 call    #m_dspop        'reg_a = adr
                        rdword  REG_B,REG_A     'nwt einlesen
                        add     REG_A,#2
                        rdword  REG_A,REG_A     'hwt einlesen
                        rcl     REG_A,#16
                        add     REG_A,REG_B
                        jmp     #m_pushnext

m_store                 call    #m_2pop         'reg_b = adr, reg_a = n
                        wrword  REG_A,REG_B     'nwt schreiben
                        add     REG_B,#2
                        rcr     REG_A,#16
                        wrword  REG_A,REG_B     'hwt schreiben
                        jmp     #m_next

m_wfetch                call    #m_dspop
                        rdword  REG_A,REG_A
                        jmp     #m_pushnext

m_wstore                call    #m_2pop         'reg_b = adr, reg_a = n
                        wrword  REG_A,REG_B
                        jmp     #m_next

m_cfetch                call    #m_dspop
                        rdbyte  REG_A,REG_A
                        jmp     #m_pushnext

m_cstore                call    #m_2pop         'reg_b = adr, reg_a = n
                        wrbyte  REG_A,REG_B
                        jmp     #m_next


' reg_a       - zeiger auf quelle
' reg_b       - zähler
' reg_c       - zeiger auf ziel
' reg_d       - wert

m_cmove                 call    #m_2pop
                        mov     REG_C,REG_A
                        call    #m_dspop
m_cmove_m1              rdbyte  REG_D,REG_A
                        add     REG_A,#1
                        wrbyte  REG_D,REG_C
                        add     REG_C,#1
                        djnz    REG_B,#m_cmove_m1
                        jmp     #m_next

' ---------------------------------------------------------------------
' stringfunktionen
' ---------------------------------------------------------------------

' reg_a       - zeiger 1
' reg_b       - zeiger 2
' reg_c       - maske für länge, char 1
' reg_d       - stringlänge 1
' reg_e       - char 2
' ergebnis --> reg_a & z-flag

m_streq
                        rdbyte  REG_D,REG_A wz
              if_nz     and     REG_D,REG_C wz
              if_z      jmp     #m_streq_ret

                        rdbyte  REG_C,REG_B
                        cmp     REG_C,REG_D wz  'länge1 = länge2?
              if_nz     mov     REG_A,#0
              if_nz     jmp     m_streq_ret
m_streq_m1
                        add     REG_A,#1
                        rdbyte  REG_C,REG_A
                        add     REG_B,#1
                        rdbyte  REG_E,REG_B
                        cmp     REG_C,REG_E wz
              if_z      djnz    REG_D,#m_streq_m1
                        muxz    REG_A,M_32B
m_streq_ret   ret

m_nameeq
                        mov     REG_C,#$0F
                        jmp     #m_cstreq_m1
m_cstreq
                        mov     REG_C,#$FF
m_cstreq_m1             call    #m_2pop
                        call    #m_streq
                        jmp     #m_pushnext

' (cstr nfa1 -- nfa2)
' reg_a/b/c   - tmp
' reg_d/d     - benutzt von m_streq
' reg_f       - cstr
' reg_g       - nfa

m_find
                        call    #m_2pop
                        mov     REG_F,REG_A     'cstr puffern
                        mov     REG_G,REG_B     'nfa1 puffern
m_find_loop
                        mov     REG_B,REG_F     'cstr1 (cstr)
                        mov     REG_A,REG_G     'cstr2 (nfa)
                        mov     REG_C,#$0F      'maske für namensstrings
                        call    #m_streq        'strings vergleichen
              if_nz     jmp     #m_find_m2      'z=0 --> nicht gefunden, nächstes wort
m_find_m1
                        mov     REG_A,REG_G
                        jmp     #m_pushnext
m_find_m2
                        mov     REG_B,REG_G     'zum nächsten wort linken
                        sub     REG_B,#2
                        rdword  REG_G,REG_B   wz
              if_z      jmp     #m_find_m1      'nfa2 = 0? --> ende erreicht
                        jmp     #m_find_loop

' ---------------------------------------------------------------------
' businterface
' ---------------------------------------------------------------------

' reg_a       io-zeichen
' reg_b       temp
' reg_c       temp

m_aput                  ' zeichen zu administra senden
                        mov     REG_B,_a1
                        mov     REG_C,_a2
                        jmp     #m_sput

m_bput                  ' zeichen zu bellatrix senden
                        mov     REG_B,_b1
                        mov     REG_C,_b2

m_sput                  call    #m_dspop
                        waitpeq _hs,_hs           ' warte auf hs=1 (slave bereit)
                        and     reg_a,#$ff        ' wert maskieren
                        or      reg_a,REG_B       ' + bel=0 wr=0 clk=0
                        mov     outa,reg_a        ' daten + signale ausgeben
                        mov     dira,dout         ' bus auf ausgabe schalten
                        or      outa,REG_C        ' clk=0 --> clk=1
                        waitpeq _zero,_hs         ' warte auf hs=0
                        mov     dira,dinp         ' bus auf eingabe schalten
                        mov     outa,_s1          ' bussignale inaktiv
                        jmp     #m_next

m_aget                  ' zeichen von administra empfangen
                        mov     REG_B,_a3
                        jmp     #m_sget

m_bget                  ' zeichen von belatrix empfangen
                        mov     REG_B,_b3

m_sget                  waitpeq _hs,_hs           ' warte auf hs=1 (slave bereit)
                        mov     outa,REG_B        ' bel=0 wr=1 clk=1
                        waitpeq _zero,_hs         ' warte auf hs=0
                        mov     reg_a,ina         ' daten einlesen
                        and     reg_a,#$ff        ' wert maskieren
                        mov     outa,_s1          ' bussignale inaktiv
                        jmp     #m_pushnext


'       reg_a         wert
'       reg_b         adresse
'       reg_c         zerstört
'       reg_d         zerstört

m_xstore                ' byte in xram schreiben
                        call    #m_2pop
                        mov     dira,dout         ' bus auf ausgabe schalten
                        call    #setadr           ' adresse setzen
                        ' wert schreiben
                        and     REG_A,#$ff
                        or      outa,REG_A        ' wert an ports setzen
                        xor     outa,_bwr         ' schreibsignal aktiv
                        mov     dira,dinp         ' bus auf eingabe schalten
                        mov     outa,_s1          ' bus wieder inaktiv
                        jmp     #m_next

m_xfetch                ' byte aus xram lesen
                        call    #m_dspop
                        mov     REG_B,REG_A
                        call    #setadr           ' adresse setzen
                        ' wert schreiben
                        mov     REG_A,ina         ' port einlesen
                        and     REG_A,#$ff        ' daten ausmaskieren
                        mov     outa,_s1          ' bus wieder inaktiv
                        jmp     #m_pushnext

setadr                  ' adresse verarbeiten
                        ' hwt-adresse --> latch
                        mov     REG_C,REG_B       ' adresse holen
                        shr     REG_C,#3          ' adresse für latch zurechtschieben
                        and     REG_C,_latch      ' latchbits ausmaskieren
                        or      outa,REG_C        ' adresse für latch an ports setzen
                        xor     outa,_al          ' wert in latch übernehmen
                        mov     outa,_s1          ' bus wieder inaktiv
                        ' nwt-adresse setzen
                        mov     REG_C,REG_B       ' adresse holen
                        shl     REG_C,#8          ' adresse zurechtschieben
                        and     REG_C,_adr        ' adresse ausmaskieren
                        or      outa,REG_C        ' adresse an ports setzen
                        xor     outa,_ram1        ' rambank 1 selektieren
setadr_ret              ret


'                  +------------------------------- /hs
'                  |+------------------------------ /wr
'                  ||+----------------------------- busclk
'                  |||+---------------------------- hbeat
'                  |||| +-------------------------- al
'                  |||| |+------------------------- /bel
'                  |||| ||+------------------------ /adm
'                  |||| |||+----------------------- /ram2
'                  |||| ||||+---------------------- /ram1
'                  |||| |||||           +---------- a0..10
'                  |||| |||||           |
'                  |||| |||||           |        +- d0..7
'                  |||| |||||+----------+ +------+
_al     long  %00000000_10000000_00000000_00000000  ' /al bitmaske
_bwr    long  %00000100_00000000_00000000_00000000  ' /wr bitmaske
_ram1   long  %00000000_00001000_00000000_00000000  ' /ram1 bitmaske
_latch  long  %00000000_00000000_11111111_00000000  ' latch bitmaske
_adr    long  %00000000_00000111_11111111_00000000  ' adrbus bistmaske

dinp    long  %00000111_11111111_11111111_00000000  ' bus input
dout    long  %00000111_11111111_11111111_11111111  ' bus output
_s1     long  %00000100_01111000_00000000_00000000  ' bus inaktiv
_b1     long  %00000000_00111000_00000000_00000000  ' adm=1, bel=0, wr=0, busclk=0
_b2     long  %00000010_00111000_00000000_00000000  ' adm=1, bel=0, wr=0, busclk=1
_b3     long  %00000110_00111000_00000000_00000000  ' adm=1, bel=0, wr=1, busclk=1
_a1     long  %00000000_01011000_00000000_00000000  ' adm=0, bel=1, wr=0, busclk=0
_a2     long  %00000010_01011000_00000000_00000000  ' adm=0, bel=1, wr=0, busclk=1
_a3     long  %00000110_01011000_00000000_00000000  ' adm=0, bel=1, wr=1, busclk=1
_hs     long  %00001000_00000000_00000000_00000000  ' hs=1?
_zero   long  %00000000_00000000_00000000_00000000  '

' ---------------------------------------------------------------------
' kontrollstrukturen
' ---------------------------------------------------------------------

' reg_a       - limit
' reg_b       - index
' reg_c       - step

m_loop                  mov     REG_C,#1
                        jmp     #m_ploop_m1
m_ploop                 call    #m_dspop
                        mov     REG_C,REG_A
m_ploop_m1              call    #m_rspop
                        mov     REG_B,REG_A
                        call    #m_rspop
                        add     REG_B,REG_C
                        cmp     REG_A,REG_B      wz,wc
              if_c      add     IP,#2
              if_c      jmp     #m_next
                        call    #m_rspush
                        mov     REG_A,REG_B
                        call    #m_rspush
                        rdword  REG_A,IP
                        mov     IP,REG_A
                        jmp     #m_next

' reg_a       - limit
' reg_b       - index
m_leave                 call    #m_rspop        ' index einlesen
                        mov     REG_B,REG_A
                        call    #m_rspop
                        mov     REG_A,REG_B
                        call    #m_rspush
                        call    #m_rspush
                        jmp     #m_next

m_fnext                 call    #m_rspop
                        sub     REG_A,#1 wz
              if_z      add     IP,#2
              if_z      jmp     #m_next
                        call    #m_rspush
                        rdword  REG_A,IP
                        mov     IP,REG_A
                        jmp     #m_next

m_index                 call    #m_rspop
                        call    #m_rspush
                        call    #m_dspush
                        jmp     #m_next

m_execute               mov     REG_A,IP
                        call    #m_rspush
                        call    #m_dspop
                        mov     IP,REG_A
                        jmp     #m_next


m_branch                rdword  REG_A,IP
                        mov     IP,REG_A
                        jmp     #m_next

m_0branch               call    #m_dspop
                        cmp     REG_A,#0  wz
              if_z      jmp     #m_branch
                        add     IP,#2
                        jmp     #m_next

                        ' ip = adr + index * 2  ' sprungtabelle
m_perform               call    #m_dspop        ' a = adresse
                        mov     REG_B,REG_A     ' a = b
                        call    #m_dspop        ' a = index
                        shl     REG_A,#1        ' a = a * 2
                        add     REG_A,REG_B     ' a = a + b
                        rdword  REG_A,REG_A     ' a = (a)
                        jmp     #m_exit2        ' return

m_reset                 'clkset  M_RES
                        hubop $, #%10000_000


' ---------------------------------------------------------------------
' innerer interpreter
' ---------------------------------------------------------------------
' 16 bit opcode:
' 1xxxxxxa_aaaaaaaa     a - 9  bit adresse primärcode (cRAM-adresse, primärer code)
'                       x - 6  bit immediate-literal
' 0aaaaaaa_aaaaaaaa     a - 15 bit adresse sekundärcode (hRAM-adresse, sekundärer code)


m_exit                  call    #m_rspop
m_exit2                 mov     IP,REG_A
m_next                  rdword  REG_A,IP                ' reg_a = (ip) - opcode einlesen
                        add     IP,#2                   ' ip = ip + 2 - befehlszähler erhöhen
                        test    REG_A,M_PRI     wz      ' bit15 = primär/sekundär?
                        '-------------------------------
        if_nz           jmp     REG_A                   ' bit 15 == 1, primären code ausführen
                        '-------------------------------
                        movd    :modify,RP              ' | sekundären code ausführen
                        add     RP,#1                   ' | ip --> rs(rp)
  :modify               mov     IP,IP                   ' |
                        jmp     #m_exit2                ' next

' ---------------------------------------------------------------------
' befehls-subsequenzen
' ---------------------------------------------------------------------

' (reg_a reg_b -- )
' reg_b - oberstes stackelement
' reg_a - zweites stackelement

m_2pop                  call    #m_dspop
                        mov     REG_B,REG_A
                        call    #m_dspop
m_2pop_ret              ret

' ---------------------------------------------------------------------

m_pushnext              call    #m_dspush
                        jmp     #m_next

' ---------------------------------------------------------------------

m_err                   mov     REG_A,#ASM_ERR_ST
                        WRLONG  REG_A,ECP         ' fehlercode schreiben
                        mov     REG_A,PAR
m_abort                 rdlong  IP,REG_A          ' adresse startcode einlesen
                        mov     RP,R0
                        mov     DP,D0
                        jmp     #m_next

' ---------------------------------------------------------------------
' stackroutinen
' ---------------------------------------------------------------------
' stacks:
' - absteigende organisation
' - stackpointer steht immer auf erstem freien element

m_rspush                movd    :modify,RP      ' (RP++) = REG_A
                        add     RP,#1
                        cmp     RP,#RS_BOT wc
              if_nc     jmp     #m_err
  :modify               mov     REG_A,REG_A
m_rspush_ret            ret

' ---------------------------------------------------------------------

m_rspop                 sub     RP,#1           ' REG_A = (--RP)
                        movs    :modify,RP
                        cmp     RP,#RS wc
              if_c      jmp     #m_err
  :modify               mov     REG_A,REG_A
m_rspop_ret             ret

' ---------------------------------------------------------------------

m_dspush                movd    :modify,DP      ' (DP++) = REG_A
                        add     DP,#1
                        cmp     DP,#DS_BOT wc
              if_nc     jmp     #m_err
  :modify               mov     REG_A,REG_A
m_dspush_ret            ret

' ---------------------------------------------------------------------

m_dspop                 sub     DP,#1           ' REG_A = (--DP)
                        movs    :modify,DP
                        cmp     DP,#DS wc
              if_c      jmp     #m_err
  :modify               mov     REG_A,REG_A wz
m_dspop_ret             ret


' ---------------------------------------------------------------------
' register und konstanten
' ---------------------------------------------------------------------
m_rbase                 ' adresse registerfile-anfang

IP                      long    0                       ' instruction pointer
RP                      long    (@RS - @m_cbase) / 4    ' returnstack pointer
DP                      long    (@DS - @m_cbase) / 4    ' datenstack pointer
R0                      long    (@RS - @m_cbase) / 4    ' returnstack start
D0                      long    (@DS - @m_cbase) / 4    ' datenstack start
REG_A                   long    0                       ' arbeitsregister a..d
REG_B                   long    0
REG_C                   long    0
REG_D                   long    0
REG_E                   long    0
REG_F                   long    0
REG_G                   long    0
ECP                     long    0                       ' error code pointer

M_PRI                   long    $8000                   ' maske für primäre

RS                      long    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ' returnstack
                        long    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
RS_BOT

DS                      long    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ' datenstack
                        long    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DS_BOT

M_16B                   long    $0000FFFF
M_32B                   long    $FFFFFFFF

m_rend                  ' adresse registerfile-ende
m_cend

                        long    0 [10]          'freie longs in cogram
                        FIT
' ---------------------------------------------------------------------
'
' ---------------------------------------------------------------------

DAT                                                     'lizenz                 '

{{

┌──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
│                                                   TERMS OF USE: MIT License                                                  │
├──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    │
│files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    │
│modify, merge, PRIlish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software│
│is furnished to do so, subject to the following conditions:                                                                   │
│                                                                                                                              │
│The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.│
│                                                                                                                              │
│THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          │
│WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         │
│COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   │
│ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         │
└──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
}}


































