{{
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ Autor: Ingo Kripahle                                                                                 │
│ Copyright (c) 2010 Ingo Kripahle                                                                     │
│ See end of file for terms of use.                                                                    │
│ Die Nutzungsbedingungen befinden sich am Ende der Datei                                              │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘

Informationen   : hive-project.de
Kontakt         : drohne235@gmail.com
System          : mental
Name            : Administra-Flash
Chip            : Administra
Typ             : Flash

Funktion        :

                  Chip-Managment-Funktionen
                  - Abfrage Version und Spezifikation

                  SD-Funktionen:
                  - Block/Screeninterface für mental
                  - FAT16/32 Funktionen

Komponenten     :

COG's           : MANAGMENT     1 COG
                  FATENGINE     1 COG
                  COM           1 COG
                  PLX-POLLER    1 COG
                  SID1/2        2 COGS
                  -------------------
                                6 Cogs

Multifile Handles:

0               mCore Blockinterface
1               SIDcog/DMP-Player
2..MAXFILES-1   Freie Dateihandles



Logbuch         :

27.03.2012-dr235  - übernahme in mental system
                  - ausfügung von hss
31.03.2012-dr235  - screennummern sind jetzt long in anpassung an m
18.09.2012-dr235  - kompletter neuaufbau mit fsrw als basis für ein reines blockinterface
11.07.2014-dr235  - fatengine 2.0 singlefile
06.10.2014-dr235  - fatengine 2.0 multifilesupport
                  - dmp-player


Notizen         :

}}

' bei aktivierung der debug-ausgabe muss das com-objekt deaktiviert werden!

'#define _debug
#define _com
'#define _fat_rtc
#define _fat_nortc
#define _dmp


CON

_CLKMODE     = XTAL1 + PLL16X
_XINFREQ     = 5_000_000


'                   +----------
'                   |  +------- system
'                   |  |  +---- version    (änderungen)
'                   |  |  |  +- subversion (hinzufügungen)
CHIP_VER        = $00_02_00_01
'
'                                          +----------- blk
'                                          |+---------- com
'                                          || +-------- i2c
'                                          || |+------- rtc
'                                          || ||+------ lan
'                                          || |||+----- sid
'                                          || ||||+---- wav
'                                          || |||||+--- hss
'                                          || ||||||+-- bootfähig
'                                          || |||||||+- dateisystem
CHIP_SPEC       = %00000000_00000000_00000010_00000000

'
'          hbeat   --------+
'          clk     -------+|
'          /wr     ------+||
'          /hs     -----+||| +------------------------- /cs
'                       |||| |+------------------------ adm-p22
'                       |||| ||+----------------------- adm-p21 (io)
'                       |||| |||+---------------------- adm-p20 (rx)
'                       |||| ||||+--------------------- adm-p19 (tx)
'                       |||| |||||             +------+ d0..d7
'                       |||| |||||             |      |
DB_IN            = %00001001_00100000_00000000_00000000 'dira-wert für datenbuseingabe
DB_OUT           = %00001001_00100000_00000000_11111111 'dira-wert für datenbusausgabe

M1               = %00000010_00000000_00000000_00000000 'busclk=1? & /prop1=0?
M2               = %00000010_10000000_00000000_00000000 'maske: busclk & /cs (/prop1)

M3               = %00000000_00000000_00000000_00000000 'busclk=0?
M4               = %00000010_00000000_00000000_00000000 'maske: busclk

LED_OPEN     = gc#HBEAT                                 'led-pin für anzeige "dateioperation"
SD_BASE      = gc#ADM_SDD0                              'baspin cardreader

' screeninterface

SECTORSIZE   = 512
SCREENSIZE   = 1024                                     'screengröße
SIZEMASK     = 1023                                     'maske für position
SECCOUNT     = SCREENSIZE / SECTORSIZE                  'anzahl sektoren pro screen
SCRSTACK     = 32                                       'größe screenstack

' parser

TIBMAX       = 64
TIB_SP       = $20

MAXFILES     = 8                                        'anzahl der fat-engines
FTCNT        = 32                                       'bytes/record in ftab
FTABLEN      = MAXFILES * FTCNT                         'länge ftab
FTABIXNAME   = 1                                        'index dateinam in ftab
FTABIXRW     = 0                                        'index rw-flag in ftab

'FH_M         = 0
'FH_SID       = 1
'FH_DEF       = 2                                        ' default filehandle

'sidcog

playRate        = 50            'Hz
detune          = 1.006

OBJ

#ifdef _fat_rtc
  fat[MAXFILES]   : "m-adm-fat-rtc"       'fat-layer
#endif

#ifdef _fat_nortc
  fat[MAXFILES]   : "m-adm-fat-nortc"     'fat-layer
#endif

  plx   : "m-adm-plx"           'io-bus (plexbus)
  sid[2]: "m-adm-sid"           'sidcog

#ifdef _com
  ser   : "m-adm-ser"           'serielle schnittstelle
#endif

#ifdef _debug
  pst   : "m-glob-pst"          'debug-interface
#endif

  gc    : "m-glob-con"          'globale konstanten
  num   : "m-glob-num"          'wandlung zahl <--> string
  str   : "m-glob-string"       'stringfunktionen

VAR

' screeninterface

  byte  s_pscreen[SCREENSIZE]                           'screenpuffer
  long  s_screens[SCRSTACK]                             'stack scrennnummern
  long  s_positions[SCRSTACK]                           'stack screenpositionen
  long  s_max                                           'maximale anzahl screens im container
  long  s_scr                                           'screen-nummer
  long  s_blk                                           'blocknummer
  long  s_pos                                           'position im screen
  byte  s_err                                           'fehler der letzten screen-op
  byte  s_index                                         'stackindex
  byte  s_sys[16]
  byte  s_home[16]

' sd-card

  byte  fl_mounted                                      '1 = mounted
  byte  fl_eof                                          '0 <> eof
  byte  fnr                                             'filehandle
  byte  ftab[FTABLEN]                                   'tabelle geöffnete dateien
  byte  fh_m                                            ' für m-system reserviertes filehandle
  byte  fh_sid                                          'für dmp-player reserviertes filehandle

' protokolle

  byte  tbuf[32]                                        'stringpuffer
  byte  tbuf2[32]

' parser

  byte  tok[TIBMAX+2] 'token
  byte  tok_tag
  byte  m_base                                            'zahlenbasis

' sid

  long  sidreg0                                         'adresse register der sidcog 1
  long  sidreg1                                         'adresse register der sidcog 2
  byte  sidnr                                           'sid-nr
  byte  sidchan                                         'kanal-nr

#ifdef _dmp
  long  dmpcog                                          'id der dmp-player-cog
  long  dmpstack[50]                                    'stack für dmpcog
  byte  sidbuffer[25]                                   'puffer für dmpcog
  byte  dmpstatus                                       '0 = inaktiv; 1 = play; 2 = pause
  long  dmppos                                          'position des players im dump
  long  dmplen                                          'länge des dmp-files (anzahl regsitersätze)
  byte  dmppause                                        'pauseflag
  byte  dmpstereo                                       '0=mono, 1=stereo
  byte  dmpnext                                         '1 = next
  byte  dmpnumber                                       'nummer des aktuellen songs
  long  dmpsong                                         'zeiger auf aktuellen dateinamen
#endif

CON ''------------------------------------------------- ADMINISTRA

PUB main | cmd,err,a,b,c,d,e,f                          'chip: kommandointerpreter
''funktionsgruppe               : chip
''funktion                      : kommandointerpreter
''eingabe                       : -
''ausgabe                       : -

  init_chip                                             'bus/vga/keyboard/maus initialisieren
  repeat
    cmd := bus_getchar                                  'kommandocode empfangen
    err := 0
    case cmd

'       ----------------------------------------------  SD-FUNKTIONEN

        gc#adm_sd_mount:        sd_mount                'sd-card mounten                                              '
        gc#adm_sd_unmount:      sd_unmount              'medium abmelden
        gc#adm_sd_opendir:      sd_opendir              'directory öffnen
        gc#adm_sd_nextfile:     sd_nextfile             'verzeichniseintrag lesen
        gc#adm_sd_open:         sd_open                 'datei öffnen
        gc#adm_sd_close:        sd_close                'datei schließen
        gc#adm_sd_getc:         sd_getc                 'zeichen lesen
        gc#adm_sd_putc:         sd_putc                 'zeichen schreiben
        gc#adm_sd_getblk:       sd_getblk               'block lesen
        gc#adm_sd_putblk:       sd_putblk               'block schreiben
        gc#adm_sd_seek:         sd_seek                 'zeiger in datei positionieren
        gc#adm_sd_fattrib:      sd_fattrib              'dateiattribute übergeben
        gc#adm_sd_volname:      sd_volname              'volumelabel abfragen
        gc#adm_sd_checkmounted: sd_checkmounted         'test ob volume gemounted ist
        gc#adm_sd_checkused:    sd_checkused            'test wie viele sektoren benutzt sind
        gc#adm_sd_checkfree:    sd_checkfree            'test wie viele sektoren frei sind
        gc#adm_sd_newfile:      sd_newfile              'neue datei erzeugen
        gc#adm_sd_newdir:       sd_newdir               'neues verzeichnis wird erzeugt
        gc#adm_sd_del:          sd_del                  'verzeichnis oder datei löschen
        gc#adm_sd_rename:       sd_rename               'verzeichnis oder datei umbenennen
        gc#adm_sd_chattrib:     sd_chattrib             'attribute ändern
        gc#adm_sd_chdir:        sd_chdir                'verzeichnis wechseln
        gc#adm_sd_format:       sd_format               'medium formatieren
        gc#adm_sd_eof:          sd_eof                  'eof abfragen
        gc#adm_sd_getfh:        sd_getfh                'nächstes freies handle abfragen
        gc#adm_sd_usefh:        sd_usefh                'handle setzen
        gc#adm_sd_clrfh:        sd_clrfh                'handle freigeben
        gc#adm_sd_copy:         sd_copy                 'datei kopieren
        gc#adm_sd_move:         sd_move                 'datei verschieben
        gc#adm_sd_getftab:      sd_getftab              'ftab auslesen


'       ----------------------------------------------  SCREEN-INTERFACE

        gc#adm_scr_fill:        scr_fill                'screenpuffer mit zeichen füllen
        gc#adm_scr_read:        scr_read                'screen in den puffer laden
        gc#adm_scr_write:       scr_write               'screen auf disk schreiben
        gc#adm_scr_getnr:       scr_getnr               'nummer des aktuellen screens abfragen
        gc#adm_scr_setpos:      scr_setpos              'zeiger auf position im puffer setzen
        gc#adm_scr_getpos:      scr_getpos              'aktuelle position im puffer abfragen
        gc#adm_scr_getc:        scr_getc                'zeichen wird aus dem puffer gelesen
        gc#adm_scr_putc:        scr_putc                'zeichen wird in den puffer geschrieben
        gc#adm_scr_err:         scr_err                 'fehlerstatus abfragen
        gc#adm_scr_maxscr:      scr_maxscr              'screenanzahl in containerdatei abfragen
        gc#adm_scr_eos:         scr_eos                 'end of screen
        gc#adm_scr_call:        scr_call                'subscreen aufrufen
        gc#adm_scr_ret:         scr_ret                 'subscreen beenden
        gc#adm_scr_use:         scr_use                 'blockdatei öffnen
        gc#adm_scr_sys:         scr_sys_use             'systemdatei öffnen
        gc#adm_scr_home:        scr_home                'systemverzeichnis öffnen

'       ----------------------------------------------  COM-FUNKTIONEN
#ifdef _com
        gc#adm_com_tx: com_tx(bus_getchar)              'zeichen senden
        gc#adm_com_rx: bus_putchar(com_rx)              'zeichen empfangen
#endif
'       ----------------------------------------------  SID-FUNKTIONEN

        gc#adm_m_chan:      a := bus_getchar
                            sidnr := a & 1
                            sidchan := a >> 1
        gc#adm_m_regclr:    sid[sidnr].resetRegisters
        gc#adm_m_setvol:    sid[sidnr].setVolume(bus_getchar)
        gc#adm_m_play:      a := sub_getword
                            b := bus_getchar
                            c := bus_getchar
                            d := bus_getchar
                            e := bus_getchar
                            f := bus_getchar
                            sid[sidnr].play(sidchan,a,b,c,d,e,f)
        gc#adm_m_noteon:    sid[sidnr].noteOn(sidchan,sub_getword)
        gc#adm_m_noteoff:   sid[sidnr].noteOff(sidchan)
        gc#adm_m_setfreq:   sid[sidnr].setFreq(sidchan,sub_getword)
        gc#adm_m_setwave:   sid[sidnr].setWaveform(sidchan,bus_getchar)
        gc#adm_m_setpw:     sid[sidnr].setPulseWidth(sidchan,sub_getword)
        gc#adm_m_setadsr:   a := bus_getchar
                            b := bus_getchar
                            c := bus_getchar
                            d := bus_getchar
                            sid[sidnr].setADSR(sidchan,a,b,c,d)
        gc#adm_m_setres:    sid[sidnr].setResonance(bus_getchar)
        gc#adm_m_setcoff:   sid[sidnr].setCutoff(sub_getword)
        gc#adm_m_setfmask:  a := bus_getchar
                            b := bus_getchar
                            c := bus_getchar
                            sid[sidnr].setFilterMask(a,b,c)
        gc#adm_m_setftype:  a := bus_getchar
                            b := bus_getchar
                            c := bus_getchar
                            sid[sidnr].setFilterType(a,b,c)
        gc#adm_m_ringmod:   a := bus_getchar
                            b := bus_getchar
                            c := bus_getchar
                            sid[sidnr].enableRingmod(a,b,c)
        gc#adm_m_sync:      a := bus_getchar
                            b := bus_getchar
                            c := bus_getchar
                            sid[sidnr].enableSynchronization(a,b,c)

'       ----------------------------------------------  SIDCog: DMP-Player-Funktionen (SIDCog2)
#ifdef _dmp
        gc#adm_dmp_stereo:  dmp_stereo                    'modus mono/stereo
        gc#adm_dmp_play:    dmp_play                      'dmp-file abspielen
        gc#adm_dmp_stop:    dmp_stop                      'dmp-player beenden
        gc#adm_dmp_pause:   dmp_pause                     'dmp-player pausenmodus
        gc#adm_dmp_status:  dmp_status                    'dmp-player statusabfrage
        gc#adm_dmp_pos:     dmp_pos                       'player-position im dumpfile
        gc#adm_dmp_mute:    dmp_mute                      'alle register löschen
        gc#adm_dmp_playdir: dmp_playdir                   'dmp-dateien in einem verzeichnis abspielen
        gc#adm_dmp_next:    dmp_next                      'nächste datei im verzeichnis abspielen
        gc#adm_dmp_number:  dmp_number
        gc#adm_dmp_song:    dmp_song
        gc#adm_dmp_reg:     dmp_reg
#endif
'       ----------------------------------------------  PLX-FUNKTIONEN

                                                        'poller steuern
        gc#adm_m_run:    plx.run
        gc#adm_m_halt:   plx.halt
                                                        'digitale ports
        gc#adm_m_in:     a := bus_getchar               'adr
                         bus_putchar(plx.in(a))
        gc#adm_m_out:    a := bus_getchar               'adr
                         b := bus_getchar               'dat
                         plx.out(a,b)

                                                        'analoge ports
        gc#adm_m_adch:   a := bus_getchar               'adr
                         b := bus_getchar               'chan
                         bus_putchar(plx.ad_ch(a,b))    'analogwert

                                                        'pollerregister
        gc#adm_m_getreg: a := bus_getchar               'regnr
                         bus_putchar(plx.getreg(a))
        gc#adm_m_setreg: a := bus_getchar               'regnr
                         b := bus_getchar               'wert
                         plx.setreg(a,b)

                                                        'i2c-funktionen
        gc#adm_m_start:  plx.start
        gc#adm_m_stop:   plx.stop
        gc#adm_m_write:  a := bus_getchar               'wert
                         bus_putchar(plx.write(a))      'ack-bit
        gc#adm_m_read:   a := bus_getchar               'ack-bit
                         bus_putchar(plx.read(a))       'wert

                                                        'devices abfragen
        gc#adm_m_ping:   a := bus_getchar               'adr
                         bus_putchar(plx.ping(a))

        gc#adm_m_setadr: a := bus_getchar               'adresse adda
                         b := bus_getchar               'adresse ports
                         plx.setadr(a,b)
'       ----------------------------------------------  GAMEDEVICES

        gc#adm_m_joy:    bus_putchar(!plx.getreg(plx#R_INP0))

        gc#adm_m_paddle: bus_putchar(!plx.getreg(plx#R_INP0))
                         bus_putchar(plx.getreg(plx#R_PAD0))

        gc#adm_m_pad:    bus_putchar(!plx.getreg(plx#R_INP0))
                         bus_putchar(plx.getreg(plx#R_PAD0))
                         bus_putchar(plx.getreg(plx#R_PAD1))


'       ----------------------------------------------  M-FUNKTIONEN

        gc#adm_m_parse:         m_parse                 'nächstes token von screen parsen
        gc#adm_m_setbase:       m_setbase               'base setzen

'       ----------------------------------------------  CHIP-MANAGMENT
        gc#adm_m_getspec:       mgr_getspec             'spezifikation abfragen
        gc#adm_m_getver:        mgr_getver              'codeversion abfragen
        gc#adm_m_reboot:        reboot                  'neu starten

PRI init_chip | err,n,i,j                               'chip: initialisierung des administra-chips
''funktionsgruppe               : chip
''funktion                      : - initialisierung des businterface
''                                - grundzustand definieren
''eingabe                       : -
''ausgabe                       : -

  'debug-ausgabe

#ifdef _debug
  pst.start(57600)
  waitcnt(cnt+clkfreq*3)
  pst.str(string("adm-debug gestartet!",13))
#endif

  'businterface initialisieren

  outa[gc#bus_hs] := 1                                  'handshake inaktiv
  dira := db_in                                         'datenbus auf eingabe schalten

  'systemvariablen setzen

  m_base     := 10              'zahlenbasis dezimal
  s_pos      := 0
  s_scr      := 0
  s_err      := 0
  s_index    := 0               'screenstack rücksetzen
  fl_mounted := 0               'dateisystem ist noch nicht eingebunden
  fnr        := FH_M            'filehandle auf mental setzen

  'pfade und systemdateien setzen

  str.copy(@s_sys, @str_sys)
  str.copy(@s_home, @str_home)

  'serielle schnittstelle starten
#ifdef _com
  ser.start(gc#ser_rx,gc#ser_tx,0,115200)     ' start the default serial interface
#endif


  'fatengine starten, karte mounten, filehandles reservieren

  repeat until \fat.FATEngineStart(gc#adm_sdd0,gc#adm_sdclk,gc#adm_sdcmd,gc#adm_sdd3,-1,-1,gc#i2c_sda,gc#i2c_scl,-1)
  sd_mount2
  sd_clrftab
  fh_m    := sd_getfh2
  fh_sid  := sd_getfh2

  'plx-bus initialisieren

  plx.init                      ' defaultwerte setzen, poller-cog starten
  plx.run                       ' plexbus freigeben (poller läuft)

  'soundsystem initialisieren

  sidreg0 := sid[0].start(gc#adm_soundl,0)              'erste sidcog starten
  waitcnt(cnt+(clkfreq>>8))
  sid[0].resetRegisters
  sid[0].setVolume(15)

  sidreg1 := sid[1].start(gc#adm_soundr,0)              'zweite sidcog starten
  waitcnt(cnt+(clkfreq>>8))
  sid[1].resetRegisters
  sid[1].setVolume(15)

  repeat j from 0 to 1                                  'register initialisieren
    repeat i from 0 to 2
      sid[j].setPulseWidth(i,2048)
      sid[j].setWaveform(i,16)
      sid[j].setADSR(i,2,5,9,6)
      sid[j].noteOff(i)

#ifdef _dmp
  dmpstereo := 1                                        'default ist stereo an
  dmpnext   := 0
#endif



PRI sighigh(err)                                        'chip: schneller hbeat | fehlersound
''funktionsgruppe               : chip
''funktion                      : schneller hbeat | fehlersound
''eingabe                       : -
''ausgabe                       : -

'  if fl_syssnd == 1
     if err == 0
'       hss.sfx_play(1, @SoundFX3)                       'Heartbeat High
     else
'       hss.sfx_play(1, @SoundFX7)                       'Error

PRI siglow(err)                                         'chip: langsamer hbeat | fehlersound
''funktionsgruppe               : chip
''funktion                      : langsamer hbeat | fehlersound
''eingabe                       : -
''ausgabe                       : -

'  if fl_syssnd == 1
     if err == 0
'       hss.sfx_play(1, @SoundFX4)                       'Heartbeat High
     else
'       hss.sfx_play(1, @SoundFX7)                       'Error

CON ''------------------------------------------------- BUS-FUNKTIONEN

PRI bus_putchar(zeichen)                                'chip: ein byte über bus ausgeben
''funktionsgruppe               : chip
''funktion                      : senderoutine für ein byte zu regnatix über den systembus
''eingabe                       : byte zeichen
''ausgabe                       : -

  waitpeq(M1,M2,0)                                      'busclk=1? & /prop1=0?
  dira := db_out                                        'datenbus auf ausgabe stellen
  outa[7..0] := zeichen                                 'daten ausgeben
  outa[gc#bus_hs] := 0                                  'daten gültig
  waitpeq(M3,M4,0)                                      'busclk=0?
  dira := db_in                                         'bus freigeben
  outa[gc#bus_hs] := 1                                  'daten ungültig

PRI bus_getchar : zeichen                               'chip: ein byte über bus empfangen
''funktionsgruppe               : chip
''funktion                      : emfangsroutine für ein byte von regnatix über den systembus
''eingabe                       : -
''ausgabe                       : byte zeichen

  waitpeq(M1,M2,0)                                      'busclk=1? & /prop1=0?
  zeichen := ina[7..0]                                  'daten einlesen
  outa[gc#bus_hs] := 0                                  'daten quittieren
  waitpeq(M3,M4,0)                                      'busclk=0?
  outa[gc#bus_hs] := 1

PRI sub_getstr(strptr) | i,len                          'sub: string einlesen
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen string von regnatix zu empfangen und im
''                              : textpuffer (tbuf) zu speichern
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [get.len][get.byte(1)]..[get.byte(len)]
''                              : len - länge des dateinamens

  repeat i from 0 to 19                                 'puffer löschen
    byte[strptr][i] := 0
  len := bus_getchar                                    'längenbyte name empfangen
  repeat i from 0 to len - 1                            'dateiname einlesen
    byte[strptr][i] := bus_getchar

PRI sub_putstr(strptr)|len,i                            'sub: string senden
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen string an regnatix zu senden
''eingabe                       : strptr - zeiger auf einen string (0-term)
''ausgabe                       : -
''busprotokoll                  : [put.len][put.byte(1)]..[put.byte(len)]
''                              : len - länge des dateinamens


  len := strsize(strptr)

  bus_putchar(len)
  repeat i from 0 to len - 1                            'string übertragen
    bus_putchar(byte[strptr][i])


PRI sub_putword(wert)                                   'sub: long senden
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen 16bit-wert an regnatix zu senden
''eingabe                       : 16bit wert der gesendet werden soll
''ausgabe                       : -
''busprotokoll                  : [put.byte1][put.byte2]
''                              : [  hsb    ][   lsb   ]

   bus_putchar(wert >> 8)
   bus_putchar(wert)

PRI sub_getword:wert                                    'sub: long empfangen
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen 16bit-wert von regnatix zu empfangen
''eingabe                       : -
''ausgabe                       : 16bit-wert der empfangen wurde
''busprotokoll                  : [get.byte1][get.byte2]
''                              : [  hsb    ][   lsb   ]

  wert := wert + bus_getchar << 8
  wert := wert + bus_getchar

PRI sub_putlong(wert)                                   'sub: long senden
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen long-wert an regnatix zu senden
''eingabe                       : 32bit wert der gesendet werden soll
''ausgabe                       : -
''busprotokoll                  : [put.byte1][put.byte2][put.byte3][put.byte4]
''                              : [  hsb    ][         ][         ][   lsb   ]

   bus_putchar(wert >> 24)                              '32bit wert senden hsb/lsb
   bus_putchar(wert >> 16)
   bus_putchar(wert >> 8)
   bus_putchar(wert)

PRI sub_getlong:wert                                    'sub: long empfangen
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen long-wert von regnatix zu empfangen
''eingabe                       : -
''ausgabe                       : 32bit-wert der empfangen wurde
''busprotokoll                  : [get.byte1][get.byte2][get.byte3][get.byte4]
''                              : [  hsb    ][         ][         ][   lsb   ]

  wert :=        bus_getchar << 24                      '32 bit empfangen hsb/lsb
  wert := wert + bus_getchar << 16
  wert := wert + bus_getchar << 8
  wert := wert + bus_getchar

PRI sub_mtag                                            'sub: m-tag senden

  bus_putchar(tok_tag)

PRI sub_mtoken                                          'sub: m-token senden

  bus_putchar(tok_tag)
  sub_putstr(@tok)

PRI sub_mnumber                                         'sub: m-wert senden

  bus_putchar(tok_tag)
  sub_putlong(m_number(@tok))


CON ''------------------------------------------------- CHIP-MANAGMENT-FUNKTIONEN

PRI mgr_getver                                          'cmgr: abfrage der version
''funktionsgruppe               : cmgr
''funktion                      : abfrage der version und spezifikation des chips
''eingabe                       : -
''ausgabe                       : cogs - anzahl der cogs
''busprotokoll                  : [cmd][sub_putlong.ver]
''                              : ver - version
''                  +----------
''                  |  +------- system
''                  |  |  +---- version    (änderungen)
''                  |  |  |  +- subversion (hinzufügungen)
''version :       $00_00_00_00
''

  sub_putlong(CHIP_VER)

PRI mgr_getspec                                         'cmgr: abfrage der spezifikation des chips
''funktionsgruppe               : cmgr
''funktion                      : abfrage der version und spezifikation des chips
''eingabe                       : -
''ausgabe                       : cogs - anzahl der cogs
''busprotokoll                  : [cmd][sub_putlong.spec]
''                              : spec - spezifikation
''
''                                          +---------- com
''                                          | +-------- i2c
''                                          | |+------- rtc
''                                          | ||+------ lan
''                                          | |||+----- sid
''                                          | ||||+---- wav
''                                          | |||||+--- hss
''                                          | ||||||+-- bootfähig
''                                          | |||||||+- dateisystem
''spezifikation : %00000000_00000000_00000000_01001111

  sub_putlong(CHIP_SPEC)

CON ''------------------------------------------------- COM-FUNKTIONEN
#ifdef _com
PRI com_tx(char)

  ser.tx(char)

PRI com_rx:char

  char := ser.rx

#endif
CON ''------------------------------------------------- SIDCog: DMP-Player-Funktionen (SIDCog2)

#ifdef _dmp

PRI dmp_stereo                                          'dmp: stereo/mono

  dmpstereo := bus_getchar

PRI dmp_play | err                                      'dmp: dmp-datei stereo auf beiden sid's abspielen

   sub_getstr(@tbuf)
   dmp_stop
   err := sd_open2(fh_sid,@tbuf,"R")                    '\fat[fh_sid].openFile(@tbuf, "r")
   if err == 0
      dmppause := 0
      dmpcog := cognew(dmp_cog,@dmpstack) + 1           'player-cog starten
   bus_putchar(err)                                     'ergebnis der operation senden

PRI dmp_playdir                                         'dmp: dmp-dateien in einem verzeichnis abspielen

  sub_getstr(@tbuf)
  dmp_stop
  dmpcog := cognew(dmp_cogdir,@dmpstack) + 1            'player-cog starten

PRI dmp_stop                                            'dmp: dmp-player stoppen
  if dmpcog
    cogstop(dmpcog-1)
    dmpstatus := 0
    'sd_close2(fh_sid)

PRI dmp_next                                            'dmp: nächste dmp-datei abspielen

  if dmpcog
    dmpnext := 1

PRI dmp_pause|i                                         'dmp: dmp-player pause
  case dmppause
    0: dmppause := 1
       repeat until dmpstatus == 2
       sid[0].setVolume(0)
       sid[1].setVolume(0)
    1: dmppause := 0

PRI dmp_status                                          'dmp: status des dmp-players abfragen
' 0 = player aus
' 1 = player läuft
' 2 = player pause

  bus_putchar(dmpstatus)

PRI dmp_pos                                             'dmp: position/länge des dmp-players abfragen

  sub_putlong(dmppos)
  sub_putlong(dmplen)

PRI dmp_number                                          'dmp: songnummer abfragen

  bus_putchar(dmpnumber)

PRI dmp_song                                            'dmp: songnamen abfragen

  if dmpsong
    sub_putstr(dmpsong)
  else
    sub_putstr(string("-"))

PRI dmp_mute|sid_nr,i                                   'dmp: ruhe!

  repeat i from 0 to 25
    sidbuffer[i] := 0
  sid_nr := bus_getchar
  case sid_nr
    1: sid[0].updateRegisters(@sidbuffer)
    2: sid[1].updateRegisters(@sidbuffer)
    3: sid[0].updateRegisters(@sidbuffer)
       sid[1].updateRegisters(@sidbuffer)

PRI dmp_cogdir|err                                      'dmp: dmpcog - listenplayer

  dmpnumber := 0
  \fat[fh_sid].changeDirectory(@tbuf)
  err := fat[fh_sid].partitionError
  if err == 0
    \fat[fh_sid].listEntries("W")
    repeat while(dmpsong := fat[fh_sid].listEntries("N"))
      ifnot(fat[fh_sid].listIsDirectory)
        sd_open2(fh_sid,dmpsong,"R")                    '\fat[fh_sid].openFile(dmpsong, "r")
        dmppause := 0
        dmp_cog
        dmpnumber++
    dmp_mute
    sd_close2(fh_sid)

PRI dmp_cog | i                                         'dmp: dmpcog - player

  dmpstatus := 1                                        'player läuft
  dmplen := \fat[fh_sid].fileSize / 25
  dmppos := 0

  repeat dmplen
    waitcnt(cnt+(clkfreq/playRate))                     'warten auf den c64-vbl :)
    \fat[fh_sid].readData(@sidbuffer,25)                '25 byte in den puffer einlesen
    sid[1].updateRegisters(@sidbuffer)                  'puffer in die sid-register schreiben

    if dmpstereo                                       'pseudo-stereo
      sid[0].updateRegisters(@sidbuffer)
      word[sidreg1+0 ] := (word[sidreg1+0 ]<<16)/trunc(65536.0/detune)
      word[sidreg1+8 ] := (word[sidreg1+8 ]<<16)/trunc(65536.0/detune)
      word[sidreg1+16] := (word[sidreg1+16]<<16)/trunc(65536.0/detune)

    dmppos := dmppos + 1
    if dmppause == 1
      dmpstatus := 2
    else
      dmpstatus := 1
    repeat while dmppause == 1                          'warten solange pause
    if dmpnext
      dmpnext := 0
      quit

  dmpstatus := 0                                        'player beendet

PRI dmp_reg                                             'dmp: dmpregister senden

  bus_putchar(byte[sidreg1+1])                       'kanal 1
  bus_putchar(byte[sidreg1+0])
  bus_putchar(byte[sidreg1+9])                       'kanal 2
  bus_putchar(byte[sidreg1+8])
  bus_putchar(byte[sidreg1+17])                      'kanal 3
  bus_putchar(byte[sidreg1+16])
  bus_putchar(byte[sidreg1+24])                      'filter1
  bus_putchar(byte[sidreg1+25])                      'filter2
  bus_putchar(byte[sidreg1+26])                      'filter3
  bus_putchar(byte[sidreg1+27])                      'volume

#endif

CON ''------------------------------------------------- SD-LAUFWERKS-FUNKTIONEN

PRI sd_mount                                            'sdcard: sd-card mounten
''funktionsgruppe               : sdcard
''funktion                      : eingelegtes volume in alle fh-instanzen mounten
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt]

  ifnot fl_mounted
    sd_mount2                   'fehlerstatus senden

PRI sd_mount2:err|fh                                    'sdcard: mount parameter

  err := 0
  ifnot fl_mounted
    repeat fh from 0 to MAXFILES-1
      repeat
        \fat[fh].mountPartition(0)
        err := err | fat[fh].partitionError
      while err

  outa[LED_OPEN] := 1
  fl_mounted := 1

PRI sd_unmount | err,fh                                 'sdcard: medium abmelden
''funktionsgruppe               : sdcard
''funktion                      : medium abmelden
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt]
''                              : error - fehlernummer entspr. list

  repeat fh from 0 to MAXFILES-1
    \fat[fh].unmountPartition
  siglow(err)                                           'fehleranzeige
  fl_mounted := 0
  outa[LED_OPEN] := 0


PRI sd_opendir | err                                    'sdcard: verzeichnis öffnen
''funktionsgruppe               : sdcard
''funktion                      : verzeichnis öffnen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt]

  err := \fat[fnr].listEntries("W")

PRI sd_nextfile | strpt                                 'sdcard: nächsten eintrag aus verzeichnis holen
''funktionsgruppe               : sdcard
''funktion                      : nächsten eintrag aus verzeichnis holen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.status=false]
''                              : [fkt][put.status=true][sub_putstr.fn]
''                              : status - 1 = gültiger eintrag
''                              :          0 = es folgt kein eintrag mehr
''                              : fn - verzeichniseintrag string

  strpt := \fat[fnr].listEntries("N")                   'nächsten eintrag holen
  if strpt                                              'status senden
    bus_putchar(TRUE)                                   'gültiger eintrag folgt
    if \fat[fnr].listIsDirectory
      sub_putstr(strpt)                                 'verzeichnisse bleiben in großbuchstaben
    else
     'charactersToLowerCase(strpt)                      'dateinamen werden in kleinbuchstaben gewandelt
      str.StrToLower(strpt)                             'dateinamen werden in kleinbuchstaben gewandelt
      sub_putstr(strpt)
  else
    bus_putchar(FALSE)                                      'kein eintrag mehr

PRI sd_open  | err,modus                                'sdcard: datei öffnen
''funktionsgruppe               : sdcard
''funktion                      : eine bestehende datei öffnen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][get.modus][sub_getstr.fn][put.error]
''                              : modus - "A" Append, "W" Write, "R" Read
''                              : fn - name der datei
''                              : error - fehlernummer entspr. list

   modus := bus_getchar                                 'modus empfangen
   sub_getstr(@tbuf)
   err := sd_open2(fnr,@tbuf,modus)
   bus_putchar(err)                                     'ergebnis der operation senden

PRI sd_open2(fh,stradr,modus):err

   \fat[fh].openFile(stradr, modus)
   err := fat[fh].partitionError
   ifnot err
     str.StrToUpper(stradr)
     str.copy((@ftab+fh*FTCNT+FTABIXNAME),stradr)
     ftab[fh*FTCNT+FTABIXRW] := modus

PRI sd_close | err                                      'sdcard: datei schließen
''funktionsgruppe               : sdcard
''funktion                      : die aktuell geöffnete datei schließen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.error]
''                              : error - fehlernummer entspr. list

  err := sd_close2(fnr)
  siglow(err)                                           'fehleranzeige
  bus_putchar(err)                                      'ergebnis der operation senden

PRI sd_close2(fh):err

  \fat[fh].closeFile
  err := fat[fh].partitionError
  ifnot err
     sd_clrentry(fh)


PRI sd_getc | n                                         'sdcard: zeichen aus datei lesen
''funktionsgruppe               : sdcard
''funktion                      : zeichen aus datei lesen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.char]
''                              : char - gelesenes zeichen

  n := \fat[fnr].readByte
  bus_putchar(n)

PRI sd_putc                                             'sdcard: zeichen in datei schreiben
''funktionsgruppe               : sdcard
''funktion                      : zeichen in datei schreiben
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][get.char]
''                              : char - zu schreibendes zeichen

  \fat[fnr].writeByte(bus_getchar)

PRI sd_eof                                              'sdcard: eof abfragen
''funktionsgruppe               : sdcard
''funktion                      : eof abfragen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.eof]
''                              : eof - eof-flag

  if fat[fnr].fileSize == fat[fnr].fileTell
    bus_putchar(TRUE)
  else
    bus_putchar(FALSE)

PRI sd_getblk                                           'sdcard: block aus datei lesen
''funktionsgruppe               : sdcard
''funktion                      : block aus datei lesen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getlong.count][put.char(1)]..[put.char(count)]
''                              : count - anzahl der zu lesenden zeichen
''                              : char - gelesenes zeichen

  repeat sub_getlong
    bus_putchar(\fat[fnr].readByte)

PRI sd_putblk                                           'sdcard: block in datei schreiben
''funktionsgruppe               : sdcard
''funktion                      : block in datei schreiben
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getlong.count][put.char(1)]..[put.char(count)]
''                              : count - anzahl der zu schreibenden zeichen
''                              : char - zu schreibende zeichen

  repeat sub_getlong
    \fat[fnr].writeByte(bus_getchar)

PRI sd_seek | wert                                      'sdcard: zeiger in datei positionieren
''funktionsgruppe               : sdcard
''funktion                      : zeiger in datei positionieren
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getlong.pos]
''                              : pos - neue zeichenposition in der datei

  wert := sub_getlong
  \fat[fnr].fileSeek(wert)

PRI sd_fattrib | anr,wert                               'sdcard: dateiattribute übergeben
''funktionsgruppe               : sdcard
''funktion                      : dateiattribute abfragen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][get.anr][sub_putlong.wert]
''                              : anr - 0  = Dateigröße
''                              :       1  = Erstellungsdatum - Tag
''                              :       2  = Erstellungsdatum - Monat
''                              :       3  = Erstellungsdatum - Jahr
''                              :       4  = Erstellungsdatum - Sekunden
''                              :       5  = Erstellungsdatum - Minuten
''                              :       6  = Erstellungsdatum - Stunden
''                              :       7  = Zugriffsdatum - Tag
''                              :       8  = Zugriffsdatum - Monat
''                              :       9  = Zugriffsdatum - Jahr
''                              :       10 = Änderungsdatum - Tag
''                              :       11 = Änderungsdatum - Monat
''                              :       12 = Änderungsdatum - Jahr
''                              :       13 = Änderungsdatum - Sekunden
''                              :       14 = Änderungsdatum - Minuten
''                              :       15 = Änderungsdatum - Stunden
''                              :       16 = Read-Only-Bit
''                              :       17 = Hidden-Bit
''                              :       18 = System-Bit
''                              :       19 = Direktory
''                              :       20 = Archiv-Bit
''                              : wert - wert des abgefragten attributes

   anr := bus_getchar
   case anr
     0:  wert := \fat[fnr].listSize
     1:  wert := \fat[fnr].listCreationDay
     2:  wert := \fat[fnr].listCreationMonth
     3:  wert := \fat[fnr].listCreationYear
     4:  wert := \fat[fnr].listCreationSeconds
     5:  wert := \fat[fnr].listCreationMinutes
     6:  wert := \fat[fnr].listCreationHours
     7:  wert := \fat[fnr].listAccessDay
     8:  wert := \fat[fnr].listAccessMonth
     9:  wert := \fat[fnr].listAccessYear
     10: wert := \fat[fnr].listModificationDay
     11: wert := \fat[fnr].listModificationMonth
     12: wert := \fat[fnr].listModificationYear
     13: wert := \fat[fnr].listModificationSeconds
     14: wert := \fat[fnr].listModificationMinutes
     15: wert := \fat[fnr].listModificationHours
     16: wert := \fat[fnr].listIsReadOnly
     17: wert := \fat[fnr].listIsHidden
     18: wert := \fat[fnr].listIsSystem
     19: wert := \fat[fnr].listIsDirectory
     20: wert := \fat[fnr].listIsArchive
   sub_putlong(wert)

PRI sd_volname                                          'sdcard: volumenlabel abfragen
''funktionsgruppe               : sdcard
''funktion                      : name des volumes überragen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_putstr.volname]
''                              : volname - name des volumes
''                              : len   - länge des folgenden strings

  sub_putstr(\fat[fnr].partitionVolumeLabel)                    'label holen und senden

PRI sd_checkmounted                                     'sdcard: test ob volume gemounted ist
''funktionsgruppe               : sdcard
''funktion                      : test ob volume gemounted ist
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.flag]
''                              : flag  - 0 = unmounted, 1 mounted

  bus_putchar(fl_mounted)

PRI sd_checkused                                        'sdcard: anzahl der benutzten sektoren senden
''funktionsgruppe               : sdcard
''funktion                      : anzahl der benutzten sektoren senden
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_putlong.used]
''                              : used - anzahl der benutzten sektoren

  sub_putlong(\fat[fnr].partitionUsedSectorCount("F"))

PRI sd_checkfree                                        'sdcard: anzahl der freien sektoren senden
''funktionsgruppe               : sdcard
''funktion                      : anzahl der freien sektoren senden
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_putlong.free]
''                              : free - anzahl der freien sektoren

  sub_putlong(\fat[fnr].partitionFreeSectorCount("F"))

PRI sd_newfile | err                                    'sdcard: eine neue datei erzeugen
''funktionsgruppe               : sdcard
''funktion                      : eine neue datei erzeugen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn][put.error]
''                              : fn - name der datei
''                              : error - fehlernummer entspr. liste

   sub_getstr(@tbuf)
   err := \fat[fnr].newFile(@tbuf)
   sighigh(err)                                         'fehleranzeige
   bus_putchar(err)                                     'ergebnis der operation senden

PRI sd_newdir | err                                     'sdcard: ein neues verzeichnis erzeugen
''funktionsgruppe               : sdcard
''funktion                      : ein neues verzeichnis erzeugen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn][put.error]
''                              : fn - name des verzeichnisses
''                              : error - fehlernummer entspr. liste

   sub_getstr(@tbuf)
   \fat[fnr].newDirectory(@tbuf)
   err := fat[fnr].partitionError
   sighigh(err)                                         'fehleranzeige
   bus_putchar(err)                                     'ergebnis der operation senden

PRI sd_del | err                                        'sdcard: eine datei oder ein verzeichnis löschen
''funktionsgruppe               : sdcard
''funktion                      : eine datei oder ein verzeichnis löschen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn][put.error]
''                              : fn - name des verzeichnisses oder der datei
''                              : error - fehlernummer entspr. liste

   sub_getstr(@tbuf)
   \fat[fnr].deleteEntry(@tbuf)
   err := fat[fnr].partitionError
   sighigh(err)                                         'fehleranzeige
   bus_putchar(err)                                     'ergebnis der operation senden

PRI sd_rename | err                                     'sdcard: datei oder verzeichnis umbenennen
''funktionsgruppe               : sdcard
''funktion                      : datei oder verzeichnis umbenennen
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn1][sub_getstr.fn2][put.error]
''                              : fn1 - alter name
''                              : fn2 - neuer name
''                              : error - fehlernummer entspr. liste

   sub_getstr(@tbuf)                                    'fn1
   sub_getstr(@tbuf2)                                   'fn2
   \fat[fnr].moveEntry(@tbuf2,@tbuf)
   err := fat[fnr].partitionError
   sighigh(err)                                         'fehleranzeige
   bus_putchar(err)                                     'ergebnis der operation senden

PRI sd_chattrib | err                                   'sdcard: attribute ändern
''funktionsgruppe               : sdcard
''funktion                      : attribute einer datei oder eines verzeichnisses ändern
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn][sub_getstr.attrib][put.error]
''                              : fn - dateiname
''                              : attrib - string mit attributen
''                              : error - fehlernummer entspr. liste

  sub_getstr(@tbuf)
  sub_getstr(@tbuf2)
  \fat[fnr].changeAttributes(@tbuf2,@tbuf)
  err := fat[fnr].partitionError
  siglow(err)                                           'fehleranzeige
  bus_putchar(err)                                      'ergebnis der operation senden

PRI sd_chdir | err                                      'sdcard: verzeichnis wechseln
''funktionsgruppe               : sdcard
''funktion                      : verzeichnis wechseln
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][sub_getstr.fn][put.error]
''                              : fn - name des verzeichnisses
''                              : error - fehlernummer entspr. list
  sub_getstr(@tbuf)
  \fat[fnr].changeDirectory(@tbuf)
  err := fat[fnr].partitionError
  bus_putchar(err)                                      'ergebnis der operation senden

PRI sd_format | err                                     'sdcard: medium formatieren
''funktionsgruppe               : sdcard
''funktion                      : medium formatieren
''eingabe                       : -
''ausgabe                       : -
''busprotokoll                  : [fkt][put.error]
''                              : error - fehlernummer entspr. list

  sub_getstr(@tbuf)
  \fat[fnr].formatPartition(0)
  err := fat[fnr].partitionError
  siglow(err)                                           'fehleranzeige
  bus_putchar(err)                                      'ergebnis der operation senden

PRI sd_copy

PRI sd_move
CON                                                     'SDCARD: DATEILISTE
{
  @ftab + i * FCNT + FTABIXNAME

  [1 byte r/w-flag][31 bytes pfad/name 0-term]

}

PRI sd_getftab|i                                        'sdcard: dateiliste abfragen

  bus_putchar(MAXFILES-1)
  repeat i from 0 to MAXFILES-1
    sub_putstr(@ftab + i * FTCNT + FTABIXNAME)          'dateiname senden
    bus_putchar(ftab[i * FTCNT + FTABIXRW])             'flag senden


PRI sd_clrftab|i                                        'sdcard: dateiliste löschen

  repeat i from 0 to MAXFILES-1
    sd_clrentry(i)
'  ftab[FH_M   * FTCNT] := "M"   'filehandle für system reservieren
'  ftab[FH_SID * FTCNT] := "S"   'filehandle für sidplayer reservieren

PRI sd_clrentry(fh)|i                                   'sdcard: eintrag in dateiliste löschen

  repeat i from 0 to FTCNT-1
    ftab[fh * FTCNT + i] := " "
  ftab[fh * FTCNT + FTABIXNAME + 12] := 0               'string abschließen
  ftab[fh * FTCNT + FTABIXRW] := "C"                    'flag auf closed setzen

PRI sd_getfh

  bus_putchar(sd_getfh2)

PRI sd_getfh2|freefh,i

  repeat i from 0 to MAXFILES-1
    if ftab[i * FTCNT] == "C"
      freefh := i
      ftab[i * FTCNT] := "!"
      return freefh
  freefh := 255
  return freefh

PRI sd_usefh

  fnr := bus_getchar

PRI sd_clrfh|fh

  sd_clrentry(bus_getchar)


PRI xcharactersToLowerCase(characters) '' 4 Stack Longs

'' ┌──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
'' │ Demotes all upper case characters in the set of ("A","Z") to their lower case equivalents.                               │
'' │                                                                                                                          │
'' │ Characters - A pointer to a string of characters to convert to lowercase.                                                │
'' └──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘

  repeat strsize(characters--)
    result := byte[++characters]
    if((result => "A") and (result =< "Z"))
      byte[characters] := (result + 32)

CON ''------------------------------------------------- SCREEN-FUNKTIONEN

PRI scr_home|err                                        'scr: systemverzeichnis öffnen

  \fat[fh_m].changeDirectory(@s_home)
  err := fat[fh_m].partitionError
  bus_putchar(err)                                      'ergebnis der operation senden


PRI scr_sys_use                                         'scr: systemfile öffnen

  scr_use2(@s_sys)

PRI scr_use | err                                       'scr: schreendatei öffnen

   sub_getstr(@tbuf)
   err := scr_use2(@tbuf)
   bus_putchar(err)

PRI scr_use2(stradr):err | n

  fat[fh_m].closeFile
  s_err := sd_open2(fh_m,stradr,"W")
  s_max := fat[fh_m].fileSize/SCREENSIZE
  return s_err

PRI scr_fill | i,char                                   'scr: screenpuffer mit zeichen füllen

  char := bus_getchar                                   'füllzeichen empfangen
  repeat i from 0 to SCREENSIZE - 1                     'screenpuffer mit zeichen füllen
    s_pscreen[i] := char
  s_pos := 0

PRI scr_read                                            'scr: screen in den puffer laden

' [cmd][sub_getlong.scrnr][put.err]

  s_scr := sub_getlong                                  'screennummer empfangen
  scr_read2
  bus_putchar(s_err)                                    'ergebnis der operation senden

PRI scr_read2|fpos

  outa[LED_OPEN] := 0
  if s_scr < s_max
    s_err := 0
    fpos  := s_scr * SCREENSIZE
    fat[fh_m].fileSeek(fpos)
    \fat[fh_m].readData(@s_pscreen,SCREENSIZE)
    s_pos := 0
  else
    s_err := gc#M_ERR_RW
  outa[LED_OPEN] := 1


PRI scr_write                                           'scr: screenpuffer auf disk schreiben

' [cmd][sub_getlong.scrnr][put.err]

  s_scr := sub_getlong                                  '32 bit screennnummer einlesen
  scr_write2
  bus_putchar(s_err)                                     'ergebnis der operation senden

PRI scr_write2|fpos

  outa[LED_OPEN] := 0
  if s_scr < s_max
    fpos  := s_scr * SCREENSIZE
    fat[fh_m].fileSeek(fpos)
    \fat[fh_m].writeData(@s_pscreen,SCREENSIZE)
  else
    s_err := gc#M_ERR_RW
  outa[LED_OPEN] := 1

PRI scr_getnr                                           'scr: nummer des aktuellen screens abfragen

  sub_putlong(s_scr)

PRI scr_setpos                                          'scr: zeiger auf position im puffer setzen

  s_pos := sub_getlong & SIZEMASK

PRI scr_getpos                                          'scr: aktuelle position im puffer abfragen

  sub_putlong(s_pos)

PRI scr_getc                                            'scr: zeichen wird aus dem puffer gelesen

  outa[LED_OPEN] := 0
  bus_putchar(s_pscreen[s_pos++ & SIZEMASK])
  outa[LED_OPEN] := 1

PRI scr_putc                                            'scr: zeichen wird in den puffer geschrieben

  outa[LED_OPEN] := 0
  s_pscreen[s_pos++ & SIZEMASK] := bus_getchar
  outa[LED_OPEN] := 1

PRI scr_err                                             'scr: fehlerstatus abfragen

  bus_putchar(s_err)

PRI scr_maxscr                                          'scr: screenanzahl des containers abfragen

  sub_putlong(s_max)

PRI scr_eos                                             'scr: end of screen

  if s_pos > (SCREENSIZE - 1)
    bus_putchar(-1)
  else
    bus_putchar(0)

PRI scr_call                                            'scr: screen --> stack

' [cmd][sub_getlong.scrnr][put.err]

  s_screens[s_index]   := s_scr
  s_positions[s_index] := s_pos
  if (s_index < SCRSTACK-1)
    s_index++
  s_scr := sub_getlong                                  'screennummer empfangen
  scr_read2
  bus_putchar(s_err)                                    'ergebnis der operation senden

PRI scr_ret                                             'scr: stack --> screen

' [cmd][put.err]

  if (s_index > 0)
    s_index--
    s_scr := s_screens[s_index]
    scr_read2
    s_pos := s_positions[s_index]
    bus_putchar(s_err)                                  'ergebnis der operation senden

CON ''------------------------------------------------- M-FUNKTIONEN

PRI m_parse                                             'm: screenpuffer parsen

' [get.cmd][sub_mtoken]|[sub_mnumber]

  m_next

  case tok_tag
    gc#m_c_tag1: sub_mtoken          'wort ausführen
    gc#m_c_tag2: sub_mtoken          'wort definieren
    gc#m_c_tag3: sub_mtoken          'wort compilieren
    gc#m_c_tag4: sub_mnumber         'zahl
    gc#m_c_tag5: sub_mnumber         'zahl literal
    gc#m_c_tag6: sub_mtoken          'string
    gc#m_c_tag7: sub_mtoken          'string literal
    gc#m_c_tag8: sub_mtoken          'data
    gc#m_c_tag9: sub_mtoken          'remark
    gc#m_c_eos : sub_mtag            'eos

PRI m_next: flag | i,pos                                'm: parst nächstes token aus screenpuffer

  'tokenpuffer löschen
  repeat i from 0 to TIBMAX+2
    tok[i] := 0

  pos := 0
  'führende tags ausblenden, tag für parser speichern
  repeat until (s_pscreen[s_pos] > gc#m_c_max) or (s_pos > (SCREENSIZE - 1))
    s_pos++
  tok_tag := s_pscreen[s_pos - 1]

  'länge ermitteln, token kopieren
  repeat until (s_pscreen[s_pos] < TIB_SP) or (s_pos > (SCREENSIZE - 1))
    tok[pos++] := s_pscreen[s_pos++]

  if (s_pos > (SCREENSIZE - 1))
    tok_tag := gc#m_c_eos

PRI m_setbase                                           'm: base-variable setzen

  m_base := bus_getchar

PRI m_number(strptr): n                                 'm: formatierte zahleneingabe

  case m_base
    02: return num.FromStr(@tok,num#BIN)
    10: return num.FromStr(@tok,num#DEC)
    16: return num.FromStr(@tok,num#HEX)


DAT                                                     '

str_sys       byte      "/mental/sys.m",0
str_home      byte      "/mental",0


DAT                                                     'mit-lizenz


{{

┌──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
│                                                   TERMS OF USE: MIT License                                                  │
├──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    │
│files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    │
│modify, merge, PRIlish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software│
│is furnished to do so, subject to the following conditions:                                                                   │
│                                                                                                                              │
│The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.│
│                                                                                                                              │
│THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          │
│WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         │
│COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   │
│ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         │
└──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
}}

