con

  GP_RIGHT  = %00000001
  GP_LEFT   = %00000010
  GP_DOWN   = %00000100
  GP_UP     = %00001000
  GP_START  = %00010000
  GP_SELECT = %00100000
  GP_B      = %01000000
  GP_A      = %10000000
        
var

  long stack[6]
  long nes_bits

pub start

  nes_bits := 0

  'cognew(process, @stack)

pub read

  'return nes_bits
  return process

pub process | i, bits

  ' set I/O ports to proper direction
  ' P3 = JOY_CLK    (4)
  ' P4 = JOY_SH/LDn (5) 
  ' P5 = JOY_DATAOUT0 (6)
  ' P6 = JOY_DATAOUT1 (7)
  ' NES Bit Encoding

  ' step 1: set I/Os
  DIRA[3] := 1 ' output
  DIRA[4] := 1 ' output
  DIRA[5] := 0 ' input
  DIRA[6] := 0 ' input

  repeat
    ' step 2: set clock and latch to 0
    OUTA[3] := 0 ' JOY_CLK = 0
    OUTA[4] := 0 ' JOY_SH/LDn = 0
    'Delay(1)

    ' step 3: set latch to 1
    OUTA[4] := 1 ' JOY_SH/LDn = 1
    'Delay(1)

    ' step 4: set latch to 0
    OUTA[4] := 0 ' JOY_SH/LDn = 0

    ' step 5: read first bit of each game pad

    ' data is now ready to shift out
    ' first bit is ready

    ' left controller
    bits := INA[5] | (INA[6] << 8)

    ' step 7: read next 7 bits
    repeat i from 0 to 6
      OUTA[3] := 1 ' JOY_CLK = 1
      'Delay(1)
      OUTA[3] := 0 ' JOY_CLK = 0
      bits := (bits << 1)
      bits := bits | INA[5] | (INA[6] << 8)
      'Delay(1)          

    ' invert bits to make positive logic and store result
    nes_bits := (!bits & $FFFF)
    return nes_bits
        